var https = require("https");
var util = require("util");
var process = require("process");

let nSession=Number(process.argv[2])||1,         // defaults are 1 session
	nContext=Number(process.argv[3])||2,         // having 2 context messages
	nTransaction=Number(process.argv[4])||3;     // with 3 transactions each
const prefix=(process.argv[5]||"JunkLoadTest");  // and dataset and all _id items labeled JunkLoadTest
const datashop=(process.argv[6]||"pslc-qa.andrew.cmu.edu");

let script={
	session:
	'<?xml version="1.0" encoding="UTF-8"?><log_session_start timezone="America/New_York" date_time="2021/03/31 01:11:50.649" auth_token="none" session_id="__SESSION_ID__" user_guid="none" class_id="" treatment_id="" assignment_id="" info_type="tutor_message.dtd"/>',
	context:
	'<?xml version="1.0" encoding="UTF-8"?><log_action auth_token="none" session_id="__SESSION_ID__" action_id="EVALUATE_QUESTION" user_guid="none" date_time="2021/03/31 01:11:50.652" timezone="America/New_York" source_id="PACT_CTAT_HTML5" external_object_id="" info_type="tutor_message.dtd">%3C%3Fxml%20version%3D%221.0%22%20encoding%3D%22UTF-8%22%3F%3E%3Ctutor_related_message_sequence%20version_number%3D%224%22%3E%3Ccontext_message%20context_message_id%3D%22__CONTEXT_MESSAGE_ID__%22%20name%3D%22START_PROBLEM%22%3E%3Cclass%3E%3Cname%3EDefaultClass%3C%2Fname%3E%3Cschool%3Enone%3C%2Fschool%3E%3Cinstructor%3Enone%3C%2Finstructor%3E%3C%2Fclass%3E%3Cdataset%3E%3Cname%3E__DATASET__%3C%2Fname%3E%3Clevel%20type%3D%22Problem%20Set%22%3E%3Cname%3ELogging%20Test%3C%2Fname%3E%3Cproblem%20%3E%3Cname%3E1_4th_plus_1_6th%3C%2Fname%3E%3Ccontext%20%2F%3E%3C%2Fproblem%3E%3C%2Flevel%3E%3C%2Fdataset%3E%3Ccondition%3E%3Cname%3Enone%3C%2Fname%3E%3Ctype%3Enone%3C%2Ftype%3E%3Cdesc%3Enone%3C%2Fdesc%3E%3C%2Fcondition%3E%3C%2Fcontext_message%3E%3C%2Ftutor_related_message_sequence%3E</log_action>',
	tool:
	'<?xml version="1.0" encoding="UTF-8"?><log_action auth_token="none" session_id="__SESSION_ID__" action_id="EVALUATE_QUESTION" user_guid="none" date_time="2021/03/31 01:12:02.616" timezone="America/New_York" source_id="PACT_CTAT_HTML5" external_object_id="" info_type="tutor_message.dtd">%3C%3Fxml%20version%3D%221.0%22%20encoding%3D%22UTF-8%22%3F%3E%3Ctutor_related_message_sequence%20version_number%3D%224%22%3E%3Ctool_message%20context_message_id%3D%22__CONTEXT_MESSAGE_ID__%22%3E%3Csemantic_event%20transaction_id%3D%22__TRANSACTION_ID__%22%20name%3D%22ATTEMPT%22%2F%3E%3Cevent_descriptor%3E%3Cselection%3E__SELECTION__%3C%2Fselection%3E%3Caction%3EUpdateTextArea%3C%2Faction%3E%3Cinput%3E%3C!%5BCDATA%5B11%5D%5D%3E%3C%2Finput%3E%3C%2Fevent_descriptor%3E%3Ccustom_field%3E%3Cname%3Etool_event_time%3C%2Fname%3E%3Cvalue%3E%3C!%5BCDATA%5B2021-03-31%2001%3A12%3A02.616%20UTC%5D%5D%3E%3C%2Fvalue%3E%3C%2Fcustom_field%3E%3C%2Ftool_message%3E%3C%2Ftutor_related_message_sequence%3E</log_action>',
	tutor:
	'<?xml version="1.0" encoding="UTF-8"?><log_action auth_token="none" session_id="__SESSION_ID__" action_id="EVALUATE_QUESTION" user_guid="none" date_time="2021/03/31 01:12:02.638" timezone="America/New_York" source_id="PACT_CTAT_HTML5" external_object_id="" info_type="tutor_message.dtd">%3C%3Fxml%20version%3D%221.0%22%20encoding%3D%22UTF-8%22%3F%3E%3Ctutor_related_message_sequence%20version_number%3D%224%22%3E%3Ctutor_message%20context_message_id%3D%22__CONTEXT_MESSAGE_ID__%22%3E%3Csemantic_event%20transaction_id%3D%22__TRANSACTION_ID__%22%20name%3D%22RESULT%22%2F%3E%3Cevent_descriptor%3E%3Cselection%3EfirstDenConv%3C%2Fselection%3E%3Caction%3EUpdateTextArea%3C%2Faction%3E%3Cinput%3E%3C!%5BCDATA%5B12%5D%5D%3E%3C%2Finput%3E%3C%2Fevent_descriptor%3E%3Caction_evaluation%20%3EINCORRECT%3C%2Faction_evaluation%3E%3Ctutor_advice%3E%3C!%5BCDATA%5B__TUTOR_ADVICE__%5D%5D%3E%3C%2Ftutor_advice%3E%3Ccustom_field%3E%3Cname%3Estep_id%3C%2Fname%3E%3Cvalue%3E%3C!%5BCDATA%5B1%5D%5D%3E%3C%2Fvalue%3E%3C%2Fcustom_field%3E%3Ccustom_field%3E%3Cname%3Etutor_input%3C%2Fname%3E%3Cvalue%3E%3C!%5BCDATA%5B12%5D%5D%3E%3C%2Fvalue%3E%3C%2Fcustom_field%3E%3Ccustom_field%3E%3Cname%3Etutor_event_time%3C%2Fname%3E%3Cvalue%3E%3C!%5BCDATA%5B2021-03-31%2001%3A12%3A02.638%20UTC%5D%5D%3E%3C%2Fvalue%3E%3C%2Fcustom_field%3E%3C%2Ftutor_message%3E%3C%2Ftutor_related_message_sequence%3E</log_action>'
};

function send(msg, key) {
	console.error("%s\n%s", key, msg);  // to stderr so can redirect
	let serverResp=key+"_";
	let req=https.request(
		{
			method: "POST",
			protocol: "https:",
			host: datashop,
			port: 443,
			path: "/log/server"
		},
		resp => {
			resp.on('data', d => serverResp+=d); 
			resp.on('end', e => console.log(serverResp.trim()));
		}
	);
	req.on('error', (e) => {
		console.log(`problem with request ${key}: ${e.message}`);
	});
	req.write(msg);
	req.end();
}

function fmtDate(time) {
	const t=new Date(); t.setTime(time);
	let y=t.getUTCFullYear(), m=t.getUTCMonth(), d=t.getUTCDate(),
		h=t.getUTCHours(), mm=t.getUTCMinutes(), s=t.getUTCSeconds(),
		ms=t.getUTCMilliseconds();
	return util.format("%d-%s-%s_%s-%s-%s.%s",
		y, (m<10?'0':'')+m, (d<10?'0':'')+d, (h<10?'0':'')+h, (mm<10?'0':'')+mm, (s<10?'0':'')+s,
		(ms<10?'00':(ms<100?'0':''))+ms);
}

const dataset=prefix;
for(let s=1; s<=nSession; ++s){
	const sPrefix=prefix+"_"+fmtDate(Date.now())+"_";
    let sScript={};
	for(let i in script){
		sScript[i]=script[i].replace("__SESSION_ID__", sPrefix+s);
	}
	send(sScript.session, sPrefix+s);
	const cPrefix=prefix+"C_"+Date.now()+"_";
    let cScript={};
	for(let c=1; c<=nContext; ++c) {
		for(let i in sScript){
			cScript[i]=sScript[i].replace("__CONTEXT_MESSAGE_ID__", cPrefix+c);
		}
		send(cScript.context.replace("__DATASET__", dataset), cPrefix+c);
		const txPrefix=prefix+"Tx_"+Date.now()+"_";
		for(let t=1; t<=nTransaction; ++t) {
			send(
				cScript.tool.replace("__TRANSACTION_ID__", txPrefix+t).replace("__SELECTION__", "c"+c+" s"+t),
				txPrefix+t+"_tl"
			);
			send(
				cScript.tutor.replace("__TRANSACTION_ID__", txPrefix+t).replace("__TUTOR_ADVICE__", "c"+c+" t"+t),
				txPrefix+t+"_tt"
			);
		}
	}
}
