/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.CTATDiagnostics;
import edu.cmu.hcii.ctat.CTATHTTPHandlerInterface;
import edu.cmu.hcii.ctat.CTATHTTPServer;
import edu.cmu.hcii.ctat.CTATLink;
import edu.cmu.hcii.ctat.CTATTutorUpdater;
import edu.cmu.hcii.ctat.ExitableServer;
import edu.cmu.hcii.ctat.ProblemEndHandler;
import edu.cmu.hcii.ctat.ProblemSetEndHandler;
import edu.cmu.hcii.utilities.DiagTools;
import edu.cmu.pact.TutoringService.LauncherServer;
import edu.cmu.pact.TutoringService.Monitor;
import edu.cmu.pact.Utilities.trace;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;

public class CTATBaseTutorShop
extends CTATBase
implements ExitableServer {
    protected Boolean useSysTray = true;
    private BufferedReader br = null;
    protected CTATDiagnostics diags = null;
    protected CTATHTTPServer wserver = null;
    protected CTATTutorUpdater updater = null;
    private CTATHTTPHandlerInterface handler = null;
    protected boolean nowExiting = false;
    protected List<ExitableServer> otherServers = new ArrayList<ExitableServer>();
    protected LauncherServer ls = null;

    public CTATBaseTutorShop() {
        this.setClassName("CTATBaseTutorShop");
        this.debug("CTATBaseTutorShop ()");
    }

    protected void setUseTray(Boolean aValue) {
        this.useSysTray = aValue;
    }

    public CTATHTTPHandlerInterface getHandler() {
        return this.handler;
    }

    public void setHandler(CTATHTTPHandlerInterface aHandler) {
        this.handler = aHandler;
    }

    public void setProblemSetEndHandler(ProblemSetEndHandler pseh) {
        CTATLink.problemSetEndHandler = pseh;
    }

    public void setProblemEndHandler(ProblemEndHandler peh) {
        CTATLink.problemEndHandler = peh;
    }

    protected void runPrep() {
        this.debug("runPrep ()");
    }

    public void runBarebones() {
        this.debug("runBarebones ()");
        this.diags = new CTATDiagnostics();
        this.br = new BufferedReader(new InputStreamReader(System.in));
        this.runPrep();
        this.runInternal();
    }

    public void runService(ProblemSetEndHandler pseh, ProblemEndHandler peh) {
        this.debug("runService ()");
        CTATLink.problemSetEndHandler = pseh;
        CTATLink.problemEndHandler = peh;
        this.runBasic();
    }

    public void runBasic() {
        this.debug("runBasic ()");
        this.diags = new CTATDiagnostics();
        this.br = new BufferedReader(new InputStreamReader(System.in));
        this.killPreviousInstance();
        this.updater = new CTATTutorUpdater(null, null, null);
        this.runPrep();
        this.runInternal();
        if (CTATLink.appMode.equalsIgnoreCase("normal") || CTATLink.appMode.equalsIgnoreCase("admin")) {
            this.showExitUI();
        }
    }

    private void runInternal() {
        Integer tPort;
        Integer hPort;
        this.debug("runInternal (" + CTATLink.appMode + ")");
        if (CTATLink.appMode.compareTo("update") == 0) {
            this.debug("Running update process, this might take a few minutes ...");
            this.updater.runUpdate();
            return;
        }
        if (CTATLink.appMode.compareTo("diagnostics") == 0 || CTATLink.appMode.compareTo("diagnostic") == 0) {
            this.diags.testSettings(true);
            return;
        }
        if (!this.diags.testSettings(false)) {
            System.out.println("Error: " + this.diags.diagnosis);
            return;
        }
        this.debug("Diagnosis and tests passed, booting services ...");
        if (CTATLink.appMode.compareTo("safemode") == 0) {
            this.waitForInput("Press ENTER to continue");
        }
        this.debug("Starting local tutoring service ...");
        trace.addDebugCodes("pr,sp,br,tsltsp,tsltstp,ls,log,et,logservice");
        this.setLoggingProperties();
        ArrayList<String> cmdLineArgs = new ArrayList<String>();
        if (CTATLink.deployType == CTATLink.DEPLOYHTML5) {
            hPort = CTATLink.tsPort;
            tPort = CTATLink.tsPort + 1;
            cmdLineArgs.add("-h");
            cmdLineArgs.add(hPort.toString());
            cmdLineArgs.add("-t");
            cmdLineArgs.add(tPort.toString());
        } else {
            hPort = CTATLink.tsPort;
            tPort = CTATLink.tsPort + 1;
            cmdLineArgs.add("-t");
            cmdLineArgs.add(hPort.toString());
            cmdLineArgs.add("-h");
            cmdLineArgs.add(tPort.toString());
        }
        String[] array = cmdLineArgs.toArray(new String[cmdLineArgs.size()]);
        this.ls = LauncherServer.create(array);
        this.otherServers.add(this.ls);
        if (CTATLink.appMode.compareTo("safemode") == 0) {
            this.waitForInput("Press ENTER to continue");
        }
        this.debug("Launching local webservice ...");
        try {
            this.installHandler();
            this.wserver = new CTATHTTPServer(CTATLink.wwwPort, CTATLink.htdocs, CTATLink.logdir + "/access.log", this.handler);
            this.otherServers.add(this.wserver);
            if (!this.wserver.startWebServer()) {
                JOptionPane.showMessageDialog(null, "Unable to start the HTTP server, aborting local TutorShop");
                System.exit(0);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Unable to start the HTTP handler, aborting local TutorShop");
            System.exit(0);
        }
        if (CTATLink.appMode.compareTo("safemode") == 0) {
            this.waitForInput("Press ENTER to continue");
        }
        this.createSysTrayIcon();
        if (CTATLink.appMode.compareTo("safemode") == 0) {
            this.waitForInput("Press ENTER to continue");
        }
        this.debug("Launching desktop ...");
        this.debug("active threads " + DiagTools.listThreads());
        this.invokeBrowserOnLocalWebServer();
        this.monitorConnectivity();
    }

    protected void killPreviousInstance() {
        this.debug("killPreviousInstance()");
        try {
            String response = Monitor.request("<service cmd=\"shutdown\"/>", 1503, 1000L);
            if (trace.getDebugCode("kill")) {
                trace.out("kill", "response from server: " + response);
            }
        }
        catch (Exception e) {
            trace.err("Error trying to shutdown previous instance: " + e + "; cause " + e.getCause());
        }
    }

    private void waitForInput(String message) {
        this.debug(message);
        try {
            this.br.readLine();
        }
        catch (IOException ioe) {
            System.out.println("Diagnostic, TutoShop is not allowed to read from the keyboard, aborting ...");
            return;
        }
    }

    protected Boolean installHandler() throws IOException {
        this.debug("installHandler ()");
        return true;
    }

    protected void setLoggingProperties() {
        if (CTATLink.datashopURL != null && CTATLink.datashopURL.length() > 0) {
            System.setProperty("log_service_url", CTATLink.datashopURL);
        }
        if (CTATLink.logdir != null && CTATLink.logdir.length() > 0) {
            System.setProperty("log_to_disk_directory", CTATLink.logdir);
        }
    }

    protected void createSysTrayIcon() {
        this.debug("createSysTrayIcon() no-op in superclass.");
    }

    protected void invokeBrowserOnLocalWebServer() {
        this.debug("invokeBrowserOnLocalWebServer() no-op in superclass.");
    }

    protected void monitorConnectivity() {
        this.debug("monitorConnectivity() no-op in superclass.");
    }

    @Override
    public boolean isExiting() {
        return false;
    }

    @Override
    public boolean startExiting() {
        return false;
    }

    protected void showExitUI() {
        this.debug("showExitUI() no-op in superclass");
    }
}

