/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.CTATDesktopFileManager;
import edu.cmu.hcii.ctat.CTATFlashTutorShop;
import edu.cmu.hcii.ctat.CTATLink;
import edu.cmu.hcii.ctat.CTATMilestoneManager;
import edu.cmu.pact.Utilities.trace;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;

public class CTATConfigPanel
extends JPanel
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = -4206289219634303096L;
    private JRadioButton flashButton = null;
    private JRadioButton html5Button = null;
    private JRadioButton deployDisabled = null;
    private JRadioButton deployOnButton = null;
    private JRadioButton deployAutoButton = null;
    private JTextField htdocs;
    private JTextField hostName;
    private JTextField wwwPort;
    private JTextField tsPort;
    private JTextField tsMonitorPort;
    private JTextField remoteHost;
    private JTextField etc;
    private JTextField datashopURL;
    private JTextField logdir;
    private JTextField datasetName;
    private JTextArea crossDomainPolicy;
    private JTextField adminPasswordFilename;
    private JTextField maxCachedFiles;
    private JCheckBox noNetwork;
    private JCheckBox allowWriting;
    private JCheckBox inMemoryOnly;
    private JCheckBox useLocalTutoringService;
    private JCheckBox printDebugMessages;
    private JCheckBox showNavButtons;
    private JCheckBox remoteTutoringService;
    private JCheckBox generateIndex;
    private JButton restoreButton;
    private JButton okButton;
    private JButton cancelButton;
    private String path = null;
    private JButton updateButton = null;
    private JTextArea console = null;
    private JTextField className = null;
    private JFrame frame = null;
    private JTabbedPane tabbedPane = null;
    private JProgressBar progressBar = null;
    private JComboBox configList = null;
    private JLabel configHelp = null;

    public CTATConfigPanel(JFrame aContainer) {
        this.frame = aContainer;
        this.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.setLayout(new BoxLayout(this, 1));
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addChangeListener(this);
        JPanel configPanel = this.createConfigPanel();
        JScrollPane aConfigScroller = new JScrollPane(configPanel);
        this.tabbedPane.addTab("Configuration", null, aConfigScroller, "Change global program settings");
        JPanel updatePanel = this.createUpdatePanel();
        this.tabbedPane.addTab("Update Content", null, updatePanel, "Download the latest live content");
        JPanel milestonesPanel = this.createMilestonesPanel();
        this.tabbedPane.addTab("Milestones", null, milestonesPanel, "View milestone set");
        Box buttonBox = new Box(0);
        buttonBox.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.restoreButton = new JButton("Restore default settings");
        this.restoreButton.addActionListener(new RestoreButtonListener());
        buttonBox.add(this.restoreButton);
        buttonBox.add(Box.createHorizontalGlue());
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new OKButtonListener());
        buttonBox.add(this.okButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new CancelButtonListener());
        buttonBox.add(this.cancelButton);
        this.add((Component)this.tabbedPane, "North");
        this.add((Component)buttonBox, "South");
        if (this.flashButton.isSelected()) {
            this.tsPort.setEnabled(true);
            this.tsMonitorPort.setEnabled(true);
        } else {
            this.tsPort.setEnabled(false);
            this.tsMonitorPort.setEnabled(false);
        }
        this.evaluateInMemory();
    }

    public CTATConfigPanel(JFrame aContainer, String path) {
        this(aContainer);
        this.path = path;
    }

    private void debug(String aMessage) {
        CTATBase.debug("CTATConfigPanel", aMessage);
    }

    private JPanel createConfigPanel() {
        GridBagConstraints c = new GridBagConstraints();
        JPanel tfp = new JPanel();
        tfp.setLayout(new GridBagLayout());
        tfp.setMinimumSize(new Dimension(200, 100));
        this.flashButton = new JRadioButton("Flash Tutor");
        this.flashButton.setFont(new Font("Dialog", 1, 9));
        this.flashButton.addActionListener(this);
        this.html5Button = new JRadioButton("HTML5 Tutor");
        this.html5Button.setFont(new Font("Dialog", 1, 9));
        this.html5Button.addActionListener(this);
        if (CTATLink.deployType == CTATLink.DEPLOYFLASH) {
            this.flashButton.setSelected(true);
        }
        if (CTATLink.deployType == CTATLink.DEPLOYHTML5) {
            this.html5Button.setSelected(true);
        }
        ButtonGroup group = new ButtonGroup();
        group.add(this.flashButton);
        group.add(this.html5Button);
        JPanel radioPanel = new JPanel();
        radioPanel.setLayout(new BoxLayout(radioPanel, 0));
        radioPanel.setMinimumSize(new Dimension(50, 10));
        radioPanel.setMaximumSize(new Dimension(50, 22));
        radioPanel.add(this.flashButton);
        radioPanel.add(this.html5Button);
        this.addLabeledComponent(tfp, "Choose tutor type: ", radioPanel);
        this.deployDisabled = new JRadioButton("Disabled");
        this.deployDisabled.setFont(new Font("Dialog", 1, 9));
        this.deployOnButton = new JRadioButton("On");
        this.deployOnButton.setFont(new Font("Dialog", 1, 9));
        this.deployAutoButton = new JRadioButton("Auto");
        this.deployAutoButton.setFont(new Font("Dialog", 1, 9));
        if (CTATLink.deployMobileAPI == CTATLink.MOBILEAPIDISABLED) {
            this.deployDisabled.setSelected(true);
        }
        if (CTATLink.deployMobileAPI == CTATLink.MOBILEAPION) {
            this.deployOnButton.setSelected(true);
        }
        if (CTATLink.deployMobileAPI == CTATLink.MOBILEAPIAUTO) {
            this.deployAutoButton.setSelected(true);
        }
        ButtonGroup groupB = new ButtonGroup();
        groupB.add(this.deployDisabled);
        groupB.add(this.deployOnButton);
        groupB.add(this.deployAutoButton);
        JPanel radioBPanel = new JPanel();
        radioBPanel.setLayout(new BoxLayout(radioBPanel, 0));
        radioBPanel.setMinimumSize(new Dimension(50, 10));
        radioBPanel.setMaximumSize(new Dimension(50, 22));
        radioBPanel.add(this.deployDisabled);
        radioBPanel.add(this.deployOnButton);
        radioBPanel.add(this.deployAutoButton);
        this.addLabeledComponent(tfp, "Use Mobile Math Keyboard: ", radioBPanel);
        String[] configStrings = new String[]{"DEFAULT", "LOCAL", "OFFLINE", "CS2N", "DEMO"};
        this.configList = new JComboBox<String>(configStrings);
        this.configList.addActionListener(this);
        this.addLabeledComponent(tfp, "Install HTTP Handler: ", this.configList);
        this.configList.setSelectedItem(CTATLink.handlerConfig);
        this.configHelp = new JLabel();
        this.configHelp.setFont(new Font("Dialog", 1, 9));
        this.configHelp.setMinimumSize(new Dimension(20, 30));
        this.configHelp.setPreferredSize(new Dimension(120, 30));
        this.configHelp.setBorder(BorderFactory.createLineBorder(Color.black));
        this.addLabeledComponent(tfp, " ", this.configHelp);
        this.htdocs = new JTextField(CTATLink.htdocs, 50);
        this.addLabeledComponent(tfp, "Location of htdocs folder: ", this.htdocs);
        this.hostName = new JTextField(CTATLink.hostName, 50);
        this.addLabeledComponent(tfp, "Host name: ", this.hostName);
        this.wwwPort = new JTextField(String.valueOf(CTATLink.wwwPort), 50);
        this.addLabeledComponent(tfp, "Port number: ", this.wwwPort);
        this.tsPort = new JTextField(String.valueOf(CTATLink.tsPort), 50);
        this.addLabeledComponent(tfp, "Tutoring service port number: ", this.tsPort);
        this.tsMonitorPort = new JTextField(String.valueOf(CTATLink.tsMonitorPort), 50);
        this.addLabeledComponent(tfp, "Tutoring service monitor port number: ", this.tsMonitorPort);
        this.remoteHost = new JTextField(CTATLink.remoteHost, 50);
        this.addLabeledComponent(tfp, "Remote host name -- leave empty to run local tutors: ", this.remoteHost);
        this.etc = new JTextField(CTATLink.etc, 50);
        this.addLabeledComponent(tfp, "Location of etc folder: ", this.etc);
        this.datashopURL = new JTextField(CTATLink.datashopURL, 50);
        this.addLabeledComponent(tfp, "DataShop URL: ", this.datashopURL);
        this.logdir = new JTextField(CTATLink.logdir, 50);
        this.addLabeledComponent(tfp, "Location of local DataShop log: ", this.logdir);
        this.datasetName = new JTextField(CTATLink.datasetName, 50);
        this.addLabeledComponent(tfp, "Name of dataset within DataShop: ", this.datasetName);
        this.adminPasswordFilename = new JTextField(CTATLink.adminPasswordFilename, 50);
        this.addLabeledComponent(tfp, "Location of administrator password file: ", this.adminPasswordFilename);
        this.maxCachedFiles = new JTextField(String.valueOf(CTATLink.maxCachedFiles), 50);
        this.addLabeledComponent(tfp, "Maximum number of files to cache in memory: ", this.maxCachedFiles);
        if (trace.getDebugCode("tsu")) {
            trace.out("tsu", "adminPasswordFilename border " + this.adminPasswordFilename.getBorder());
        }
        this.noNetwork = new JCheckBox("No network access allowed", CTATLink.noNetwork);
        this.addLabeledComponent(tfp, "No network: ", this.noNetwork);
        this.allowWriting = new JCheckBox("Allow writing to disk (cache, logging)", CTATLink.allowWriting);
        this.addLabeledComponent(tfp, "Disk access (cache, logs): ", this.allowWriting);
        this.allowWriting.addActionListener(this);
        this.inMemoryOnly = new JCheckBox("In-memory user database)", CTATLink.inMemoryOnly);
        this.addLabeledComponent(tfp, "In Memory User DB: ", this.inMemoryOnly);
        this.useLocalTutoringService = new JCheckBox("Use local tutoring service", CTATLink.useLocalTutoringService);
        this.addLabeledComponent(tfp, "Tutoring service: ", this.useLocalTutoringService);
        this.printDebugMessages = new JCheckBox("Print debug messsages to console", CTATLink.printDebugMessages);
        this.addLabeledComponent(tfp, "Debug messages: ", this.printDebugMessages);
        this.showNavButtons = new JCheckBox("Show navigation buttons in tutor frame", CTATLink.showNavButtons);
        this.addLabeledComponent(tfp, "Navigation buttons: ", this.showNavButtons);
        this.crossDomainPolicy = new JTextArea(CTATLink.crossDomainPolicy, 5, 50);
        this.addLabeledComponent(tfp, "Cross-domain policy: ", this.crossDomainPolicy);
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 18;
        tfp.add((Component)new JLabel(), c);
        this.crossDomainPolicy.setBorder(BorderFactory.createEtchedBorder(1));
        return tfp;
    }

    private JPanel createUpdatePanel() {
        JPanel updatePanel = new JPanel();
        updatePanel.setLayout(new BoxLayout(updatePanel, 1));
        Box buttonBox = new Box(0);
        this.updateButton = new JButton();
        this.updateButton.setFont(new Font("Dialog", 1, 9));
        this.updateButton.setPreferredSize(new Dimension(75, 20));
        this.updateButton.setText("Update");
        this.updateButton.addActionListener(this);
        JLabel aLabel = new JLabel();
        aLabel.setText("Name of the Class to download:");
        aLabel.setFont(new Font("Dialog", 1, 9));
        aLabel.setPreferredSize(new Dimension(200, 20));
        this.className = new JTextField();
        this.className.setFont(new Font("Dialog", 1, 9));
        this.className.setPreferredSize(new Dimension(150, 20));
        this.className.setMaximumSize(new Dimension(150, 20));
        this.progressBar = new JProgressBar();
        this.progressBar.setValue(0);
        this.progressBar.setFont(new Font("Dialog", 1, 9));
        this.progressBar.setStringPainted(true);
        this.progressBar.setPreferredSize(new Dimension(200, 20));
        this.progressBar.setMaximumSize(new Dimension(200, 20));
        buttonBox.add(this.updateButton);
        buttonBox.add(Box.createRigidArea(new Dimension(2, 0)));
        buttonBox.add(aLabel);
        buttonBox.add(Box.createRigidArea(new Dimension(2, 0)));
        buttonBox.add(this.className);
        buttonBox.add(Box.createRigidArea(new Dimension(2, 0)));
        buttonBox.add(this.progressBar);
        buttonBox.add(Box.createRigidArea(new Dimension(2, 0)));
        this.generateIndex = new JCheckBox();
        this.generateIndex.setText("Generate index html file");
        this.generateIndex.setFont(new Font("Dialog", 1, 9));
        this.generateIndex.setSelected(CTATLink.generateHTMLIndex);
        buttonBox.add(this.generateIndex);
        buttonBox.add(Box.createRigidArea(new Dimension(2, 0)));
        buttonBox.add(Box.createHorizontalGlue());
        updatePanel.add(buttonBox);
        this.console = new JTextArea();
        this.console.setEditable(false);
        this.console.setFont(new Font("Courier", 1, 10));
        JScrollPane consoleContainer = new JScrollPane(this.console);
        consoleContainer.setVerticalScrollBarPolicy(22);
        updatePanel.add(Box.createRigidArea(new Dimension(0, 2)));
        updatePanel.add(consoleContainer);
        return updatePanel;
    }

    private JPanel createMilestonesPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JTextArea text = new JTextArea();
        JScrollPane aConsoleScroller = new JScrollPane(text);
        panel.add(aConsoleScroller);
        CTATMilestoneManager milestones = new CTATMilestoneManager();
        milestones.initialize();
        text.setText(milestones.getDebugString());
        return panel;
    }

    private void addLabeledComponent(JPanel tfp, String labelText, JComponent comp) {
        GridBagConstraints c = new GridBagConstraints();
        comp.setFont(new Font("Dialog", 1, 9));
        if (comp instanceof JTextComponent) {
            c.insets = new Insets(1, 1, 1, 1);
        }
        c.anchor = 13;
        JLabel label = new JLabel(labelText);
        label.setFont(new Font("Dialog", 1, 9));
        c.gridwidth = -1;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 18;
        tfp.add((Component)label, c);
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        tfp.add((Component)comp, c);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object comp = event.getSource();
        if (comp == this.flashButton || comp == this.html5Button) {
            if (this.flashButton.isSelected()) {
                this.tsPort.setEnabled(true);
                this.tsMonitorPort.setEnabled(true);
            } else {
                this.tsPort.setEnabled(false);
                this.tsMonitorPort.setEnabled(false);
            }
        }
        if (comp == this.allowWriting) {
            this.evaluateInMemory();
        }
        if (comp == this.updateButton) {
            this.restoreButton.setEnabled(false);
            this.okButton.setEnabled(false);
            this.cancelButton.setEnabled(false);
            this.updateButton.setEnabled(false);
            this.className.setEnabled(false);
            this.tabbedPane.setEnabledAt(0, false);
            String targetClass = this.className.getText();
            if (targetClass.isEmpty()) {
                this.alert("Please provide a class name");
                this.restoreButton.setEnabled(true);
                this.okButton.setEnabled(true);
                this.cancelButton.setEnabled(true);
                return;
            }
            CTATLink.FIREClass = targetClass;
            if (!this.propagateValues()) {
                this.restoreButton.setEnabled(true);
                this.okButton.setEnabled(true);
                this.cancelButton.setEnabled(true);
                return;
            }
            CTATLink.generateHTMLIndex = this.generateIndex.isSelected();
            CTATFlashTutorShop.downloadContent(this.console, this.progressBar, false, true, new Runnable(){

                @Override
                public void run() {
                }
            });
            this.restoreButton.setEnabled(true);
            this.okButton.setEnabled(true);
            this.cancelButton.setEnabled(true);
            this.updateButton.setEnabled(true);
            this.className.setEnabled(true);
            this.tabbedPane.setEnabledAt(0, true);
        }
        if (this.configHelp != null) {
            String selConfig = (String)this.configList.getSelectedItem();
            if (selConfig.equalsIgnoreCase("DEFAULT")) {
                this.configHelp.setText("DEFAULT: CTATHTTPHandler ()");
            }
            if (selConfig.equalsIgnoreCase("LOCAL")) {
                this.configHelp.setText("LOCAL: CTATHTTPLocalHandler ()");
            }
            if (selConfig.equalsIgnoreCase("OFFLINE")) {
                this.configHelp.setText("OFFLINE: CTATOfflineHTTPHandler ()");
            }
            if (selConfig.equalsIgnoreCase("CS2N")) {
                this.configHelp.setText("CS2N: CTATCS2NHandler ()");
            }
        }
    }

    private void alert(String aMessage) {
        JOptionPane.showMessageDialog(this.frame, aMessage);
    }

    private boolean propagateValues() {
        boolean inputIsValid = true;
        if (this.flashButton.isSelected()) {
            CTATLink.deployType = CTATLink.DEPLOYFLASH;
        }
        if (this.html5Button.isSelected()) {
            CTATLink.deployType = CTATLink.DEPLOYHTML5;
        }
        if (this.deployDisabled.isSelected()) {
            CTATLink.deployMobileAPI = CTATLink.MOBILEAPIDISABLED;
        }
        if (this.deployOnButton.isSelected()) {
            CTATLink.deployMobileAPI = CTATLink.MOBILEAPION;
        }
        if (this.deployAutoButton.isSelected()) {
            CTATLink.deployMobileAPI = CTATLink.MOBILEAPIAUTO;
        }
        CTATLink.htdocs = this.htdocs.getText();
        CTATLink.hostName = this.hostName.getText();
        try {
            CTATLink.wwwPort = Integer.valueOf(this.wwwPort.getText());
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(null, "The port number must be an integer.");
            inputIsValid = false;
        }
        try {
            int i = Integer.valueOf(this.tsPort.getText());
            if (i <= 0) {
                throw new NumberFormatException("value " + i + " must be positive");
            }
            CTATLink.tsPort = i;
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(null, "The TutorShop port number must be a positive integer: " + ex);
            inputIsValid = false;
        }
        try {
            CTATLink.tsMonitorPort = Integer.valueOf(this.tsMonitorPort.getText());
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(null, "The TutorShop monitor port number must be an integer.");
            inputIsValid = false;
        }
        CTATLink.remoteHost = this.remoteHost.getText();
        CTATLink.etc = this.etc.getText();
        CTATLink.datashopURL = this.datashopURL.getText();
        CTATLink.logdir = this.logdir.getText();
        CTATLink.datasetName = this.datasetName.getText();
        CTATLink.crossDomainPolicy = this.crossDomainPolicy.getText();
        CTATLink.adminPasswordFilename = this.adminPasswordFilename.getText();
        try {
            CTATLink.maxCachedFiles = Integer.valueOf(this.maxCachedFiles.getText());
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(null, "The number of cached files must be an integer: " + ex);
            inputIsValid = false;
        }
        CTATLink.noNetwork = this.noNetwork.isSelected();
        CTATLink.allowWriting = this.allowWriting.isSelected();
        CTATLink.useLocalTutoringService = this.useLocalTutoringService.isSelected();
        CTATLink.printDebugMessages = this.printDebugMessages.isSelected();
        CTATLink.showNavButtons = this.showNavButtons.isSelected();
        CTATLink.handlerConfig = String.valueOf(this.configList.getSelectedItem());
        return inputIsValid;
    }

    @Override
    public void stateChanged(ChangeEvent arg0) {
        this.debug("stateChanged ()");
        if (this.tabbedPane.getSelectedIndex() == 0) {
            if (this.cancelButton != null) {
                this.cancelButton.setVisible(true);
            }
            if (this.restoreButton != null) {
                this.restoreButton.setVisible(true);
            }
        }
        if (this.tabbedPane.getSelectedIndex() == 1) {
            if (this.cancelButton != null) {
                this.cancelButton.setVisible(false);
            }
            if (this.restoreButton != null) {
                this.restoreButton.setVisible(false);
            }
        }
    }

    public void evaluateInMemory() {
        this.debug("evaluateInMemory ()");
        if (!this.allowWriting.isSelected()) {
            this.inMemoryOnly.setEnabled(true);
        } else {
            this.inMemoryOnly.setEnabled(false);
        }
    }

    protected ImageIcon createImageIcon(String path) {
        String file = "/edu/cmu/pact/hcii/ctat/" + path;
        URL url = this.getClass().getResource(file);
        return new ImageIcon(url);
    }

    private class CancelButtonListener
    implements ActionListener {
        private CancelButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            System.exit(0);
        }
    }

    private class OKButtonListener
    implements ActionListener {
        private OKButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int answer;
            if (CTATConfigPanel.this.tabbedPane.getSelectedIndex() == 1) {
                System.exit(0);
            }
            if ((answer = JOptionPane.showConfirmDialog(null, "Are you sure that you want to create a configuration file with the specified settings? This will overwrite any existing configuration file.", "Please confirm", 0)) == 0) {
                if (!CTATConfigPanel.this.propagateValues()) {
                    return;
                }
                boolean success = false;
                success = CTATConfigPanel.this.path == null ? new CTATDesktopFileManager().saveConfigData() : new CTATDesktopFileManager().saveConfigData(CTATConfigPanel.this.path);
                if (success) {
                    JOptionPane.showMessageDialog(null, "The configuration file has been saved.");
                    System.exit(0);
                } else {
                    JOptionPane.showMessageDialog(null, "An exception occurred which prevented the configuration file from being saved.");
                }
            }
        }
    }

    private class RestoreButtonListener
    implements ActionListener {
        private RestoreButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (trace.getDebugCode("tsu")) {
                trace.out("tsu", "actionPerformed() size " + CTATConfigPanel.this.getSize());
            }
            CTATConfigPanel.this.wwwPort.setText("8080");
            CTATConfigPanel.this.tsPort.setText("4000");
            CTATConfigPanel.this.tsMonitorPort.setText("4001");
            CTATConfigPanel.this.remoteHost.setText("");
            CTATConfigPanel.this.datashopURL.setText("http://digger.pslc.cs.cmu.edu/log/server/sandboxlogger.php");
            CTATConfigPanel.this.logdir.setText("logs/");
            CTATConfigPanel.this.datasetName.setText("FIRE Preview");
            CTATConfigPanel.this.maxCachedFiles.setText(Integer.toString(CTATLink.maxCachedFiles));
            CTATConfigPanel.this.allowWriting.setSelected(true);
            CTATConfigPanel.this.useLocalTutoringService.setSelected(true);
            CTATConfigPanel.this.printDebugMessages.setSelected(false);
        }
    }
}

