/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.CTATFileManager;
import edu.cmu.hcii.ctat.CTATLink;
import edu.cmu.pact.Utilities.trace;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Date;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CTATDesktopFileManager
extends CTATFileManager {
    private Writer streamOut = null;

    public CTATDesktopFileManager() {
        this.setClassName("CTATDesktopFileManager");
        this.debug("CTATDesktopFileManager ()");
    }

    public static String getConfigFilePath() {
        return CTATLink.configFilePath;
    }

    public static void setConfigFilePath(String configFilePath) {
        CTATLink.configFilePath = configFilePath;
    }

    public boolean isStreamOpen() {
        return this.streamOut != null;
    }

    public boolean openStream(String aFileURI) {
        this.debug("openStream (" + aFileURI + ")");
        if (this.streamOut != null) {
            this.debug("Stream already open");
            return true;
        }
        File aFile = null;
        if (aFileURI.indexOf(".jar") != -1) {
            this.debug("Can't create a file in a jar yet");
            return false;
        }
        aFile = new File(aFileURI);
        try {
            aFile.createNewFile();
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return false;
        }
        if (!aFile.exists()) {
            this.debug("File does not exist: " + aFile);
            return false;
        }
        if (!aFile.isFile()) {
            this.debug("Should not be a directory: " + aFile);
            return false;
        }
        if (!aFile.canWrite()) {
            this.debug("File cannot be written: " + aFile);
            return false;
        }
        try {
            this.streamOut = new BufferedWriter(new FileWriter(aFile));
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public void closeStream() {
        this.debug("closeStream ()");
        if (this.streamOut != null) {
            try {
                this.streamOut.close();
                this.streamOut = null;
            }
            catch (IOException e) {
                e.printStackTrace();
                this.debug("Error closing output stream");
            }
        }
    }

    public void writeToStream(String aContents) {
        if (this.streamOut != null) {
            try {
                this.streamOut.write(aContents);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                this.streamOut.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean doesFileExist(String aFileURI) {
        this.debug("doesFileExist (" + aFileURI + ")");
        File aFile = null;
        if (aFileURI.indexOf(".jar?") != -1) {
            return this.jarFileExist(aFileURI);
        }
        aFile = new File(aFileURI);
        boolean exists = aFile.exists();
        return exists;
    }

    @Override
    public boolean createDirectory(String aDirURI) {
        this.debug("createDirectory (" + aDirURI + ")");
        if (this.doesFileExist(aDirURI)) {
            this.debug("Directory already exists");
        } else {
            boolean success = new File(aDirURI).mkdir();
            if (!success) {
                this.debug("Unable to create directory");
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copy(File src, File dst) throws IOException {
        this.debug("copy (" + src.getAbsolutePath() + " , " + dst.getAbsolutePath() + ")");
        if (!src.exists()) {
            this.debug("Error, source file does not exist: " + src.getAbsolutePath());
            return;
        }
        try (FileInputStream in = new FileInputStream(src);){
            if (!dst.exists()) {
                this.debug("Destination file does not exist, creating: " + dst.getAbsolutePath());
                dst.createNewFile();
            }
            try (FileOutputStream out = new FileOutputStream(dst, false);){
                int len;
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
            }
        }
    }

    public static byte[] getBytesFromInputStream(InputStream is) throws IOException {
        int offset;
        long length = is.available();
        if (length > Integer.MAX_VALUE) {
            // empty if block
        }
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = is.read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file ");
        }
        return bytes;
    }

    @Override
    public InputStream getInputStream(String aFileURI) {
        this.debug("getInputStream (" + aFileURI + ")");
        FileInputStream is = null;
        if (!this.doesFileExist(aFileURI)) {
            this.debug("Error: file does not exist");
            return null;
        }
        File aFile = null;
        if (aFileURI.indexOf(".jar") != -1) {
            return this.getJarInputStream(aFileURI);
        }
        aFile = new File(aFileURI);
        try {
            is = new FileInputStream(aFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getContents(String aFileURI) {
        this.debug("getContents (" + aFileURI + ")");
        if (!this.doesFileExist(aFileURI)) {
            this.debug("Error: file does not exist");
            return null;
        }
        File aFile = null;
        if (aFileURI.indexOf(".jar") != -1) {
            return this.getJarContents(aFileURI);
        }
        aFile = new File(aFileURI);
        StringBuilder contents = new StringBuilder();
        BufferedReader input = new BufferedReader(new FileReader(aFile));
        try {
            String line = null;
            while ((line = input.readLine()) != null) {
                contents.append(line);
                contents.append(System.getProperty("line.separator"));
            }
        }
        catch (IOException e) {
            String string;
            try {
                string = null;
            }
            catch (Throwable throwable) {
                try {
                    input.close();
                    throw throwable;
                }
                catch (IOException ex) {
                    return null;
                }
            }
            input.close();
            return string;
        }
        input.close();
        return contents.toString();
    }

    @Override
    public Element getContentsXML(String aFileURI) {
        this.debug("getContentsXML (" + aFileURI + ")");
        if (!this.doesFileExist(aFileURI)) {
            this.debug("Error: file does not exist: " + aFileURI);
            return null;
        }
        Document document = null;
        DocumentBuilderFactory dbf = null;
        DocumentBuilder builder = null;
        try {
            dbf = DocumentBuilderFactory.newInstance();
            builder = dbf.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        String toBeParsed = this.getContents(aFileURI);
        try {
            document = builder.parse(new InputSource(new ByteArrayInputStream(toBeParsed.getBytes("utf-8"))));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (SAXException e) {
            trace.err("Error while parsing file: " + e + "; cause: " + e.getCause() + "; start, end of content:\n  " + (toBeParsed == null ? null : toBeParsed.substring(0, Math.min(70, toBeParsed.length()))) + "\n  " + (toBeParsed == null ? null : toBeParsed.substring(toBeParsed.length() - Math.min(70, toBeParsed.length()))));
            return null;
        }
        Element root = document.getDocumentElement();
        return root;
    }

    @Override
    public Element getContentsXMLEncrypted(String aFileURI) {
        this.debug("getContentsXMLEncrypted (" + aFileURI + ")");
        String decrypted = this.getContentsEncrypted(aFileURI);
        Document document = null;
        DocumentBuilderFactory dbf = null;
        DocumentBuilder builder = null;
        try {
            dbf = DocumentBuilderFactory.newInstance();
            builder = dbf.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        try {
            ByteArrayInputStream decryptedStream = new ByteArrayInputStream(decrypted.getBytes("UTF-8"));
            document = builder.parse(decryptedStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (SAXException e) {
            System.err.println("Error while parsing file");
            return null;
        }
        Element root = document.getDocumentElement();
        return root;
    }

    public boolean appendContents(String aFileURI, String aContents) {
        this.debug("appendContents (" + aFileURI + ")");
        File aFile = new File(aFileURI);
        BufferedWriter output = null;
        if (!aFile.exists()) {
            this.debug("File does not exist, creating ...");
            try {
                aFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        if (aFile.isDirectory()) {
            this.debug("Should not be a directory: " + aFile);
            return false;
        }
        if (!aFile.canWrite()) {
            this.debug("File cannot be written: " + aFile);
            return false;
        }
        try {
            output = new BufferedWriter(new FileWriter(aFile));
        }
        catch (IOException e) {
            return false;
        }
        try {
            output.write(aContents);
            ((Writer)output).flush();
            ((Writer)output).close();
        }
        catch (IOException e) {
            try {
                ((Writer)output).close();
            }
            catch (IOException closeException) {
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean setContents(String aFileURI, String aContents) {
        this.debug("setContents (" + aFileURI + ")");
        File aFile = new File(aFileURI);
        BufferedWriter output = null;
        if (!aFile.exists()) {
            this.debug("File does not exist, creating ...");
            try {
                aFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        if (aFile.isDirectory()) {
            this.debug("Should not be a directory: " + aFile);
            return false;
        }
        if (!aFile.canWrite()) {
            this.debug("File cannot be written: " + aFile);
            return false;
        }
        try {
            output = new BufferedWriter(new FileWriter(aFile));
        }
        catch (IOException e) {
            return false;
        }
        try {
            output.write(aContents);
            ((Writer)output).flush();
            ((Writer)output).close();
        }
        catch (IOException e) {
            try {
                ((Writer)output).close();
            }
            catch (IOException closeException) {
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean setContentsEncrypted(String aFileURI, String aContents) {
        this.debug("setContents (" + aFileURI + ")");
        String encrypted = "";
        try {
            encrypted = CTATLink.crypto.encrypt(aContents, CTATLink.keyString);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
            return false;
        }
        File aFile = new File(aFileURI);
        BufferedWriter output = null;
        if (!aFile.exists()) {
            this.debug("File does not exist: " + aFile);
            return false;
        }
        if (!aFile.isFile()) {
            this.debug("Should not be a directory: " + aFile);
            return false;
        }
        if (!aFile.canWrite()) {
            this.debug("File cannot be written: " + aFile);
            return false;
        }
        try {
            output = new BufferedWriter(new FileWriter(aFile));
        }
        catch (IOException e) {
            return false;
        }
        try {
            output.write(encrypted);
            ((Writer)output).flush();
            ((Writer)output).close();
        }
        catch (IOException e) {
            try {
                ((Writer)output).close();
            }
            catch (IOException closeException) {
                return false;
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getContentsEncrypted(String aFileURI) {
        this.debug("getContentsEncrypted (" + aFileURI + ")");
        File aFile = new File(aFileURI);
        if (!aFile.exists()) {
            this.debug("File does not exist: " + aFile);
            return null;
        }
        if (!aFile.isFile()) {
            this.debug("Should not be a directory: " + aFile);
            return null;
        }
        if (!aFile.canRead()) {
            this.debug("File cannot be read: " + aFile);
            return null;
        }
        try {
            FileReader reader = new FileReader(aFile);
            StringWriter writer = new StringWriter((int)aFile.length());
            char[] buffer = new char[1024];
            try {
                int num;
                while ((num = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, num);
                }
            }
            finally {
                ((Reader)reader).close();
            }
            String fileContents = ((Object)writer).toString();
            return CTATLink.crypto.decrypt(fileContents, CTATLink.keyString);
        }
        catch (FileNotFoundException e) {
            this.debug("File not found: " + e);
            return null;
        }
        catch (GeneralSecurityException e) {
            this.debug("GeneralSecurityException: " + e);
            return null;
        }
        catch (IOException e) {
            this.debug("IOException: " + e);
            return null;
        }
    }

    @Override
    public boolean configureCTATLink() {
        this.debug("configureCTATLink ()");
        String decrypted = this.getContents(CTATLink.configFilePath);
        return CTATLink.parse(decrypted);
    }

    public boolean saveConfigData() {
        return this.saveConfigData(CTATLink.configFilePath);
    }

    public boolean saveConfigData(String path) {
        this.debug("saveConfigData ()");
        StringBuilder str = new StringBuilder();
        str.append(CTATLink.htdocs);
        str.append("\t");
        str.append(CTATLink.hostName);
        str.append("\t");
        str.append(CTATLink.wwwPort);
        str.append("\t");
        str.append(CTATLink.tsPort);
        str.append("\t");
        str.append(CTATLink.tsMonitorPort);
        str.append("\t");
        str.append(CTATLink.remoteHost);
        str.append("\t");
        str.append(CTATLink.etc);
        str.append("\t");
        str.append(CTATLink.datashopURL);
        str.append("\t");
        str.append(CTATLink.datashopFile);
        str.append("\t");
        str.append(CTATLink.crossDomainPolicy);
        str.append("\t");
        str.append(CTATLink.adminPasswordFilename);
        str.append("\t");
        str.append(CTATLink.allowWriting);
        str.append("\t");
        str.append(CTATLink.useLocalTutoringService);
        str.append("\t");
        str.append(CTATLink.maxCachedFiles);
        str.append("\t");
        str.append(CTATLink.printDebugMessages);
        str.append("\t");
        str.append(CTATLink.datasetName);
        str.append("\t");
        str.append(CTATLink.noNetwork);
        str.append("\t");
        str.append(CTATLink.logdir);
        str.append("\t");
        str.append(CTATLink.showNavButtons);
        str.append("\t");
        if (CTATLink.deployType == CTATLink.DEPLOYFLASH) {
            str.append("flash");
        }
        str.append("\t");
        if (CTATLink.deployType == CTATLink.DEPLOYHTML5) {
            str.append("html5");
        }
        str.append("\t");
        str.append(CTATLink.handlerConfig);
        str.append("\t");
        if (CTATLink.deployMobileAPI == CTATLink.MOBILEAPIDISABLED) {
            str.append("disabled");
        }
        str.append("\t");
        if (CTATLink.deployMobileAPI == CTATLink.MOBILEAPION) {
            str.append("on");
        }
        str.append("\t");
        if (CTATLink.deployMobileAPI == CTATLink.MOBILEAPIAUTO) {
            str.append("auto");
        }
        str.append("\t");
        try {
            new File(path).createNewFile();
        }
        catch (IOException e) {
            this.debug(e.toString());
            return false;
        }
        return this.setContents(path, str.toString());
    }

    public void getFileProperties(String aFile) {
        File file = new File(aFile);
        if (!file.exists()) {
            this.debug("The File \"" + aFile + "\" does not exist. Please enter a valid FileName.");
            return;
        }
        this.debug("**Properties of File " + file.getAbsolutePath() + "**");
        if (file.isDirectory()) {
            System.out.println(file.getPath() + " is a directory.");
        } else {
            this.debug("Size of file in bytes... " + file.length());
        }
        if (file.canWrite()) {
            if (file.canRead()) {
                this.debug(file.getPath() + " is read-write.");
            } else {
                this.debug(file.getPath() + " cannot be read from, but write permissions are allowed.");
            }
        } else if (file.canRead()) {
            this.debug(file.getPath() + " is read-only");
        } else {
            this.debug("You cannot read or write to " + file.getPath());
        }
        String parent = file.getParent();
        if (parent == null) {
            this.debug(file.getPath() + " is a root directory.");
        } else {
            this.debug("Parent of " + file.getPath() + " is " + parent + ".");
        }
        if (file.isHidden()) {
            this.debug(file.getPath() + " is Hidden.");
        }
        this.debug(file.getPath() + " was last modified on " + new Date(file.lastModified()));
    }

    public Boolean copyfile(String srFile, String dtFile) {
        this.debug("copyFile (" + srFile + "," + dtFile + ")");
        try {
            int len;
            File f1 = new File(srFile);
            File f2 = new File(dtFile);
            FileInputStream in = new FileInputStream(f1);
            FileOutputStream out = new FileOutputStream(f2);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
            this.debug("File copied");
        }
        catch (FileNotFoundException ex) {
            this.debug(ex.getMessage() + " in the specified directory.");
            return false;
        }
        catch (IOException e) {
            this.debug("IO error copying file");
            this.debug(e.getMessage());
            return false;
        }
        return true;
    }

    public Boolean saveFileChecksum(String filename, String checksumFileName, Boolean encrypted) {
        this.debug("saveFileChecksum (" + filename + "," + checksumFileName + ")");
        String crc = null;
        try {
            crc = this.getMD5Checksum(filename);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        try {
            new File(checksumFileName).createNewFile();
        }
        catch (IOException e) {
            this.debug(e.toString());
            return false;
        }
        if (encrypted.booleanValue()) {
            return this.setContentsEncrypted(checksumFileName, crc);
        }
        return this.setContents(checksumFileName, crc);
    }

    public byte[] createChecksum(String filename) throws Exception {
        int numRead;
        CTATBase.debug("CTATDesktopFileManager", "createChecksum (" + filename + ")");
        if (!this.doesFileExist(filename)) {
            this.debug("File does not exist: " + filename);
            return null;
        }
        FileInputStream fis = new FileInputStream(filename);
        byte[] buffer = new byte[1024];
        MessageDigest complete = MessageDigest.getInstance("MD5");
        do {
            if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
            complete.update(buffer, 0, numRead);
        } while (numRead != -1);
        ((InputStream)fis).close();
        return complete.digest();
    }

    public String getMD5Checksum(String filename) throws Exception {
        CTATBase.debug("CTATDesktopFileManager", "getMD5Checksum (" + filename + ")");
        byte[] b = this.createChecksum(filename);
        if (b == null) {
            return null;
        }
        String result = "";
        for (int i = 0; i < b.length; ++i) {
            result = result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
        }
        return result;
    }

    public String cleanPath(String aPath) {
        while (aPath.indexOf("//") != -1) {
            aPath = aPath.replaceAll("//", "/");
        }
        String clean2 = aPath.replaceAll("\\\\\\\\", "\\\\");
        return clean2;
    }

    private String getJarName(String aFileURI) {
        int splitIndex = aFileURI.indexOf("?");
        if (splitIndex == -1) {
            return aFileURI;
        }
        return aFileURI.substring(0, splitIndex);
    }

    private String getJarFileName(String aFileURI) {
        int splitIndex = aFileURI.indexOf("?");
        if (splitIndex == -1) {
            return aFileURI;
        }
        String splitString = aFileURI.substring(splitIndex + 1);
        return this.cleanPath(splitString);
    }

    private InputStream getJarInputStream(String aFileURI) {
        this.debug("getJarInputStream (" + aFileURI + ")");
        JarFile jarFile = null;
        String jarName = this.getJarName(aFileURI);
        if (jarName == null) {
            this.debug("Error: jarName is null");
            return null;
        }
        this.debug("Using jar: " + jarName);
        try {
            jarFile = new JarFile(jarName);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        String jarFileName = this.getJarFileName(aFileURI);
        if (jarFileName == null) {
            this.debug("Error: jarFileName is null");
            try {
                jarFile.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return null;
        }
        this.debug("Using jar: " + jarFileName);
        JarEntry entry = jarFile.getJarEntry(jarFileName);
        if (entry == null) {
            this.debug("Error: entry is null");
            try {
                jarFile.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return null;
        }
        InputStream input = null;
        try {
            input = jarFile.getInputStream(entry);
        }
        catch (IOException e) {
            this.debug("Unable to obtain inputstream for entry in jar");
            e.printStackTrace();
            try {
                jarFile.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return null;
        }
        this.debug("We should now have an open input stream set on our jar file entry");
        return input;
    }

    private String getJarContents(String aFileURI) {
        this.debug("getJarContents (" + aFileURI + ")");
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(this.getJarName(aFileURI));
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
        JarEntry entry = jarFile.getJarEntry(this.getJarFileName(aFileURI));
        InputStream input = null;
        try {
            input = jarFile.getInputStream(entry);
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                jarFile.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return "";
        }
        InputStreamReader isr = new InputStreamReader(input);
        BufferedReader reader = new BufferedReader(isr);
        StringBuffer formatter = new StringBuffer();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                formatter.append(line);
                formatter.append("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
        try {
            jarFile.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return formatter.toString();
    }

    private Boolean jarFileExist(String aJarURI) {
        this.debug("jarFileExist (" + aJarURI + ")");
        String aJar = this.getJarName(aJarURI);
        String filePath = this.getJarFileName(aJarURI);
        this.debug("Looking for " + filePath + " in " + aJar);
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(aJar);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        Enumeration<JarEntry> enm = jarFile.entries();
        while (enm.hasMoreElements()) {
            JarEntry entry = enm.nextElement();
            String name = entry.getName();
            if (!name.equalsIgnoreCase(filePath)) continue;
            this.debug("File found!");
            try {
                jarFile.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return true;
        }
        this.debug("File not found in jar!");
        try {
            jarFile.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return false;
    }

    public void jarListContents(String aJarURI) {
        this.debug("jarListContents (" + aJarURI + ")");
        String aJar = this.getJarName(aJarURI);
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(aJar);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        Enumeration<JarEntry> enm = jarFile.entries();
        while (enm.hasMoreElements()) {
            JarEntry entry = enm.nextElement();
            String name = entry.getName();
            long size = entry.getSize();
            long compressedSize = entry.getCompressedSize();
            this.debug(name + "\t" + size + "\t" + compressedSize);
        }
        try {
            jarFile.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        CTATLink link = new CTATLink(new CTATDesktopFileManager());
        CTATLink.printDebugMessages = true;
        CTATBase.debug("CTATDesktopFileManager", "main ()");
        String inputFile = "";
        String outputFile = "";
        Boolean enc = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].toLowerCase().equals("-input") || args[i].equals("-inputfile")) {
                inputFile = args[i + 1];
            }
            if (args[i].toLowerCase().equals("-output") || args[i].equals("-outputfile")) {
                outputFile = args[i + 1];
            }
            if (!args[i].toLowerCase().equals("-encrypted")) continue;
            enc = args[i + 1].toLowerCase().equals("yes") ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        if (inputFile.isEmpty()) {
            CTATBase.debug("CTATDesktopFileManager", "Please specify an input file");
            return;
        }
        if (outputFile.isEmpty()) {
            CTATBase.debug("CTATDesktopFileManager", "No input specified, creating name from input file ...");
            outputFile = inputFile + ".crc";
        }
        CTATBase.debug("CTATDesktopFileManager", "Creating MD5 checksum from: " + inputFile + " and storing into: " + outputFile);
        CTATDesktopFileManager fManager = new CTATDesktopFileManager();
        if (!fManager.doesFileExist(inputFile)) {
            CTATBase.debug("CTATDesktopFileManager", "Error: input file does not exist: " + inputFile);
            return;
        }
        fManager.saveFileChecksum(inputFile, outputFile, enc);
    }

    public String[] listFiles(String dname) {
        File f = new File(dname);
        String[] files = f.list();
        this.debug("listFiles(" + dname + ") returns String[" + (files == null ? "null" : Integer.toString(files.length)) + "]");
        return files;
    }

    public boolean delete(String fname) {
        File f = new File(fname);
        boolean result = f.delete();
        this.debug("delete(" + fname + ") returns " + result);
        return result;
    }

    public static boolean deleteRecursive(File path) throws FileNotFoundException {
        if (!path.exists()) {
            throw new FileNotFoundException(path.getAbsolutePath());
        }
        boolean ret = true;
        if (path.isDirectory()) {
            for (File f : path.listFiles()) {
                ret = ret && CTATDesktopFileManager.deleteRecursive(f);
            }
        }
        return ret && path.delete();
    }
}

