/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat;

import edu.cmu.hcii.ctat.CTATBase;
import java.io.Serializable;
import java.util.ArrayList;

public class CTATMilestone
extends CTATBase
implements Serializable {
    private static final long serialVersionUID = -356274976381830723L;
    public static int TYPEUNSET = 0;
    public static int TYPETIME = 1;
    public static int TYPESKILL = 2;
    public static int TYPEMETA = 3;
    public static int TYPEPSET = 4;
    public static int TYPEASSN = 5;
    public static int WAITING = 0;
    public static int ACCOMPLISHED = 1;
    public static int SHOWN = 2;
    public static int METAAND = 0;
    public static int METAOR = 1;
    private int type = TYPESKILL;
    private String slug = "";
    private String description = "";
    private String image = "CT30.png";
    private ArrayList<String> children = null;
    private String test = "nop";
    private int metaType = METAAND;
    private String assignment = null;
    private int state = WAITING;

    public CTATMilestone() {
        this.setClassName("CTATMilestone");
        this.debug("CTATMilestone ()");
        this.children = new ArrayList();
    }

    public int getMetaType() {
        return this.metaType;
    }

    public void setMetaType(int metaType) {
        this.metaType = metaType;
    }

    public ArrayList<String> getChildren() {
        return this.children;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public String getSlug() {
        return this.slug;
    }

    public void setSlug(String slug) {
        this.slug = slug;
    }

    public String getTest() {
        return this.test;
    }

    public void setTest(String aTest) {
        this.debug("setTest (" + aTest + ")");
        if (aTest.startsWith("skill:")) {
            this.test = aTest.substring(6);
            this.type = TYPESKILL;
            this.debug("test: " + this.test);
            return;
        }
        if (aTest.startsWith("assignment_completed:")) {
            this.test = aTest.substring(21);
            this.type = TYPEASSN;
            this.debug("test: " + this.test);
            return;
        }
        if (aTest.startsWith("problemset_completed:")) {
            this.test = aTest.substring(21);
            this.type = TYPEPSET;
            this.debug("test: " + this.test);
            return;
        }
        if (aTest.startsWith("meta:")) {
            this.test = aTest.substring(5);
            this.type = TYPEMETA;
            this.debug("test: " + this.test);
            this.parseMeta(this.test);
            return;
        }
    }

    public String getAssignment() {
        return this.assignment;
    }

    public void setAssignment(String assignment) {
        this.assignment = assignment;
    }

    private void parseMeta(String test) {
        this.debug("parseMeta (" + test + ")");
        if (test.indexOf(":or:") != -1) {
            this.setMetaType(METAOR);
            String[] splitterA = test.split(":or:");
            this.debug("Found " + splitterA.length + " terms for OR meta");
            this.children = new ArrayList();
            for (int i = 0; i < splitterA.length; ++i) {
                this.children.add(splitterA[i]);
            }
        } else {
            this.setMetaType(METAAND);
            String[] splitterB = test.split(":and:");
            this.debug("Found " + splitterB.length + " terms for AND meta");
            this.children = new ArrayList();
            for (int i = 0; i < splitterB.length; ++i) {
                this.children.add(splitterB[i]);
            }
        }
    }

    @Override
    public String toString() {
        return "Type: " + this.type + "; Slug: " + this.slug + "; Description: " + this.description + "; Image: " + this.image + "; Children: " + this.children + "; Test: " + this.test + "; MetaType: " + this.metaType + "; Assignment: " + this.assignment + "; State: " + this.state;
    }
}

