/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class CTATSWFObject {
    static final int UNCOMP_HDR_LEN = 8;
    public boolean isCompressed;
    public int version;
    public long size;
    public int width;
    public int height;
    public float fps;
    public int frameCount;

    private CTATSWFObject() {
    }

    public static CTATSWFObject getInfo(String path) {
        return CTATSWFObject.getInfo(new File(path));
    }

    public static CTATSWFObject getInfo(File file) {
        CTATSWFObject info = new CTATSWFObject();
        byte[] hdr = CTATSWFObject.getBytes(file);
        if (hdr == null) {
            return null;
        }
        info.isCompressed = hdr[0] == 67;
        info.version = hdr[3];
        info.size = hdr[4] & 0xFF | (hdr[5] & 0xFF) << 8 | (hdr[6] & 0xFF) << 16 | hdr[7] << 24;
        BitReader rdr = new BitReader(hdr, 8);
        int[] dims = CTATSWFObject.decodeRect(rdr);
        info.width = (dims[1] - dims[0]) / 20;
        info.height = (dims[3] - dims[2]) / 20;
        info.fps = (float)rdr.uI16() / 256.0f;
        info.frameCount = rdr.uI16();
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getBytes(File file) {
        if (file == null || !file.exists() || file.isDirectory()) {
            return null;
        }
        byte[] bytes = new byte[128];
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            if (fis.read(bytes) < bytes.length) {
                bytes = null;
            } else if (bytes[0] == 67 && bytes[1] == 87 && bytes[2] == 83) {
                bytes = CTATSWFObject.expand(bytes, 8);
            } else if (bytes[0] != 70 || bytes[1] != 87 || bytes[2] != 83) {
                bytes = null;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return bytes;
    }

    private static byte[] expand(byte[] bytes, int skip) {
        byte[] newBytes = new byte[bytes.length - skip];
        Inflater inflater = new Inflater();
        inflater.setInput(bytes, skip, newBytes.length);
        try {
            int outCount = inflater.inflate(newBytes);
            System.arraycopy(newBytes, 0, bytes, skip, outCount);
            Arrays.fill(bytes, skip + outCount, bytes.length, (byte)0);
            return bytes;
        }
        catch (DataFormatException dataFormatException) {
            return null;
        }
    }

    public static int[] decodeRect(BitReader rdr) {
        int[] dims = new int[4];
        int nBits = rdr.uBits(5);
        dims[0] = rdr.sBits(nBits);
        dims[1] = rdr.sBits(nBits);
        dims[2] = rdr.sBits(nBits);
        dims[3] = rdr.sBits(nBits);
        return dims;
    }

    static class BitReader {
        private byte[] bytes;
        private int byteIdx;
        private int bitIdx = 0;

        public BitReader(byte[] bytes) {
            this(bytes, 0);
        }

        public BitReader(byte[] bytes, int startIndex) {
            this.bytes = bytes;
            this.byteIdx = startIndex;
        }

        public int uBits(int bitCount) {
            int value = 0;
            while (--bitCount >= 0) {
                value = value << 1 | this.getBit();
            }
            return value;
        }

        public int sBits(int bitCount) {
            int value = this.getBit() == 0 ? 0 : -1;
            --bitCount;
            while (--bitCount >= 0) {
                value = value << 1 | this.getBit();
            }
            return value;
        }

        private int getBit() {
            int value = this.bytes[this.byteIdx] >> 7 - this.bitIdx & 1;
            if (++this.bitIdx == 8) {
                this.bitIdx = 0;
                ++this.byteIdx;
            }
            return value;
        }

        public int uI16() {
            this.sync();
            return this.bytes[this.byteIdx++] & 0xFF | (this.bytes[this.byteIdx++] & 0xFF) << 8;
        }

        public void sync() {
            if (this.bitIdx > 0) {
                ++this.byteIdx;
                this.bitIdx = 0;
            }
        }
    }
}

