/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat;

public class CTATURLParamEncoder {
    public static String encode(String input) {
        StringBuilder resultStr = new StringBuilder();
        for (char ch : input.toCharArray()) {
            if (CTATURLParamEncoder.isUnsafe(ch)) {
                resultStr.append('%');
                resultStr.append(CTATURLParamEncoder.toHex(ch / 16));
                resultStr.append(CTATURLParamEncoder.toHex(ch % 16));
                continue;
            }
            resultStr.append(ch);
        }
        return resultStr.toString();
    }

    private static char toHex(int ch) {
        return (char)(ch < 10 ? 48 + ch : 65 + ch - 10);
    }

    private static boolean isUnsafe(char ch) {
        if (ch > '\u0080' || ch < '\u0000') {
            return true;
        }
        return " %$&+,/:;=?@<>#%".indexOf(ch) >= 0;
    }
}

