/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat.monitor;

import com.sleepycat.collections.StoredMap;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.Environment;
import edu.cmu.hcii.ctat.CTATBase;
import java.util.Iterator;
import java.util.Map;

public class CTATBerkeleyDBInstance
extends CTATBase {
    private Database db = null;
    private DatabaseConfig dbConfig = null;
    private StoredMap<Long, String> map = null;
    private Environment env = null;
    private boolean dbDisabled = false;
    private boolean create = true;
    private String dbDir = "./db";

    public CTATBerkeleyDBInstance() {
        this.setClassName("CTATBerkeleyDBInstance");
        this.debug("CTATBerkeleyDBInstance ()");
    }

    public Database getDB() {
        return this.db;
    }

    public void setEnvironment(Environment anEnv) {
        this.env = anEnv;
    }

    public Environment getEnvironment() {
        return this.env;
    }

    public boolean isDbDisabled() {
        return this.dbDisabled;
    }

    public void setDbDisabled(boolean dbDisabled) {
        this.dbDisabled = dbDisabled;
    }

    public String getDbDir() {
        return this.dbDir;
    }

    public void setDbDir(String dbDir) {
        this.dbDir = dbDir;
    }

    public StoredMap<Long, String> getData() {
        return this.map;
    }

    public void assignMap(StoredMap<Long, String> aMap) {
        this.map = aMap;
    }

    public void openDB(String DBName) throws Exception {
        this.debug("openDB ()");
        if (this.env == null) {
            this.debug("Error, no Environment available");
            return;
        }
        this.dbConfig = new DatabaseConfig();
        this.dbConfig.setTransactional(true);
        if (this.create) {
            this.dbConfig.setAllowCreate(true);
        }
        this.db = this.env.openDatabase(null, DBName, this.dbConfig);
        if (this.db == null) {
            this.setDbDisabled(true);
            return;
        }
        this.debug("Database should be open and available for binding");
    }

    public Boolean close() {
        this.debug("close ()");
        this.dbDisabled = true;
        this.debug("Closing database ...");
        if (this.db != null) {
            this.db.close();
            this.db = null;
        }
        this.debug("Resetting map ...");
        this.map = null;
        this.debug("Database successfully shutdown");
        return true;
    }

    public boolean writeKV(Long aKey, String aValue) {
        this.debug("writeKV (key:" + aKey + ", value:" + aValue + ")");
        if (this.dbDisabled) {
            this.debug("Error: database is not open or disabled, aborting");
            return false;
        }
        if (this.map == null) {
            this.debug("No map available to write to, aborting ..");
            return false;
        }
        this.map.put((Object)aKey, (Object)aValue);
        return true;
    }

    public void dumpDB() {
        this.debug("dumpDB ()");
        if (this.map == null) {
            this.debug("No map available to read from, aborting ..");
            return;
        }
        this.debug("Map size: " + this.map.size() + " entries");
        Iterator iter = null;
        try {
            iter = this.map.entrySet().iterator();
        }
        catch (IndexOutOfBoundsException e) {
            this.debug("Integrity check failed, IndexOutOfBoundsException");
        }
        this.debug("Reading data ...");
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            this.debug(((Long)entry.getKey()).toString() + ' ' + (String)entry.getValue());
        }
    }

    public Boolean checkDB() {
        this.debug("checkDB ()");
        if (this.map == null) {
            this.debug("No map available to read from, aborting ..");
            return false;
        }
        this.debug("Checking: " + this.map.size() + " entries");
        Iterator iter = null;
        try {
            iter = this.map.entrySet().iterator();
        }
        catch (IndexOutOfBoundsException e) {
            this.debug("Integrity check failed, IndexOutOfBoundsException");
            return false;
        }
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            System.out.print(".");
        }
        System.out.println(" done");
        return true;
    }
}

