/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat.monitor;

import edu.cmu.hcii.ctat.monitor.CTATXMLBase;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CTATServerConfig
extends CTATXMLBase {
    private ArrayList<String> smtpContacts = null;
    private ArrayList<String> emailContacts = null;

    public CTATServerConfig() {
        this.setClassName("CTATServerConfig");
        this.debug("CTATServerConfig ()");
        this.smtpContacts = new ArrayList();
        this.emailContacts = new ArrayList();
    }

    public ArrayList<String> getSMTPContacts() {
        return this.smtpContacts;
    }

    public ArrayList<String> getEmailContacts() {
        return this.emailContacts;
    }

    @Override
    public Boolean fromXML(Element root) {
        this.debug("fromXML ()");
        if (root.getNodeName().equals("config")) {
            NodeList children = root.getChildNodes();
            if (children == null) {
                this.debug("Internal error: children list is null");
                return false;
            }
            if (children.getLength() > 0) {
                for (int i = 0; i < children.getLength(); ++i) {
                    int j;
                    Node node = children.item(i);
                    if (node.getNodeType() != 1) continue;
                    this.debug("Parsing: " + node.getNodeName());
                    if (node.getNodeName().equals("contactServers")) {
                        NodeList servers = node.getChildNodes();
                        for (j = 0; j < servers.getLength(); ++j) {
                            Node aServerNode = servers.item(j);
                            if (aServerNode.getNodeType() != 1) continue;
                            this.debug("Parsing: " + aServerNode.getNodeName());
                            Element aServer = (Element)aServerNode;
                            this.smtpContacts.add(aServer.getAttribute("url"));
                        }
                    }
                    if (!node.getNodeName().equals("contacts")) continue;
                    NodeList emails = node.getChildNodes();
                    for (j = 0; j < emails.getLength(); ++j) {
                        Node email = emails.item(j);
                        if (email.getNodeType() != 1) continue;
                        this.debug("Parsing: " + email.getNodeName());
                        Element anEmail = (Element)email;
                        this.emailContacts.add(anEmail.getAttribute("email"));
                    }
                }
            }
        }
        return true;
    }
}

