/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat.monitor;

import edu.cmu.hcii.ctat.monitor.CTATClientEntry;
import java.util.Date;

public class CTATWSEntry
extends CTATClientEntry {
    private Integer lastAmountReceived = 0;

    public CTATWSEntry() {
        this.setClassName("CTATWSEntry");
        this.debug("CTATWSEntry ()");
        this.setClientType("webservice");
        this.setPort(80);
        this.setAccess("HTTP");
    }

    public Integer getLastAmountReceived() {
        return this.lastAmountReceived;
    }

    @Override
    public void setStatus(String status) {
        super.setStatus(status);
        if (this.getShouldLog().booleanValue()) {
            StringBuffer formatter = new StringBuffer();
            Date stamp = new Date();
            Integer currentTimeStamp = (int)stamp.getTime();
            formatter.append(String.format("%d", stamp.getTime()));
            formatter.append(",");
            formatter.append(status);
            formatter.append(",");
            formatter.append(String.format("%d", currentTimeStamp - this.getLastTimestamp()));
            formatter.append(",");
            formatter.append(String.format("%d", this.getLastAmountReceived()));
            this.setLastTimestamp(currentTimeStamp);
            if (this.logger != null) {
                this.logger.addLine(formatter.toString());
            }
        }
    }

    public void setLastAmountReceived(Integer lastAmountReceived) {
        if (!this.lastAmountReceived.equals(lastAmountReceived)) {
            this.lastAmountReceived = lastAmountReceived;
        }
    }

    @Override
    public void startLogging() {
        this.debug("startLogging ()");
        if (this.getShouldLog().booleanValue()) {
            this.logger.setFileID("WS-" + this.getGuid() + "-" + this.getHostname());
        } else {
            this.debug("Logging is disabled for this entry");
        }
    }
}

