/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.utilities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DiagTools {
    private static final String topLevelPkg;

    private DiagTools() {
    }

    public static List<String> listThreads() {
        Thread[] activeThreads = new Thread[Thread.activeCount() * 5];
        int count = Thread.enumerate(activeThreads);
        ArrayList<String> tNames = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            int j;
            Thread t = activeThreads[i];
            StackTraceElement[] stack = t.getStackTrace();
            StringBuilder sb = new StringBuilder();
            int nSkipped = 0;
            for (j = 0; j < stack.length - 1; ++j) {
                if (stack[j].getClassName().startsWith(topLevelPkg)) {
                    if (nSkipped > 0) {
                        if (nSkipped > 1) {
                            sb.append("\n   ...");
                        }
                        sb.append("\n   ").append(stack[j - 1].toString());
                    }
                    sb.append("\n   ").append(stack[j].toString());
                    nSkipped = 0;
                    continue;
                }
                ++nSkipped;
            }
            if (sb.length() < 1) {
                for (j = 0; j < stack.length - 1; ++j) {
                    sb.append("\n   ").append(stack[j].toString());
                }
            }
            tNames.add("\n" + t.toString() + ":" + sb.toString());
        }
        Collections.sort(tNames);
        return tNames;
    }

    static {
        String[] thisClassName = new DiagTools().getClass().getName().split("\\.");
        topLevelPkg = thisClassName[0] + (thisClassName.length > 1 ? "." + thisClassName[1] : "");
    }
}

