/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.oli.log.tools;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class DiskFileSplitter {
    private static boolean splitToFile = false;
    private static int chunkNo = 0;
    private static long totalBytesWritten = 0L;
    private static int totalRecordsWritten = 0;

    private static void usageExit(String msg) {
        System.out.println(msg + " Purpose: splits OLI disk log by lines. Writes to stdout or chunk files named <inputFile>.1, <inputFile>.2, ....\nUsage:\n  java -cp .. " + DiskFileSplitter.class.getName() + " [-h] [-s splitLength] [inputFile]\nwhere--\n  -h          prints this message;\n  splitLength means split the file into chunks of about this length (in messages);\n  inputFile   OLI disk log file to read; reads stdin if omitted.");
        System.exit(1);
    }

    public static void main(String[] args) throws FileNotFoundException {
        int i = 0;
        int splitLen = 100;
        splitToFile = false;
        block8: for (i = 0; i < args.length && '-' == args[i].charAt(0); ++i) {
            switch (args[i].charAt(1)) {
                case 'H': 
                case 'h': {
                    DiskFileSplitter.usageExit("Help message.");
                    continue block8;
                }
                case 'S': 
                case 's': {
                    try {
                        splitLen = Integer.parseInt(args[++i]);
                        splitToFile = true;
                    }
                    catch (NumberFormatException nfe) {
                        DiskFileSplitter.usageExit("Error parsing split length: " + nfe);
                    }
                    continue block8;
                }
                default: {
                    DiskFileSplitter.usageExit("Undefined option \"-" + args[i].charAt(1) + "\".");
                }
            }
        }
        String inFileName = null;
        InputStreamReader inFile = null;
        if (i < args.length) {
            inFileName = args[i++];
            inFile = new FileReader(inFileName);
        } else {
            inFileName = "stdin";
            inFile = new InputStreamReader(System.in);
        }
        ArrayList<String> xmlDocs = new ArrayList<String>();
        StringBuffer line = new StringBuffer();
        BufferedReader in = new BufferedReader(inFile);
        try {
            int chunkLen = 524288;
            int c = -1;
            while (0 <= (c = in.read())) {
                line.append((char)c);
                int len = line.length();
                if (len > chunkLen && "<?xml".equals(line.substring(len - 5))) {
                    String chunk = line.substring(0, len - 5);
                    line.delete(0, len - 5);
                    DiskFileSplitter.split(xmlDocs, chunk);
                    while (xmlDocs.size() >= splitLen) {
                        DiskFileSplitter.writeFile(inFileName, splitLen, xmlDocs);
                    }
                }
                c = -1;
            }
            DiskFileSplitter.split(xmlDocs, line.toString());
            while (xmlDocs.size() > 0) {
                DiskFileSplitter.writeFile(inFileName, splitLen, xmlDocs);
            }
        }
        catch (IOException ex) {
            System.err.println("Error reading " + (args.length > 0 ? args[0] : "stdin") + " at line " + i);
            ex.printStackTrace();
            System.exit(2);
        }
        System.out.println("\nFound " + totalRecordsWritten + " documents.");
    }

    private static void writeFile(String inFileName, int splitLen, List<String> xmlDocs) {
        String outFileName = null;
        int i = 0;
        try {
            PrintStream outStr = null;
            if (splitToFile) {
                outFileName = inFileName + "." + Integer.toString(++chunkNo);
                outStr = new PrintStream(new FileOutputStream(outFileName));
            } else {
                outStr = System.out;
            }
            int nToWrite = Math.min(xmlDocs.size(), splitLen);
            for (i = 0; i < nToWrite; ++i) {
                String record = xmlDocs.remove(0);
                byte[] bytes = record.getBytes("ISO-8859-1");
                ++totalRecordsWritten;
                totalBytesWritten += (long)bytes.length;
                if (!splitToFile) {
                    outStr.printf("\n%5d. %8d ", totalRecordsWritten, totalBytesWritten);
                }
                outStr.write(bytes);
                outStr.flush();
            }
            if (splitToFile) {
                outStr.close();
            }
        }
        catch (IOException ex) {
            System.err.println("Error writing " + outFileName + " at record# " + i);
            ex.printStackTrace();
            System.exit(3);
        }
    }

    private static void split(List<String> xmlDocs, String chunk) {
        String[] chunkDocs = chunk.split("<\\?xml");
        for (int i = 1; i < chunkDocs.length; ++i) {
            xmlDocs.add("<?xml" + chunkDocs[i]);
        }
    }
}

