/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Controller.LMS;

import cl.LMS.client.LMS_Client;
import cl.LMS.exception.LMS_Exception;
import cl.common.CL_Class;
import cl.common.CL_Curriculum;
import cl.common.CL_Instructor;
import cl.common.CL_School;
import cl.common.CL_Section;
import cl.common.CL_SectionSkill;
import cl.common.CL_Student;
import cl.common.CL_StudentSkill;
import cl.common.CL_StudentStatus;
import cl.common.CL_Unit;
import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Dialogs.OpenInterfaceDialog;
import edu.cmu.pact.CTAT_LMS_Launcher;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.CtatLMSClient;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import pact.CommWidgets.SkillometerManager;
import pact.CommWidgets.StudentInterfaceWrapper;
import pact.CommWidgets.TutorWindow;

public class CTAT_LMS
implements ActionListener,
CtatLMSClient {
    private String initialStateFolder;
    private boolean initialized;
    private LMS_Client lmsClient;
    private CL_School clSchool;
    private List classList;
    private List studentList;
    private CL_Class clClass;
    private CL_Curriculum clCurriculum;
    private CL_Student clStudent;
    private CL_StudentStatus clStudentStatus;
    private CL_Unit clUnit;
    private boolean loggedIn;
    private String lastSectionName;
    private String lastUnitName;
    private String currentSectionName;
    private String currentUnitName;
    private BR_Controller controller;
    private HashMap interfaceTable = new HashMap();
    private SkillometerManager skillometerManager;
    private CTAT_LMS_Launcher ctatCarnegieLearningLauncher;

    public CTAT_LMS(BR_Controller controller, SkillometerManager skillometerManager) {
        this.controller = controller;
        this.skillometerManager = skillometerManager;
    }

    public void login() {
    }

    private void loginStudent(String studentName) {
        LMS_Client.Student_N_Curricula curricula = null;
        try {
            int answer;
            this.controller.getLoggingSupport().setStudentName(studentName);
            this.controller.getLoggingSupport().resetLogger();
            this.controller.getLoggingSupport().setEnableAuthorLog(false);
            if (trace.getDebugCode("ctat_lms")) {
                trace.out("ctat_lms", "school = " + this.clSchool + " student =  " + studentName);
            }
            curricula = this.lmsClient.loginStudent(this.clSchool, studentName, null, null, false);
            if (trace.getDebugCode("ctat_lms")) {
                trace.out("ctat_lms", "curricula = " + curricula.activeCurriculaList);
            }
            if (curricula.activeCurriculaList.size() <= 0) {
                String title = "Error loading curricula";
                String message = "<html>No valid curricula were found for the student " + studentName + "<br>at root.ref location " + this.getRootRef();
                JOptionPane.showMessageDialog(this.controller.getJGraphWindow(), message, title, 2);
                return;
            }
            this.clCurriculum = (CL_Curriculum)curricula.activeCurriculaList.get(0);
            if (trace.getDebugCode("ctat_lms")) {
                trace.out("ctat_lms", "clCurriculum.getId() = " + this.clCurriculum.getId());
            }
            this.loadInterfaceMapFile((String)this.clCurriculum.getId());
            this.clStudent = this.lmsClient.getStudentPosition(this.clSchool, curricula.student, this.clCurriculum);
            if (trace.getDebugCode("ctat_lms")) {
                trace.out("ctat_lms", "clStudent = " + this.clStudent);
            }
            this.clStudentStatus = this.lmsClient.getCurrentProblemState(this.clSchool, this.clStudent, this.clCurriculum);
            if (trace.getDebugCode("ctat_lms")) {
                trace.out("ctat_lms", "clStudentStatus = " + this.clStudentStatus);
            }
            this.clUnit = this.clStudentStatus.getCurrentUnit();
            if (trace.getDebugCode("ctat_lms")) {
                trace.out("ctat_lms", "clUnit= " + this.clUnit);
            }
            CL_Section clSection = this.clStudentStatus.getCurrentSection();
            if (trace.getDebugCode("ctat_lms")) {
                trace.out("ctat_lms", "clSection = " + clSection);
            }
            if (trace.getDebugCode("ctat_lms")) {
                trace.out("ctat_lms", "problem list = " + this.clStudentStatus.getCompiledProblemList());
            }
            CL_Instructor clInstructor = (CL_Instructor)this.lmsClient.getAllInstructors(this.clSchool).get(0);
            if (trace.getDebugCode("ctat_lms")) {
                trace.out("ctat_lms", "clInstructor = " + clInstructor);
            }
            if (this.clStudent.getFirstName().charAt(0) != '_' && (answer = JOptionPane.showConfirmDialog(null, "Would you like to reset the unit \n and section to the beginning?", "Reset unit/section?", 0)) == 0) {
                this.lmsClient.changeStudentPlacement(this.clStudent, this.clCurriculum, this.clUnit, clSection, null, clInstructor, "");
            }
            this.clStudent = this.lmsClient.getStudentPosition(this.clSchool, curricula.student, this.clCurriculum);
        }
        catch (LMS_Exception e) {
            e.printStackTrace();
            return;
        }
        this.loadInterfaceAndProblem();
        this.loggedIn = true;
    }

    private void loadInterface(String interfaceName) {
        this.controller.closeCurrentInterface();
        trace.out("inter", "load interface");
        String filename = this.getInitialStateFolder() + interfaceName + ".class";
        StudentInterfaceWrapper window2 = this.controller.getStudentInterface();
        Point p = null;
        if (window2 instanceof TutorWindow) {
            p = ((TutorWindow)((Object)window2)).getLocation();
            window2.setVisible(false);
            ((TutorWindow)((Object)window2)).dispose();
        }
        StudentInterfaceWrapper window = OpenInterfaceDialog.openInterface(new File(filename), this.controller);
        if (p != null && window instanceof TutorWindow) {
            ((TutorWindow)((Object)window)).setLocation(p);
        }
        if (window != null) {
            window.setVisible(true);
        }
    }

    private void loadInterfaceMapFile(String unitID) {
        String rootRef = this.getRootRef();
        if (trace.getDebugCode("ctat_lms")) {
            trace.out("ctat_lms", "root.ref = " + rootRef);
        }
        String filename = rootRef + File.separator + "Administrative" + File.separator + "Curricula" + File.separator + unitID + ".interfaces";
        if (trace.getDebugCode("ctat_lms")) {
            trace.out("ctat_lms", "file = " + filename);
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(filename);
            this.loadInterfaceMapDocument(doc);
        }
        catch (Exception e) {
            if (trace.getDebugCode("ctat_lms")) {
                trace.out("ctat_lms", "error reading file " + filename + ": " + e);
            }
            e.printStackTrace();
            return;
        }
    }

    private String getRootRef() {
        String ref = System.getProperty("root.ref");
        if (ref != null) {
            return ref;
        }
        trace.out("ctat_lms", "root.ref system property not set, trying Root.ref file in working directory");
        try {
            BufferedReader in = new BufferedReader(new FileReader("Root.ref"));
            ref = in.readLine();
            in.close();
        }
        catch (IOException e) {
            if (trace.getDebugCode("ctat_lms")) {
                trace.out("ctat_lms", "File Root.ref not found.  Cannot load interfaces correctly.");
            }
            e.printStackTrace();
            return null;
        }
        if (trace.getDebugCode("inter")) {
            trace.out("inter", " root.ref = " + ref);
        }
        return ref;
    }

    private void loadInterfaceMapDocument(Document doc) {
        Element root = doc.getRootElement();
        for (Element el : root.getChildren()) {
            Iterator problems = el.getChildren().iterator();
            String interfaceName = el.getAttributeValue("name");
            while (problems.hasNext()) {
                Element prob = (Element)problems.next();
                String problemName = prob.getAttributeValue("name").toUpperCase();
                this.interfaceTable.put(problemName.toUpperCase(), interfaceName);
            }
        }
    }

    private void loadBRDFile(String problemName) {
        String filename = this.getInitialStateFolder() + problemName + ".brd";
        if (trace.getDebugCode("inter")) {
            trace.printStack("inter", "load new brd file: " + filename);
        }
        this.controller.reset();
        try {
            problemName = this.getCLProblemName(problemName);
            boolean bl = this.controller.openBRDFileAndSendStartState(filename, problemName);
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = "<html>The file could not be found or the format of the file is not recognized. <br>Please check the file and try again.";
            String title = "Error loading file";
            Utils.showExceptionOccuredDialog(e, message, title);
        }
        this.controller.getProblemModel().setProblemName(problemName);
    }

    private String getCLProblemName(String problemName) {
        if (this.clStudentStatus == null) {
            return problemName;
        }
        if (this.clStudentStatus.getCurrentProblem() == null) {
            return problemName;
        }
        String clProblemName = this.clStudentStatus.getCurrentProblem().getProblemName();
        if (clProblemName == null || clProblemName.length() < 1) {
            return problemName;
        }
        return clProblemName;
    }

    @Override
    public boolean isStudentLoggedIn() {
        return this.loggedIn;
    }

    @Override
    public void logout() {
        if (this.ctatCarnegieLearningLauncher == null) {
            return;
        }
        this.ctatCarnegieLearningLauncher.setIsFinished(true);
    }

    private void storeStudentState(String action) {
        CL_StudentStatus.State newState = new CL_StudentStatus.State();
        newState.setAction(action);
        String problemState = "current node here";
        newState.setCurrentProblemState(problemState);
        if (trace.getDebugCode("ctat_lms")) {
            trace.out("ctat_lms", "STORING STUDENT STATE: problem state = " + problemState);
        }
        if (this.skillometerManager != null) {
            Vector names = this.skillometerManager.getSkillNames();
            for (int i = 0; i < names.size(); ++i) {
                String skillName = (String)names.elementAt(i);
                float pKnown = this.skillometerManager.getSkillValue(skillName);
                if (trace.getDebugCode("ctat_lms")) {
                    trace.out("ctat_lms", "adding skill " + skillName + " pKnown = " + pKnown);
                }
                newState.addStudentSkill(skillName, pKnown);
            }
        }
        newState.setHints(0);
        newState.setErrors(0);
        newState.setUniqueErrors(0);
        newState.setUniqueHints(0);
        try {
            this.clStudentStatus.mergeUpdates(newState);
            this.lmsClient.putStudentProblemData(this.clSchool, this.clStudent, this.clCurriculum, this.clStudentStatus);
        }
        catch (LMS_Exception e) {
            if (trace.getDebugCode("ctat_lms")) {
                trace.out("ctat_lms", "Error writing student problem data");
            }
            e.printStackTrace();
        }
    }

    @Override
    public void advanceProblem() {
        if (trace.getDebugCode("inter")) {
            trace.out("inter", "**** advance problem now");
        }
        if (!this.loggedIn) {
            trace.err("Cannot advance problem when student is not logged in.");
            return;
        }
        try {
            this.storeStudentState("Done");
            this.lastSectionName = this.clStudentStatus.getCurrentSection().getSectionName();
            this.lastUnitName = this.clStudentStatus.getCurrentUnit().getUnitName();
            LMS_Client.Problem_N_Activity_Status activityStatus = this.lmsClient.advanceToNextProblem(this.clSchool, this.clStudent, this.clCurriculum);
            this.clStudentStatus = this.lmsClient.getCurrentProblemState(this.clSchool, this.clStudent, this.clCurriculum);
            this.currentSectionName = this.clStudentStatus.getCurrentSection().getSectionName();
            this.currentUnitName = this.clStudentStatus.getCurrentUnit().getUnitName();
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "*** lastSectionName " + this.lastSectionName + ", lastUnitName " + this.lastUnitName + ", currentSectionName " + this.currentSectionName + ", currentUnitName " + this.currentUnitName + ", problem_status_d " + activityStatus.problem_status_d + ", activity_status_d " + activityStatus.activity_status_d);
            }
            if (activityStatus.problem_status_d.equals("New Section")) {
                boolean keepGoing = this.nextSection(activityStatus);
                if (!keepGoing) {
                    return;
                }
            } else if (activityStatus.problem_status_d.equals("New Unit")) {
                boolean keepGoing = this.nextUnit(activityStatus);
                if (!keepGoing) {
                    return;
                }
            } else if (activityStatus.problem_status_d.equals("End Curriculum")) {
                this.endCurriculum();
                return;
            }
        }
        catch (LMS_Exception e) {
            e.printStackTrace();
            return;
        }
        this.loadInterfaceAndProblem();
    }

    public void loadInterfaceAndProblem() {
        String problemName = this.clStudentStatus.getCurrentProblem().getProblemName();
        String interfaceName = (String)this.interfaceTable.get(problemName.toUpperCase());
        if (trace.getDebugCode("inter")) {
            trace.out("inter", "!!!!  loading interface: new problem = " + problemName + " interface = " + interfaceName);
        }
        this.loadInterface(interfaceName);
        this.loadBRDFile(problemName);
        this.controller.setBehaviorRecorderMode("Example-tracing Tutor");
    }

    private void endCurriculum() {
        JOptionPane.showMessageDialog(this.controller.getStudentInterface().getActiveWindow(), "Congratulations.  You have now completed this curriculum.\nYou will be automatically logged out.");
        this.logout();
    }

    private boolean nextSection(LMS_Client.Problem_N_Activity_Status activityStatus) {
        boolean keepGoing = this.sameExecutable(activityStatus);
        if (keepGoing) {
            JOptionPane.showMessageDialog(this.controller.getStudentInterface().getActiveWindow(), "You have finished the section " + this.lastSectionName + ".\nNow you will begin the section " + this.currentSectionName + ".");
        } else {
            JOptionPane.showMessageDialog(this.controller.getStudentInterface().getActiveWindow(), "You have finished the section " + this.lastSectionName + ".\nYou must log in again to continue with the next section.");
            this.logout();
        }
        return keepGoing;
    }

    private boolean nextUnit(LMS_Client.Problem_N_Activity_Status activityStatus) {
        boolean keepGoing = this.sameExecutable(activityStatus);
        if (keepGoing) {
            JOptionPane.showMessageDialog(this.controller.getStudentInterface().getActiveWindow(), "You have finished the unit " + this.lastUnitName + ".\nNow you will begin the unit " + this.currentUnitName + ".");
        } else {
            JOptionPane.showMessageDialog(this.controller.getStudentInterface().getActiveWindow(), "You have finished the unit " + this.lastUnitName + ".\nYou must now log in again to continue with the next unit.");
            this.logout();
        }
        return keepGoing;
    }

    private boolean sameExecutable(LMS_Client.Problem_N_Activity_Status activityStatus) {
        boolean result = false;
        result = this.ctatCarnegieLearningLauncher == null ? true : (activityStatus == null ? false : "Continue".equals(activityStatus.activity_status_d));
        if (trace.getDebugCode("ctat_lms")) {
            trace.out("ctat_lms", "sameExecutable() returning " + result);
        }
        return result;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Component c = (Component)e.getSource();
        ListBox listBox = (ListBox)SwingUtilities.getRoot(c);
        listBox.setVisible(false);
        if (trace.getDebugCode("ctat_lms")) {
            trace.out("ctat_lms", "action command = " + e.getActionCommand());
        }
        if (e.getActionCommand().equals("OK")) {
            if (listBox.getTitle().equals("Select a Class")) {
                this.pickStudent(listBox.getSelectedItem());
            }
            if (listBox.getTitle().equals("Select a Student")) {
                this.loginStudent(listBox.getSelectedItem());
            }
        }
    }

    private void pickStudent(String className) {
        if (trace.getDebugCode("ctat_lms")) {
            trace.out("ctat_lms", "class name = " + className);
        }
        for (CL_Class myClass : this.classList) {
            if (!myClass.getClassName().equals(className)) continue;
            this.clClass = myClass;
            break;
        }
        try {
            this.studentList = this.lmsClient.getStudentsForClass(this.clSchool, this.clClass);
        }
        catch (LMS_Exception e) {
            e.printStackTrace();
            return;
        }
        Vector<String> studentNames = new Vector<String>();
        for (CL_Student student : this.studentList) {
            studentNames.addElement(student.getFirstName() + " " + student.getLastName());
        }
        ListBox dialog = new ListBox("Select a Student", "Please select a student from this class", studentNames, this);
        dialog.pack();
        dialog.setLocationRelativeTo(this.controller.getStudentInterface().getActiveWindow());
        dialog.setVisible(true);
    }

    private void initSkillometer() {
        this.skillometerManager.reset();
        try {
            this.clStudentStatus = this.lmsClient.getCurrentProblemState(this.clSchool, this.clStudent, this.clCurriculum);
            List skills = this.lmsClient.getSectionSkills(this.clSchool, this.clStudent, this.clCurriculum);
            for (CL_SectionSkill sectionSkill : skills) {
                String skillName = sectionSkill.getSkill().getSkillName();
                this.skillometerManager.initializeSkill(skillName);
            }
            List studentSkills = this.lmsClient.getStudentSkills(this.clSchool, this.clStudent, this.clCurriculum);
            if (studentSkills != null) {
                for (CL_StudentSkill studentSkill : studentSkills) {
                    String skillName = studentSkill.getSkill().getSkillName();
                    Float value = studentSkill.getPKnown();
                    this.skillometerManager.updateSkill(skillName, value.floatValue());
                }
            }
        }
        catch (LMS_Exception e) {
            e.printStackTrace();
        }
        this.skillometerManager.show();
    }

    public String getCurrentProblemName() {
        return this.clStudentStatus.getCurrentProblem().toShortString();
    }

    public void setLMSClient(LMS_Client c) throws LMS_Exception {
        this.lmsClient = c;
        if (trace.getDebugCode("ctat_lms")) {
            trace.out("ctat_lms", "lms client = " + c);
        }
        this.clStudentStatus = this.lmsClient.getCurrentProblemState(this.clSchool, this.clStudent, this.clCurriculum);
    }

    public void setSchool(CL_School school) {
        trace.out("ctat_lms", "school = " + school);
        this.clSchool = school;
    }

    public void setCurriculum(CL_Curriculum curriculum) {
        trace.out("ctat_lms", "curriculum = " + curriculum);
        this.clCurriculum = curriculum;
        this.loadInterfaceMapFile((String)this.clCurriculum.getId());
    }

    public void setStudent(CL_Student clStudent) {
        this.clStudent = clStudent;
    }

    public boolean waitForProblemFinished() {
        try {
            trace.out("inter", "sleep for 5 sec");
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return true;
    }

    private void setInitialStateFolder(String initialStateFolder) {
        this.initialStateFolder = initialStateFolder;
    }

    private String getInitialStateFolder() {
        if (this.initialStateFolder == null) {
            this.setInitialStateFolder(this.getRootRef() + File.separator + "Administrative" + File.separator + "Curricula" + File.separator + "Problem Data" + File.separator + "Initial State" + File.separator);
        }
        return this.initialStateFolder;
    }

    public void setUseCL_Launcher(CTAT_LMS_Launcher launcher) {
        this.loggedIn = true;
        this.ctatCarnegieLearningLauncher = launcher;
    }

    private class ListBox
    extends JDialog {
        private JComboBox cb;
        private String title;

        public ListBox(String title, String labelText, List items, ActionListener listener) {
            this.setTitle(title);
            this.title = title;
            JLabel label = new JLabel(labelText);
            this.cb = new JComboBox();
            JButton okButton = new JButton("OK");
            JButton cancelButton = new JButton("Cancel");
            JPanel buttonPanel = new JPanel();
            this.cb.setEditable(false);
            okButton.addActionListener(listener);
            cancelButton.addActionListener(listener);
            Iterator i = items.iterator();
            while (i.hasNext()) {
                this.cb.addItem(i.next());
            }
            this.getContentPane().setLayout(new GridLayout(3, 0, 5, 5));
            this.setResizable(false);
            buttonPanel.add(okButton);
            buttonPanel.add(cancelButton);
            this.getContentPane().add(label);
            this.getContentPane().add(this.cb);
            this.getContentPane().add(buttonPanel);
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        public String getSelectedItem() {
            return (String)this.cb.getModel().getSelectedItem();
        }
    }
}

