/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Controller;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerLink;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerSAI;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Matcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import java.util.List;
import java.util.Vector;

public class PseudoTutorMessageBuilder {
    public static final String INCORRECT = "InCorrect";
    public static final String CORRECT = "Correct";
    public static final String HINT = "Hint";
    public static final String INDICATOR = "Indicator";
    public static final String STUDENT_SELECTION = "StudentSelection";
    public static final String STUDENT_ACTION = "StudentAction";
    public static final String STUDENT_INPUT = "StudentInput";
    public static final String WMIAGESS_PNAME = "WMImages";
    public static final String STEP_ID = "StepID";
    public static final String TUTOR_ADVICE = "TutorAdvice";
    public static final String TUTOR_PERFORMED = "tutor-performed";
    public static final String SUBTYPE = "subtype";
    public static final String TRIGGER = "trigger";
    public static final String TRIGGER_USER = "USER";
    public static final String TRIGGER_DATA = "DATA";
    public static final String SKILLS_PNAME = "Skills";
    public static final String RULES_PNAME = "Rules";
    public static final String BUGGY_MSG = "BuggyMsg";

    public static MessageObject buildAssociatedRules(ProblemEdge targetEdge, String indicatorValue, String actor, BR_Controller controller, String tool_selection) {
        return PseudoTutorMessageBuilder.buildAssociatedRules(targetEdge, null, null, indicatorValue, actor, controller, tool_selection);
    }

    public static MessageObject buildAssociatedRules(ProblemEdge targetEdge, Vector input, ExampleTracerSAI studentSAI, String indicatorValue, String actor, BR_Controller controller, String tool_selection) {
        EdgeData targetEdgeData = targetEdge.getEdgeData();
        Vector selection = targetEdgeData.getMatcher().getDefaultSelectionVector();
        Vector action = targetEdgeData.getMatcher().getDefaultActionVector();
        if (input == null) {
            input = targetEdgeData.getMatcher().getDefaultInputVector();
        }
        return PseudoTutorMessageBuilder.buildAssociatedRules(targetEdge, selection, action, input, studentSAI, indicatorValue, actor, controller, tool_selection);
    }

    static MessageObject buildAssociatedRules(ProblemEdge targetEdge, Vector selection, Vector action, Vector input, ExampleTracerSAI studentSAI, String indicatorValue, String actor, BR_Controller controller, String tool_selection) {
        EdgeData targetEdgeData = targetEdge.getEdgeData();
        Vector<String> hints = null;
        if (HINT.equalsIgnoreCase(indicatorValue)) {
            hints = targetEdgeData.getHints();
            input = targetEdgeData.appendHintOrder(input);
        }
        Vector ruleNames = new Vector();
        Vector<String> skillBarVector = null;
        String skillBarDelimiter = null;
        if (!Matcher.isTutorActor(actor, false)) {
            ruleNames = ProblemModel.getNamedRules(targetEdgeData.getSkills());
            if (targetEdgeData.getProblemModel() != null) {
                skillBarVector = targetEdgeData.getProblemModel().getSkillBarVector();
                skillBarDelimiter = targetEdgeData.getProblemModel().getSkillBarDelimiter();
            }
        }
        if (trace.getDebugCode("skills")) {
            trace.out("skills", "buildAssocRules targetEdgeData.getProblemModel() pm " + targetEdgeData.getProblemModel() + ", actor " + actor + ", skillBars\n " + skillBarVector);
        }
        MessageObject newMessage = PseudoTutorMessageBuilder.buildAssociatedRulesMsg(indicatorValue, selection, action, input, studentSAI, ruleNames, skillBarVector, skillBarDelimiter, Integer.toString(targetEdge.getUniqueID()), actor, controller, tool_selection, hints);
        return newMessage;
    }

    public static MessageObject buildAssocRulesFromEvent(ExampleTracerEvent result, BR_Controller controller) {
        ExampleTracerLink link = result.getReportableLink();
        EdgeData edgeData = link == null ? null : link.getEdge();
        Vector<String> skillNames = new Vector<String>(result.getSkillNames());
        Vector<String> skillBarVector = null;
        String skillBarDelimiter = null;
        if (edgeData != null && edgeData.getProblemModel() != null) {
            skillBarVector = edgeData.getProblemModel().getSkillBarVector();
            skillBarDelimiter = edgeData.getProblemModel().getSkillBarDelimiter();
        }
        boolean isHint = HINT.equalsIgnoreCase(result.getResult());
        MessageObject newMessage = PseudoTutorMessageBuilder.buildAssociatedRulesMsg(result.getResult(), result.getTutorSelection(), result.getTutorAction(), isHint ? edgeData.appendHintOrder(result.getTutorInput()) : result.getTutorInput(), isHint ? null : result.getStudentSAI(), skillNames, skillBarVector, skillBarDelimiter, Integer.toString(edgeData.getUniqueID()), result.isTutorPerformed() ? "Tutor" : "Student", controller, result.getStudentSAI() == null ? null : result.getStudentSAI().getSelectionAsVector().get(0), result.getTutorAdvice());
        return newMessage;
    }

    public static MessageObject buildAssociatedRulesMsg(String indicatorValue, Vector selection, Vector action, Vector input, ExampleTracerSAI studentSAI, Vector ruleNames, Vector<String> skillBarVector, String skillBarDelimiter, String stepID, String actor, BR_Controller controller, String tool_selection, Vector<String> tutorAdvice) {
        MessageObject newMessage = MessageObject.create("AssociatedRules", "SendNoteProperty");
        Vector<String> emptyV = new Vector<String>();
        emptyV.add("");
        newMessage.setProperty(INDICATOR, PseudoTutorMessageBuilder.fixIndicator(indicatorValue));
        newMessage.setSelection(selection == null ? emptyV : selection);
        newMessage.setAction(action == null ? emptyV : action);
        newMessage.setInput(input == null ? emptyV : input);
        if (studentSAI != null) {
            newMessage.setProperty(STUDENT_SELECTION, studentSAI.getSelectionAsVector() == null ? emptyV : studentSAI.getSelectionAsVector());
            newMessage.setProperty(STUDENT_ACTION, studentSAI.getActionAsVector() == null ? emptyV : studentSAI.getActionAsVector());
            newMessage.setProperty(STUDENT_INPUT, studentSAI.getInputAsVector() == null ? emptyV : studentSAI.getInputAsVector());
        }
        if (tutorAdvice != null) {
            newMessage.setProperty(TUTOR_ADVICE, tutorAdvice);
            if (PseudoTutorMessageBuilder.isHint(indicatorValue)) {
                newMessage.setProperty("TotalHintsAvailable", tutorAdvice.size());
                newMessage.setProperty("CurrentHintNumber", tutorAdvice.size() > 0 ? 1 : 0);
            }
        }
        if (actor != null && actor.length() > 0) {
            newMessage.setProperty("Actor", actor);
        }
        if (ruleNames == null || ruleNames.size() < 1) {
            ruleNames = PseudoTutorMessageBuilder.s2v("unnamed");
        }
        newMessage.setProperty(RULES_PNAME, ruleNames);
        if (skillBarVector != null && skillBarVector.size() > 0) {
            newMessage.setProperty(SKILLS_PNAME, skillBarVector);
        }
        newMessage.setProperty("skillBarDelimiter", skillBarDelimiter);
        newMessage.setProperty(STEP_ID, stepID);
        if (tool_selection != null && tool_selection.length() > 0) {
            newMessage.setProperty("tool_selection", tool_selection);
        }
        newMessage.setTransactionId(controller.getSemanticEventId());
        return newMessage;
    }

    public static MessageObject buildCommCorrectMessage(Vector selectionP, Vector actionP, Vector inputP, BR_Controller controller) {
        if (trace.getDebugCode("js")) {
            trace.printStack("js", "buildCommCorrectMessage(" + selectionP + "," + actionP + "," + inputP + ")");
        }
        MessageObject newMessage = MessageObject.create("CorrectAction", "SendNoteProperty");
        newMessage.setSelection(selectionP);
        newMessage.setAction(actionP);
        newMessage.setInput(inputP);
        newMessage.setTransactionId(controller.getSemanticEventId());
        return newMessage;
    }

    public static MessageObject createInterfaceConfigurationEnd() {
        MessageObject newMessage = MessageObject.create("InterfaceConfigurationEnd", "SendNoteProperty");
        return newMessage;
    }

    public static MessageObject createLockWidgetMsg(boolean lockFlag) {
        MessageObject newMessage = MessageObject.create("SendWidgetLock", "SendNoteProperty");
        newMessage.setProperty("WidgetLockFlag", Boolean.toString(lockFlag));
        return newMessage;
    }

    public static MessageObject buildUnLockMessage(Vector selection, BR_Controller controller) {
        MessageObject newMessage = MessageObject.create("UnlockComposer", "SendNoteProperty");
        newMessage.setSelection(selection);
        newMessage.setTransactionId(controller.getSemanticEventId());
        return newMessage;
    }

    public static MessageObject buildNoHintMessage(BR_Controller controller) {
        MessageObject newMessage = MessageObject.create("NoHintMessage", "SendNoteProperty");
        newMessage.setProperty(STEP_ID, new Integer(-1).toString());
        newMessage.setTransactionId(controller.getSemanticEventId());
        return newMessage;
    }

    public static MessageObject buildCommHighLightWidgetMessage(Vector selectionP, Vector actionP, BR_Controller controller) {
        MessageObject newMessage = MessageObject.create("HighlightMsg", "SendNoteProperty");
        ProblemModel pm = controller == null ? null : controller.getProblemModel();
        String highlightMsgText = pm == null || pm.getOutOfOrderMessage() == null ? "Instead of the step you are working on, please work on the highlighted step." : pm.getOutOfOrderMessage();
        newMessage.setProperty("HighlightMsgText", highlightMsgText);
        newMessage.setSelection(selectionP);
        newMessage.setAction(actionP);
        newMessage.setTransactionId(controller.getSemanticEventId());
        return newMessage;
    }

    public static MessageObject buildProtectToolStepMessage(Vector selectionP, Vector actionP, Vector inputP, BR_Controller controller) {
        trace.out("build ProtectToolStep message message");
        MessageObject newMessage = MessageObject.create("WrongUserMessage", "SendNoteProperty");
        newMessage.setSelection(selectionP);
        newMessage.setInput(inputP);
        newMessage.setTransactionId(controller.getSemanticEventId());
        return newMessage;
    }

    public static MessageObject buildCommBuggyMessage(String buggyMsg, Vector selectionP, Vector actionP, BR_Controller controller) {
        MessageObject newMessage = MessageObject.create("BuggyMessage", "SendNoteProperty");
        newMessage.setProperty(BUGGY_MSG, buggyMsg);
        if (selectionP != null) {
            newMessage.setSelection(selectionP);
            newMessage.setAction(actionP);
        }
        newMessage.setTransactionId(controller.getSemanticEventId());
        return newMessage;
    }

    public static MessageObject buildCommIncorrectMessage(Vector selectionP, Vector actionP, Vector inputP, BR_Controller controller) {
        MessageObject newMessage = MessageObject.create("InCorrectAction", "SendNoteProperty");
        Vector emptyV = new Vector();
        emptyV.add("");
        newMessage.setSelection(selectionP == null ? emptyV : selectionP);
        newMessage.setAction(actionP == null ? emptyV : actionP);
        newMessage.setInput(inputP == null ? emptyV : inputP);
        newMessage.setTransactionId(controller.getSemanticEventId());
        return newMessage;
    }

    public static MessageObject buildCommSuccessMessage(String successMsg, BR_Controller controller) {
        MessageObject newMessage = MessageObject.create("SuccessMessage", "SendNoteProperty");
        newMessage.setProperty("SuccessMsg", successMsg);
        newMessage.setTransactionId(controller.getSemanticEventId());
        return newMessage;
    }

    public static MessageObject buildHintsMsg(ProblemEdge hintsEdge, BR_Controller controller) {
        EdgeData hintsEdgeData = hintsEdge.getEdgeData();
        Vector<String> hints = hintsEdgeData.getHints();
        Vector selection = hintsEdgeData.getSelection();
        Vector action = hintsEdgeData.getAction();
        Vector input = hintsEdgeData.getInput();
        String stepID = Integer.toString(hintsEdge.getUniqueID());
        Vector namedRules = ProblemModel.getNamedRules(hintsEdgeData.getSkills());
        Vector<String> skillBarVector = hintsEdgeData.getProblemModel() == null ? null : hintsEdgeData.getProblemModel().getSkillBarVector();
        return PseudoTutorMessageBuilder.buildHintsMsg(hints, selection, action, input, stepID, namedRules, skillBarVector, controller);
    }

    public static MessageObject buildHintsMsg(Vector hints, Vector selection, Vector action, Vector input, String stepID, Vector namedRules, Vector<String> skillBarVector, BR_Controller controller) {
        MessageObject newMessage = MessageObject.create("ShowHintsMessage", "SendNoteProperty");
        Vector emptyV = new Vector();
        emptyV.add("");
        newMessage.setProperty("HintsMessage", hints);
        newMessage.setSelection(selection == null ? emptyV : selection);
        newMessage.setAction(action == null ? emptyV : action);
        newMessage.setInput(input == null ? emptyV : input);
        newMessage.setProperty(STEP_ID, stepID);
        if (namedRules != null && namedRules.size() > 0) {
            newMessage.setProperty(RULES_PNAME, namedRules);
        }
        if (skillBarVector != null && skillBarVector.size() > 0) {
            newMessage.setProperty(SKILLS_PNAME, skillBarVector);
        }
        newMessage.setTransactionId(controller.getSemanticEventId());
        return newMessage;
    }

    public static MessageObject buildConfirmDoneMsg(BR_Controller controller) {
        MessageObject newMessage = MessageObject.create("ConfirmDone", "SendNoteProperty");
        newMessage.setTransactionId(MessageObject.makeTransactionId());
        return newMessage;
    }

    public static MessageObject buildInterfaceAction(Vector<String> selection, Vector<String> action, Vector<String> input, BR_Controller controller) {
        return PseudoTutorMessageBuilder.buildInterfaceAction(selection, action, input, null, controller, null, false);
    }

    public static MessageObject buildInterfaceActionMsg(Vector<String> selection, Vector<String> action, Vector<String> input, BR_Controller controller) {
        return PseudoTutorMessageBuilder.buildInterfaceActionMsg(selection, action, input, null, controller, null, false);
    }

    public static MessageObject buildInterfaceAction(Vector<String> selection, Vector<String> action, Vector<String> input, String prompt, BR_Controller controller, String transactionId, boolean suppressLogging) {
        MessageObject newMessage = MessageObject.create("InterfaceAction", "SendNoteProperty");
        newMessage.setSelection(selection);
        newMessage.setAction(action);
        newMessage.setInput(input);
        if (prompt != null) {
            newMessage.setProperty("prompt", prompt);
        }
        if (transactionId != null) {
            newMessage.lockTransactionId(transactionId);
        } else if (controller != null) {
            newMessage.setTransactionId(controller.getSemanticEventId());
        }
        if (suppressLogging) {
            newMessage.suppressLogging(true);
        }
        return newMessage;
    }

    public static MessageObject buildInterfaceActionMsg(Vector<String> selection, Vector<String> action, Vector<String> input, String prompt, BR_Controller controller, String transactionId, boolean suppressLogging) {
        return PseudoTutorMessageBuilder.buildInterfaceAction(selection, action, input == null ? PseudoTutorMessageBuilder.s2v("") : input, prompt, controller, transactionId, suppressLogging);
    }

    public static MessageObject buildToolInterfaceAction(Vector selection, Vector action, Vector input, String trigger, String subtype) {
        MessageObject mo = MessageObject.create("InterfaceAction", "NotePropertySet");
        mo.setSelection(selection);
        mo.setAction(action);
        mo.setInput(input);
        mo.setProperty(TRIGGER, trigger == null || trigger.length() < 1 ? TRIGGER_DATA : trigger);
        mo.setProperty(SUBTYPE, subtype == null || subtype.length() < 1 ? TUTOR_PERFORMED : subtype);
        mo.lockTransactionId(MessageObject.makeTransactionId());
        return mo;
    }

    public static MessageObject buildUntutoredAction(Vector<String> selection, Vector<String> action, Vector<String> input, BR_Controller controller, String transactionId, boolean suppressLogging) {
        MessageObject newMessage = MessageObject.create("UntutoredAction", "SendNoteProperty");
        newMessage.setSelection(selection);
        newMessage.setAction(action);
        newMessage.setInput(input);
        if (transactionId != null) {
            newMessage.lockTransactionId(transactionId);
        } else if (controller != null) {
            newMessage.setTransactionId(controller.getSemanticEventId());
        }
        if (suppressLogging) {
            newMessage.suppressLogging(true);
        }
        return newMessage;
    }

    public static MessageObject createStartStateEndMsg() {
        MessageObject newMessage = MessageObject.create("StartStateEnd", "NotePropertySet");
        return newMessage;
    }

    public static Vector<String> s2v(String s) {
        if (s == null) {
            return null;
        }
        Vector<String> result = new Vector<String>();
        result.add(s);
        return result;
    }

    public static String v2s(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof List) {
            List v = (List)obj;
            if (v.size() < 1 || v.get(0) == null) {
                return null;
            }
            return v.get(0).toString();
        }
        return obj.toString();
    }

    public static boolean isHint(Object indicatorObj) {
        if (indicatorObj == null) {
            return false;
        }
        String indicator = indicatorObj.toString().toLowerCase();
        return indicator.startsWith(HINT.toLowerCase());
    }

    public static boolean isCorrect(Object indicatorObj) {
        if (indicatorObj == null) {
            return false;
        }
        String indicator = indicatorObj.toString().toLowerCase();
        if (indicator.startsWith(CORRECT.toLowerCase())) {
            return true;
        }
        return indicator.startsWith("SUCCESS".toLowerCase());
    }

    public static String fixIndicator(Object indicatorObj) {
        if (PseudoTutorMessageBuilder.isHint(indicatorObj)) {
            return HINT;
        }
        if (PseudoTutorMessageBuilder.isCorrect(indicatorObj)) {
            return CORRECT;
        }
        return INCORRECT;
    }

    public static boolean isDoneStep(MessageObject assocRulesResp, boolean[] correct) {
        correct[0] = false;
        Object indicatorObj = assocRulesResp.getProperty(INDICATOR);
        Object selectionObj = assocRulesResp.getProperty("tool_selection");
        if (indicatorObj == null) {
            return false;
        }
        correct[0] = PseudoTutorMessageBuilder.isCorrect(indicatorObj);
        boolean result = "Done".equalsIgnoreCase(PseudoTutorMessageBuilder.v2s(selectionObj));
        if (trace.getDebugCode("ps")) {
            trace.outNT("ps", "PseudoTutorMessageBuilder.isDoneStep() indicator " + indicatorObj + ", tool_selection " + selectionObj + ", selection " + assocRulesResp.getSelection() + "correct[0] " + correct[0] + ", result " + result);
        }
        return result;
    }
}

