/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Controller;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SelectionDialog {
    private static final String DEFAULT_TITLE = "Make your selection...";
    private static final Boolean DEFAULT_VALUE = false;

    public static <T> Map<T, Boolean> doElementSelection(String message, List<T> elements, String title, Boolean defaultSelectionValue) {
        ArrayList<String> strings = new ArrayList<String>();
        for (T e : elements) {
            strings.add(e.toString());
        }
        return SelectionDialog.doElementSelection(message, SelectionDialog.zip(elements, strings), title, defaultSelectionValue);
    }

    public static <T> Map<T, Boolean> doElementSelection(String message, Map<T, String> elementLabelMap, String title, Boolean defaultSelectionValue) {
        String diagTitle = title != null ? title : DEFAULT_TITLE;
        Boolean defaultValue = defaultSelectionValue != null ? defaultSelectionValue : DEFAULT_VALUE;
        Product diagUI = SelectionDialog.buildDiag(message, elementLabelMap, defaultValue);
        JPanel msg = diagUI.getPanel();
        Map boxMap = diagUI.getBoxMap();
        int response = JOptionPane.showConfirmDialog(null, message, diagTitle, 2);
        if (response == 0) {
            HashMap selections = new HashMap();
            for (JCheckBox box : boxMap.keySet()) {
                selections.put(boxMap.get(box), box.isSelected());
            }
            return selections;
        }
        return null;
    }

    private static <T> Product buildDiag(String message, Map<T, String> elements, boolean defaultSelectionValue) {
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 1));
        JPanel messagePanel = new JPanel(new FlowLayout());
        messagePanel.add(new JLabel(message));
        JPanel selectionPanel = new JPanel();
        selectionPanel.setBackground(Color.white);
        selectionPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        selectionPanel.setLayout(new BoxLayout(selectionPanel, 1));
        HashMap<JCheckBox, T> boxMap = new HashMap<JCheckBox, T>();
        int maxWidth = 0;
        for (Map.Entry<T, String> ent : elements.entrySet()) {
            JCheckBox newBox = new JCheckBox(ent.getValue(), defaultSelectionValue);
            newBox.setHorizontalAlignment(2);
            boxMap.put(newBox, ent.getKey());
            if (newBox.getWidth() <= maxWidth) continue;
            maxWidth = newBox.getWidth();
        }
        for (JCheckBox box : boxMap.keySet()) {
            int deficit = maxWidth - box.getWidth();
            Component filler = Box.createRigidArea(new Dimension(deficit, box.getHeight()));
            JPanel boxPanel = new JPanel(new FlowLayout());
            boxPanel.add(box);
            boxPanel.add(filler);
            selectionPanel.add(boxPanel);
        }
        topPanel.add(messagePanel);
        topPanel.add(selectionPanel);
        return new Product(topPanel, boxMap);
    }

    private static List<Integer> xrange(int numElements) {
        ArrayList<Integer> l = new ArrayList<Integer>();
        for (int i = 0; i < numElements; ++i) {
            l.add(i);
        }
        return l;
    }

    private static <K, V> Map<K, V> zip(List<K> keys, List<V> values) {
        if (keys == null || values == null || keys.size() != values.size()) {
            return null;
        }
        HashMap<K, V> map = new HashMap<K, V>();
        for (Integer i : SelectionDialog.xrange(keys.size())) {
            map.put(keys.get(i), values.get(i));
        }
        return map;
    }

    private static class Product<T> {
        private final JPanel panel;
        private final Map<JCheckBox, T> boxMap;

        public Product(JPanel panel, Map<JCheckBox, T> boxMap) {
            this.panel = panel;
            this.boxMap = boxMap;
        }

        public JPanel getPanel() {
            return this.panel;
        }

        public Map<JCheckBox, T> getBoxMap() {
            return this.boxMap;
        }
    }
}

