/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Dialogs;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Dialogs.BrdFilter;
import edu.cmu.pact.BehaviorRecorder.Dialogs.CreateProblemsTableDialog;
import edu.cmu.pact.BehaviorRecorder.Dialogs.DialogUtilities;
import edu.cmu.pact.BehaviorRecorder.Dialogs.DirectoryFilter;
import edu.cmu.pact.BehaviorRecorder.Dialogs.TxtFilter;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.BehaviorRecorder.View.JUndo;
import edu.cmu.pact.Utilities.XMLSpecialCharsTransform;
import edu.cmu.pact.Utilities.trace;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class MergeMassProductionDialog
extends JDialog {
    public static final String VAR_RIGHT_DELIMITER = ")%";
    public static final String VAR_LEFT_DELIMITER = "%(";
    private ArrayList brdVariables = new ArrayList();
    private List<String> extraBRDvars = new ArrayList<String>();
    private ArrayList extraDatavars = new ArrayList();
    private ArrayList badDatavars = new ArrayList();
    private ArrayList emptyVars = new ArrayList();
    private static Pattern varPattern = ProblemModel.getMassProductionVarPattern();
    private String[][] dataTempData;
    final int NO_VARIABLES = 0;
    final int NO_CONFIGURE_DATA = 1;
    final int BRD_TEMP_VARS_ABSENT_FROM_DATA_TEMP = 2;
    final int DATA_TEMPLATE_VARIABLES_ABSENT = 3;
    final int DATA_TEMPLATE_MISSING_DATA = 4;
    final int DATA_MATCH = 5;
    private JLabel brdTemplateLabel = new JLabel("Select the BRD template:");
    private JTextField brdTemplateTextField = new JTextField();
    private JButton brdTemplateBrowseButton;
    private JLabel problemsTableLabel;
    private JTextField problemsTableTextField;
    private JButton problemsTableBrowseButton;
    private JButton saveMergeButton;
    private JButton mergeButton;
    private JButton cancelButton;
    private JCheckBox excelJCheckbox;
    private Container contentPane;
    private boolean flagFoundProblemTag;
    private boolean flagFoundProblemTagClose;
    private boolean flagFoundFirstNodeTag;
    private boolean flagFoundFirstNodeText;
    private BR_Controller controller;
    private String instructions;
    private static String prevbrdTemplateFileName = "";
    private static String prevProblemTableLocation = "";
    private File problemsFolder;
    private static final String[] ERROR_MESSAGE = new String[]{"The files you selected cannot be merged, because the ", "data in the Problems Table is missing or incomplete.", "Please check your Problems Table file and try again."};
    private static final String[] NO_DATA_TEMPLATE_VARIABLES_ERROR_MESSAGE = new String[]{"The files you selected cannot be merged, because the ", "data in the Problems Table is missing or incomplete.", "Please check your Problems Table file and try again."};
    private static final String[] NO_BRD_TEMPLATE_VARIABLES_ERROR_MESSAGE = new String[]{"The files you selected cannot be merged, because there ", "are no variables in the BRD Template.", "Please use an appropriate BRD Template file."};
    private static final String[] BRD_TEMPLATE_SHORT_ERROR_MESSAGE = new String[]{"The files you selected cannot be merged, because the ", "BRD Template has fewer variables than the Problems Table.", "Please compare the two files."};
    private static final String[] DATA_TEMPLATE_SHORT_ERROR_MESSAGE = new String[]{"The files you selected cannot be merged, because the ", "BRD Template has more variables than the Problems Table.", "Please compare the two files."};
    private static final String[] DATA_TEMPLATE_MISSING_DATA_MESSAGE = new String[]{"The files you selected cannot be merged, because the ", "Data Template has blank or invalid fields."};
    private static final String[] EMPTY_FILE_MESSAGE = new String[]{"The problem table is empty.  No problems were found."};
    private static final String[] EMPTY_ROW_MESSAGE = new String[]{"The problem table includes a empty row.  Please check ", "the file and remove empty rows"};
    private static final Pattern Tab = Pattern.compile("\t");

    MergeMassProductionDialog() {
        super((Frame)null);
        JUndo.JTextUndoPacket jTextUndoPacket = JUndo.makeTextUndoable(this.brdTemplateTextField);
        this.brdTemplateBrowseButton = new JButton("Browse...");
        this.problemsTableLabel = new JLabel("Select the problems table:");
        this.problemsTableTextField = new JTextField();
        jTextUndoPacket = JUndo.makeTextUndoable(this.problemsTableTextField);
        this.problemsTableBrowseButton = new JButton("Browse...");
        this.saveMergeButton = new JButton("Save & Merge");
        this.mergeButton = new JButton("Merge");
        this.cancelButton = new JButton("Cancel");
        this.excelJCheckbox = new JCheckBox("Table file was edited with Microsoft Excel", true);
        this.contentPane = this.getContentPane();
        this.instructions = "<html>Use this window to generate BRD files using Mass Production. Mass production allows you to easily produce many Behavior Recorder graphs that use a single student interface. Select a BRD template (the BRD file with variables in place of constants) and a completed problems table (the file containing variable names and values for the graphs you will produce.";
    }

    public MergeMassProductionDialog(BR_Controller controller) {
        super((Frame)controller.getActiveWindow(), true);
        JUndo.JTextUndoPacket jTextUndoPacket = JUndo.makeTextUndoable(this.brdTemplateTextField);
        this.brdTemplateBrowseButton = new JButton("Browse...");
        this.problemsTableLabel = new JLabel("Select the problems table:");
        this.problemsTableTextField = new JTextField();
        jTextUndoPacket = JUndo.makeTextUndoable(this.problemsTableTextField);
        this.problemsTableBrowseButton = new JButton("Browse...");
        this.saveMergeButton = new JButton("Save & Merge");
        this.mergeButton = new JButton("Merge");
        this.cancelButton = new JButton("Cancel");
        this.excelJCheckbox = new JCheckBox("Table file was edited with Microsoft Excel", true);
        this.contentPane = this.getContentPane();
        this.instructions = "<html>Use this window to generate BRD files using Mass Production. Mass production allows you to easily produce many Behavior Recorder graphs that use a single student interface. Select a BRD template (the BRD file with variables in place of constants) and a completed problems table (the file containing variable names and values for the graphs you will produce.";
        this.controller = controller;
        this.setTitle("Merge Problems for Mass Production");
        this.initUI();
    }

    private void initUI() {
        int headerHeight = 115;
        int leftAlign = 20;
        int rowSpace = 30;
        int broweSpace = 15;
        int labelWidth = 400;
        int textFiledWidth = 400;
        int buttonWidth = 100;
        int LbuttonWidth = 115;
        int fieldHeight = 20;
        int buttonLeft = 190;
        Font labelFont = new Font("", 1, 12);
        int dialogWidth = 555;
        int dialogHeight = 340;
        this.contentPane.setLayout(null);
        JLabel instructionsLabel = new JLabel(this.instructions);
        instructionsLabel.setBounds(leftAlign, 0, 450, 90);
        this.contentPane.add(instructionsLabel);
        this.brdTemplateLabel.setLocation(leftAlign, headerHeight);
        this.brdTemplateLabel.setFont(labelFont);
        this.brdTemplateLabel.setSize(labelWidth, fieldHeight);
        this.contentPane.add(this.brdTemplateLabel);
        this.brdTemplateTextField.setLocation(leftAlign, headerHeight + rowSpace);
        this.brdTemplateTextField.setSize(textFiledWidth, fieldHeight);
        if (prevbrdTemplateFileName != "") {
            this.brdTemplateTextField.setText(prevbrdTemplateFileName);
        } else {
            String problemFullName = this.controller.getProblemModel().getProblemFullName();
            if (problemFullName != null && problemFullName.length() > 0) {
                this.brdTemplateTextField.setText(problemFullName);
            } else {
                this.brdTemplateTextField.setText(this.controller.getPreferencesModel().getStringValue("BRD Template Path"));
            }
        }
        this.contentPane.add(this.brdTemplateTextField);
        this.brdTemplateBrowseButton.setLocation(leftAlign + this.brdTemplateTextField.getWidth() + broweSpace, headerHeight + rowSpace);
        this.brdTemplateBrowseButton.setSize(buttonWidth, fieldHeight);
        this.contentPane.add(this.brdTemplateBrowseButton);
        this.brdTemplateBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MergeMassProductionDialog.this.brdTemplateBrowseButtonClicked();
            }
        });
        this.problemsTableLabel.setLocation(leftAlign, headerHeight + 2 * rowSpace);
        this.problemsTableLabel.setFont(labelFont);
        this.problemsTableLabel.setSize(labelWidth, fieldHeight);
        this.contentPane.add(this.problemsTableLabel);
        this.problemsTableTextField.setLocation(leftAlign, headerHeight + 3 * rowSpace);
        this.problemsTableTextField.setSize(textFiledWidth, fieldHeight);
        String problemTableLocation = this.controller.getPreferencesModel().getStringValue("Problems Table Location");
        if (problemTableLocation != null) {
            this.problemsTableTextField.setText(problemTableLocation);
        } else if (prevProblemTableLocation != "") {
            this.problemsTableTextField.setText(prevProblemTableLocation);
        } else {
            this.problemsTableTextField.setText(this.brdTemplateTextField.getText().replace(".brd", ".txt"));
        }
        this.contentPane.add(this.problemsTableTextField);
        this.problemsTableBrowseButton.setLocation(leftAlign + this.brdTemplateTextField.getWidth() + broweSpace, headerHeight + 3 * rowSpace);
        this.problemsTableBrowseButton.setSize(buttonWidth, fieldHeight);
        this.contentPane.add(this.problemsTableBrowseButton);
        this.problemsTableBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MergeMassProductionDialog.this.problemsTableBrowseButtonClicked();
            }
        });
        this.excelJCheckbox.setLocation(leftAlign, headerHeight + 4 * rowSpace);
        this.excelJCheckbox.setFont(labelFont);
        this.excelJCheckbox.setSize(labelWidth, fieldHeight);
        this.contentPane.add(this.excelJCheckbox);
        this.saveMergeButton.setLocation(buttonLeft, headerHeight + 5 * rowSpace + 10);
        this.saveMergeButton.setSize(LbuttonWidth, fieldHeight);
        if (!this.brdTemplateTextField.getText().equals("") && this.brdTemplateTextField.getText().equalsIgnoreCase(this.controller.getProblemModel().getProblemFullName())) {
            this.saveMergeButton.setEnabled(true);
        } else {
            this.saveMergeButton.setEnabled(false);
        }
        this.contentPane.add(this.saveMergeButton);
        this.saveMergeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MergeMassProductionDialog.this.saveMergeButtonClicked();
            }
        });
        this.mergeButton.setLocation(buttonLeft + buttonWidth + rowSpace, headerHeight + 5 * rowSpace + 10);
        this.mergeButton.setSize(buttonWidth, fieldHeight);
        this.contentPane.add(this.mergeButton);
        this.mergeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MergeMassProductionDialog.this.mergeButtonClicked();
            }
        });
        this.cancelButton.setLocation(leftAlign + this.brdTemplateTextField.getWidth() + broweSpace, headerHeight + 5 * rowSpace + 10);
        this.cancelButton.setSize(buttonWidth, fieldHeight);
        this.contentPane.add(this.cancelButton);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MergeMassProductionDialog.this.setVisible(false);
                MergeMassProductionDialog.this.dispose();
            }
        });
        this.setSize(dialogWidth, dialogHeight);
        this.setResizable(false);
        this.setLocationRelativeTo(this.controller.getJGraphWindow());
        this.setVisible(true);
    }

    protected void brdTemplateBrowseButtonClicked() {
        String targetDir = this.controller.getPreferredBRDLocation();
        String title = "Select the BRD Template File";
        File selectedFile = DialogUtilities.chooseFile(targetDir, new BrdFilter(), "Select the BRD Template File", "Select", this.controller);
        if (selectedFile != null) {
            this.brdTemplateTextField.setText(selectedFile.getPath());
            this.controller.setPreferredBRDLocation(selectedFile.getParent());
            if (this.brdTemplateTextField.getText().equalsIgnoreCase(this.controller.getProblemModel().getProblemFullName())) {
                this.saveMergeButton.setEnabled(true);
            } else {
                this.saveMergeButton.setEnabled(false);
            }
        }
    }

    private void problemsTableBrowseButtonClicked() {
        File selectedFile = DialogUtilities.chooseFile(this.controller.getPreferredBRDLocation(), new TxtFilter(), "Select the Problems Table File", "Select", this.controller);
        if (selectedFile != null) {
            this.problemsTableTextField.setText(selectedFile.getPath());
            this.controller.setPreferredBRDLocation(selectedFile.getParent());
        }
    }

    private void saveMergeButtonClicked() {
        this.collectBRDData();
        Boolean keepGoing = this.promptToSaveBRD();
        if (!keepGoing.booleanValue()) {
            return;
        }
        this.collectProblemData();
    }

    private void mergeButtonClicked() {
        this.collectBRDData();
        this.collectProblemData();
    }

    private void collectBRDData() {
        this.dataTempData = null;
        String brdTemplateFileName = this.brdTemplateTextField.getText();
        String problemsTableFileName = this.problemsTableTextField.getText();
        if (!this.checkFileExistence(brdTemplateFileName, "BRD Template")) {
            return;
        }
        if (!this.checkFileExistence(problemsTableFileName, "problems table")) {
            return;
        }
        prevbrdTemplateFileName = brdTemplateFileName;
        prevProblemTableLocation = problemsTableFileName;
        this.collectBRDTempVars(brdTemplateFileName);
        if (this.brdVariables.size() == 0) {
            this.displayWarningMsg(ERROR_MESSAGE);
            return;
        }
    }

    private Boolean promptToSaveBRD() {
        String brdTemplateFileName = this.brdTemplateTextField.getText();
        boolean keepGoing = CreateProblemsTableDialog.promptToSaveBRDSilently(brdTemplateFileName, this.controller, this, "Next you will be prompted for the folder to save the generated problem files in.");
        return keepGoing;
    }

    private void collectProblemData() {
        String problemsTableFileName = this.problemsTableTextField.getText();
        Boolean bDataTempValid = this.collectDataTempVars(problemsTableFileName);
        if (!bDataTempValid.booleanValue()) {
            return;
        }
        this.problemsFolder = this.promptForProblemsFolder();
        if (this.problemsFolder != null) {
            this.createProblemsFilesWithVariablesReplace();
        } else if (trace.getDebugCode("mp")) {
            trace.out("mp", "collectProblemData : final BRD files folder is null");
        }
        this.setVisible(false);
        this.dispose();
    }

    private boolean checkFileExistence(String fileName, String fileType) {
        if (fileName == null || fileName.trim().equals("")) {
            String message = "Please select a " + fileType + " file";
            String title = "File Missing";
            JOptionPane.showMessageDialog(this, message, title, 2);
            return false;
        }
        if (!new File(fileName).exists()) {
            String message = "<html>" + fileType + " " + fileName + "<br> could not be found";
            String title = "File Missing";
            JOptionPane.showMessageDialog(this, message, title, 2);
            return false;
        }
        return true;
    }

    private File promptForProblemsFolder() {
        File f;
        String startLocation = this.controller.getPreferredBRDLocation();
        while ((f = DialogUtilities.chooseFile(startLocation, null, new DirectoryFilter(), "Select Output Folder for New Problem Files", "Create Merged Files", 1, this.controller.getActiveWindow())) != null) {
            if (f.isDirectory()) {
                return f;
            }
            String message = "<html>The selected folder: <B>" + f.toString() + "</B> doesn't exist. <br>Please select an existing folder or click <B>New Folder</B> to create a new folder.</html>";
            String title = "Error creating folder";
            JOptionPane.showMessageDialog(this, message, title, 2);
        }
        return null;
    }

    private void displayDataMatchErrorMessage(int dataMatchCheck) {
        trace.out("data match check = " + dataMatchCheck);
        if (trace.getDebugCode("mp")) {
            trace.out("mp", "1 so displayDataMatchErrorMessage : variables.size() = " + this.brdVariables.size());
        }
        this.displayWarningMsg(ERROR_MESSAGE);
    }

    private void displayNoBRDTemplateVariablesErrorMessage() {
        if (trace.getDebugCode("mp")) {
            trace.out("mp", "1 so displayNoBRDTemplateVariablesErrorMessage: variables.size() = " + this.brdVariables.size());
        }
        this.displayWarningMsg(NO_BRD_TEMPLATE_VARIABLES_ERROR_MESSAGE);
    }

    private void displayNoDataTemplateVariablesErrorMessage() {
        if (trace.getDebugCode("mp")) {
            trace.out("mp", "1 so displayNoDataTemplateVariablesErrorMessage: variables.size() = " + this.brdVariables.size());
        }
        this.displayWarningMsg(NO_DATA_TEMPLATE_VARIABLES_ERROR_MESSAGE);
    }

    private void displayBRDTempVarsMissingFromDataTempErrorMessage(List<String> extraVariables) {
        String[] BRD_TEMPLATE_SHORT_ERROR_MESSAGE = new String[3 + extraVariables.size()];
        BRD_TEMPLATE_SHORT_ERROR_MESSAGE[0] = "The BRD Template has variable(s) not defined in the Data Template";
        BRD_TEMPLATE_SHORT_ERROR_MESSAGE[1] = "(problems) table. These will remain untranslated in the output.";
        BRD_TEMPLATE_SHORT_ERROR_MESSAGE[2] = "The missing variable(s) are:";
        for (int i = 0; i < extraVariables.size(); ++i) {
            BRD_TEMPLATE_SHORT_ERROR_MESSAGE[i + 3] = extraVariables.get(i);
        }
        if (trace.getDebugCode("mp")) {
            trace.out("mp", "1 so displayFewerBRDTEmplateVariablesErrorMessage: BRD_TEMPLATE_SHORT_ERROR_MESSAGE = " + BRD_TEMPLATE_SHORT_ERROR_MESSAGE);
        }
        this.displayWarningMsg(BRD_TEMPLATE_SHORT_ERROR_MESSAGE);
    }

    private void displayDataTempVarsMissingFromBRDTempErrorMessage(ArrayList extraVariables) {
        String[] DATA_TEMPLATE_SHORT_ERROR_MESSAGE = new String[3 + extraVariables.size() + 1];
        DATA_TEMPLATE_SHORT_ERROR_MESSAGE[0] = new String("The BRD Template has more variables than the BRD Template table.");
        DATA_TEMPLATE_SHORT_ERROR_MESSAGE[1] = new String("The merge process will ignore these variables");
        DATA_TEMPLATE_SHORT_ERROR_MESSAGE[2] = new String("The extra variables are:");
        for (int i = 0; i < extraVariables.size(); ++i) {
            DATA_TEMPLATE_SHORT_ERROR_MESSAGE[i + 3] = (String)extraVariables.get(i);
        }
        DATA_TEMPLATE_SHORT_ERROR_MESSAGE[3 + extraVariables.size()] = new String("The merge will proceed anyway but will ignore the extras.");
        if (trace.getDebugCode("mp")) {
            trace.out("mp", "1 so displayFewerDataTemplateVariablesErrorMessage: DATA_TEMPLATE_SHORT_ERROR_MESSAGE = " + DATA_TEMPLATE_SHORT_ERROR_MESSAGE);
        }
        this.displayWarningMsg(DATA_TEMPLATE_SHORT_ERROR_MESSAGE);
    }

    private void displayDataTempMissingDataErrorMessage(ArrayList extraVariables) {
        String[] DATA_TEMPLATE_MISSING_DATA_ERROR_MESSAGE = new String[3 + extraVariables.size()];
        DATA_TEMPLATE_MISSING_DATA_ERROR_MESSAGE[0] = new String("The files you selected cannot be merged, because the ");
        DATA_TEMPLATE_MISSING_DATA_ERROR_MESSAGE[1] = new String("Data Template (problems) has missing data.");
        DATA_TEMPLATE_MISSING_DATA_ERROR_MESSAGE[2] = new String("The variables that are missing are:");
        for (int i = 0; i < extraVariables.size(); ++i) {
            DATA_TEMPLATE_MISSING_DATA_ERROR_MESSAGE[i + 3] = (String)extraVariables.get(i);
        }
        if (trace.getDebugCode("mp")) {
            trace.out("mp", "2 so displayDataTempMissingDataErrorMessage: DATA_TEMPLATE_MISSING_DATA_ERROR_MESSAGE = " + DATA_TEMPLATE_MISSING_DATA_ERROR_MESSAGE);
        }
        this.displayWarningMsg(DATA_TEMPLATE_MISSING_DATA_ERROR_MESSAGE);
    }

    private void displayWarningMsg(String[] messageText) {
        if (messageText == null) {
            return;
        }
        JOptionPane.showMessageDialog(this, messageText, "Warning", 1);
    }

    private void createProblemsFilesWithVariablesReplace() {
        if (trace.getDebugCode("mp")) {
            trace.out("mp", "createProblemsFilesWithVariablesReplace : ");
        }
        int problemsCreated = 0;
        try {
            for (int i = 1; i < this.dataTempData.length; ++i) {
                this.writeOneProblemFile(i);
                ++problemsCreated;
            }
        }
        catch (IOException ioe) {
            if (trace.getDebugCode("mp")) {
                trace.out("mp", "IOException: " + ioe.toString());
            }
            String message = "An error occurred while writing the output files.";
            String title = "Error writing files";
            JOptionPane.showMessageDialog(this, message, title, 2);
            return;
        }
        String title = "Problem Files Created";
        String message = "<html>" + problemsCreated + " problem file(s) were created in<br>" + this.problemsFolder.toString() + "</html>";
        JOptionPane.showMessageDialog(this, message, title, 1);
    }

    private void writeOneProblemFile(int i) throws FileNotFoundException, IOException {
        String tempStr;
        if (trace.getDebugCode("mp")) {
            trace.out("mp", "writeOneProblemFile :  i = " + i);
        }
        HashMap<String, String> vars = new HashMap<String, String>();
        for (int j = 1; j < this.dataTempData[0].length; ++j) {
            String variableName = this.dataTempData[0][j];
            variableName = XMLSpecialCharsTransform.transformSpecialChars(variableName);
            String variableValue = this.dataTempData[i][j];
            if (trace.getDebugCode("mp")) {
                trace.out("mp", "writeOneProblemFile :  variableName = " + variableName + " variableValue = " + variableValue);
            }
            if (variableValue == null || variableValue.length() == 0) {
                variableValue = "";
            }
            variableValue = XMLSpecialCharsTransform.transformSpecialChars(variableValue);
            variableValue = this.trimExtraDoubleQuotes(variableValue);
            vars.put(variableName, variableValue);
        }
        String newProblemFilePath = this.problemsFolder.toString();
        int indexSeparator = newProblemFilePath.lastIndexOf(File.separator);
        if (indexSeparator != newProblemFilePath.length()) {
            newProblemFilePath = newProblemFilePath + File.separator;
        }
        String problemNameConfig = this.dataTempData[i][0];
        if (!(newProblemFilePath = newProblemFilePath + problemNameConfig).endsWith(".brd")) {
            newProblemFilePath = newProblemFilePath + ".brd";
        }
        if (trace.getDebugCode("mp")) {
            trace.out("mp", "writeOneProblemFile :  newProblemFilePath = " + newProblemFilePath);
        }
        if (problemNameConfig.endsWith(".brd")) {
            problemNameConfig = problemNameConfig.substring(0, problemNameConfig.length() - 4);
        }
        FileOutputStream fout = new FileOutputStream(newProblemFilePath);
        FileReader massFileFr = new FileReader(this.brdTemplateTextField.getText().trim());
        BufferedReader massFileBr = new BufferedReader(massFileFr);
        this.flagFoundProblemTag = false;
        this.flagFoundProblemTagClose = false;
        this.flagFoundFirstNodeTag = false;
        this.flagFoundFirstNodeText = false;
        while ((tempStr = massFileBr.readLine()) != null) {
            if (!this.flagFoundProblemTag || !this.flagFoundProblemTagClose) {
                tempStr = this.replaceProblemNameTagValue(tempStr, problemNameConfig);
            }
            if (!this.flagFoundFirstNodeTag || !this.flagFoundFirstNodeText) {
                tempStr = this.replaceStartNodeTextTagValue(tempStr, problemNameConfig);
            }
            tempStr = this.replaceVars(tempStr, vars);
            tempStr = tempStr + "\n";
            ((OutputStream)fout).write(tempStr.getBytes());
        }
        ((OutputStream)fout).close();
        massFileBr.close();
        massFileFr.close();
    }

    private String replaceVars(String str, HashMap vars) {
        Matcher varMatcher = varPattern.matcher(str);
        while (varMatcher.find()) {
            String value = null;
            if (varMatcher.group(0) != null) {
                value = (String)vars.get(varMatcher.group(0));
            }
            if (value == null) continue;
            str = varMatcher.replaceFirst(value);
            varMatcher = varPattern.matcher(str);
        }
        return str;
    }

    private String trimExtraDoubleQuotes(String inString) {
        StringBuffer outStringbuf = new StringBuffer("");
        if (inString.length() > 0) {
            if (this.testFirst3CharsDoubleQuotes(inString)) {
                inString = inString.substring(2, inString.length() - 2);
            } else if (inString.charAt(0) == '\"') {
                inString = inString.substring(1, inString.length() - 1);
            }
            boolean firstQutoe = false;
            for (int i = 0; i < inString.length(); ++i) {
                if (inString.charAt(i) == '\"') {
                    if (firstQutoe) {
                        firstQutoe = false;
                        continue;
                    }
                    firstQutoe = true;
                    outStringbuf.append(inString.charAt(i));
                    continue;
                }
                firstQutoe = false;
                if (inString.charAt(i) == '$') {
                    outStringbuf.append('\\');
                }
                outStringbuf.append(inString.charAt(i));
            }
        }
        return outStringbuf.toString();
    }

    boolean testFirst3CharsDoubleQuotes(String testString) {
        if (testString.length() > 0) {
            for (int i = 0; i < 3; ++i) {
                if (testString.charAt(i) == '\"') continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private String replaceProblemNameTagValue(String strLine, String problemNameValue) {
        int indexStartTag;
        String problemNameTag = "<ProblemName>";
        String problemNameCloseTag = "</ProblemName>";
        String replacedStr = strLine;
        boolean flagBefore = this.flagFoundProblemTag;
        if (!this.flagFoundProblemTag && (indexStartTag = strLine.indexOf("<ProblemName>")) >= 0) {
            replacedStr = strLine.substring(0, indexStartTag + "<ProblemName>".length());
            replacedStr = replacedStr + problemNameValue;
            this.flagFoundProblemTag = true;
        }
        if (!this.flagFoundProblemTagClose) {
            int indexEndTag = strLine.indexOf("</ProblemName>");
            if (indexEndTag >= 0) {
                replacedStr = !flagBefore ? replacedStr + strLine.substring(indexEndTag) : strLine.substring(indexEndTag);
                this.flagFoundProblemTagClose = true;
            } else if (flagBefore) {
                replacedStr = "";
            }
        }
        return replacedStr;
    }

    private String replaceStartNodeTextTagValue(String strLine, String problemNameValue) {
        int indexTextTag;
        int indexNodeTag;
        String nodeTag = "<node";
        String textTag = "<text>";
        String textCloseTag = "</text>";
        String replacedStr = strLine;
        if (!this.flagFoundFirstNodeTag && (indexNodeTag = strLine.indexOf("<node")) >= 0) {
            this.flagFoundFirstNodeTag = true;
        }
        if (this.flagFoundFirstNodeTag && !this.flagFoundFirstNodeText && (indexTextTag = strLine.indexOf("<text>")) >= 0) {
            replacedStr = strLine.substring(0, indexTextTag + "<text>".length());
            replacedStr = replacedStr + problemNameValue;
            int TextTagClose = strLine.indexOf("</text>");
            if (TextTagClose >= 0) {
                replacedStr = replacedStr + strLine.substring(TextTagClose);
            }
            this.flagFoundFirstNodeText = true;
        }
        return replacedStr;
    }

    private void collectBRDTempVars(String templatFilePath) {
        block7: {
            if (trace.getDebugCode("mp")) {
                trace.out("mp", "1 buildVariables : intro : file = " + templatFilePath);
            }
            this.brdVariables.clear();
            templatFilePath = templatFilePath.trim();
            try {
                FileReader fr = new FileReader(templatFilePath);
                BufferedReader br = new BufferedReader(fr);
                LinkedHashSet<String> brdVarsSet = new LinkedHashSet<String>();
                String strLine = br.readLine();
                while (strLine != null) {
                    strLine = XMLSpecialCharsTransform.transformBackSpecialChars(strLine);
                    ArrayList variableList = this.fetchVariables(strLine);
                    for (int i = 0; i < variableList.size(); ++i) {
                        String tempStr = (String)variableList.get(i);
                        if (brdVarsSet.contains(tempStr)) continue;
                        brdVarsSet.add(tempStr);
                    }
                    strLine = br.readLine();
                }
                this.brdVariables.addAll(brdVarsSet);
                br.close();
                fr.close();
            }
            catch (FileNotFoundException fe) {
                if (trace.getDebugCode("mp")) {
                    trace.out("mp", "FileNotFoundException: " + fe.toString());
                }
            }
            catch (IOException ie) {
                if (!trace.getDebugCode("mp")) break block7;
                trace.out("mp", "IOException: " + ie.toString());
            }
        }
    }

    private boolean collectDataTempVars(String problemsTableFile) {
        this.dataTempData = null;
        try {
            BufferedReader br = new BufferedReader(new FileReader(problemsTableFile));
            String allText = "";
            String strLine = br.readLine();
            while (strLine != null) {
                strLine = this.removeEndTabs(strLine);
                allText = allText + "\n" + strLine;
                strLine = br.readLine();
            }
            this.dataTempData = this.parseConfigData(allText);
            br.close();
        }
        catch (FileNotFoundException fe) {
            trace.out("FileNotFoundException: " + fe.toString());
            return false;
        }
        catch (IOException ie) {
            this.dataTempData = null;
            trace.out("IOException: " + ie.toString());
            return false;
        }
        if (this.dataTempData == null) {
            return false;
        }
        int dataMatchCheck = this.dataMatch();
        if (trace.getDebugCode("mp")) {
            trace.out("mp", "collectDataTempVars : dataMatchCheck = " + dataMatchCheck);
        }
        if (dataMatchCheck == 0) {
            this.displayNoBRDTemplateVariablesErrorMessage();
            return false;
        }
        if (dataMatchCheck == 1) {
            this.displayNoDataTemplateVariablesErrorMessage();
            return false;
        }
        if (dataMatchCheck == 2) {
            this.displayBRDTempVarsMissingFromDataTempErrorMessage(this.extraBRDvars);
            return true;
        }
        if (dataMatchCheck == 3) {
            this.displayDataTempVarsMissingFromBRDTempErrorMessage(this.extraDatavars);
            return true;
        }
        if (dataMatchCheck == 4) {
            this.displayDataTempMissingDataErrorMessage(this.badDatavars);
            return false;
        }
        if (dataMatchCheck == 5) {
            return true;
        }
        return true;
    }

    private String[][] parseConfigData(String allText) {
        String cellData;
        int rowNumber = 0;
        int colNumber = 0;
        StringTokenizer rowTk = new StringTokenizer(allText, "\n\r");
        if (!rowTk.hasMoreElements()) {
            this.displayWarningMsg(EMPTY_FILE_MESSAGE);
            return null;
        }
        rowNumber = rowTk.countTokens();
        String rowString = "";
        rowString = (String)rowTk.nextElement();
        rowString.trim();
        rowString = this.removeEndTabs(rowString);
        StringTokenizer rowCellTk = new StringTokenizer(rowString, "\t");
        String[] rowCellTk2 = rowString.split("\t");
        String[] rowCellTkArr = rowString.split("\t", -2);
        if (!rowCellTk.hasMoreElements()) {
            return null;
        }
        colNumber = rowCellTk.countTokens();
        if (rowCellTkArr.length > colNumber) {
            colNumber = rowCellTkArr.length;
        }
        if (rowNumber <= 1 || colNumber <= 1) {
            this.displayWarningMsg(EMPTY_FILE_MESSAGE);
            return null;
        }
        String[][] configdata = new String[rowNumber][colNumber];
        boolean variablesInRow = false;
        int j = 0;
        while (rowCellTk.hasMoreElements()) {
            cellData = (String)rowCellTk.nextElement();
            if (j == 1 && cellData.startsWith(VAR_LEFT_DELIMITER) && cellData.endsWith(VAR_RIGHT_DELIMITER)) {
                variablesInRow = true;
            }
            configdata[0][j++] = cellData;
        }
        this.emptyVars.clear();
        int i = 1;
        while (rowTk.hasMoreElements()) {
            rowString = (String)rowTk.nextElement();
            rowString = this.removeEndTabs(rowString);
            List<String> rowData = this.getRowConfigureData(rowString, this.excelJCheckbox.getModel().isSelected());
            if (trace.getDebugCode("mp")) {
                trace.out("mp", "configdata[" + i + "] = " + rowData);
            }
            for (j = 0; j < rowData.size(); ++j) {
                cellData = rowData.get(j);
                if (cellData == null || cellData.length() == 0) {
                    int row = i + 1;
                    int col = j + 1;
                    String pos = "row " + row + " column " + col;
                    this.emptyVars.add(new String("row " + row + " column " + col));
                    cellData = "";
                    if (trace.getDebugCode("mp")) {
                        trace.out("mp", "parseConfigData :  pos = " + pos);
                    }
                }
                if (variablesInRow ? j <= this.brdVariables.size() && cellData != null && cellData.length() == 0 : i > this.brdVariables.size() || cellData == null || cellData.length() == 0) {
                    // empty if block
                }
                configdata[i][j] = cellData;
            }
            ++i;
        }
        if (this.emptyVars.size() > 0) {
            if (trace.getDebugCode("mp")) {
                trace.out("mp", "parseConfigData : TRUE empty cells : emptyVars.size() = " + this.emptyVars.size() + "  variablesInRow = " + variablesInRow);
            }
            for (int k = 0; k < this.emptyVars.size(); ++k) {
                if (!trace.getDebugCode("mp")) continue;
                trace.out("mp", "parseConfigData :" + (String)this.emptyVars.get(k));
            }
            this.createWarningMsg(this.emptyVars);
        }
        if (!variablesInRow) {
            String[][] rotateConfigdata = new String[colNumber][rowNumber];
            for (int l = 0; l < rotateConfigdata.length; ++l) {
                for (int m = 0; m < rotateConfigdata[l].length; ++m) {
                    rotateConfigdata[l][m] = configdata[m][l];
                }
            }
            configdata = rotateConfigdata;
        }
        for (i = 0; i < configdata.length; ++i) {
            if (configdata[i][0] != null && configdata[i][0].length() >= 1) continue;
            this.createMissingProblemNameWarningMsg(i, 0);
            return null;
        }
        return configdata;
    }

    private String removeEndTabs(String rowString) {
        StringBuffer lcRowString = new StringBuffer(rowString);
        for (int i = lcRowString.length() - 1; i >= 0 && lcRowString.charAt(i) == '\t'; --i) {
            lcRowString.deleteCharAt(i);
        }
        return lcRowString.toString();
    }

    private void createWarningMsg(ArrayList emptyVarsList) {
        String[] emptyCellMsg = new String[2 + emptyVarsList.size()];
        emptyCellMsg[0] = "The problem table includes empty cell(s) at";
        for (int i = 0; i < emptyVarsList.size(); ++i) {
            if (trace.getDebugCode("mp")) {
                trace.out("mp", "createWarningMsg :" + (String)emptyVarsList.get(i));
            }
            emptyCellMsg[i + 1] = (String)emptyVarsList.get(i);
        }
        emptyCellMsg[1 + emptyVarsList.size()] = "The merge process will insert blank values.";
        this.displayWarningMsg(emptyCellMsg);
    }

    private void createMissingProblemNameWarningMsg(int i, int j) {
        String si = new Integer(i + 1).toString();
        String sj = new Integer(j).toString();
        String[] emptyCellMsg = new String[]{"The problem table includes a missing problem name at row: " + si, "and column : " + sj, " Please check the file and complete the problem name."};
        this.displayWarningMsg(emptyCellMsg);
    }

    List<String> getRowConfigureData(String rowDataString, boolean removeExcelQuotes) {
        String[] cells = Tab.split(rowDataString, 0);
        for (int i = 0; i < cells.length; ++i) {
            int end;
            if (!removeExcelQuotes || !cells[i].contains("\"")) continue;
            StringBuffer sb = new StringBuffer(cells[i]);
            if (sb.charAt(0) == '\"') {
                sb.deleteCharAt(0);
            }
            if ((end = sb.length() - 1) >= 0 && sb.charAt(end) == '\"') {
                sb.deleteCharAt(end);
            }
            for (int j = 0; j < sb.length() - 1; ++j) {
                if (sb.charAt(j) != '\"' || sb.charAt(j + 1) != '\"') continue;
                sb.deleteCharAt(j + 1);
            }
            cells[i] = sb.toString();
        }
        return Arrays.asList(cells);
    }

    private int dataMatch() {
        String dataVar;
        int j;
        boolean foundFlag;
        String brdVar;
        int i;
        int result = 5;
        if (this.brdVariables == null) {
            return 0;
        }
        if (this.dataTempData == null) {
            return 1;
        }
        this.extraBRDvars.clear();
        for (i = 0; i < this.brdVariables.size(); ++i) {
            brdVar = (String)this.brdVariables.get(i);
            foundFlag = false;
            for (j = 1; j < this.dataTempData[0].length && !foundFlag; ++j) {
                dataVar = this.dataTempData[0][j];
                if (!brdVar.equals(dataVar)) continue;
                foundFlag = true;
            }
            if (foundFlag) continue;
            this.extraBRDvars.add(brdVar);
        }
        if (this.extraBRDvars.size() != 0) {
            result = 2;
        }
        this.extraDatavars.clear();
        for (i = 1; i < this.dataTempData[0].length; ++i) {
            dataVar = this.dataTempData[0][i];
            foundFlag = false;
            for (j = 0; j < this.brdVariables.size() && !foundFlag; ++j) {
                brdVar = (String)this.brdVariables.get(j);
                if (!dataVar.equals(brdVar)) continue;
                foundFlag = true;
            }
            if (foundFlag) continue;
            this.extraDatavars.add(dataVar);
        }
        if (this.extraDatavars.size() != 0) {
            return 3;
        }
        if (result == 2) {
            this.dataTempData = this.extendDataArray(this.dataTempData, this.extraBRDvars);
        }
        return result;
    }

    private String[][] extendDataArray(String[][] dataTable, List<String> extraVars) {
        int oldNVars = dataTable[0].length;
        int nColumns = dataTable.length;
        String[][] result = new String[nColumns][];
        int newNVars = dataTable[0].length + extraVars.size();
        for (int c = 0; c < nColumns; ++c) {
            int r;
            result[c] = new String[newNVars];
            for (r = 0; r < dataTable[c].length; ++r) {
                result[c][r] = dataTable[c][r];
            }
            for (r = oldNVars; r < newNVars; ++r) {
                result[c][r] = "";
            }
        }
        return result;
    }

    private ArrayList fetchVariables(String strLine) {
        ArrayList<String> variableList = new ArrayList<String>();
        Matcher varMatcher = varPattern.matcher(strLine);
        while (varMatcher.find()) {
            if (varMatcher.group(0) == null) continue;
            String tempStr = varMatcher.group(0);
            int index = tempStr.lastIndexOf(VAR_LEFT_DELIMITER);
            if (index == 0 && (index = tempStr.indexOf(VAR_RIGHT_DELIMITER)) == tempStr.length() - 2) {
                variableList.add(tempStr);
            }
            strLine = varMatcher.replaceFirst(" ");
            varMatcher = varPattern.matcher(strLine);
        }
        return variableList;
    }
}

