/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.LinkInspector.Subpanels;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Dialogs.HelpSuccessPanel;
import edu.cmu.pact.BehaviorRecorder.LinkInspector.LinkInspectorException;
import edu.cmu.pact.BehaviorRecorder.LinkInspector.LinkInspectorPanel;
import edu.cmu.pact.BehaviorRecorder.LinkInspector.Subpanels.LI_Subpanel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.EdgeEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.EdgeUpdatedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.Utilities.trace;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class LI_HintSubpanel
extends LI_Subpanel
implements ActionListener {
    private JLabel PanelLabel = null;
    private JButton addButton = null;
    private JScrollPane ContentsPane = null;
    private static int PREF_HEIGHT = 150;

    public LI_HintSubpanel(BR_Controller Controller, ProblemEdge Edge, int CurrWidth, LinkInspectorPanel Panel2) throws LinkInspectorException {
        if (trace.getDebugCode("LI_HintSubpanel")) {
            trace.outNT("LI_HintSubpanel", "Generating Panel");
        }
        this.Panel = Panel2;
        this.setController(Controller);
        this.setEdge(Edge);
        this.setName("LI_HintSubpanel");
        int MinHeight = this.getMinHeight(CurrWidth);
        this.setPreferredSize(new Dimension(CurrWidth, MinHeight));
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(Color.WHITE);
        this.setBorder(BorderFactory.createEtchedBorder(1));
        String LabelText = "<html><u>Hints:</u></html>";
        this.PanelLabel = new JLabel(LabelText, 0);
        this.add(this.PanelLabel);
        this.PanelLabel.setToolTipText("Click for more options");
        this.PanelLabel.addMouseListener(this);
        this.addButton = new JButton("Add New Hint");
        this.addButton.setPreferredSize(new Dimension(30, 20));
        this.add(this.addButton);
        this.addButton.addActionListener(this);
        this.setContents();
    }

    public void setContents() {
        this.setContents1(false);
        this.revalidate();
    }

    private void setContentsOriginal() {
        String TmpStr = null;
        StringBuffer DBuffer = new StringBuffer();
        if (this.ContentsPane != null) {
            this.remove(this.ContentsPane);
        }
        DBuffer.append("<HTML>");
        Vector<String> Hints2 = this.CurrEdgeData.getAllHints();
        for (int i = 0; i < Hints2.size(); ++i) {
            TmpStr = Hints2.elementAt(i);
            if (TmpStr.length() <= 0) continue;
            if (TmpStr.length() > 75) {
                TmpStr = TmpStr.substring(0, 74);
                TmpStr = TmpStr + "...";
            }
            DBuffer.append("<hr><i>Hint#{" + i + "}:</i>");
            DBuffer.append(TmpStr);
        }
        DBuffer.append("</HTML>");
        this.add(this.ContentsPane);
    }

    private void setContents1(boolean addTextBox) {
        int i;
        Vector<String> Hints2 = this.CurrEdgeData.getAllHints();
        if (this.ContentsPane != null) {
            this.remove(this.ContentsPane);
        }
        JPanel contents = new JPanel();
        HintTextArea top = null;
        HintTextArea singleHint = null;
        for (i = 0; i < Hints2.size(); ++i) {
            String text = Hints2.elementAt(i);
            if (text.length() <= 0) continue;
            singleHint = new HintTextArea(text, i, this, false);
            if (top == null) {
                top = singleHint;
            }
            contents.add(singleHint);
        }
        if (addTextBox) {
            singleHint = new HintTextArea("", i, this, true);
            contents.add(singleHint);
        }
        BoxLayout box = new BoxLayout(contents, 1);
        contents.setLayout(box);
        this.ContentsPane = new JScrollPane(contents);
        this.ContentsPane.setVerticalScrollBarPolicy(20);
        this.ContentsPane.setHorizontalScrollBarPolicy(31);
        this.add((Component)this.ContentsPane, 1);
        if (addTextBox) {
            singleHint.selectAll();
            singleHint.grabFocus();
        } else if (top != null) {
            top.select(0, 0);
        }
    }

    private void setContents2() {
        String TmpStr = null;
        StringBuffer DBuffer = new StringBuffer();
        if (this.ContentsPane != null) {
            this.remove(this.ContentsPane);
        }
        DBuffer.append("<HTML>");
        Vector<String> Hints2 = this.CurrEdgeData.getAllHints();
        for (int i = 0; i < Hints2.size(); ++i) {
            TmpStr = Hints2.elementAt(i);
            if (TmpStr.length() <= 0) continue;
            if (TmpStr.length() > 75) {
                TmpStr = TmpStr.substring(0, 74);
                TmpStr = TmpStr + "...";
            }
            DBuffer.append("<hr><i>Hint#{" + i + "}:</i>");
            DBuffer.append(TmpStr);
        }
        DBuffer.append("</HTML>");
        this.add(this.ContentsPane);
    }

    @Override
    public void refreshData(EdgeEvent Ev) {
        this.setContents();
    }

    @Override
    protected int getMinHeight(int WidthLimit) {
        if (this.ContentsPane == null) {
            return PREF_HEIGHT;
        }
        Dimension LabelDimen = this.PanelLabel.getSize();
        Dimension ContentDimen = this.ContentsPane.getSize();
        int ContentWidth = (int)ContentDimen.getWidth();
        int ContentHeight = (int)ContentDimen.getHeight();
        if (trace.getDebugCode("LI_HintSubpanel")) {
            trace.outNT("LI_HintSubpanel", "Curr Cw:" + ContentWidth + " Ch:" + ContentHeight + " Wl:" + WidthLimit);
        }
        int NewHeight = ContentWidth * ContentHeight / WidthLimit;
        NewHeight += (int)LabelDimen.getHeight();
        NewHeight += 5;
        if (trace.getDebugCode("LI_HintSubpanel")) {
            trace.outNT("LI_HintSubpanel", "Generated Height: " + NewHeight);
        }
        return NewHeight;
    }

    @Override
    public void mouseClicked(MouseEvent E) {
        String ActionType = this.CurrEdgeData.getActionType();
        if (ActionType.equalsIgnoreCase("Correct Action")) {
            new HelpSuccessPanel(this.Controller, this.CurrEdgeData, false).setVisible(true);
            this.setContents();
            this.fireUpdateEvent(false, true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.setContents1(true);
        this.revalidate();
    }

    class HintTextArea
    extends JTextArea
    implements FocusListener {
        private String oldText;
        private int hintNumber;
        private String title;
        private LI_HintSubpanel hintPanel;
        private boolean newHint;
        private EdgeData edge;

        HintTextArea(String oldText, int hintNumber, LI_HintSubpanel hintPanel, boolean newHint) {
            this.newHint = newHint;
            this.oldText = oldText;
            this.hintPanel = hintPanel;
            this.hintNumber = hintNumber;
            this.edge = hintPanel.CurrEdgeData;
            this.title = "Hint " + (hintNumber + 1) + ":";
            this.setText(this.title + oldText);
            this.setBorder(BorderFactory.createLineBorder(Color.black));
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            this.addFocusListener(this);
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (this.newHint) {
                String newTitle;
                String newText = this.getText();
                if (newText != null && newText.length() >= this.title.length() && (newTitle = newText.substring(0, this.title.length())).equalsIgnoreCase(this.title)) {
                    newText = newText.substring(this.title.length());
                }
                if ((newText = newText.trim()) != null && newText.length() > 0) {
                    Vector<String> hints = this.edge.getAllHints();
                    hints.add(this.hintNumber, newText);
                    LI_HintSubpanel.this.Controller.getProblemModel().fireProblemModelEvent(new EdgeUpdatedEvent(this.hintPanel.Panel, this.edge.getEdge(), true));
                    this.oldText = newText;
                    this.newHint = false;
                } else if (LI_HintSubpanel.this.CurrEdgeData != null) {
                    LI_HintSubpanel.this.setContents();
                }
            } else {
                Vector<String> hints;
                String newText = this.getText();
                if (newText.length() > this.title.length()) {
                    String newTitle = newText.substring(0, this.title.length());
                    if (newText == null) {
                        return;
                    }
                    if (newTitle.equalsIgnoreCase(this.title)) {
                        newText = newText.substring(this.title.length());
                    }
                }
                if ((newText = newText.trim()).equals(this.oldText)) {
                    this.setText(this.title + newText);
                    return;
                }
                if (newText.isEmpty()) {
                    hints = this.edge.getAllHints();
                    hints.remove(this.hintNumber);
                    this.edge.setHints(hints);
                    if (LI_HintSubpanel.this.CurrEdgeData != null) {
                        LI_HintSubpanel.this.setContents();
                    }
                    return;
                }
                hints = this.edge.getAllHints();
                hints.set(this.hintNumber, newText);
                this.setText(this.title + newText);
                LI_HintSubpanel.this.Controller.getProblemModel().fireProblemModelEvent(new EdgeUpdatedEvent(this.hintPanel.Panel, this.edge.getEdge(), true));
                this.oldText = newText;
            }
        }
    }
}

