/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.FeedbackEnum;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerLink;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerSAI;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Matcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.VariableTable;
import edu.cmu.pact.Utilities.trace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class ExampleTracerEvent
extends EventObject {
    private boolean doneStepFailed = false;
    private String result = "NO-MODEL";
    private ExampleTracerSAI studentSAI;
    private ExampleTracerSAI tutorSAI;
    private ExampleTracerLink reportableLink;
    private boolean isOutOfOrder;
    private ArrayList<ExampleTracerLink> preloadedLinkMatches;
    private Vector evaluatedInput;
    private VariableTable reportableVariableTable;
    private int numberOfInterpretations = -1;
    private Vector<String> tutorAdvice;
    private Set<String> skillNames;
    private boolean solverDone = false;
    private boolean fromSolver;
    private boolean tutorSAILocked = false;
    private List<InterfaceAction> iaMessages;
    private List<String> reportableHints;
    private boolean wantReportableHints = false;
    private FeedbackEnum feedback = FeedbackEnum.DEFAULT;
    private boolean hintRequest = false;

    public static Vector<String> s2v(String s) {
        if (s == null) {
            return null;
        }
        Vector<String> result = new Vector<String>();
        result.add(s);
        return result;
    }

    public ExampleTracerEvent(Object source) {
        this(source, null);
    }

    public ExampleTracerEvent(Object source, ExampleTracerSAI studentSAI) {
        super(source);
        if (studentSAI != null) {
            this.setStudentSAI(studentSAI);
        }
    }

    public FeedbackEnum getFeedback() {
        return this.feedback;
    }

    public void setFeedback(FeedbackEnum feedback) {
        this.feedback = feedback;
    }

    public boolean isTutorPerformed() {
        if (this.studentSAI == null) {
            return false;
        }
        return Matcher.isTutorActor(this.studentSAI.getActor(), false);
    }

    public boolean isDoneStepFailed() {
        return this.doneStepFailed;
    }

    void setDoneStepFailed(boolean doneStepFailed) {
        if (trace.getDebugCode("et")) {
            trace.out("et", "setting doneStepFailed " + doneStepFailed);
        }
        this.doneStepFailed = doneStepFailed;
    }

    void setStudentSAI(ExampleTracerSAI sai) {
        this.studentSAI = (ExampleTracerSAI)sai.clone();
    }

    void setStudentSAI(Vector selection, Vector action, Vector input, String actor) {
        this.studentSAI = new ExampleTracerSAI(selection, action, input, actor);
    }

    void setTutorSAI(ExampleTracerSAI sai) {
        this.tutorSAI = (ExampleTracerSAI)sai.clone();
        if (trace.getDebugCode("solverdebug")) {
            trace.printStack("solverdebug", "setTutorSAI(" + sai + ")");
        }
    }

    void setTutorSAI(Vector selection, Vector action, Vector input, String actor) {
        this.tutorSAI = new ExampleTracerSAI(selection, action, input, actor);
        if (trace.getDebugCode("solverdebug")) {
            trace.printStack("solverdebug", "setTutorSAI(" + selection + "," + action + "," + input + "," + actor + ")");
        }
    }

    public void setResult(String result) {
        if (trace.getDebugCode("solverdebug")) {
            trace.outNT("solverdebug", "ExampleTracerEvent.setResult(" + result + ") replaces old " + this.result);
        }
        this.result = result;
    }

    public String getResult() {
        return this.result;
    }

    void setReportableLink(ExampleTracerLink reportableLink) {
        this.reportableLink = reportableLink;
    }

    public ExampleTracerLink getReportableLink() {
        return this.reportableLink;
    }

    public ExampleTracerSAI getStudentSAI() {
        return this.studentSAI;
    }

    public ExampleTracerSAI getTutorSAI() {
        return this.tutorSAI;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("[");
        sb.append(this.getResult());
        if (this.getStudentSAI() != null) {
            sb.append(", StudentSAI ").append(this.getStudentSAI());
        }
        if (this.getReportableLink() != null) {
            sb.append(", reportableLink ").append(this.getReportableLink().getEdge().getEdge().getActionLabel());
        }
        if (this.isDoneStepFailed()) {
            sb.append(", doneStepFailed");
        }
        if (this.getTutorSAI() != null) {
            sb.append(", TutorSAI ").append(this.getTutorSAI());
        }
        sb.append("]");
        return sb.toString();
    }

    public String getSelectionAsString() {
        return this.getStudentSAI().getSelectionAsString();
    }

    ArrayList<ExampleTracerLink> getPreloadedLinkMatches() {
        return this.preloadedLinkMatches;
    }

    void addPreloadedLinkMatch(ExampleTracerLink link) {
        if (this.preloadedLinkMatches == null) {
            this.preloadedLinkMatches = new ArrayList();
        }
        this.preloadedLinkMatches.add(link);
    }

    void setEvaluatedInput(String evaluatedInput) {
        if (this.evaluatedInput == null) {
            this.evaluatedInput = new Vector();
        }
        this.evaluatedInput.addElement(evaluatedInput);
    }

    public Vector getEvaluatedInputAsVector() {
        return this.evaluatedInput;
    }

    public Vector getTutorSelection() {
        return this.tutorSAI == null ? null : this.tutorSAI.getSelectionAsVector();
    }

    public Vector getTutorAction() {
        return this.tutorSAI == null ? null : this.tutorSAI.getActionAsVector();
    }

    public Vector getTutorInput() {
        if (this.evaluatedInput != null) {
            return this.getEvaluatedInputAsVector();
        }
        if (this.tutorSAI != null) {
            return this.tutorSAI.getInputAsVector();
        }
        return null;
    }

    public String getTutorActor() {
        return this.tutorSAI == null ? null : this.tutorSAI.getActor();
    }

    public boolean isOutOfOrder() {
        return this.isOutOfOrder;
    }

    void setOutOfOrder(boolean isOutOfOrder) {
        this.isOutOfOrder = isOutOfOrder;
    }

    void setReportableVariableTable(VariableTable bestInterpVT) {
        this.reportableVariableTable = (VariableTable)bestInterpVT.clone();
    }

    public VariableTable getReportableVariableTable() {
        return this.reportableVariableTable;
    }

    public int getNumberOfInterpretations() {
        return this.numberOfInterpretations;
    }

    void setNumberOfInterpretations(int numberOfInterpretations) {
        this.numberOfInterpretations = numberOfInterpretations;
    }

    public void setIncorrectMsg(String buggyMessage) {
        this.setResult("Buggy Action");
        this.setTutorAdvice(buggyMessage);
    }

    public void setTutorAdvice(String[] tutorAdvice) {
        if (tutorAdvice == null || tutorAdvice.length < 1) {
            this.tutorAdvice = null;
            return;
        }
        this.tutorAdvice = new Vector<String>(Arrays.asList(tutorAdvice));
    }

    public void setTutorAdvice(String tutorAdvice) {
        if (tutorAdvice == null) {
            this.tutorAdvice = null;
            return;
        }
        if (this.tutorAdvice == null) {
            this.tutorAdvice = new Vector();
        } else {
            this.tutorAdvice.clear();
        }
        this.tutorAdvice.add(tutorAdvice);
    }

    public Vector<String> getTutorAdvice() {
        return this.tutorAdvice;
    }

    public void makeTutorSAI(String selection, String action, String input) {
        if (!this.isTutorSAILocked()) {
            if (this.tutorSAI == null && this.studentSAI == null) {
                this.tutorSAI = new ExampleTracerSAI(selection, action, input);
            } else {
                if (this.tutorSAI == null && this.studentSAI != null) {
                    this.tutorSAI = (ExampleTracerSAI)this.studentSAI.clone();
                }
                if (selection != null) {
                    this.tutorSAI.setSelection(selection);
                }
                if (action != null) {
                    this.tutorSAI.setAction(action);
                }
                if (input != null) {
                    this.tutorSAI.setInput(input);
                }
            }
        }
        if (trace.getDebugCode("solverdebug")) {
            trace.outNT("solverdebug", (this.isTutorSAILocked() ? "locked " : "") + "makeTutorSAI(" + selection + "," + action + "," + input + ") result " + this.tutorSAI);
        }
    }

    public void addSkillName(String skillName) {
        if (this.skillNames == null) {
            this.skillNames = new LinkedHashSet<String>();
        }
        this.skillNames.add(skillName);
    }

    public Set<String> getSkillNames() {
        if (this.skillNames == null) {
            this.skillNames = new LinkedHashSet<String>();
        }
        return this.skillNames;
    }

    public void setSolverDone(boolean b) {
        this.solverDone = b;
    }

    public boolean isSolverDone() {
        return this.solverDone;
    }

    public boolean isSolverResult() {
        return this.fromSolver;
    }

    public void setFromSolver(boolean fromSolver) {
        this.fromSolver = fromSolver;
    }

    public boolean isTransaction() {
        return !"NotATransaction".equalsIgnoreCase(this.result);
    }

    public InterfaceAction addIaMessage(String action, Object input, String prompt) {
        if (input == null || input instanceof List) {
            return this.addIaMessage(action, (List)input, prompt);
        }
        return this.addIaMessage(action, ExampleTracerEvent.s2v(input.toString()), prompt);
    }

    public InterfaceAction addIaMessage(String action, List input, String prompt) {
        return this.addIaMessage(action, input, prompt, true);
    }

    public InterfaceAction addIaMessage(String action, Object input, String prompt, boolean promptNeedsInput) {
        if (input == null || input instanceof List) {
            return this.addIaMessage(action, (List)input, prompt, promptNeedsInput);
        }
        return this.addIaMessage(action, ExampleTracerEvent.s2v(input.toString()), prompt, promptNeedsInput);
    }

    public InterfaceAction addIaMessage(String action, List input, String prompt, boolean promptNeedsInput) {
        if (trace.getDebugCode("solverdebug")) {
            trace.out("solverdebug", "addIaMessage(" + action + "," + input + "," + prompt + "," + promptNeedsInput + ")");
        }
        InterfaceAction ia = new InterfaceAction();
        ia.setIaAction(action);
        if (input != null) {
            for (Object i : input) {
                if (i == null) continue;
                ia.addIaOutput(i.toString());
            }
        }
        ia.setPrompt(prompt);
        ia.setPromptNeedsInput(new Boolean(promptNeedsInput));
        if (this.iaMessages == null) {
            this.iaMessages = new ArrayList<InterfaceAction>();
        }
        this.iaMessages.add(ia);
        Collections.sort(this.iaMessages);
        return ia;
    }

    public InterfaceAction dequeueInterfaceAction() {
        if (this.iaMessages == null || this.iaMessages.size() < 1) {
            return null;
        }
        return this.iaMessages.remove(0);
    }

    public List<InterfaceAction> getInterfaceActions() {
        return this.iaMessages;
    }

    public boolean hasGradeableIAMsgs() {
        if (this.iaMessages == null || this.iaMessages.isEmpty()) {
            return false;
        }
        InterfaceAction ia = this.iaMessages.get(0);
        return ia.isGradeable();
    }

    public Object getVariableValue(String vName) {
        VariableTable vt = this.getReportableVariableTable();
        if (vt == null || vName == null || vName.length() < 1) {
            return null;
        }
        return vt.get(vName);
    }

    public String getSolverStepID(String stepID) {
        StringBuffer result = new StringBuffer(stepID == null ? "" : stepID);
        result.append('_').append(this.getTutorSelection());
        result.append('_').append(this.getTutorAction());
        for (String skillName : this.getSkillNames()) {
            result.append('_').append(skillName);
        }
        return result.toString();
    }

    public boolean isTutorSAILocked() {
        return this.tutorSAILocked;
    }

    public void setTutorSAILocked(boolean tutorSAILocked) {
        this.tutorSAILocked = tutorSAILocked;
    }

    public List<String> getReportableHints() {
        return this.reportableHints;
    }

    void setWantReportableHints(boolean wantReportableHints) {
        this.wantReportableHints = wantReportableHints;
    }

    boolean getWantReportableHints() {
        return this.wantReportableHints;
    }

    void setReportableHints(Vector<String> hints) {
        this.reportableHints = hints;
    }

    public void setActor(String actor) {
        this.studentSAI.setActor(actor);
    }

    public boolean getHintRequest() {
        return this.hintRequest;
    }

    public void setHintRequest(boolean hintRequest) {
        this.hintRequest = hintRequest;
    }

    public class InterfaceAction
    implements Comparable {
        private String prompt;
        private Map<String, Object> solverProperties;
        private Vector<String> iaAction;
        private Vector<String> iaOutput;
        private Boolean promptNeedsInput = null;

        public synchronized void addSolverProperty(String name, String value) {
            this.makeSolverProperties().put(name, value);
        }

        public synchronized void addSolverProperties(Map<String, Object> newProps) {
            this.makeSolverProperties().putAll(newProps);
        }

        public Map<String, Object> getSolverProperties() {
            return this.solverProperties;
        }

        public Object getSolverProperty(String key) {
            if (this.solverProperties == null) {
                return null;
            }
            return this.solverProperties.get(key.toLowerCase());
        }

        private synchronized Map<String, Object> makeSolverProperties() {
            if (this.getSolverProperties() == null) {
                this.solverProperties = new LinkedHashMap<String, Object>();
            }
            return this.getSolverProperties();
        }

        public String getPrompt() {
            return this.prompt;
        }

        public void setPrompt(String prompt) {
            this.prompt = prompt;
        }

        public Vector<String> getIaAction() {
            return this.iaAction;
        }

        public void setIaAction(String iaAction) {
            this.setIaAction(ExampleTracerEvent.s2v(iaAction));
        }

        public void setIaAction(Vector<String> iaAction) {
            this.iaAction = iaAction;
        }

        public Vector<String> getIaOutput() {
            return this.iaOutput;
        }

        public void setIaOutput(String iaOutput) {
            this.setIaOutput(ExampleTracerEvent.s2v(iaOutput));
        }

        private void setIaOutput(List<String> iaOutput) {
            this.iaOutput = new Vector<String>(iaOutput);
        }

        public void addIaOutput(String iaOutput) {
            if (trace.getDebugCode("solverdebug")) {
                trace.printStack("solverdebug", "ExampleTracerEvent.addIaOutput(" + iaOutput + ")");
            }
            if (this.iaOutput == null) {
                this.setIaOutput(iaOutput);
            } else {
                this.iaOutput.add(iaOutput);
            }
        }

        public int compareTo(Object other) {
            boolean thatP;
            boolean thatG;
            if (!(other instanceof InterfaceAction)) {
                trace.errStack("compareTo(" + other + ") argument wrong type", new ClassCastException(other == null ? "null" : other.getClass().getName()));
                return 0;
            }
            InterfaceAction that = (InterfaceAction)other;
            boolean thisG = this.isGradeable();
            if (thisG != (thatG = that.isGradeable())) {
                if (thisG) {
                    return -1;
                }
                return 1;
            }
            boolean thisP = this.promptsForInput();
            if (thisP == (thatP = that.promptsForInput())) {
                return 0;
            }
            if (thisP) {
                return 1;
            }
            return -1;
        }

        private boolean promptsForInput() {
            if (this.promptNeedsInput != null) {
                return this.promptNeedsInput;
            }
            if (this.prompt == null) {
                return false;
            }
            return this.prompt.length() > 0;
        }

        public Boolean getPromptNeedsInput() {
            return this.promptNeedsInput;
        }

        public void setPromptNeedsInput(Boolean promptNeedsInput) {
            this.promptNeedsInput = promptNeedsInput;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("{ ");
            sb.append(this.getIaAction()).append(", ");
            sb.append(this.getIaOutput()).append(", \"");
            sb.append(this.getPrompt()).append("\", ");
            sb.append(this.getSolverProperties()).append(" }");
            return sb.toString();
        }

        public boolean isGradeable() {
            Vector<String> iaAction = this.getIaAction();
            if (iaAction == null || iaAction.size() < 1) {
                return false;
            }
            return "promptLabel".equalsIgnoreCase((String)iaAction.get(0));
        }
    }
}

