/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerLink;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class ExampleTracerNode {
    private int nodeID;
    private ArrayList<ExampleTracerLink> outLinks;
    private ProblemNode problemNode;
    private Set<ExampleTracerLink> inLinks;

    public ExampleTracerNode(ProblemNode problemNode) {
        this.nodeID = problemNode.getUniqueID();
        this.problemNode = problemNode;
        this.outLinks = new ArrayList();
        this.inLinks = new HashSet<ExampleTracerLink>();
    }

    ExampleTracerNode(int nodeID, ArrayList<ExampleTracerLink> outLinks) {
        this.nodeID = nodeID;
        this.outLinks = outLinks;
        this.inLinks = new HashSet<ExampleTracerLink>();
    }

    ExampleTracerNode(int nodeID) {
        this(nodeID, new ArrayList<ExampleTracerLink>());
    }

    public int getNodeID() {
        return this.nodeID;
    }

    public ArrayList<ExampleTracerLink> getOutLinks() {
        return this.outLinks;
    }

    void addOutLink(ExampleTracerLink link) {
        this.outLinks.add(link);
    }

    public ProblemNode getProblemNode() {
        return this.problemNode;
    }

    boolean containsInLink(ExampleTracerLink link) {
        return this.inLinks.contains(link);
    }

    public Set<ExampleTracerLink> getInLinks() {
        return this.inLinks;
    }

    void clearInLinks() {
        this.inLinks.clear();
    }

    void addInLink(ExampleTracerLink link) {
        this.inLinks.add(link);
    }

    public boolean isStartNode() {
        return this.isStartNode(false);
    }

    public boolean isStartNode(boolean includeStudentStartNode) {
        ProblemNode startNode = null;
        ProblemNode node = this.getProblemNode();
        if (node == null) {
            return false;
        }
        if (includeStudentStartNode && node.isStudentBeginsHereState()) {
            return true;
        }
        if (node.getProblemModel() == null || (startNode = node.getProblemModel().getStartNode()) == null) {
            return false;
        }
        return startNode.getUniqueID() == this.getNodeID();
    }

    public boolean isBeforeStartState() {
        ProblemNode node = this.getProblemNode();
        return node != null && node.isBeforeStartState();
    }
}

