/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerLink;
import edu.cmu.pact.Utilities.trace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ExampleTracerPath
implements Iterable<ExampleTracerLink> {
    private Set<ExampleTracerLink> links;
    private ArrayList<ExampleTracerLink> sortedLinks = null;
    private Integer numberOfPreferredPrefixLinks = null;
    private Integer numberOfPreferredLinks = null;
    private Integer numberOfSuboptimalLinks = null;
    private Boolean donePath = null;
    private Boolean incorrectPath = null;

    public ExampleTracerPath() {
        this(null);
    }

    ExampleTracerPath(Set<ExampleTracerLink> links) {
        this.links = links == null ? new HashSet<ExampleTracerLink>() : new HashSet<ExampleTracerLink>(links);
        this.sortedLinks = null;
        this.numberOfPreferredPrefixLinks = null;
        this.numberOfPreferredLinks = null;
        this.numberOfSuboptimalLinks = null;
        this.donePath = null;
        this.incorrectPath = null;
    }

    public int getNumberOfPreferredPrefixLinks() {
        if (this.numberOfPreferredPrefixLinks != null) {
            return this.numberOfPreferredPrefixLinks;
        }
        int prefs = 0;
        for (ExampleTracerLink link : this) {
            if (!link.getEdge().isPreferredEdge()) break;
            ++prefs;
        }
        this.numberOfPreferredPrefixLinks = new Integer(prefs);
        return prefs;
    }

    public int getNumberOfPreferredLinks() {
        if (this.numberOfPreferredLinks != null) {
            return this.numberOfPreferredLinks;
        }
        int count = 0;
        for (ExampleTracerLink link : this.getLinks()) {
            if (!link.getEdge().isPreferredEdge()) continue;
            ++count;
        }
        this.numberOfPreferredLinks = new Integer(count);
        return count;
    }

    public boolean isIncorrectPath() {
        if (this.incorrectPath != null) {
            return this.incorrectPath;
        }
        for (ExampleTracerLink link : this.getLinks()) {
            if (!link.getType().equals("Buggy Action")) continue;
            this.incorrectPath = Boolean.TRUE;
            return true;
        }
        this.incorrectPath = Boolean.FALSE;
        return false;
    }

    public boolean isDonePath() {
        if (this.donePath != null) {
            return this.donePath;
        }
        for (ExampleTracerLink link : this.getLinks()) {
            if (!link.getEdge().isDone()) continue;
            this.donePath = Boolean.TRUE;
            return true;
        }
        this.donePath = Boolean.FALSE;
        return false;
    }

    public int getNumberOfSuboptimalLinks() {
        if (this.numberOfSuboptimalLinks != null) {
            return this.numberOfSuboptimalLinks;
        }
        int result = 0;
        for (ExampleTracerLink link : this.getLinks()) {
            if (!"Fireable Buggy Action".equals(link.getType())) continue;
            ++result;
        }
        this.numberOfSuboptimalLinks = new Integer(result);
        return result;
    }

    public Set<ExampleTracerLink> getLinks() {
        return this.links;
    }

    public ExampleTracerPath subpath(int destNodeID) {
        ExampleTracerPath result = new ExampleTracerPath();
        for (ExampleTracerLink link : this) {
            result.addLink(link);
            if (link.getNextNode() != destNodeID) continue;
            return result;
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ExampleTracerPath: links");
        for (ExampleTracerLink link : this) {
            sb.append(" ").append(link);
        }
        return sb.toString();
    }

    public ExampleTracerLink getLastLink() {
        ExampleTracerLink curr = null;
        for (ExampleTracerLink link : this.links) {
            if (curr != null && curr.getDepth() >= link.getDepth()) continue;
            curr = link;
        }
        return curr;
    }

    public int size() {
        return this.links.size();
    }

    public Set<ExampleTracerLink> getLinksRestricted(ArrayList<ExampleTracerLink> matchedLinks) {
        ExampleTracerLink deepest = ExampleTracerPath.getDeepestLink(matchedLinks);
        HashSet<ExampleTracerLink> restrictedLinks = new HashSet<ExampleTracerLink>();
        for (ExampleTracerLink link : this.links) {
            if (link.getDepth() > deepest.getDepth()) continue;
            restrictedLinks.add(link);
        }
        return restrictedLinks;
    }

    public static ExampleTracerLink getDeepestLink(Collection<ExampleTracerLink> c) {
        ExampleTracerLink curr = null;
        for (ExampleTracerLink link : c) {
            if (curr != null && curr.getDepth() >= link.getDepth()) continue;
            curr = link;
        }
        return curr;
    }

    public void addLink(ExampleTracerLink exampleTracerLink) {
        this.links.add(exampleTracerLink);
        this.sortedLinks = null;
        this.numberOfPreferredPrefixLinks = null;
        this.numberOfPreferredLinks = null;
        this.numberOfSuboptimalLinks = null;
        this.donePath = null;
        this.incorrectPath = null;
    }

    public static ExampleTracerPath getBestPath(Set<ExampleTracerPath> paths) {
        ExampleTracerPath bestPath = null;
        ExampleTracerPathComparator comp = new ExampleTracerPathComparator();
        for (ExampleTracerPath path : paths) {
            if (bestPath != null && comp.compare(bestPath, path) <= 0) continue;
            bestPath = path;
        }
        return bestPath;
    }

    @Override
    public Iterator<ExampleTracerLink> iterator() {
        PathIterator result = new PathIterator(this.sortedLinks);
        this.sortedLinks = result.sortedLinks;
        return result;
    }

    public boolean containsAll(List<ExampleTracerLink> memberLinks) {
        if (memberLinks == null) {
            return false;
        }
        return this.getLinks().containsAll(memberLinks);
    }

    private class PathIterator
    implements Iterator<ExampleTracerLink> {
        private ArrayList<ExampleTracerLink> sortedLinks;
        int i = 0;

        public PathIterator(ArrayList<ExampleTracerLink> sortedLinks) {
            if (sortedLinks != null) {
                this.sortedLinks = sortedLinks;
            } else {
                this.sortedLinks = new ArrayList<ExampleTracerLink>(ExampleTracerPath.this.getLinks());
                Collections.sort(this.sortedLinks, new ExampleTracerLink.LinkDepthComparator());
            }
        }

        @Override
        public boolean hasNext() {
            return this.i < this.sortedLinks.size();
        }

        @Override
        public ExampleTracerLink next() {
            return this.sortedLinks.get(this.i++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported in ExampleTracerPath iterator");
        }
    }

    public static class ExampleTracerPathComparator
    implements Comparator<ExampleTracerPath> {
        @Override
        public int compare(ExampleTracerPath p1, ExampleTracerPath p2) {
            int i2;
            if (trace.getDebugCode("et")) {
                trace.out("et", "comparing paths(" + p1 + "," + p2 + ")");
            }
            if (p1.isDonePath() && !p2.isDonePath()) {
                return -1;
            }
            if (p2.isDonePath() && !p1.isDonePath()) {
                return 1;
            }
            if (p2.isIncorrectPath() && !p1.isIncorrectPath()) {
                return -1;
            }
            if (p1.isIncorrectPath() && !p2.isIncorrectPath()) {
                return 1;
            }
            int i1 = p1.getNumberOfPreferredPrefixLinks();
            if (i1 > (i2 = p2.getNumberOfPreferredPrefixLinks())) {
                return -1;
            }
            if (i1 < i2) {
                return 1;
            }
            i1 = p1.getNumberOfSuboptimalLinks();
            if (i1 < (i2 = p2.getNumberOfSuboptimalLinks())) {
                return -1;
            }
            if (i1 > i2) {
                return 1;
            }
            i1 = p1.getNumberOfPreferredLinks();
            if (i1 > (i2 = p2.getNumberOfPreferredLinks())) {
                return -1;
            }
            if (i1 < i2) {
                return 1;
            }
            i1 = p1.getLinks().size();
            if (i1 < (i2 = p2.getLinks().size())) {
                return -1;
            }
            if (i1 > i2) {
                return 1;
            }
            if (trace.getDebugCode("et")) {
                trace.out("et", "About to call breakByLowerLinkID(" + p1 + "," + p2 + ")");
            }
            return this.breakByLowerLinkID(p1, p2);
        }

        private int breakByLowerLinkID(ExampleTracerPath i1, ExampleTracerPath i2) {
            Iterator<ExampleTracerLink> links1 = i1.iterator();
            Iterator<ExampleTracerLink> links2 = i2.iterator();
            ExampleTracerLink link1 = null;
            ExampleTracerLink link2 = null;
            int result = 0;
            do {
                if (!links1.hasNext()) {
                    result = -1;
                    continue;
                }
                if (!links2.hasNext()) {
                    result = 1;
                    continue;
                }
                link1 = links1.next();
                link2 = links2.next();
            } while (result == 0 && link1.getUniqueID() == link2.getUniqueID());
            if (result == 0) {
                int n = result = link1.getUniqueID() < link2.getUniqueID() ? -1 : 1;
            }
            if (trace.getDebugCode("et")) {
                trace.outNT("et", "breakByLowerLinkID result " + result + ", i1 size " + i1.getLinks().size() + ", i2 size " + i2.getLinks().size());
            }
            return result;
        }
    }
}

