/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph;

import java.util.Vector;

public class ExampleTracerSAI {
    private Vector<String> selection;
    private Vector<String> input;
    private Vector<String> action;
    private String actor = "Student";
    private String grade = null;

    ExampleTracerSAI() {
        this(new Vector<String>(), new Vector<String>(), new Vector<String>(), null);
    }

    public ExampleTracerSAI(String selection, String action, String input) {
        this(selection, action, input, null);
    }

    ExampleTracerSAI(String selection, String action, String input, String actor) {
        this.selection = new Vector();
        this.selection.add(selection);
        this.action = new Vector();
        this.action.add(action);
        this.input = new Vector();
        this.input.add(input);
        this.setActor(actor);
    }

    public ExampleTracerSAI(Vector<String> selection, Vector<String> action, Vector<String> input, String actor) {
        this.selection = selection == null ? null : (Vector)selection.clone();
        this.action = action == null ? null : (Vector)action.clone();
        this.input = input == null ? null : (Vector)input.clone();
        this.setActor(actor);
    }

    public String getSelectionAsString() {
        if (this.selection == null || this.selection.size() < 1) {
            return null;
        }
        String obj = this.selection.get(0);
        return obj == null ? null : obj.toString();
    }

    public Vector<String> getSelectionAsVector() {
        return this.selection;
    }

    void setSelection(String selection) {
        if (this.selection == null) {
            this.selection = new Vector();
        } else {
            this.selection.clear();
        }
        this.selection.add(selection);
    }

    void setSelection(Vector<String> selection) {
        this.selection = selection;
    }

    String getActionAsString() {
        if (this.action == null || this.action.size() < 1) {
            return null;
        }
        String obj = this.action.get(0);
        return obj == null ? null : obj.toString();
    }

    public Vector<String> getActionAsVector() {
        return this.action;
    }

    void setAction(String action) {
        if (this.action == null) {
            this.action = new Vector();
        } else {
            this.action.clear();
        }
        this.action.add(action);
    }

    void setAction(Vector<String> action) {
        this.action = action;
    }

    String getInputAsString() {
        if (this.input == null || this.input.size() < 1) {
            return null;
        }
        String obj = this.input.get(0);
        return obj == null ? null : obj.toString();
    }

    public Vector<String> getInputAsVector() {
        return this.input;
    }

    void setInput(String input) {
        if (this.input == null) {
            this.input = new Vector();
        } else {
            this.input.clear();
        }
        this.input.add(input);
    }

    void setInput(Vector<String> input) {
        this.input = input;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExampleTracerSAI) {
            return this.equals((ExampleTracerSAI)obj);
        }
        return false;
    }

    public boolean equals(ExampleTracerSAI sai) {
        if (sai == null) {
            return false;
        }
        if (this.actor == null ? sai.actor != null : !this.actor.equals(sai.actor)) {
            return false;
        }
        if (this.selection == null ? sai.selection != null : !this.selection.equals(sai.selection)) {
            return false;
        }
        if (this.action == null ? sai.action != null : !this.action.equals(sai.action)) {
            return false;
        }
        return !(this.input == null ? sai.input != null : !this.input.equals(sai.input));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[");
        sb.append(this.selection).append(",");
        sb.append(this.action).append(",");
        sb.append(this.input).append(",");
        sb.append(this.actor).append("]");
        return sb.toString();
    }

    public String getActor() {
        return this.actor;
    }

    void setActor(String actor) {
        this.actor = "Tutor".equalsIgnoreCase(actor) ? "Tutor" : ("Tutor (unevaluated)".equalsIgnoreCase(actor) ? "Tutor (unevaluated)" : ("Student".equalsIgnoreCase(actor) ? "Student" : "Student"));
    }

    public Object clone() {
        Vector s = (Vector)(this.getSelectionAsVector() == null ? null : this.getSelectionAsVector().clone());
        Vector a = (Vector)(this.getActionAsVector() == null ? null : this.getActionAsVector().clone());
        Vector i = (Vector)(this.getInputAsVector() == null ? null : this.getInputAsVector().clone());
        ExampleTracerSAI result = new ExampleTracerSAI(s, a, i, this.getActor());
        return result;
    }

    public boolean isDone() {
        Vector<String> s = this.getSelectionAsVector();
        if (null == s || s.size() < 1) {
            return false;
        }
        Vector<String> a = this.getActionAsVector();
        if (null == a || a.size() < 1) {
            return false;
        }
        return "Done".equalsIgnoreCase(s.get(0)) && "ButtonPressed".equalsIgnoreCase(a.get(0));
    }

    public String getGrade() {
        return this.grade;
    }

    public void setGrade(String grade) {
        this.grade = grade;
    }
}

