/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Matcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.VariableTable;
import edu.cmu.pact.Utilities.trace;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class ExactMatcher
extends Matcher {
    Element element;
    private Document doc;
    private Element selectionElement;
    private Element actionElement;
    private Element inputElement;
    private Element actorElement;

    public ExactMatcher(boolean concat2, int vector, String value) {
        super(concat2, vector);
        this.setSingle(value);
    }

    public ExactMatcher() {
        this.initXML();
    }

    private void initXML() {
        this.element = new Element("matcher");
        Element type = new Element("matcherType");
        type.addContent("ExactMatcher");
        this.element.addContent((Content)type);
        this.selectionElement = new Element("matcherParameter");
        this.selectionElement.setAttribute("name", "Selection");
        this.actionElement = new Element("matcherParameter");
        this.actionElement.setAttribute("name", "Action");
        this.inputElement = new Element("matcherParameter");
        this.inputElement.setAttribute("name", "Input");
        this.actorElement = new Element("matcherParameter");
        this.actorElement.setAttribute("name", "Actor");
        this.element.addContent((Content)this.selectionElement);
        this.element.addContent((Content)this.actionElement);
        this.element.addContent((Content)this.inputElement);
        this.element.addContent((Content)this.actorElement);
        this.doc = new Document(this.element);
    }

    public ExactMatcher(Vector currentSelection, Vector currentAction, Vector currentInput) {
        this();
        this.setDefaultSelection((String)currentSelection.elementAt(0));
        this.setDefaultAction((String)currentAction.elementAt(0));
        this.setDefaultInput((String)currentInput.elementAt(0));
        this.setDefaultActor("Student");
    }

    public ExactMatcher(Vector currentSelection, Vector currentAction, Vector currentInput, Vector currentActor) {
        this();
        this.setDefaultSelection((String)currentSelection.elementAt(0));
        this.setDefaultAction((String)currentAction.elementAt(0));
        this.setDefaultInput((String)currentInput.elementAt(0));
        this.setDefaultActor(currentActor == null || currentActor.size() < 1 ? "Student" : (String)currentActor.elementAt(0));
    }

    @Override
    public Object clone() {
        ExactMatcher m = new ExactMatcher(this.concat, this.vector, this.getSingle());
        m.copyFrom(this);
        return m;
    }

    protected void copyFrom(ExactMatcher m) {
        super.copyFrom(m);
        this.initXML();
        this.setDefaultSelection(m.getDefaultSelection());
        this.setDefaultAction(m.getDefaultAction());
        this.setDefaultInput(m.getDefaultInput());
        this.setDefaultActor(m.getDefaultActor());
    }

    protected Document doc() {
        return this.doc;
    }

    @Override
    public String toXML() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            XMLOutputter outp = new XMLOutputter(Format.getPrettyFormat());
            outp.output(this.doc(), (OutputStream)out);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        String newString = out.toString();
        newString = newString.substring(newString.indexOf("\n"), newString.length());
        return newString;
    }

    @Override
    public String toXML(String prefix) {
        String xml = this.toXML();
        xml = prefix + xml;
        xml = xml.replaceAll("\n", "\n" + prefix);
        return xml;
    }

    @Override
    public boolean match(Vector selection, Vector action, Vector input) {
        return this.match(selection, action, input, this.getActor());
    }

    @Override
    public boolean match(Vector selection, Vector action, Vector input, String actor) {
        boolean comparisonValue = false;
        String actualInput = input.elementAt(0).toString();
        String actualSelection = selection.elementAt(0).toString();
        String actualAction = action.elementAt(0).toString();
        String expectedInput = this.getInput().toString();
        String expectedSelection = this.getSelection().toString();
        String expectedAction = this.getAction().toString();
        if (trace.getDebugCode("match")) {
            trace.out("match", String.format("ExactMatcher.match[%s,%s,%s] getCaseInsensitive() %b", expectedSelection, expectedAction, expectedInput, this.getCaseInsensitive()));
        }
        if (this.getCaseInsensitive()) {
            comparisonValue = expectedInput.equalsIgnoreCase(actualInput) && expectedSelection.equalsIgnoreCase(actualSelection) && expectedAction.equalsIgnoreCase(actualAction);
        } else {
            boolean bl = comparisonValue = expectedInput.equals(actualInput) && expectedSelection.equals(actualSelection) && expectedAction.equals(actualAction);
        }
        if (comparisonValue) {
            trace.out("matcher", this.getActor() + " vs " + actor);
        }
        comparisonValue = comparisonValue && this.matchActor(actor);
        return comparisonValue;
    }

    @Override
    public boolean matchSingle(String s) {
        if (trace.getDebugCode("match")) {
            trace.out("match", "ExactMatcher[" + this.singleValue + "].matchSingle(" + s + ") caseInsensitive " + this.getCaseInsensitive());
        }
        return this.getCaseInsensitive() ? s.equalsIgnoreCase(this.singleValue) : s.equals(this.singleValue);
    }

    @Override
    public boolean matchForHint(Vector selection, Vector action, String actor, VariableTable vt) {
        boolean matchesSelection;
        if (!this.matchActor(actor)) {
            return false;
        }
        if (selection == null) {
            return false;
        }
        if (selection.elementAt(0) == null) {
            return false;
        }
        String actualSelection = selection.elementAt(0).toString();
        String expectedSelection = this.getSelection().toString();
        boolean caseInsensitve = this.getCaseInsensitive();
        boolean bl = matchesSelection = caseInsensitve ? expectedSelection.equals(actualSelection) : expectedSelection.equalsIgnoreCase(actualSelection);
        if (!matchesSelection) {
            return false;
        }
        boolean matchesAction = true;
        if (action != null && action.elementAt(0) != null) {
            String actualAction = action.elementAt(0).toString();
            String expectedAction = this.getAction().toString();
            matchesAction = caseInsensitve ? expectedAction.equals(actualAction) : expectedAction.equalsIgnoreCase(actualAction);
        }
        return matchesAction;
    }

    @Override
    public void setDefaultAction(String action) {
        if (!this.single) {
            this.actionElement.removeContent();
            this.actionElement.addContent(action);
        }
        super.setDefaultAction(action);
    }

    @Override
    public void setDefaultInput(String inputValue) {
        if (!this.single) {
            this.inputElement.removeContent();
            this.inputElement.addContent(inputValue);
        }
        super.setDefaultInput(inputValue);
    }

    @Override
    public void setDefaultSelection(String defaultSelection) {
        if (!this.single) {
            this.selectionElement.removeContent();
            this.selectionElement.addContent(defaultSelection);
        }
        super.setDefaultSelection(defaultSelection);
    }

    @Override
    public void setDefaultActor(String defaultActor) {
        if (!this.single) {
            this.actorElement.removeContent();
            this.actorElement.addContent(defaultActor);
        }
        super.setDefaultActor(defaultActor);
    }

    @Override
    public void setSingle(String single) {
        if (single == null) {
            return;
        }
        super.setSingle(single);
    }

    @Override
    protected void setParameterInternal(Element element2, int index) {
        if (ExactMatcher.versionIsBeforeMatcherParameterStd(element2)) {
            switch (index) {
                case 0: {
                    this.setDefaultAction(element2.getText());
                    return;
                }
                case 1: {
                    this.setDefaultInput(element2.getText());
                    return;
                }
                case 2: {
                    this.setDefaultSelection(element2.getText());
                    return;
                }
                case 3: {
                    this.setDefaultActor(element2.getText());
                    return;
                }
            }
            return;
        }
        this.setParameterByIndex(element2.getText(), index);
    }

    @Override
    public void setParameterByIndex(String stringValue, int index) {
        switch (index) {
            case 0: {
                this.setDefaultSelection(stringValue);
                return;
            }
            case 1: {
                this.setDefaultAction(stringValue);
                return;
            }
            case 2: {
                this.setDefaultInput(stringValue);
                return;
            }
            case 3: {
                this.setDefaultActor(stringValue);
                return;
            }
        }
        trace.err("ExactMatcher.setParameterByIndex(): unknown index " + index);
    }

    @Override
    public Object getParameter(int index) {
        if (this.single) {
            if (index == 0) {
                return this.singleValue;
            }
            return null;
        }
        switch (index) {
            case 0: {
                return this.getDefaultSelection();
            }
            case 1: {
                return this.getDefaultAction();
            }
            case 2: {
                return this.getDefaultInput();
            }
            case 3: {
                return this.getDefaultActor();
            }
        }
        return null;
    }

    @Override
    public int getParameterCount() {
        return this.single ? 1 : 4;
    }

    @Override
    public Matcher.MatcherParameter getMatcherParameter(int index) {
        if (this.single) {
            return new Matcher.MatcherParameter("single", this.getParameter(index));
        }
        return super.getMatcherParameter(index);
    }

    @Override
    public String getMatcherType() {
        return "Exact Match";
    }

    @Override
    public String getMatcherTypeText() {
        return "Exact";
    }

    @Override
    public String getMatcherClassType() {
        return "ExactMatcher";
    }

    @Override
    public String getSelectionLabelText() {
        return this.getSelection();
    }

    @Override
    public String getActionLabelText() {
        return this.getAction();
    }

    @Override
    public String getInputLabelText() {
        return this.getInput();
    }

    @Override
    public String getSingleLabelText() {
        return this.singleValue;
    }

    public String toString() {
        if (this.single && this.concat) {
            return this.singleValue;
        }
        return super.toString();
    }

    @Override
    public String[] getValuesVector() {
        String[] arr = this.singleValue.split("\n", -1);
        return arr;
    }

    @Override
    public String getActionMatcherType() {
        return this.getMatcherTypeText();
    }

    @Override
    public String getInputMatcherType() {
        return this.getMatcherTypeText();
    }

    @Override
    public String getSelectionMatcherType() {
        return this.getMatcherTypeText();
    }
}

