/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.AnyMatcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.ExactMatcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.ExpressionMatcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Matcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.RangeMatcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.RegexMatcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.WildcardMatcher;
import edu.cmu.pact.Utilities.trace;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class MatcherFactory {
    static final String[] RANGE_CLASS = new String[]{"edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.RangeMatcher", "pact.BehaviorRecorder.Matcher.RangeMatcher", "RangeMatcher"};
    static final String[] REGEX_CLASS = new String[]{"edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.RegexMatcher", "RegexMatcher"};
    static final String[] WILDCARD_CLASS = new String[]{"edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.WildcardMatcher", "edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.SimpleRegexMatcher", "WildcardMatcher"};
    static final String[] ANY_CLASS = new String[]{"edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.AnyMatcher", "pact.BehaviorRecorder.Matcher.AnyMatcher", "AnyMatcher"};
    static final String[] EXACT_CLASS = new String[]{"edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.ExactMatcher", "ExactMatcher"};
    static final String[] EXPRESSION_CLASS = new String[]{"edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.ExpressionMatcher", "ExpressionMatcher"};
    private static final String[][] ALL_MATCHERS = new String[][]{EXPRESSION_CLASS, EXACT_CLASS, ANY_CLASS, WILDCARD_CLASS, REGEX_CLASS, RANGE_CLASS};

    public static Matcher buildSingleMatcher(String matcherClassType, boolean concat2, int vector) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InvocationTargetException {
        String className = MatcherFactory.getClassForName(matcherClassType);
        trace.out("functions", " class name = " + className + " type = " + matcherClassType);
        Class[] args = new Class[]{Boolean.TYPE, Integer.TYPE, String.class};
        Constructor<?> c = Class.forName(className).getConstructor(args);
        return (Matcher)c.newInstance(concat2, vector, null);
    }

    public static Matcher buildMatcher(String matcherClassType) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String className = MatcherFactory.getClassForName(matcherClassType);
        trace.out("functions", " class name = " + className + " type = " + matcherClassType);
        return (Matcher)Class.forName(className).newInstance();
    }

    public static Matcher createSingleMatcher(String matcherType, boolean concat2, int vector, String value) {
        Matcher m = null;
        if (trace.getDebugCode("functions")) {
            trace.outln("functions", "createMatcher: " + matcherType);
        }
        if (matcherType.equals("Any Match")) {
            m = new AnyMatcher(concat2, vector, value);
        } else if (matcherType.equals("Exact Match")) {
            m = new ExactMatcher(concat2, vector, value);
        } else if (matcherType.equals("Range Match")) {
            m = new RangeMatcher(concat2, vector, value);
        } else if (matcherType.equals("Regular Expression Match")) {
            m = new RegexMatcher(concat2, vector, value);
        } else if (matcherType.equals("Wildcard Match")) {
            m = new WildcardMatcher(concat2, vector, value);
        } else if (matcherType.equals("Formula Match")) {
            m = new ExpressionMatcher(concat2, vector, value);
        } else if (trace.getDebugCode("functions")) {
            trace.outln("functions", "matcher for " + matcherType + " not found.");
        }
        return m;
    }

    private static String getClassForName(String matcherType) {
        for (int i = 0; i < ALL_MATCHERS.length; ++i) {
            String[] names = ALL_MATCHERS[i];
            for (int j = 0; j < names.length; ++j) {
                if (!names[j].equals(matcherType)) continue;
                return names[0];
            }
        }
        return null;
    }
}

