/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.MatcherPanels;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.MatcherPanels.AnyMatcherPanel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.MatcherPanels.ExactMatcherPanel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.MatcherPanels.ExpressionMatcherPanel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.MatcherPanels.MatcherPanel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.MatcherPanels.RangeMatcherPanel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.MatcherPanels.RegexMatcherPanel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.MatcherPanels.WildcardMatcherPanel;
import edu.cmu.pact.Utilities.trace;

public class MatcherPanelFactory {
    public static MatcherPanel createMatcherPanel(String matcherType, EdgeData edgeData, Boolean allowToolReportedActions, Integer num) {
        return MatcherPanelFactory.createMatcherPanel(matcherType, edgeData, allowToolReportedActions, num, 0);
    }

    public static MatcherPanel createMatcherPanel(String matcherType, EdgeData edgeData, Boolean allowToolReportedActions, Integer num, int index) {
        boolean allowToolActions = allowToolReportedActions;
        int n = num;
        if (trace.getDebugCode("functions")) {
            trace.outln("functions", "createMatcherPanel: " + matcherType);
        }
        if (matcherType.equals("Any Match")) {
            return new AnyMatcherPanel(edgeData, allowToolActions, n, index);
        }
        if (matcherType.equals("Exact Match")) {
            return new ExactMatcherPanel(edgeData, allowToolActions, n, index);
        }
        if (matcherType.equals("Range Match")) {
            return new RangeMatcherPanel(edgeData, allowToolActions, n, index);
        }
        if (matcherType.equals("Regular Expression Match")) {
            return new RegexMatcherPanel(edgeData, allowToolActions, n, index);
        }
        if (matcherType.equals("Wildcard Match")) {
            return new WildcardMatcherPanel(edgeData, allowToolActions, n, index);
        }
        if (matcherType.equals("Formula Match")) {
            if (trace.getDebugCode("functions")) {
                trace.outln("functions", "creating expression matcher...");
            }
            return new ExpressionMatcherPanel(edgeData, allowToolActions, n, index);
        }
        if (trace.getDebugCode("functions")) {
            trace.outln("functions", "matcher for " + matcherType + " not found.");
        }
        return null;
    }
}

