/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel;

import com.megginson.sax.DataWriter;
import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.DialogueSystemInfo;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Matcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.SolverMatcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.VectorMatcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.RuleProduction;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.XMLElements.ActionLabelElement;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.XMLElements.EdgeElement;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.XMLElements.FocusOfAttentionElement;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.XMLElements.MatcherElement;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.XMLElements.MessageElement;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.XMLElements.NodeElement;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.XMLElements.PropertiesElement;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.XMLElements.SimStElement;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.XMLElements.SolverMatcherElement;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.XMLElements.StartNodeMessagesElement;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.XMLElements.StateGraphElement;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.XMLElements.VectorMatcherElement;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.XMLElements.VectorProperty;
import edu.cmu.pact.BehaviorRecorder.View.NodeView;
import edu.cmu.pact.BehaviorRecorder.View.RuleLabel;
import edu.cmu.pact.BehaviorRecorder.jgraphwindow.BR_JGraphNode;
import edu.cmu.pact.BehaviorRecorder.jgraphwindow.BR_JGraphVertexView;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.model.StartStateModel;
import edu.cmu.pact.ctat.view.CtatFrame;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jgraph.graph.GraphLayoutCache;
import org.xml.sax.SAXException;

public class ProblemStateWriter {
    public static final XMLOutputter multiLineOutputter = new XMLOutputter();
    private BR_Controller controller;

    public ProblemStateWriter(BR_Controller controller) {
        this.controller = controller;
    }

    public String saveBRDFile(String problemFullName) {
        return this.saveBRDFile(problemFullName, null);
    }

    public String saveBRDFile(String problemFullName, byte[] imageToWrite) {
        try {
            FileOutputStream fos = new FileOutputStream(problemFullName);
            if (imageToWrite == null) {
                imageToWrite = this.createBRDDiskImage();
            }
            fos.write(imageToWrite);
            fos.close();
            if (this.controller != null && this.controller.getProblemStateReader() != null) {
                this.controller.getProblemStateReader().setSavedImage(imageToWrite);
            }
            this.controller.modifyStartState(this.controller.getProblemModel().getProblemName());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            Throwable cause = ioe.getCause();
            String errMsg = ioe.toString() + (cause == null ? "" : "; cause: " + cause.toString());
            Utils.showExceptionOccuredDialog(null, errMsg, "Error saving graph");
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            Throwable cause = e.getCause();
            String errMsg = e.toString() + (cause == null ? "" : "; cause: " + cause.toString());
            Utils.showExceptionOccuredDialog(null, errMsg, "Error saving graph");
            return null;
        }
        this.controller.getLoggingSupport().saveFileToAuthorLog(problemFullName, "SAVE_FILE");
        return problemFullName;
    }

    private byte[] createBRDDiskImage() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String errMsg = this.saveBRDFile(baos);
        if (errMsg != null) {
            Utils.showExceptionOccuredDialog(null, errMsg, "Error saving graph");
            throw new Exception(errMsg);
        }
        return baos.toByteArray();
    }

    public byte[] createBRDDiskImagePublic() throws Exception {
        System.out.println("***1337*** CREATEBRDISKIMAGEPUBLIC");
        return this.createBRDDiskImage();
    }

    public String saveBRDFile(OutputStream outputStream) {
        try {
            PrintWriter pWriter = new PrintWriter(outputStream);
            DataWriter writer = new DataWriter((Writer)pWriter);
            StateGraphElement xmlstategraph = this.writeRootElement();
            try {
                if (!Utils.isRuntime()) {
                    CtatFrame cf;
                    CtatFrame ctatFrame = cf = this.controller.getCtatFrameController() == null ? null : this.controller.getCtatFrameController().getDockedFrame();
                    if (cf != null) {
                        cf.setTutorTypeLabel(this.controller.getCtatModeModel().getCurrentMode());
                    }
                }
            }
            catch (Exception e) {
                trace.errStack("error setting tutorType frame", e);
            }
            this.writeStartNodeMessages(writer, xmlstategraph);
            this.writeNodeElements(xmlstategraph);
            this.writeEdgeElements(writer, xmlstategraph);
            this.writeProductionRules(xmlstategraph);
            this.writeLinkGroups(xmlstategraph);
            this.writeDocumentToFile(writer, xmlstategraph);
            outputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            Throwable cause = e.getCause();
            return e.toString() + (cause == null ? "" : "; cause " + cause.toString());
        }
        catch (SAXException e) {
            e.printStackTrace();
            Throwable cause = e.getCause();
            return e.toString() + (cause == null ? "" : "; cause " + cause.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            Throwable cause = e.getCause();
            return e.toString() + (cause == null ? "" : "; cause " + cause.toString());
        }
        return null;
    }

    private MessageElement writeCommMsg(MessageObject m, DataWriter writer) {
        if (m == null) {
            return null;
        }
        MessageElement xmlmsg = new MessageElement();
        xmlmsg.addverb(m.getVerb());
        try {
            PropertiesElement xmlprop = new PropertiesElement();
            List<String> propertyNames = m.getPropertyNames();
            for (int j = 0; j < propertyNames.size(); ++j) {
                String propertyName = propertyNames.get(j);
                Object propertyValue = m.getProperty(propertyName);
                if (propertyValue instanceof Vector) {
                    VectorProperty vectorProperty = new VectorProperty(propertyName, (Vector)propertyValue);
                    xmlprop.addProperty(propertyName, vectorProperty);
                } else if (propertyValue instanceof Element) {
                    xmlprop.addProperty(propertyName, propertyValue);
                } else {
                    String inputvalue = propertyValue.toString();
                    xmlprop.addProperty(propertyName, inputvalue);
                }
                xmlmsg.addproperties(xmlprop);
            }
        }
        catch (Exception e) {
            trace.err("ProblemStateWriter.java: exception = " + e);
        }
        return xmlmsg;
    }

    void writeDocumentToFile(DataWriter writer, StateGraphElement xmlstategraph) throws SAXException {
        writer.setIndentStep(4);
        writer.startDocument();
        xmlstategraph.printXML(writer);
        writer.endDocument();
    }

    private void writeLinkGroups(StateGraphElement xmlstategraph) {
        xmlstategraph.addGroupModel(this.controller.getExampleTracerGraph().getGroupModel());
    }

    private void writeProductionRules(StateGraphElement xmlstategraph) {
        RuleProduction.Catalog rpc = this.controller.getRuleProductionCatalog();
        if (trace.getDebugCode("pm")) {
            trace.out("pm", "writeProductionRules() list before culling: " + rpc);
        }
        ProblemModel pm = this.controller.getProblemModel();
        RuleProduction.Catalog rulesInUse = pm.updateOpportunityCounts();
        for (RuleProduction rp : rulesInUse.values()) {
            xmlstategraph.addProductionRule(rp.getRuleName(), rp.getProductionSet(), rp.getHints(), rp.getOpportunityCount(), rp.getLabel(), rp.getDescription());
        }
    }

    public static MatcherElement getMatcherElement(Matcher tmpMatcher) {
        MatcherElement xmlMatcher = new MatcherElement();
        xmlMatcher.setReplacementFormula(tmpMatcher.getReplacementFormula());
        xmlMatcher.addmatcherType(tmpMatcher.getMatcherClassType());
        for (int p = 0; p < tmpMatcher.getParameterCount(); ++p) {
            Matcher.MatcherParameter param = tmpMatcher.getMatcherParameter(p);
            xmlMatcher.addmatcherParameter(param);
        }
        return xmlMatcher;
    }

    private void writeEdgeElements(DataWriter writer, StateGraphElement xmlstategraph) {
        Vector<ProblemEdge> edgesVector = new Vector<ProblemEdge>();
        Enumeration<ProblemEdge> iterEdges = this.controller.getProblemModel().getProblemGraph().edges();
        while (iterEdges.hasMoreElements()) {
            edgesVector.addElement(iterEdges.nextElement());
        }
        int edgesNumber = edgesVector.size();
        for (int i = edgesNumber - 1; i >= 0; --i) {
            Hashtable foAMap;
            Vector foAList;
            EdgeElement xmledge = new EdgeElement();
            ProblemEdge tempEdge = (ProblemEdge)edgesVector.elementAt(i);
            EdgeData myEdge = tempEdge.getEdgeData();
            ActionLabelElement xmlActionLabel = new ActionLabelElement();
            xmlActionLabel.addpreferPathMark(myEdge.isPreferredEdge());
            DialogueSystemInfo dialogueSystemInfo = myEdge.getDialogueSystemInfo();
            xmlActionLabel.addstudentHintRequest(dialogueSystemInfo.getStudent_Hint_Request());
            xmlActionLabel.addstepSuccessfulCompletion(dialogueSystemInfo.getStep_Successful_Completion());
            xmlActionLabel.addstepStudentError(dialogueSystemInfo.getStep_Student_Error());
            xmlActionLabel.adduniqueID(myEdge.getUniqueID());
            MessageElement tmpmsg = this.writeCommMsg(myEdge.getDemoMsgObj(), writer);
            if (tmpmsg != null) {
                xmlActionLabel.addmessage(tmpmsg);
            }
            xmlActionLabel.addbuggyMessage(myEdge.getBuggyMsg());
            xmlActionLabel.addsuccessMessage(myEdge.getSuccessMsg());
            for (String hint : myEdge.getAllNonEmptyHints()) {
                xmlActionLabel.addhintMessage(hint);
            }
            xmlActionLabel.setCallbackFn(myEdge.getCallbackFn());
            xmlActionLabel.addactionType(myEdge.getActionType());
            xmlActionLabel.addoldActionType(myEdge.getOldActionType());
            xmlActionLabel.addcheckedStatus(myEdge.getCheckedStatus());
            xmlActionLabel.setMinTraversals(myEdge.getMinTraversalsStr());
            xmlActionLabel.setMaxTraversals(myEdge.getMaxTraversalsStr());
            Matcher tmpMatcher = myEdge.getMatcher();
            if (tmpMatcher != null) {
                if (tmpMatcher instanceof SolverMatcher) {
                    SolverMatcherElement xmlSolverMatcher = new SolverMatcherElement((SolverMatcher)tmpMatcher);
                    xmlActionLabel.addVectorMatcher(xmlSolverMatcher);
                } else if (tmpMatcher instanceof VectorMatcher) {
                    VectorMatcherElement xmlVectorMatcher = new VectorMatcherElement((VectorMatcher)tmpMatcher);
                    xmlActionLabel.addVectorMatcher(xmlVectorMatcher);
                } else {
                    MatcherElement xmlMatcher = ProblemStateWriter.getMatcherElement(tmpMatcher);
                    xmlActionLabel.addMatcher(xmlMatcher);
                }
            }
            xmledge.addactionLabel(xmlActionLabel);
            xmledge.addprecheckedStatus(myEdge.getPreLispCheckLabel().preCheckedStatus);
            int ruleNumbers = myEdge.getRuleLabels().size();
            for (int j = 0; j < ruleNumbers; ++j) {
                RuleLabel tempRuleLabel = myEdge.getRuleLabels().elementAt(j);
                xmledge.addrule(tempRuleLabel.getText(), -1);
            }
            ProblemNode vertexNode = tempEdge.getNodes()[0];
            xmledge.addsourceID(vertexNode.getUniqueID());
            vertexNode = tempEdge.getNodes()[1];
            xmledge.adddestID(vertexNode.getUniqueID());
            xmledge.addtraversalCount(myEdge.getTraversalCount());
            if (this.controller.getCtatModeModel().isSimStudentMode()) {
                Hashtable<ProblemEdge, Vector<String>> foAMap2 = this.controller.getMissController().getSimSt().getFoaTable();
                if (this.controller.getProblemStateReader().getProblemStateReaderJDom() != null) {
                    Hashtable foAMapTemp = this.controller.getProblemStateReader().getProblemStateReaderJDom().getFoATable();
                    foAMap2.putAll(foAMapTemp);
                }
                if ((foAList = foAMap2.get(tempEdge)) != null) {
                    SimStElement simElem = new SimStElement();
                    for (int k = 0; k < foAList.size(); ++k) {
                        FocusOfAttentionElement foAElem = new FocusOfAttentionElement();
                        foAElem.addTarget((String)foAList.get(k));
                        simElem.addFoA(foAElem);
                    }
                    xmledge.addSimSt(simElem);
                }
            } else if (this.controller.getProblemStateReader().getProblemStateReaderJDom() != null && (foAList = (Vector)(foAMap = this.controller.getProblemStateReader().getProblemStateReaderJDom().getFoATable()).get(tempEdge)) != null) {
                SimStElement simElem = new SimStElement();
                for (int k = 0; k < foAList.size(); ++k) {
                    FocusOfAttentionElement foAElem = new FocusOfAttentionElement();
                    foAElem.addTarget((String)foAList.get(k));
                    simElem.addFoA(foAElem);
                }
                xmledge.addSimSt(simElem);
            }
            for (int l = 0; l < myEdge.getAssociatedElements().size(); ++l) {
                xmledge.addassociation(myEdge.getAssociatedElements().get(l).toString(), myEdge.getAssociatedElementsValues().get(l).toString());
            }
            xmlstategraph.addEdge(xmledge);
        }
    }

    private void writeNodeElements(StateGraphElement xmlstategraph) {
        Vector<ProblemNode> nodesVector = new Vector<ProblemNode>();
        Enumeration<ProblemNode> iterNodes = this.controller.getProblemModel().getProblemGraph().nodes();
        while (iterNodes.hasMoreElements()) {
            nodesVector.addElement(iterNodes.nextElement());
        }
        int nodesNumber = nodesVector.size();
        NodeView nodeView = null;
        for (int i = nodesNumber - 1; i >= 0; --i) {
            ProblemNode tempNode = (ProblemNode)nodesVector.elementAt(i);
            nodeView = tempNode.getNodeView();
            NodeElement xmlnode = new NodeElement();
            xmlnode.addlocked(nodeView.getLocked());
            xmlnode.adddoneState(tempNode.getDoneState());
            xmlnode.addtext(nodeView.getText());
            xmlnode.adduniqueID(tempNode.getUniqueID());
            BR_JGraphNode graphNode = nodeView.getProblemNode().getJGraphNode();
            if (!Utils.isRuntime()) {
                GraphLayoutCache graphView = this.controller.getJGraphWindow().getJGraphController().getGraphView();
                BR_JGraphVertexView jgraphNodeView = (BR_JGraphVertexView)graphView.getMapping((Object)graphNode, false);
                if (jgraphNodeView == null) {
                    trace.err("jgraphNodeView null: graphNode " + graphNode + ", graphView " + graphView + ", nodeView " + nodeView + ", .text " + nodeView.getText());
                }
                Rectangle2D rect = jgraphNodeView.getBounds();
                xmlnode.adddimension((int)rect.getX(), (int)rect.getY());
            }
            xmlstategraph.addNode(xmlnode);
        }
    }

    private StateGraphElement writeRootElement() {
        StateGraphElement xmlstategraph = new StateGraphElement();
        ProblemModel pm = this.controller.getProblemModel();
        xmlstategraph.addcaseInsensitive(pm.isCaseInsensitive());
        xmlstategraph.addfirstCheckAllStates(this.controller.isFirstCheckAllStatesFlag());
        xmlstategraph.addlockWidget(pm.isLockWidget());
        xmlstategraph.addHintPolicy(pm.getHintPolicy());
        xmlstategraph.addversion("4.0");
        xmlstategraph.addunordered(pm.isUnorderedMode());
        xmlstategraph.addSuppressStudentFeedback(pm.getSuppressStudentFeedback());
        xmlstategraph.addHighlightRightSelection(pm.getHighlightRightSelection());
        xmlstategraph.addConfirmDone(pm.getConfirmDone());
        xmlstategraph.addStudentBeginsHereStateName(pm.getStudentBeginsHereNameForBRD());
        xmlstategraph.addTutorType(this.controller);
        xmlstategraph.addOutOfOrderMessage(pm.getOutOfOrderMessage());
        return xmlstategraph;
    }

    private void writeStartNodeMessages(DataWriter writer, StateGraphElement xmlstategraph) {
        this.writeStartNodeMessages(writer, xmlstategraph, this.controller.getProblemModel().startNodeMessagesIterator());
    }

    void writeStartNodeMessages(DataWriter writer, StateGraphElement xmlstategraph, Iterator<MessageObject> it) {
        StartNodeMessagesElement xmlstartnodemessages = new StartNodeMessagesElement();
        if (this.controller == null) {
            xmlstategraph.addStartNodeMessages(xmlstartnodemessages);
            return;
        }
        while (it.hasNext()) {
            MessageElement tmpmsg;
            MessageObject msg = it.next();
            if (!StartStateModel.isProperStartStateMessage(msg, Boolean.TRUE) || (tmpmsg = this.writeCommMsg(msg, writer)) == null) continue;
            xmlstartnodemessages.addmessage(tmpmsg);
        }
        xmlstategraph.addStartNodeMessages(xmlstartnodemessages);
    }

    private void addToSNMElement(MessageObject msg, DataWriter writer, StartNodeMessagesElement xmlstartnodemessages) {
    }

    static {
        Format fmt = Format.getPrettyFormat();
        fmt.setOmitDeclaration(true);
        fmt.setLineSeparator("\r\n");
        fmt.setIndent("    ");
        multiLineOutputter.setFormat(fmt);
    }
}

