/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.XMLElements;

import com.megginson.sax.DataWriter;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.XMLElements.VectorProperty;
import edu.cmu.pact.Utilities.trace;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class PropertiesElement {
    private String elementName = "properties";
    private ArrayList<PropertyPair> properties = new ArrayList();
    private static XMLOutputter outputter = new XMLOutputter(Format.getCompactFormat().setOmitDeclaration(true).setLineSeparator("\n").setIndent("  "));

    public void addProperty(String properyName, Object obj) {
        if (!(obj instanceof Element || obj instanceof VectorProperty || obj instanceof String)) {
            trace.out(5, this, "invalid object type.");
            return;
        }
        this.properties.add(new PropertyPair(properyName, obj));
    }

    public void printXML(DataWriter w) throws SAXException {
        w.startElement(this.elementName);
        for (PropertyPair propertyPair : this.properties) {
            String name = propertyPair.getPropertyName();
            Object obj = propertyPair.getPropertyValue();
            if (obj instanceof Element) {
                w.startElement(name);
                PropertiesElement.printElement((Element)obj, w);
                w.endElement(name);
                continue;
            }
            if (obj instanceof String) {
                w.dataElement(name, (String)obj);
                continue;
            }
            if (!(obj instanceof VectorProperty)) continue;
            VectorProperty objV = (VectorProperty)obj;
            objV.printXML(w);
        }
        w.endElement(this.elementName);
    }

    static void printElement(Element elt, DataWriter w) {
        if (elt == null) {
            return;
        }
        try {
            List attList = elt.getAttributes();
            AttributesImpl atts = new AttributesImpl();
            for (Attribute att : attList) {
                atts.addAttribute("", att.getName(), "", "String", att.getValue());
            }
            w.startElement("", elt.getName(), "", (Attributes)atts);
            String text = elt.getText();
            if (text.trim().length() > 0) {
                w.characters(text);
            }
            List children = elt.getChildren();
            for (Element child : children) {
                PropertiesElement.printElement(child, w);
            }
            w.endElement(elt.getName());
        }
        catch (SAXException se) {
            String eltXML = outputter.outputString(elt);
            throw new RuntimeException("error converting Element " + eltXML, se);
        }
    }

    private class PropertyPair {
        private String propertyName;
        private Object propertyValue;

        public PropertyPair(String propertyName, Object propertyValue) {
            this.propertyName = propertyName;
            this.propertyValue = propertyValue;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public Object getPropertyValue() {
            return this.propertyValue;
        }
    }
}

