/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.XMLElements;

import com.megginson.sax.DataWriter;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Matcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.VectorMatcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemStateWriter;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class VectorMatcherElement {
    protected String elementName = "matchers";
    private boolean concat;
    private VectorElement selection;
    private VectorElement action;
    private VectorElement input;
    private String actor;
    private boolean linkTriggered;

    public VectorMatcherElement(VectorMatcher vm) {
        this.concat = vm.isConcat();
        this.selection = new VectorElement(vm.getMatchers(0), "Selection");
        this.action = new VectorElement(vm.getMatchers(1), "Action");
        this.input = new VectorElement(vm.getMatchers(2), "Input");
        this.actor = vm.getDefaultActor();
        this.linkTriggered = vm.isLinkTriggered();
    }

    public void printXML(DataWriter w) throws SAXException {
        w.startElement("", this.elementName, "", (Attributes)this.getAttributes());
        this.selection.printXML(w);
        this.action.printXML(w);
        this.input.printXML(w);
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "linkTriggered", "", "String", Boolean.toString(this.linkTriggered));
        w.startElement("", "Actor", "", (Attributes)atts);
        w.characters(this.actor);
        w.endElement("Actor");
        w.endElement(this.elementName);
    }

    protected AttributesImpl getAttributes() {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "Concatenation", "", "String", Boolean.toString(this.concat));
        return atts;
    }

    private class VectorElement {
        String elementName;
        List<Matcher> matchers;

        public VectorElement(List<Matcher> matchers, String elementName) {
            this.elementName = elementName;
            this.matchers = matchers;
        }

        public void printXML(DataWriter w) throws SAXException {
            w.startElement(this.elementName);
            for (int i = 0; i < this.matchers.size(); ++i) {
                ProblemStateWriter.getMatcherElement(this.matchers.get(i)).printXML(w);
            }
            w.endElement(this.elementName);
        }
    }
}

