/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemSetWizard;

import edu.cmu.pact.BehaviorRecorder.Dialogs.DialogUtilities;
import edu.cmu.pact.BehaviorRecorder.Dialogs.DirectoryFilter;
import edu.cmu.pact.BehaviorRecorder.ProblemSetWizard.CTATCSVReader;
import edu.cmu.pact.BehaviorRecorder.ProblemSetWizard.CTATFileCopy;
import edu.cmu.pact.BehaviorRecorder.ProblemSetWizard.CTATProblem;
import edu.cmu.pact.BehaviorRecorder.ProblemSetWizard.CTATProblemSet;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATFileManager;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATJPanel;
import edu.cmu.pact.BehaviorRecorder.View.JUndo;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class CTATProblemSetPanel
extends CTATJPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private CTATFileManager fManager = null;
    private JButton inputPathButton = null;
    private JTextField inputPath = null;
    private JButton outputPathButton = null;
    private JTextField outputPath = null;
    private JButton buildButton = null;
    private JTextArea console = null;
    private ArrayList<CTATProblemSet> model = null;
    private JCheckBox compDirTXT = null;
    private JCheckBox pSetXML = null;

    public CTATProblemSetPanel() {
        this.debug("CTATProblemSetPanel ()");
        this.fManager = new CTATFileManager();
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        Box panelBox = new Box(1);
        this.add(panelBox);
        JLabel inLabel = new JLabel();
        inLabel.setText("Choose a tab delimited text file");
        inLabel.setHorizontalAlignment(2);
        panelBox.add(inLabel);
        Box inputBox = new Box(0);
        panelBox.add(inputBox);
        this.inputPath = new JTextField();
        JUndo.JTextUndoPacket jTextUndoPacket = JUndo.makeTextUndoable(this.inputPath);
        this.inputPath.setFont(new Font("Dialog", 1, 10));
        this.inputPath.setMinimumSize(new Dimension(20, 20));
        this.inputPath.setMaximumSize(new Dimension(5000, 20));
        inputBox.add(this.inputPath);
        this.inputPathButton = new JButton();
        this.inputPathButton.setText("...");
        this.inputPathButton.setFont(new Font("Dialog", 1, 10));
        this.inputPathButton.setMinimumSize(new Dimension(20, 20));
        this.inputPathButton.setMaximumSize(new Dimension(75, 20));
        this.inputPathButton.addActionListener(this);
        inputBox.add(this.inputPathButton);
        JLabel outLabel = new JLabel();
        outLabel.setText("Choose an output directory");
        outLabel.setHorizontalAlignment(2);
        panelBox.add(outLabel);
        Box outputBox = new Box(0);
        panelBox.add(outputBox);
        this.outputPath = new JTextField();
        JUndo.JTextUndoPacket jTextUndoPacket2 = JUndo.makeTextUndoable(this.outputPath);
        this.outputPath.setFont(new Font("Dialog", 1, 10));
        this.outputPath.setMinimumSize(new Dimension(20, 20));
        this.outputPath.setMaximumSize(new Dimension(5000, 20));
        outputBox.add(this.outputPath);
        this.outputPathButton = new JButton();
        this.outputPathButton.setText("...");
        this.outputPathButton.setFont(new Font("Dialog", 1, 10));
        this.outputPathButton.setMinimumSize(new Dimension(20, 20));
        this.outputPathButton.setMaximumSize(new Dimension(75, 20));
        this.outputPathButton.addActionListener(this);
        outputBox.add(this.outputPathButton);
        this.console = new JTextArea();
        this.console.setFont(new Font("Courier", 1, 11));
        this.console.setMinimumSize(new Dimension(20, 20));
        this.console.setMaximumSize(new Dimension(5000, 5000));
        this.console.setEditable(false);
        this.console.setWrapStyleWord(true);
        JScrollPane scrollPane = new JScrollPane(this.console);
        scrollPane.setMinimumSize(new Dimension(20, 20));
        scrollPane.setMaximumSize(new Dimension(5000, 5000));
        panelBox.add(scrollPane);
        this.compDirTXT = new JCheckBox();
        this.compDirTXT.setText("Compile and write directory.txt");
        this.compDirTXT.setFont(new Font("Dialog", 1, 10));
        this.compDirTXT.setMinimumSize(new Dimension(20, 20));
        this.compDirTXT.setMaximumSize(new Dimension(5000, 20));
        panelBox.add(this.addInHorizontalLayout(this.compDirTXT, 5000, 20));
        this.pSetXML = new JCheckBox();
        this.pSetXML.setText("Compile and write problem_set.xml");
        this.pSetXML.setFont(new Font("Dialog", 1, 10));
        this.pSetXML.setMinimumSize(new Dimension(20, 20));
        this.pSetXML.setMaximumSize(new Dimension(5000, 20));
        this.pSetXML.setSelected(true);
        panelBox.add(this.addInHorizontalLayout(this.pSetXML, 5000, 20));
        this.buildButton = new JButton();
        this.buildButton.setText("Build");
        this.buildButton.setFont(new Font("Dialog", 1, 10));
        this.buildButton.setMinimumSize(new Dimension(20, 20));
        this.buildButton.setMaximumSize(new Dimension(5000, 20));
        this.buildButton.addActionListener(this);
        panelBox.add(this.addInHorizontalLayout(this.buildButton, 5000, 20));
    }

    private String stripFileFromPath(String aFile) {
        return new File(aFile).getParent();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File file;
        this.debug("actionPerformed ()");
        if (e.getSource() == this.buildButton) {
            this.build();
        }
        if (e.getSource() == this.inputPathButton && (file = DialogUtilities.chooseFile(null, null, null, "Choose an input file", "Open", this)) != null) {
            this.debug("Input: " + file.getAbsolutePath());
            this.inputPath.setText(file.getAbsolutePath());
        }
        if (e.getSource() == this.outputPathButton && (file = DialogUtilities.chooseFile(null, null, (FileFilter)new DirectoryFilter(), "Choose an output directory", "Open", this)) != null) {
            this.debug("Input: " + file.getAbsolutePath());
            this.outputPath.setText(file.getAbsolutePath());
        }
    }

    public void consoleWrite(String aLine) {
        this.console.append(aLine + "\n");
    }

    public void consoleReset() {
        this.console.setText("");
    }

    public CTATProblemSet addProblemSet(String aSet) {
        for (int i = 0; i < this.model.size(); ++i) {
            CTATProblemSet compare = this.model.get(i);
            if (!compare.getName().equals(aSet)) continue;
            return compare;
        }
        this.consoleWrite("Adding new problem set: " + aSet);
        CTATProblemSet newSet = new CTATProblemSet();
        newSet.setName(aSet);
        this.model.add(newSet);
        return newSet;
    }

    public void build() {
        this.debug("build ()");
        this.consoleReset();
        this.consoleWrite("Starting build ...");
        File inp = new File(this.inputPath.getText());
        if (!inp.exists()) {
            this.consoleWrite("Error: input file [" + this.inputPath.getText() + "] does not exist or isn't specified");
            return;
        }
        File outp = new File(this.outputPath.getText());
        if (!outp.exists()) {
            this.consoleWrite("Error: output path [" + this.outputPath.getText() + "] does not exist or isn't specified");
            return;
        }
        String inputStream = this.fManager.loadContents(this.inputPath.getText());
        this.model = new ArrayList();
        CTATCSVReader reader = new CTATCSVReader();
        reader.processInputTab(inputStream);
        ArrayList<ArrayList<String>> data = reader.getData();
        StringBuffer dirTXT = new StringBuffer();
        for (int i = 0; i < data.size(); ++i) {
            ArrayList<String> row = data.get(i);
            if (i == 0) {
                this.consoleWrite("Skipping header ...");
                continue;
            }
            CTATProblemSet testSet = this.addProblemSet(row.get(0));
            testSet.setCondition(row.get(1));
            if (row.get(5) != null) {
                testSet.setDescription(row.get(5));
            }
            ArrayList<CTATProblem> problems = testSet.getProblems();
            CTATProblem problem = new CTATProblem();
            problem.setCondition(row.get(1));
            problem.setSwf(row.get(2));
            problem.setBrd(row.get(3));
            problem.setProblemType(row.get(4));
            problems.add(problem);
        }
        this.consoleWrite("Generating output ...");
        for (int j = 0; j < this.model.size(); ++j) {
            Boolean ready = false;
            StringBuffer pSetBuffer = new StringBuffer();
            CTATProblemSet converter = this.model.get(j);
            pSetBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><ProblemSet max_repeat=\"1\" initial_sequence=\"0\" selection_algorithm=\"sequential\" description=\"" + converter.getName() + "-" + converter.getDescription() + "\" name=\"" + converter.getName() + "\" max_count=\"1000\"><Problems>");
            this.consoleWrite("Converting: " + converter.getName() + " ...");
            if (j > 0) {
                dirTXT.append("\n");
            }
            dirTXT.append(converter.getCondition() + "|" + converter.getName() + "-" + converter.getCondition() + "|" + converter.getDescription());
            StringBuffer pSetPath = new StringBuffer();
            pSetPath.append(this.outputPath.getText() + "/" + converter.getName() + "-" + converter.getCondition());
            StringBuffer swfPath = new StringBuffer();
            swfPath.append(this.outputPath.getText() + "/" + converter.getName() + "-" + converter.getCondition() + "/Flash/");
            StringBuffer brdPath = new StringBuffer();
            brdPath.append(this.outputPath.getText() + "/" + converter.getName() + "-" + converter.getCondition() + "/FinalBRDs/");
            this.consoleWrite("Creating problem set directory: " + pSetPath.toString());
            boolean success = new File(pSetPath.toString()).mkdir();
            if (!success) {
                this.consoleWrite("Error creating problem set directory");
            } else {
                this.consoleWrite("Creating problem set directory: " + pSetPath.toString());
                success = new File(swfPath.toString()).mkdir();
                if (!success) {
                    this.consoleWrite("Error creating Flash directory: " + swfPath.toString());
                } else {
                    success = new File(brdPath.toString()).mkdir();
                    success = false;
                    if (false) {
                        this.consoleWrite("Error creating BRD directory: " + brdPath.toString());
                    } else {
                        ready = true;
                    }
                }
            }
            if (ready.booleanValue()) {
                this.consoleWrite("Copying files ...");
                ArrayList<CTATProblem> problems = converter.getProblems();
                for (int k = 0; k < problems.size(); ++k) {
                    CTATProblem problem = problems.get(k);
                    String swfString = problem.getSwf();
                    String brdString = problem.getBrd();
                    pSetBuffer.append("<Problem tutor_flag=\"tutor\" problem_file=\"" + problem.getBrd() + "\" description=\"" + converter.getDescription() + "\" name=\"" + converter.getName() + "-" + k + "-" + converter.getCondition() + "\" student_interface=\"" + problem.getSwf() + "\"><Skills></Skills></Problem>");
                    CTATFileCopy.copyfile(swfPath.toString() + "/" + swfString, this.stripFileFromPath(this.inputPath.getText()) + "/Flash/" + swfString);
                    CTATFileCopy.copyfile(brdPath.toString() + "/" + brdString, this.stripFileFromPath(this.inputPath.getText()) + "/FinalBRDs/" + brdString);
                }
            }
            pSetBuffer.append("</Problems><Categories></Categories><Skills></Skills><Assets></Assets></ProblemSet>");
            if (!this.pSetXML.isSelected()) continue;
            this.fManager.saveContents(pSetPath.toString() + "/problem_set.xml", pSetBuffer.toString());
        }
        if (this.compDirTXT.isSelected()) {
            this.fManager.saveContents(this.outputPath.getText() + "/directory.txt", dirTXT.toString());
        }
        this.consoleWrite("Build complete");
    }
}

