/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Log.LogDifferences;

import edu.cmu.pact.Log.LogDifferences.Column;
import edu.cmu.pact.Log.LogDifferences.Content.ContentCell;
import edu.cmu.pact.Log.LogDifferences.Contents;
import edu.cmu.pact.Log.LogDifferences.DifferencesCounter;
import edu.cmu.pact.Log.LogDifferences.Row;

public class BasicRow
implements Row {
    private final Contents content;
    private final Column column;
    private final String[] row;

    public BasicRow(Contents content, Column column) {
        this.content = content;
        this.column = column;
        this.row = this.makeRowFromContents();
        this.addLeadingData();
    }

    @Override
    public String[] toArray() {
        return this.row;
    }

    private void addToRow(ContentCell cell, String[] tempRow) {
        String columnName = cell.getColumnName();
        int index = this.column.getIndex(columnName);
        tempRow[index] = cell.getContent();
    }

    private String[] makeRowFromContents() {
        String[] tempRow = new String[this.column.getNumColumns()];
        for (ContentCell cell : this.content) {
            this.addToRow(cell, tempRow);
        }
        return tempRow;
    }

    private void addLeadingData() {
        this.row[this.column.getIndex((String)"transaction_id").intValue()] = this.content.getTransactionId();
        this.row[this.column.getIndex((String)"old/new").intValue()] = "old";
    }

    void setDiffsColumns(DifferencesCounter diffs) {
        this.row[this.column.getIndex((String)"Has differences").intValue()] = diffs.hasDiffs();
        this.row[this.column.getIndex((String)"# of differences").intValue()] = diffs.getNumDiffs();
    }
}

