/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Log.LogDifferences.Content;

import edu.cmu.pact.Log.LogDifferences.Content.ColumnFormatter;
import edu.cmu.pact.Log.LogDifferences.Content.Content;
import edu.cmu.pact.Log.LogDifferences.Content.ContentCell;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class ActionEvaluationContent
implements Content {
    private static final String ACTION_EVALUATION = "action_evaluation";
    private final String evaluation;
    private final String current_hint_number;
    private final String total_hints_available;
    private final String hintId;
    private final String classification;

    public ActionEvaluationContent(String evaluation, String current_hint_number, String total_hints_available, String hintId, String classification) {
        this.evaluation = evaluation;
        this.current_hint_number = current_hint_number;
        this.total_hints_available = total_hints_available;
        this.hintId = hintId;
        this.classification = classification;
    }

    @Override
    public Iterator<ContentCell> iterator() {
        ArrayList<ContentCell> aeList = new ArrayList<ContentCell>();
        this.addCell(aeList, ACTION_EVALUATION, "evaluation", this.evaluation);
        this.addCell(aeList, ACTION_EVALUATION, "current_hint_number", this.current_hint_number);
        this.addCell(aeList, ACTION_EVALUATION, "total_hints_available", this.total_hints_available);
        this.addCell(aeList, ACTION_EVALUATION, "hintId", this.hintId);
        this.addCell(aeList, ACTION_EVALUATION, "classification", this.classification);
        return Collections.unmodifiableList(aeList).iterator();
    }

    private boolean addCell(ArrayList<ContentCell> aeList, String fieldType, String property, String content) {
        if (content == null) {
            return false;
        }
        ContentCell cell = this.makeCell(fieldType, property, content);
        aeList.add(cell);
        return true;
    }

    private ContentCell makeCell(String fieldType, String property, String content) {
        ContentCell.ContentCellBuilder builder = new ContentCell.ContentCellBuilder();
        builder.fieldType(fieldType).propertyName(property).content(content).formatter(new AEColumnFormatter());
        return builder.buildCell();
    }

    public String getEvaluation() {
        return this.evaluation;
    }

    public String getHintNum() {
        return this.current_hint_number;
    }

    public String getTotalHints() {
        return this.total_hints_available;
    }

    public String getHintId() {
        return this.hintId;
    }

    public String getClassification() {
        return this.classification;
    }

    public static class AEComparator
    implements Comparator<ContentCell> {
        @Override
        public int compare(ContentCell cell1, ContentCell cell2) {
            if (!cell1.getFieldType().equals(ActionEvaluationContent.ACTION_EVALUATION) || !cell2.getFieldType().equals(ActionEvaluationContent.ACTION_EVALUATION)) {
                throw new ClassCastException("Must compare two action_evaluation cells");
            }
            List<String> indicies = Collections.unmodifiableList(Arrays.asList("evaluation", "current_hint_number", "total_hints_available", "hintId", "classification"));
            int index1 = indicies.indexOf(cell1.getPropertyName());
            int index2 = indicies.indexOf(cell2.getPropertyName());
            return index1 - index2;
        }
    }

    static class AEColumnFormatter
    implements ColumnFormatter {
        AEColumnFormatter() {
        }

        @Override
        public String makeColumnName(String fieldType, int index, String propertyName) {
            return fieldType + " " + propertyName;
        }
    }
}

