/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Log.LogDifferences.Content;

import edu.cmu.pact.Log.LogDifferences.Content.ColumnFormatter;
import edu.cmu.pact.Log.LogDifferences.Content.Content;
import edu.cmu.pact.Log.LogDifferences.Content.ContentCell;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class CustomContent
implements Content {
    private static final String CUSTOM_FIELD = "custom_field";
    private final int index;
    private final String name;
    private final String value;

    public CustomContent(int index, String name, String value) {
        this.index = index;
        this.name = name;
        this.value = value;
    }

    @Override
    public Iterator<ContentCell> iterator() {
        if (this.name == null || this.value == null) {
            return Collections.emptyList().iterator();
        }
        ContentCell customCell = new ContentCell.ContentCellBuilder().fieldType(CUSTOM_FIELD).index(this.index).propertyName(this.name).content(this.value).formatter(new AlphabetizedCustomColumnFormatter(this.name)).buildCell();
        ArrayList<ContentCell> customList = new ArrayList<ContentCell>();
        customList.add(customCell);
        return Collections.unmodifiableList(customList).iterator();
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public static class AlphabetizedCustomComparator
    implements Comparator<ContentCell> {
        @Override
        public int compare(ContentCell cell1, ContentCell cell2) {
            if (!cell1.getFieldType().equals(CustomContent.CUSTOM_FIELD) || !cell2.getFieldType().equals(CustomContent.CUSTOM_FIELD)) {
                throw new ClassCastException("Must compare two custom_field cells");
            }
            return cell1.getColumnName().compareTo(cell2.getColumnName());
        }
    }

    static class AlphabetizedCustomColumnFormatter
    implements ColumnFormatter {
        String customName;

        public AlphabetizedCustomColumnFormatter(String customName) {
            this.customName = customName;
        }

        @Override
        public String makeColumnName(String fieldType, int index, String propertyName) {
            if (this.customName == null) {
                throw new IllegalStateException();
            }
            return fieldType + " " + this.customName;
        }
    }
}

