/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Log.LogDifferences.Content;

import edu.cmu.pact.Log.LogDifferences.Content.ColumnFormatter;
import edu.cmu.pact.Log.LogDifferences.Content.Content;
import edu.cmu.pact.Log.LogDifferences.Content.ContentCell;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class SAIContent
implements Content {
    private ArrayList<String> selection = new ArrayList();
    private ArrayList<String> action = new ArrayList();
    private ArrayList<String> input = new ArrayList();

    @Override
    public Iterator<ContentCell> iterator() {
        ArrayList<ContentCell> saiList = new ArrayList<ContentCell>();
        saiList.addAll(this.stringListToContentCellList(this.selection, "selection"));
        saiList.addAll(this.stringListToContentCellList(this.action, "action"));
        saiList.addAll(this.stringListToContentCellList(this.input, "input"));
        return Collections.unmodifiableList(saiList).iterator();
    }

    private ArrayList<ContentCell> stringListToContentCellList(ArrayList<String> stringList, String fieldType) {
        ArrayList<ContentCell> contentCellList = new ArrayList<ContentCell>();
        for (int i = 0; i < stringList.size(); ++i) {
            String content = stringList.get(i);
            ContentCell cell = new ContentCell.ContentCellBuilder().fieldType(fieldType).index(i).content(content).formatter(new SAIColumnFormatter()).buildCell();
            contentCellList.add(cell);
        }
        return contentCellList;
    }

    public void addOneSAI(String name, String value) {
        if (name.equals("selection")) {
            this.addSelection(value);
        } else if (name.equals("action")) {
            this.addAction(value);
        } else if (name.equals("input")) {
            this.addInput(value);
        }
    }

    public ArrayList<String> getSelection() {
        return this.selection;
    }

    public void addSelection(String selection) {
        this.getSelection().add(selection);
    }

    public ArrayList<String> getAction() {
        return this.action;
    }

    public void addAction(String action) {
        this.getAction().add(action);
    }

    public ArrayList<String> getInput() {
        return this.input;
    }

    public void addInput(String input) {
        this.getInput().add(input);
    }

    public static class SAIComparator
    implements Comparator<ContentCell> {
        @Override
        public int compare(ContentCell cell1, ContentCell cell2) {
            int type2;
            if (!(cell1.getFieldType().equals("selection") || cell1.getFieldType().equals("action") || cell1.getFieldType().equals("input"))) {
                throw new ClassCastException("First cell is not an SAI");
            }
            if (!(cell2.getFieldType().equals("selection") || cell2.getFieldType().equals("action") || cell2.getFieldType().equals("input"))) {
                throw new ClassCastException("Second cell is not an SAI");
            }
            List<String> type = Collections.unmodifiableList(Arrays.asList("selection", "action", "input"));
            int type1 = type.indexOf(cell1.getFieldType());
            if (type1 != (type2 = type.indexOf(cell2.getFieldType()))) {
                return type1 - type2;
            }
            return cell1.getIndex() - cell2.getIndex();
        }
    }

    static class SAIColumnFormatter
    implements ColumnFormatter {
        SAIColumnFormatter() {
        }

        @Override
        public String makeColumnName(String fieldType, int index, String propertyName) {
            return fieldType + index;
        }
    }
}

