/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Log;

import edu.cmu.pact.Utilities.EventLogger;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.jess.MTRete;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import jess.Deffacts;
import jess.Deffunction;
import jess.Defglobal;
import jess.Defquery;
import jess.Defrule;
import jess.Deftemplate;
import jess.Fact;
import jess.HasLHS;
import jess.JessException;
import jess.Named;
import jess.PrettyPrinter;
import jess.Rete;
import jess.Value;
import jess.Visitable;

public class LogReteChanges {
    private EventLogger eventLogger = null;
    private PrettyPrinter pp = new PrettyPrinter((Visitable)new Defglobal("", new Value(true)));
    private MTRete oldRete;
    private MTRete newRete;

    public LogReteChanges(EventLogger el, MTRete oldRete, MTRete newRete) {
        this.eventLogger = el;
        this.oldRete = oldRete;
        this.newRete = newRete;
    }

    public void logReteChanges() {
        this.logDefruleChanges();
        this.logDeftemplateChanges();
        this.logDeffactsChanges();
        this.logDefglobalChanges();
        this.logDeffunctionChanges();
        this.logFactChanges();
    }

    void logDefglobalChanges() {
        Defglobal dg;
        Iterator iter = this.newRete.listDefglobals();
        while (iter.hasNext()) {
            dg = (Defglobal)iter.next();
            if (this.oldRete.findDefglobal(dg.getName()) == null) {
                this.logAddedConstruct((Named)dg);
                continue;
            }
            Defglobal oldDg = this.oldRete.findDefglobal(dg.getName());
            if (this.pp.visitDefglobal(dg).equals(this.pp.visitDefglobal(oldDg))) continue;
            this.logChangedConstruct((Named)dg, (Named)oldDg);
        }
        iter = this.oldRete.listDefglobals();
        while (iter.hasNext()) {
            dg = (Defglobal)iter.next();
            if (dg.getName().equals("*sSelection*") || dg.getName().equals("*sAction*") || dg.getName().equals("*sInput*") || this.newRete.findDefglobal(dg.getName()) != null) continue;
            this.logDeletedConstruct((Named)dg);
        }
    }

    String prettyPrint(Named con) {
        if (con instanceof Defrule) {
            return (String)this.pp.visitDefrule((Defrule)con);
        }
        if (con instanceof Deftemplate) {
            return (String)this.pp.visitDeftemplate((Deftemplate)con);
        }
        if (con instanceof Deffunction) {
            return (String)this.pp.visitDeffunction((Deffunction)con);
        }
        if (con instanceof Deffacts) {
            return (String)this.pp.visitDeffacts((Deffacts)con);
        }
        if (con instanceof Defglobal) {
            return (String)this.pp.visitDefglobal((Defglobal)con);
        }
        return null;
    }

    void logDeletedConstruct(Named con) {
        this.eventLogger.log(true, "EXTERNAL_EDITOR", "DELETE_" + con.getConstructType(), con.getName(), "", "");
    }

    void logChangedConstruct(Named newCon, Named oldCon) {
        this.eventLogger.log(true, "EXTERNAL_EDITOR", "EDIT_" + newCon.getConstructType(), newCon.getName(), this.prettyPrint(oldCon), this.prettyPrint(newCon));
    }

    void logAddedConstruct(Named con) {
        this.eventLogger.log(true, "EXTERNAL_EDITOR", "ADD_" + con.getConstructType(), con.getName(), this.prettyPrint(con), "");
    }

    void logDeffunctionChanges() {
        Deffunction df;
        Object ob;
        Iterator iter = this.newRete.listFunctions();
        while (iter.hasNext()) {
            ob = iter.next();
            if (!(ob instanceof Deffunction)) continue;
            df = (Deffunction)ob;
            if (this.oldRete.findUserfunction(df.getName()) == null) {
                this.logAddedConstruct((Named)df);
                continue;
            }
            Deffunction oldDf = (Deffunction)this.oldRete.findUserfunction(df.getName());
            if (this.pp.visitDeffunction(df).equals(this.pp.visitDeffunction(oldDf))) continue;
            this.logChangedConstruct((Named)df, (Named)oldDf);
        }
        iter = this.oldRete.listFunctions();
        while (iter.hasNext()) {
            ob = iter.next();
            if (!(ob instanceof Deffunction) || this.newRete.findUserfunction((df = (Deffunction)ob).getName()) != null) continue;
            this.logDeletedConstruct((Named)df);
        }
    }

    void logDeffactsChanges() {
        Deffacts df;
        Iterator iter = this.newRete.listDeffacts();
        while (iter.hasNext()) {
            df = (Deffacts)iter.next();
            if (this.oldRete.findDeffacts(df.getName()) == null) {
                this.logAddedConstruct((Named)df);
                continue;
            }
            Deffacts oldDf = this.oldRete.findDeffacts(df.getName());
            if (this.pp.visitDeffacts(df).equals(this.pp.visitDeffacts(oldDf))) continue;
            this.logChangedConstruct((Named)df, (Named)oldDf);
        }
        iter = this.oldRete.listDeffacts();
        while (iter.hasNext()) {
            df = (Deffacts)iter.next();
            if (this.newRete.findDeffacts(df.getName()) != null) continue;
            this.logDeletedConstruct((Named)df);
        }
    }

    private Set getFactsSet(String label, Rete rete) {
        LinkedHashSet<Fact> set = new LinkedHashSet<Fact>();
        Iterator iter = rete.listFacts();
        while (iter.hasNext()) {
            Fact f = (Fact)iter.next();
            Integer id = new Integer(f.getFactId());
            set.add(f);
        }
        return set;
    }

    void logFactChanges() {
        try {
            Fact f;
            Iterator iter = this.oldRete.listFacts();
            while (iter.hasNext()) {
                f = (Fact)iter.next();
                if (this.newRete.findFactByFact(f) != null) continue;
                this.logDeletedFact(f);
            }
            iter = this.newRete.listFacts();
            while (iter.hasNext()) {
                f = (Fact)iter.next();
                if (this.oldRete.findFactByFact(f) != null) continue;
                this.logAddedFact(f);
            }
        }
        catch (JessException je) {
            trace.err("Error finding facts for logFactChanges(): " + (Object)((Object)je) + (je.getCause() == null ? "" : ": " + je.getCause().toString()));
        }
    }

    private void logAddedFact(Fact f) {
        this.eventLogger.log(true, "EXTERNAL_EDITOR", "ADD_" + f.getConstructType(), f.getName(), f.toString(), "");
    }

    private void logDeletedFact(Fact f) {
        this.eventLogger.log(true, "EXTERNAL_EDITOR", "DELETE_" + f.getConstructType(), f.getName(), f.toString(), "");
    }

    void logDefruleChanges() {
        Iterator iter = this.newRete.listDefrules();
        Map<String, Defrule> oldRules = this.oldRete.allRulesMap();
        while (iter.hasNext()) {
            HasLHS dr = (HasLHS)iter.next();
            if (oldRules.containsKey(dr.getName())) {
                String newRulePP;
                HasLHS oldDr = (HasLHS)oldRules.get(dr.getName());
                String oldRulePP = oldDr instanceof Defquery ? ((String)this.pp.visitDefquery((Defquery)oldDr)).replaceAll("_blank_mf\\d*", "") : ((String)this.pp.visitDefrule((Defrule)oldDr)).replaceAll("_blank_mf\\d*", "");
                if (oldRulePP.equals(newRulePP = dr instanceof Defquery ? ((String)this.pp.visitDefquery((Defquery)dr)).replaceAll("_blank_mf\\d*", "") : ((String)this.pp.visitDefrule((Defrule)dr)).replaceAll("_blank_mf\\d*", ""))) continue;
                this.logChangedConstruct((Named)dr, (Named)oldDr);
                continue;
            }
            this.logAddedConstruct((Named)dr);
        }
        Map<String, Defrule> newRules = this.newRete.allRulesMap();
        for (Defrule oldRule : oldRules.values()) {
            if (newRules.containsKey(oldRule.getName())) continue;
            this.logDeletedConstruct((Named)oldRule);
        }
    }

    void logDeftemplateChanges() {
        try {
            Deftemplate dt;
            Iterator iter = this.newRete.listDeftemplates();
            while (iter.hasNext()) {
                dt = (Deftemplate)iter.next();
                if (this.oldRete.findDeftemplate(dt.getName()) == null) {
                    this.logAddedConstruct((Named)dt);
                    continue;
                }
                Deftemplate oldDt = this.oldRete.findDeftemplate(dt.getName());
                String oldDtString = this.pp.visitDeftemplate(oldDt).toString().replaceAll(" extends MAIN::__fact", "");
                if (this.pp.visitDeftemplate(dt).equals(oldDtString)) continue;
                this.logChangedConstruct((Named)dt, (Named)oldDt);
            }
            iter = this.oldRete.listDeftemplates();
            while (iter.hasNext()) {
                dt = (Deftemplate)iter.next();
                if (this.newRete.findDeftemplate(dt.getName()) != null || dt.getName().equals("MAIN::studentValues")) continue;
                this.logDeletedConstruct((Named)dt);
            }
        }
        catch (JessException je) {
            je.printStackTrace();
        }
    }
}

