/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Log;

import edu.cmu.pact.Utilities.trace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class MergeFromSetPrefs {
    private int UTC_HH_Adjustment = 4;
    private int yyyy;
    private int mm;
    private int dd;
    private static DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static DateFormat dfz = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
    private static Map<String, SessionProblems> sessionsTbl = new TreeMap<String, SessionProblems>();
    private static final int ANON_STUDENT_ID2_COLUMN = 2;
    private static final int SESSION_COLUMN = 3;
    private static final int TIMESTAMP_COLUMN = 4;
    private static final int TZ_COLUMN = 5;
    private static final int UNIT_COLUMN = 10;
    private static final int SECTION_COLUMN = 11;
    private static final int PROBLEM_NAME_COLUMN = 12;
    private static final int ALL_REMAINING_COLUMN = 13;
    private static final int N_COLUMNS = 14;

    Date convToAdjUTCsecs(String time) {
        try {
            String[] hhmmss = time.split(":");
            int HH = Integer.parseInt(hhmmss[0]);
            int MM = Integer.parseInt(hhmmss[1]);
            int SS = Integer.parseInt(hhmmss[2]);
            if (HH < 0 || 23 < HH || MM < 0 || 59 < MM || SS < 0 || 60 < SS) {
                throw new Exception("HH " + HH + " or MM " + MM + " or SS " + SS + " out of range");
            }
            int dd2 = HH < 3 ? this.dd + 1 : this.dd;
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.printf("%04d-%02d-%02d %02d:%02d:%02d", this.yyyy, this.mm, dd2, HH, MM, SS);
            return df.parse(sw.toString());
        }
        catch (Exception e) {
            throw new RuntimeException("Bad time: date " + this.yyyy + "-" + this.mm + "-" + this.dd + ", time " + time + "; " + e);
        }
    }

    public MergeFromSetPrefs(String yyyymmdd) {
        this.yyyy = Integer.parseInt(yyyymmdd.substring(0, 4));
        this.mm = Integer.parseInt(yyyymmdd.substring(4, 6));
        this.dd = Integer.parseInt(yyyymmdd.substring(6, 8));
    }

    private int buildSetPrefsTbl(File inFile) throws Exception {
        SAXBuilder saxb = new SAXBuilder();
        Document doc = saxb.build(inFile);
        StringBuffer errs = new StringBuffer();
        int childNo = 0;
        for (Object child : doc.getRootElement().getChildren()) {
            Element msg = (Element)child;
            ++childNo;
            if (!"msg".equalsIgnoreCase(msg.getName())) {
                errs.append("Element ").append(childNo).append(" not a <msg>: ").append(msg.getName()).append("\n");
                continue;
            }
            String sessionId = msg.getChildText("session_id");
            String brdName = msg.getChildText("question_file");
            String problemName = msg.getChildText("problem_name");
            String time = msg.getChildText("time");
            SessionProblems oldSp = sessionsTbl.get(sessionId);
            if (oldSp != null) {
                oldSp.addProblem(brdName, problemName, time);
                continue;
            }
            sessionsTbl.put(sessionId, new SessionProblems(sessionId, brdName, problemName, time));
        }
        if (errs.length() > 0) {
            throw new RuntimeException(errs.toString());
        }
        for (String sess : sessionsTbl.keySet()) {
            trace.outNT("log", sessionsTbl.get(sess).toString() + "\n");
        }
        return childNo;
    }

    private static boolean isBrdWanted(String brdName) {
        if (brdName == null | brdName.length() < 1) {
            throw new IllegalArgumentException("isBrdWanted(): brdName null or empty");
        }
        return brdName.contains("/FractionStudy") || brdName.contains("/MartinaFract") || brdName.contains("/Tests");
    }

    public static void main(String[] args) {
        int nErrs = 0;
        for (String filename : args) {
            try {
                int yyyyPos = filename.indexOf("2009");
                String yyyymmdd = filename.substring(yyyyPos, yyyyPos + 8);
                MergeFromSetPrefs m = new MergeFromSetPrefs(yyyymmdd);
                int nSetPrefs = m.buildSetPrefsTbl(new File(filename));
                trace.outln("log", filename + "\t" + nSetPrefs);
            }
            catch (Exception e) {
                ++nErrs;
                trace.err("Error on " + filename + ": " + e + "; " + (e.getCause() == null ? "" : e.getCause()));
                e.printStackTrace();
            }
        }
        if (nErrs > 0) {
            System.exit(nErrs);
        }
        StreamTokenizer lineTkzr = new StreamTokenizer(new BufferedReader(new InputStreamReader(System.in)));
        lineTkzr.wordChars(0, 255);
        lineTkzr.whitespaceChars(10, 10);
        lineTkzr.whitespaceChars(13, 13);
        try {
            PrintStream writer = new PrintStream(new FileOutputStream(new File("out.txt")));
            if (-1 != lineTkzr.nextToken()) {
                MergeFromSetPrefs.convertHeader(lineTkzr.sval, writer);
            }
            int lineNo = 2;
            while (true) {
                if (-1 != lineTkzr.nextToken()) {
                    MergeFromSetPrefs.convertTransaction(lineNo, lineTkzr.sval, writer);
                    ++lineNo;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean convertHeader(String hdrLine, PrintStream writer) {
        String[] hdrs = hdrLine.split("\t", 14);
        if (hdrs == null) {
            return false;
        }
        for (int i = 0; i < hdrs.length - 1; ++i) {
            if (i == 10) {
                writer.append("Level(ProblemSet)");
            } else {
                if (i == 11) continue;
                writer.append(hdrs[i]);
            }
            writer.write(9);
        }
        writer.append(hdrs[hdrs.length - 1]);
        writer.append("\r\n");
        return true;
    }

    private static boolean convertTransaction(int lineNo, String transLine, PrintStream writer) {
        String[] fields = transLine.split("\t", 14);
        if (fields == null || fields.length < 14) {
            trace.err("line " + lineNo + ": too few fields:\n  " + transLine + "\n;");
            return false;
        }
        String sessionId = fields[3];
        String problemName = fields[12];
        String timeAndZone = fields[4] + " " + fields[5];
        Date timestamp = null;
        String brdFilename = null;
        String problemSet = null;
        try {
            String[] path;
            timestamp = dfz.parse(timeAndZone);
            brdFilename = MergeFromSetPrefs.lookupBrdName(sessionId, problemName, timestamp);
            if (brdFilename != null && (path = brdFilename.split("/")).length > 3) {
                problemSet = path[3];
            }
        }
        catch (ParseException pe) {
            trace.err("line " + lineNo + ": error parsing timestamp \"" + timestamp + "\": " + pe);
        }
        catch (RuntimeException re) {
            trace.err("line " + lineNo + ": " + re);
        }
        if (problemSet == null) {
            trace.err("line " + lineNo + " skipped; session " + sessionId + ", problemName " + problemName + ", " + dfz.format(timestamp) + ", brd " + brdFilename);
            return false;
        }
        for (int i = 0; i < fields.length - 1; ++i) {
            if (i == 10) {
                writer.append(problemSet);
            } else {
                if (i == 11) continue;
                writer.append(fields[i].length() < 1 ? " " : fields[i]);
            }
            writer.write(9);
        }
        writer.append(fields[fields.length - 1]);
        writer.append("\r\n");
        return true;
    }

    private static String lookupBrdName(String sessionId, String problemName, Date timestamp) {
        SessionProblems sp = sessionsTbl.get(sessionId);
        if (sp == null) {
            throw new RuntimeException("session not found in traces: " + sessionId);
        }
        String brdFilename = sp.getBrdFilename(problemName, timestamp);
        return brdFilename;
    }

    private class SessionProblems {
        private final String sessionId;
        private Map<String, ProblemName> brdNames = null;

        SessionProblems(String sessionId, String brdName, String problemName, String time) throws RuntimeException {
            if (sessionId == null | sessionId.length() < 1) {
                throw new IllegalArgumentException("sessionId null or empty on session");
            }
            this.sessionId = sessionId;
            this.brdNames = new LinkedHashMap<String, ProblemName>();
            this.addProblem(brdName, problemName, time);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(this.sessionId);
            sb.append(" [");
            for (String pn : this.brdNames.keySet()) {
                sb.append("\n ").append(this.brdNames.get(pn));
            }
            sb.append(" ]");
            return sb.toString();
        }

        int addProblem(String brdName, String problemName, String time) {
            if (brdName == null | brdName.length() < 1) {
                throw new IllegalArgumentException("brdName null or empty on session " + this.sessionId);
            }
            if (problemName == null | problemName.length() < 1) {
                throw new IllegalArgumentException("problemName null or empty on session " + this.sessionId);
            }
            ProblemName opn = this.brdNames.get(problemName);
            if (opn == null) {
                this.brdNames.put(problemName, new ProblemName(brdName, problemName, time));
            } else {
                opn.add(brdName, time);
            }
            return this.brdNames.size();
        }

        String getBrdFilename(String problemName, Date timestamp) {
            ProblemName pn = this.brdNames.get(problemName);
            if (pn == null) {
                throw new IllegalArgumentException("no problem found for session " + this.sessionId + ", problem " + problemName);
            }
            return pn.getBrdFilename(timestamp);
        }
    }

    private class ProblemName {
        private final LinkedList<BrdTimestamp> brdTimestamps;
        private final String problemName;
        private String brdName0 = null;

        ProblemName(String brdName, String problemName, String time) {
            if (brdName == null || brdName.length() < 1) {
                throw new IllegalArgumentException("brdName empty for problem_name " + problemName);
            }
            this.brdTimestamps = new LinkedList();
            this.brdTimestamps.add(new BrdTimestamp(time, brdName));
            this.brdName0 = brdName;
            this.problemName = problemName;
        }

        public String toString() {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.printf("%23s, %s", this.problemName, this.brdName0);
            for (BrdTimestamp bt : this.brdTimestamps) {
                pw.printf("\n %s", bt);
            }
            return sw.toString();
        }

        void add(String brdName, String time) {
            if (!brdName.equals(this.brdName0)) {
                this.brdName0 = null;
            }
            Date timestamp = MergeFromSetPrefs.this.convToAdjUTCsecs(time);
            ListIterator<BrdTimestamp> it = this.brdTimestamps.listIterator();
            while (it.hasNext()) {
                BrdTimestamp bt = (BrdTimestamp)it.next();
                if (bt.timestamp.compareTo(timestamp) <= 0) continue;
                it.previous();
                break;
            }
            it.add(new BrdTimestamp(brdName, timestamp));
        }

        String getBrdFilename(Date timestamp) {
            if (this.brdName0 != null) {
                return this.brdName0;
            }
            Iterator<BrdTimestamp> it = this.brdTimestamps.descendingIterator();
            while (it.hasNext()) {
                BrdTimestamp bt = it.next();
                if (bt.timestamp.compareTo(timestamp) > 0) continue;
                return bt.brdFilename;
            }
            throw new RuntimeException("no trace timestamp before " + timestamp + " for problem " + this.problemName);
        }
    }

    private class BrdTimestamp {
        private final Date timestamp;
        private final String brdFilename;

        BrdTimestamp(String time, String brdFilename) {
            this.timestamp = MergeFromSetPrefs.this.convToAdjUTCsecs(time);
            this.brdFilename = brdFilename;
        }

        public BrdTimestamp(String brdFilename, Date timestamp) {
            this.timestamp = timestamp;
            this.brdFilename = brdFilename;
        }

        public String toString() {
            return dfz.format(this.timestamp) + ", " + this.brdFilename;
        }
    }
}

