/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Log;

import edu.cmu.hcii.ctat.ExitableServer;
import edu.cmu.oli.log.client.ActionLog;
import edu.cmu.oli.log.client.DiskLogger;
import edu.cmu.oli.log.client.StreamLogger;
import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Controller.SingleSessionLauncher;
import edu.cmu.pact.Log.DataShopMessageObject;
import edu.cmu.pact.Log.DataShopReader;
import edu.cmu.pact.Log.ReplaySessionHolder;
import edu.cmu.pact.TutoringService.Monitor;
import edu.cmu.pact.TutoringService.ServiceRequest;
import edu.cmu.pact.TutoringService.SessionRequest;
import edu.cmu.pact.TutoringService.TSLauncherServer;
import edu.cmu.pact.TutoringService.TransactionInfo;
import edu.cmu.pact.Utilities.LoggingSupport;
import edu.cmu.pact.Utilities.NtpClient;
import edu.cmu.pact.Utilities.ProblemNameParser;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.model.ProblemSummary;
import edu.cmu.pslc.logging.ContextMessage;
import edu.cmu.pslc.logging.Message;
import edu.cmu.pslc.logging.ToolMessage;
import edu.cmu.pslc.logging.TutorMessage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import pact.CommWidgets.RemoteToolProxy;

public class ReplayLauncherServer
extends TSLauncherServer {
    public static final int DEFAULT_GC_FREQUENCY = 5;
    private final LinkedList<ReplaySessionHolder> replaySessionHolderList;
    private String logDir = null;
    private static Monitor ct = null;
    private static int commPort = 1503;
    private ExitableServer replayThread = null;
    private static int[] serialNoGenerator = new int[]{0};
    private static double speedFactor = 1.0;
    private static double maxWaitTime = -1.0;
    private static boolean saveMessages = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int nextSerialNo() {
        int[] nArray = serialNoGenerator;
        synchronized (serialNoGenerator) {
            serialNoGenerator[0] = serialNoGenerator[0] + 1;
            // ** MonitorExit[var0] (shouldn't be in output)
            return serialNoGenerator[0];
        }
    }

    public ReplayLauncherServer(LinkedList<ReplaySessionHolder> sessionList, ExitableServer replayThread) {
        this.replaySessionHolderList = sessionList;
        this.replayThread = replayThread;
        if (ct == null && commPort > 0) {
            ct = new Monitor(commPort);
            ct.addRequestHandler("session", new SessionRequest(this));
            ct.addRequestHandler("service", new ServiceRequest(this));
            ct.setName("Monitor");
            ct.start();
        }
    }

    @Override
    public boolean isExiting() {
        return this.replayThread.isExiting();
    }

    @Override
    public boolean startExiting() {
        return this.replayThread.startExiting();
    }

    @Override
    public void shutdown() {
        this.startExiting();
        Utils.sleep(120000L);
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeSession(String guid) {
        TSLauncherServer.Session sess = null;
        String string = this.sessionsMutex;
        synchronized (string) {
            sess = (TSLauncherServer.Session)this.sessions.remove(guid);
        }
        return sess != null;
    }

    @Override
    public void updateTimeStamp(String guid) {
    }

    @Override
    public TransactionInfo.Single createTransactionInfo(String sessionId) {
        return null;
    }

    @Override
    public void updateTransactionInfo(String sessionId, Object info) {
    }

    @Override
    public NtpClient getNtpClient() {
        return null;
    }

    public ReplaySession addSession(String guid, ReplaySessionHolder rsh, int gcFrequency) {
        ReplaySession rs = new ReplaySession(guid, rsh, gcFrequency);
        this.addSession(rs);
        return rs;
    }

    public String getLogDir() {
        return this.logDir;
    }

    void setLogDir(String logDir) {
        this.logDir = logDir;
    }

    public void setSpeedFactor(double sf) {
        speedFactor = sf;
    }

    public void setMaxWaitTime(double mwt) {
        maxWaitTime = mwt;
    }

    public void setSaveMessages(boolean b) {
        saveMessages = b;
    }

    @Override
    public boolean isAuthorMode() {
        return false;
    }

    public class ReplaySession
    extends TSLauncherServer.Session {
        private String logSessionID;
        private ArrayList<DataShopMessageObject> replayMsgs;
        private ArrayList<TxRecord> txList;
        private ReplayToolProxy rtp;
        private volatile boolean quitting;
        private TxRecord currTx;
        private ReplaySessionHolder rsh;
        private int gcFrequency;
        private ReplayLoggingSupport logger;
        private int serialNo;
        public ArrayList<ArrayList<DataShopMessageObject>> replayList;
        public ArrayList<ArrayList<String>> replayUnits;
        public ProblemNameParser pnparse;
        private String datasetName;

        private ReplaySession(String guid, ReplaySessionHolder rsh, int gcFrequency) {
            super(ReplayLauncherServer.this, guid, null);
            this.quitting = false;
            this.gcFrequency = 5;
            this.serialNo = ReplayLauncherServer.nextSerialNo();
            this.datasetName = "DefaultDataSetName";
            this.rsh = rsh;
            this.gcFrequency = gcFrequency;
        }

        public void setLogSessionID(String s) {
            this.logSessionID = s;
        }

        public String getLogSessionID() {
            return this.logSessionID;
        }

        private boolean shouldRunGC() {
            return this.serialNo % this.gcFrequency == 0;
        }

        public void setup(MessageObject setPrefsMsg, ArrayList<DataShopMessageObject> replayMsgs) {
            if (trace.getDebugCode("replay")) {
                trace.out("replay", "RLS.RS.setup() to set setPrefs\n  " + setPrefsMsg + "\n  replayMsgs, count = " + replayMsgs.size());
            }
            this.setSetPreferencesMsg(setPrefsMsg);
            this.replayMsgs = replayMsgs;
            this.getSetPreferencesMsg().setTransactionInfo(this.txInfo.create());
        }

        @Override
        protected void setLoggingProperties(MessageObject setPrefsMsg) {
            this.logger = new ReplayLoggingSupport();
            super.setLoggingProperties(setPrefsMsg);
            this.logger.setSchoolName((String)setPrefsMsg.getProperty("school_name"));
            this.logger.setClassName((String)setPrefsMsg.getProperty("class_name"));
            this.logger.setDatasetName((String)setPrefsMsg.getProperty("dataset_name"));
            this.logger.addDatasetLevelName((String)setPrefsMsg.getProperty("dataset_level_name1"), 1);
            this.logger.addDatasetLevelType((String)setPrefsMsg.getProperty("dataset_level_type1"), 1);
            this.logger.addDatasetLevelName((String)setPrefsMsg.getProperty("dataset_level_name2"), 2);
            this.logger.addDatasetLevelType((String)setPrefsMsg.getProperty("dataset_level_type2"), 2);
            this.logger.setProblemName((String)setPrefsMsg.getProperty("problem_name"));
            this.logger.addStudyConditionName((String)setPrefsMsg.getProperty("study_condition_name1"), 1);
            this.logger.addStudyConditionType((String)setPrefsMsg.getProperty("study_condition_type1"), 1);
            this.logger.setSourceId((String)setPrefsMsg.getProperty("source_id"));
            this.logger.setSessionId((String)setPrefsMsg.getProperty("session_id"));
            this.logger.setStudentName((String)setPrefsMsg.getProperty("user_guid"), false);
        }

        private void initialize(int i) {
            if (i == 0) {
                if (trace.getDebugCode("replay")) {
                    trace.out("replay", "RLS.RS.initialize() before setupController()");
                }
                this.setupController(null);
            }
            if (trace.getDebugCode("replay")) {
                trace.out("replay", "RLS.RS.initialize() before setLoggingProperties()");
            }
            this.setLoggingProperties(this.getSetPreferencesMsg());
            this.rtp = new ReplayToolProxy(this.getController());
            this.getController().setUniversalToolProxy(this.rtp);
            if (trace.getDebugCode("replay")) {
                trace.out("replay", "RLS.RS.initialize() before processSetPreferences()");
            }
            this.processSetPreferences();
            this.setTimeStamp(new Date());
        }

        @Override
        protected void createLauncher(BufferedReader br) {
            String[] argv = new String[]{"-Dguid=" + this.guid, "-DisOnline=true", "-DBehaviorRecorderMode=Example-tracing Tutor", "-DBehaviorRecorderVisible=false", "-debugCodes"};
            this.setLauncher(new SingleSessionLauncher(null, br, argv, false, ReplayLauncherServer.this, this.getSetPreferencesMsg(), null));
        }

        @Override
        public String toString() {
            return "RS " + this.serialNo + ": " + super.toString();
        }

        public MessageObject createSetPreferencesMsg(String userGuid, String problemName, String questionFile, String className, String schoolName, String sessionId, String sourceId, String datasetName, String datasetLevelName1, String datasetLevelType1, String datasetLevelName2, String datasetLevelType2, String studyConditionName1, String studyConditionType1) {
            MessageObject setPrefs = MessageObject.create("SetPreferences", "NotePropertySet");
            setPrefs.setProperty("user_guid", userGuid);
            setPrefs.setProperty("problem_name", problemName);
            setPrefs.setProperty("question_file", questionFile);
            setPrefs.setProperty("class_name", className);
            setPrefs.setProperty("school_name", schoolName);
            setPrefs.setProperty("session_id", sessionId);
            setPrefs.setProperty("source_id", sourceId);
            setPrefs.setProperty("dataset_name", datasetName);
            setPrefs.setProperty("dataset_level_name1", datasetLevelName1);
            setPrefs.setProperty("dataset_level_type1", datasetLevelType1);
            setPrefs.setProperty("dataset_level_name2", datasetLevelName2);
            setPrefs.setProperty("dataset_level_type2", datasetLevelType2);
            setPrefs.setProperty("study_condition_name1", studyConditionName1);
            setPrefs.setProperty("study_condition_type1", studyConditionType1);
            if (trace.getDebugCode("replay")) {
                trace.out("replay", "RLS.RS.createSetPreferences:\n" + setPrefs);
            }
            return setPrefs;
        }

        public void setParser(ProblemNameParser pnp) {
            this.pnparse = pnp;
        }

        public void setReplays(ArrayList<DataShopMessageObject> messages, ArrayList<ArrayList<String>> nameList) {
            this.replayList = new ArrayList();
            this.replayUnits = new ArrayList();
            ArrayList<Object> prevNames = new ArrayList();
            ArrayList<DataShopMessageObject> group = new ArrayList<DataShopMessageObject>();
            String currSid = "";
            String currUid = "";
            String currProbName = "";
            String currPS = "";
            String currAs = "";
            for (int i = 0; i < nameList.size(); ++i) {
                ArrayList<String> names = nameList.get(i);
                DataShopMessageObject obj = messages.get(i);
                String sid = names.get(0);
                String uid = names.get(1);
                String probName = names.get(4);
                String assign2 = names.get(2);
                String probSet = names.get(3);
                if (!(sid.equals(currSid) && uid.equals(currUid) && probName.equals(currProbName) && probSet.equals(currPS) && assign2.equals(currAs))) {
                    if (group.size() > 0) {
                        this.replayList.add(group);
                        this.replayUnits.add(prevNames);
                    }
                    group = new ArrayList();
                    prevNames = names;
                    currSid = sid;
                    currUid = uid;
                    currProbName = probName;
                    currPS = probSet;
                    currAs = assign2;
                }
                group.add(obj);
            }
            this.replayUnits.add(prevNames);
            this.replayList.add(group);
        }

        public void setDatasetName(String n) {
            this.datasetName = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String threadName = "";
            String fileName = "";
            if (saveMessages) {
                Thread t = Thread.currentThread();
                threadName = t.getName();
                String stdNum = threadName.substring(7, threadName.length());
                fileName = "messages/student_" + stdNum + ".xml";
                File f = new File(fileName);
                if (f.exists() && !f.isDirectory()) {
                    f.delete();
                }
                if (!f.exists()) {
                    try {
                        f.createNewFile();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (threadName.equals("Replay_0")) {
                    File dir = new File("messages");
                    for (File file : dir.listFiles()) {
                        file.delete();
                    }
                }
                try {
                    PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(fileName, true)));
                    BufferedReader br = new BufferedReader(new FileReader(fileName));
                    pw.write("<?xml version=\"1.0\" standalone=\"yes\"?>\n<messages>\n");
                    pw.flush();
                    pw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            for (int i = 0; i < this.replayList.size(); ++i) {
                PrintWriter pw;
                ArrayList<String> replayUnit = this.replayUnits.get(i);
                ArrayList<DataShopMessageObject> replay = this.replayList.get(i);
                String problemName = replayUnit.get(4);
                String datasetLevelName1 = replayUnit.get(2);
                String datasetLevelName2 = replayUnit.get(3);
                ProblemNameParser.ProblemBundle brdSwf = this.pnparse.findBundle(problemName, datasetLevelName1, datasetLevelName2);
                if (trace.getDebugCode("replay")) {
                    trace.out("replay", "LCR.assignSessionToThread() [" + brdSwf + "] <= findBundle(" + datasetLevelName1 + ", " + datasetLevelName2 + ", " + problemName + ")");
                }
                if (brdSwf == null) {
                    return;
                }
                String userGuid = replayUnit.get(1);
                String logSessionID = replayUnit.get(0);
                this.setUserGuid(userGuid);
                this.setLogSessionID(logSessionID);
                MessageObject setPrefsMsg = this.createSetPreferencesMsg(userGuid, problemName, brdSwf.getBRD(), replayUnit.get(8), replayUnit.get(7), logSessionID, "CTAT_LOG_REPLAY", this.datasetName, replayUnit.get(2), DataShopReader.getDatasetLevelType(1), replayUnit.get(3), DataShopReader.getDatasetLevelType(2), replayUnit.get(9), replayUnit.get(10));
                this.setup(setPrefsMsg, replay);
                brdSwf = null;
                this.initialize(i);
                if (this.logger.getDiskLogger() == null) {
                    this.logger.createDiskLogger();
                }
                if (this.controller == null) {
                    throw new IllegalStateException("RLS.RS: null controller at start of thread execution");
                }
                this.txList = new ArrayList();
                String guid = this.getGuid();
                long previousTime = -1L;
                if (saveMessages) {
                    try {
                        ContextMessage con = this.logger.getContextMessage();
                        String cm = con.toString().replaceAll("\n", "");
                        cm = cm.replaceAll("\t", "");
                        PrintWriter pw2 = new PrintWriter(new BufferedWriter(new FileWriter(fileName, true)));
                        pw2.append(cm + '\n');
                        pw2.flush();
                        pw2.close();
                        System.out.println(cm);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                for (int currentMsgIndex = 0; !this.quitting && currentMsgIndex < this.replayMsgs.size(); ++currentMsgIndex) {
                    DataShopMessageObject mo = this.replayMsgs.get(currentMsgIndex);
                    this.currTx = new TxRecord(mo, currentMsgIndex);
                    this.txList.add(this.currTx);
                    previousTime = this.studentSpeed(mo, previousTime);
                    try {
                        String msgType;
                        if (trace.getDebugCode("replay")) {
                            trace.outNT("replay", "RLS.RS.run() before handleCommMessage() " + this.currTx);
                        }
                        if (trace.getDebugCode("tsltsp")) {
                            trace.out("tsltsp", this.getGuid() + " " + mo + "\n");
                        }
                        if (saveMessages) {
                            pw = new PrintWriter(new BufferedWriter(new FileWriter(fileName, true)));
                            BufferedReader br = new BufferedReader(new FileReader(fileName));
                            pw.append(mo.toString() + "\n");
                            pw.flush();
                            pw.close();
                        }
                        if ("InterfaceAction".equalsIgnoreCase(msgType = mo.getMessageType()) || "UntutoredAction".equalsIgnoreCase(msgType)) {
                            this.logger.oliLog(mo, false);
                        }
                        this.controller.handleCommMessage(mo);
                        if (this.controller.inTutoringServiceMode() && mo.getTransactionInfo() != null) {
                            mo.getTransactionInfo().update(Boolean.TRUE);
                        }
                        if (!trace.getDebugCode("replay")) continue;
                        trace.outNT("replay", "RLS.RS.run() after handleCommMessage() " + this.currTx);
                        continue;
                    }
                    catch (Throwable e) {
                        trace.errStack("Error in RS " + this + " processing replay message[" + currentMsgIndex + "]:\n  " + e + ";\n  cause: " + e.getCause() + "\n  " + mo, e);
                        break;
                    }
                }
                if (!saveMessages) continue;
                try {
                    ProblemSummary ps = this.controller.getProblemModel().getProblemSummary();
                    pw = new PrintWriter(new BufferedWriter(new FileWriter(fileName, true)));
                    pw.append(ps.toXML() + '\n');
                    pw.flush();
                    pw.close();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            LinkedList i = ReplayLauncherServer.this.replaySessionHolderList;
            synchronized (i) {
                if (this != this.rsh.getSession()) {
                    throw new IllegalStateException("RLS.RS.run(): session holder session (" + this.rsh.getSession() + ") is not me");
                }
                if (!ReplayLauncherServer.this.replaySessionHolderList.remove(this.rsh)) {
                    throw new IllegalStateException("RLS.RS.run(): replaySessionHolderList " + ReplayLauncherServer.this.replaySessionHolderList.hashCode() + "did not have me");
                }
                this.rsh.setSession(null);
                ReplayLauncherServer.this.replaySessionHolderList.addFirst(this.rsh);
                this.clearFields();
                ReplayLauncherServer.this.replaySessionHolderList.notifyAll();
            }
            if (trace.getDebugCode("replay")) {
                trace.out("replay", "RLS.RS.run() finishing guid " + this.guid + ", serialNo " + this.serialNo + ", " + (this.shouldRunGC() ? " " : " not") + " to run GC");
            }
            if (this.shouldRunGC() && trace.getDebugCode("replay")) {
                trace.out("replay", "RLS.RS.run() finished guid " + this.guid + " after GC");
            }
            if (saveMessages) {
                try {
                    PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(fileName, true)));
                    pw.append("</messages>");
                    pw.flush();
                    pw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        private long studentSpeed(DataShopMessageObject mo, long previousTime) {
            String[] toks = ((String)mo.getProperty("Time")).split("\\s+");
            String timeInFormat = toks[0] + " " + toks[1];
            Timestamp t = Timestamp.valueOf(timeInFormat);
            long currTime = t.getTime();
            double waitTime = previousTime < 0L || maxWaitTime == 0.0 ? 0.0 : (double)(currTime - previousTime);
            previousTime = currTime;
            waitTime = speedFactor > 0.0 ? (waitTime /= speedFactor) : 0.0;
            if (waitTime > maxWaitTime * 1000.0 && maxWaitTime > 0.0) {
                waitTime = maxWaitTime * 1000.0;
            }
            if (waitTime > 0.0) {
                try {
                    Thread.sleep((long)waitTime);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            return previousTime;
        }

        @Override
        protected void clearFields() {
            this.currTx = null;
            this.logger = null;
            this.logSessionID = null;
            this.replayMsgs = null;
            this.rsh = null;
            this.rtp = null;
            this.txList = null;
            super.clearFields();
        }

        public ArrayList<DataShopMessageObject> getReplayMsgs() {
            return this.replayMsgs;
        }

        public void requestQuit() {
            if (trace.getDebugCode("replay")) {
                trace.out("replay", "Quit requested");
            }
            this.quitting = true;
        }

        private class TxRecord {
            int serialNo = -1;
            MessageObject reqMsg;
            ArrayList<MessageObject> respMsgs;

            TxRecord(MessageObject reqMsg, int serialNo) {
                if (reqMsg == null) {
                    throw new NullPointerException("null request msg to RLS.RS.TxRecord constructor");
                }
                this.reqMsg = reqMsg;
                this.serialNo = serialNo;
            }

            public String getTransactionId() {
                return this.reqMsg.getTransactionId();
            }

            int addRespMsg(MessageObject mo) {
                if (this.respMsgs == null) {
                    this.respMsgs = new ArrayList();
                }
                this.respMsgs.add(mo);
                return this.respMsgs.size();
            }

            public String toString() {
                StringBuilder sb = new StringBuilder("{");
                sb.append(" tx[").append(this.serialNo).append("] ").append(this.getTransactionId());
                sb.append("\n  ").append(this.reqMsg);
                if (this.respMsgs != null) {
                    for (MessageObject mo : this.respMsgs) {
                        sb.append("\n  ").append(mo);
                    }
                }
                return sb.append("\n}").toString();
            }
        }

        public class ReplayToolProxy
        extends RemoteToolProxy {
            private int startStateMsgCount = 0;
            private boolean startStateEnded = false;

            ReplayToolProxy(BR_Controller ctlr) {
                this.setController(ctlr);
            }

            @Override
            protected Object getSocket() {
                return null;
            }

            @Override
            protected void sendXMLString(String msgStr) {
                if (trace.getDebugCode("tsltstp")) {
                    trace.out("tsltstp", ReplaySession.this.getGuid() + " " + msgStr + "\n");
                }
            }

            @Override
            protected String createMessageString(MessageObject mo, boolean pssOverride) {
                String msgType;
                if (trace.getDebugCode("replay")) {
                    trace.out("replay", "RLS.RS.rtp.createMessageString() diskLogger " + ReplaySession.this.logger.getDiskLogger() + ", mo\n  " + mo);
                }
                if (ReplaySession.this.logger.getDiskLogger() == null) {
                    ReplaySession.this.logger.createDiskLogger();
                }
                if ("StartProblem".equalsIgnoreCase(msgType = mo.getMessageType())) {
                    ReplaySession.this.logger.oliLog(mo, false);
                } else if (this.startStateEnded && "AssociatedRules".equalsIgnoreCase(msgType)) {
                    if (trace.getDebugCode("replay")) {
                        trace.out("replay", "custom_fields " + mo.getProperty("custom_fields"));
                    }
                    ReplaySession.this.logger.oliLog(mo, true);
                } else if (this.startStateEnded && ("InterfaceAction".equalsIgnoreCase(msgType) || "UntutoredAction".equalsIgnoreCase(msgType))) {
                    ReplaySession.this.logger.oliLog(mo, false);
                }
                if ("StartStateEnd".equalsIgnoreCase(msgType) || "ProblemRestoreEnd".equalsIgnoreCase(msgType)) {
                    ++this.startStateMsgCount;
                    if (trace.getDebugCode("replay")) {
                        trace.out("replay", "RLS.RS.rtp.createMessageString() at StartStateEnd; startStateMsgCount " + this.startStateMsgCount);
                    }
                    this.startStateEnded = true;
                } else if (!this.startStateEnded) {
                    ++this.startStateMsgCount;
                } else {
                    if (trace.getDebugCode("replay")) {
                        trace.out("replay", "RLS.RS.rtp.createMessageString() currTx id" + ReplaySession.this.currTx.getTransactionId() + ", msg tx id " + mo.getTransactionId());
                    }
                    ReplaySession.this.currTx.addRespMsg(mo);
                    if (trace.getDebugCode("replay")) {
                        trace.out("replay", "RLS.RS.rtp.createMessageString() currTx " + ReplaySession.this.currTx);
                    }
                }
                return mo.toString();
            }
        }

        public class ReplayLoggingSupport
        extends LoggingSupport {
            private DiskLogger diskLogger;

            public ReplayLoggingSupport() {
                super(null);
            }

            @Override
            public boolean useOLILogging() {
                return this.getOLILogger() != null;
            }

            @Override
            public boolean diskLoggingSetup() {
                return this.getDiskLogger() != null;
            }

            @Override
            public DiskLogger getDiskLogger() {
                return this.diskLogger;
            }

            @Override
            public StreamLogger getOLILogger() {
                return this.streamLogger;
            }

            @Override
            public boolean oliLog(ActionLog alog) {
                if (trace.getDebugCode("log")) {
                    trace.printStack("log", "oliLog(ActionLog): enableLog=" + this.enableLog + ", action log = " + alog);
                }
                if (!this.enableLog) {
                    return false;
                }
                if (alog == null) {
                    return false;
                }
                alog.setUserGuid("x");
                alog.setSessionId(ReplaySession.this.getLogSessionID());
                alog.setAuthToken("");
                if (trace.getDebugCode("log")) {
                    trace.out("log", "oliLog(ActionLog) after setting more data:" + alog);
                }
                return this.oliLogInternal(alog);
            }

            public void createDiskLogger() {
                this.diskLogger = new DiskLogger();
                ReplaySession.this.logger.getDiskLogger().setOutfile(ReplayLauncherServer.this.getLogDir() + File.separator + ReplaySession.this.guid + "_" + System.currentTimeMillis() + ".log");
            }

            @Override
            protected void addOriginalIds(String transactionId, String studentId, Message tm) {
                if (tm instanceof ToolMessage) {
                    ((ToolMessage)tm).addCustomField("orig_trans_id", transactionId);
                    ((ToolMessage)tm).addCustomField("orig_stu_id", studentId);
                } else if (tm instanceof TutorMessage) {
                    ((TutorMessage)tm).addCustomField("orig_trans_id", transactionId);
                    ((TutorMessage)tm).addCustomField("orig_stu_id", studentId);
                }
            }

            @Override
            protected void addOriginalTime(MessageObject o, ToolMessage tm) {
                Object origTimeStr = o.getProperty("Time");
                if (trace.getDebugCode("replay")) {
                    trace.out("replay", "adjustTime() found origTimeStr " + origTimeStr);
                }
                if (origTimeStr == null) {
                    origTimeStr = "";
                }
                tm.addCustomField("orig_time", origTimeStr.toString());
            }
        }
    }
}

