/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Log;

import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Transaction {
    private String requestText;
    private MessageObject mo = null;
    public List<String> responses = null;
    private boolean responseComplete = false;
    private boolean correctTransaction = false;
    private final String key;
    private final boolean startProblem;
    private boolean cancelled = false;
    private Date sendTime;
    private long duration = -1L;
    private static final String[] pseudoTransactions = new String[]{"VersionInfo", "StartStateEnd", "ProblemSummaryResponse"};
    private static Set<String> pseudoTransactionSet = new HashSet<String>(Arrays.asList(pseudoTransactions));

    public Transaction(String request, boolean newTransId) {
        this.requestText = request;
        this.mo = MessageObject.parse(request);
        if (newTransId) {
            if (this.mo.getTransactionId() != null) {
                Transaction transaction = this;
                this.mo.setTransactionId(transaction.mo.makeTransactionId());
            }
            this.requestText = null;
        }
        this.startProblem = "SetPreferences".equalsIgnoreCase(this.mo.getMessageType());
        this.key = Transaction.getKey(this.mo);
    }

    private synchronized void cancel() {
        this.cancelled = true;
        this.notifyAll();
    }

    public synchronized void addResponse(String msg) {
        if (this.responses == null) {
            this.responses = new ArrayList<String>();
        }
        this.responses.add(msg);
        if (this.checkWhetherComplete()) {
            this.notifyAll();
        }
    }

    private boolean checkWhetherComplete() {
        String msg = this.responses.get(this.responses.size() - 1);
        MessageObject mo = MessageObject.parse(msg);
        String msgType = mo.getMessageType();
        if (pseudoTransactionSet.contains(msgType)) {
            this.responseComplete = true;
        } else {
            if ("InCorrectAction".equalsIgnoreCase(msgType)) {
                this.correctTransaction = false;
            } else if ("CorrectAction".equalsIgnoreCase(msgType)) {
                this.correctTransaction = true;
            }
            Object endOfTransaction = mo.getProperty("end_of_transaction");
            this.responseComplete = endOfTransaction instanceof Boolean ? (Boolean)endOfTransaction : (endOfTransaction != null ? Boolean.parseBoolean(endOfTransaction.toString()) : false);
        }
        trace.out("sp", "checkWhetherComplete() msgType " + msgType + " rtns " + this.responseComplete + ":\n" + msg);
        return this.responseComplete;
    }

    public static String getKey(String msg) {
        MessageObject mo = MessageObject.parse(msg);
        return Transaction.getKey(mo);
    }

    public static String getKey(MessageObject mo) {
        String msgType = mo.getMessageType();
        if ("SetPreferences".equalsIgnoreCase(msgType)) {
            return (String)mo.getProperty("ProblemName");
        }
        if (msgType.startsWith("ProblemSummary")) {
            return "ProblemSummary";
        }
        return mo.getTransactionId();
    }

    public String getKey() {
        return this.key;
    }

    public int getNumResponses() {
        return this.responses == null ? 0 : this.responses.size();
    }

    public boolean isResponseComplete() {
        return this.responseComplete || this.cancelled;
    }

    public boolean isResponseCorrect() {
        return this.correctTransaction;
    }

    public boolean isStartProblem() {
        return this.startProblem;
    }

    public String toString() {
        return "[Transaction key " + this.getKey() + ", startProblem " + this.isStartProblem() + ", nResponses " + (this.responses == null ? 0 : this.responses.size()) + ", responseComplete " + this.isResponseComplete() + ", responseCorrect " + this.isResponseCorrect() + "]";
    }

    public String getRequestText() {
        if (this.requestText == null) {
            this.requestText = this.mo.toString();
        }
        return this.requestText;
    }

    public String getMessageType() {
        return this.mo.getMessageType();
    }

    public boolean hasNoResponse() {
        return "InterfaceIdentification".equalsIgnoreCase(this.getMessageType());
    }

    public void setSessionId(String sessionId) {
        if ("InterfaceIdentification".equalsIgnoreCase(this.getMessageType())) {
            this.mo.setProperty("Guid", sessionId);
        } else if (this.mo.getProperty("session_id") != null) {
            this.mo.setProperty("session_id", sessionId);
        } else {
            return;
        }
        this.requestText = null;
    }

    public void setSendTime(Date date) {
        this.sendTime = date;
        if (this.hasNoResponse()) {
            this.duration = -1L;
        }
    }

    public Date getSendTime() {
        return this.sendTime;
    }

    public void setReceiveTime(long currentTimeMillis) {
        if (this.sendTime != null) {
            this.duration = currentTimeMillis - this.sendTime.getTime();
        }
    }

    public long getDuration() {
        return this.duration;
    }

    public static class TransactionSet {
        private Map map = new LinkedHashMap();
        private Transaction latestStartProblemTransaction;

        public synchronized void add(Transaction tx) {
            this.map.put(tx.getKey(), tx);
            this.latestStartProblemTransaction = tx.isStartProblem() ? tx : null;
            trace.out("sp", "TransactionSet.add() key " + tx.getKey());
        }

        public Transaction get(String key) {
            return (Transaction)this.map.get(key);
        }

        public synchronized void addResponse(String msg) {
            String key = Transaction.getKey(msg);
            Transaction tx = this.latestStartProblemTransaction != null ? this.latestStartProblemTransaction : this.get(key);
            trace.out("sp", "TransactionSet.addResponse() tx " + tx);
            if (tx != null) {
                tx.addResponse(msg);
            }
        }

        public synchronized void cancelIncompleteTransactions() {
            for (Transaction tx : this.map.values()) {
                if (tx == null || tx.isResponseComplete()) continue;
                tx.cancel();
            }
        }

        public synchronized boolean allTransactionsComplete() {
            boolean passed = true;
            for (Transaction tx : this.map.values()) {
                if (tx == null || tx.isResponseComplete()) continue;
                trace.out("ls", tx.toString());
                trace.out("sp", tx.toString());
                passed = false;
            }
            return passed;
        }

        public int getSize() {
            return this.map.size();
        }
    }
}

