/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.SocketProxy;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import java.util.LinkedList;
import pact.CommWidgets.UniversalToolProxy;

public class ActionHandler
extends LinkedList<MessageObject>
implements Runnable {
    private static final long serialVersionUID = 1L;
    private final BR_Controller controller;
    private UniversalToolProxy forwardToClientProxy;

    public ActionHandler(BR_Controller controller) {
        this.controller = controller;
    }

    @Override
    public void run() {
        MessageObject mo = null;
        while (!(mo = this.dequeue()).isQuitMsg()) {
            if (trace.getDebugCode("sp")) {
                trace.out("sp", "\n" + Thread.currentThread().getName() + " dequeued:\n" + mo + "\n New Queue Length: " + this.size() + "\n");
            }
            try {
                this.forwardToClient(mo);
                if (this.controller == null) continue;
                this.controller.handleCommMessage(mo);
                if (!this.controller.inTutoringServiceMode() || mo.getTransactionInfo() == null) continue;
                mo.getTransactionInfo().update(!this.controller.getCtatModeModel().isRuleEngineTracing());
            }
            catch (Exception e) {
                System.err.println("Error processing external message");
                e.printStackTrace();
            }
        }
        this.controller.dispose();
    }

    protected void forwardToClient(MessageObject mo) {
    }

    public synchronized MessageObject dequeue() {
        while (this.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
        return (MessageObject)this.removeFirst();
    }

    public synchronized int enqueue(MessageObject mo) {
        this.addLast(mo);
        int result = this.size();
        this.notifyAll();
        return result;
    }

    void setForwardToClientProxy(UniversalToolProxy stp) {
        this.forwardToClientProxy = stp;
    }
}

