/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.SocketProxy;

import edu.cmu.hcii.ctat.CTATHTTPExchange;
import edu.cmu.hcii.ctat.ExitableServer;
import edu.cmu.pact.Log.LogInfo;
import edu.cmu.pact.Log.LogWriterForwarder;
import edu.cmu.pact.Preferences.PreferencesModel;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogServlet
extends LogWriterForwarder
implements ExitableServer {
    private static final long serialVersionUID = 201406031840L;
    public static final String ENABLE_LOG_SERVICE = "EnableLogService";
    public static final String ENABLE_LOG_FORWARDING = "EnableLogForwarding";
    private static SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy-MM-dd.HH.mm.ss.SSS");
    private static SimpleDateFormat respDateFmt = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
    private static Pattern HttpPostHeader = Pattern.compile("^POST \\S+ HTTP.*\\r?\\n\\r?\\n", 32);
    private PreferencesModel prefs = null;
    private MessageObject setPrefsMsg = null;
    private final boolean inTutoringServiceMode;
    private String baseFilename = null;
    private volatile boolean nowExiting = false;

    public LogServlet(PreferencesModel prefs, boolean inTutoringServiceMode) {
        this(prefs, null, inTutoringServiceMode, null);
    }

    public LogServlet(PreferencesModel prefs, MessageObject setPrefsMsg, boolean inTutoringServiceMode, String baseFilename) {
        this.prefs = prefs;
        this.setPrefsMsg = setPrefsMsg;
        this.inTutoringServiceMode = inTutoringServiceMode;
        this.baseFilename = "LogService-" + (baseFilename != null ? baseFilename : dateFmt.format(new Date()));
    }

    @Override
    protected synchronized String openLogFile() {
        Boolean enable = this.getBooleanPreference(ENABLE_LOG_SERVICE, null);
        String dirname = this.getPreference("Disk Logging Directory", "log_to_disk_directory");
        String filename = this.baseFilename + ".log";
        if (trace.getDebugCode("log")) {
            trace.printStack("log", "LogServlet.openLogFile(): enable " + enable + ", directory " + dirname + ", file " + filename);
        }
        this.errCount = 0;
        if (enable == null || !enable.booleanValue()) {
            this.close();
            return null;
        }
        try {
            this.logFile = new File(dirname, filename);
            this.writer = new BufferedWriter(new FileWriter(this.logFile, true));
            return null;
        }
        catch (Exception e) {
            String errMsg = "Error opening file " + filename + " in directory " + dirname + ": " + e;
            trace.errStack(errMsg, e);
            this.writer = null;
            this.logFile = null;
            return errMsg;
        }
    }

    private String getPreference(String prefName, String propName) {
        Object prop;
        String result = null;
        if (this.setPrefsMsg != null && (prop = this.setPrefsMsg.getProperty(propName == null ? prefName : propName)) != null) {
            result = prop.toString();
        }
        if (result == null && this.prefs != null) {
            result = this.prefs.getStringValue(prefName);
        }
        if (trace.getDebugCode("log")) {
            trace.out("log", "getPref(" + prefName + ", " + propName + ") => " + result);
        }
        return result;
    }

    private Boolean getBooleanPreference(String prefName, String propName) {
        Boolean result = null;
        if (this.setPrefsMsg != null) {
            result = this.setPrefsMsg.getPropertyAsBoolean(propName == null ? prefName : propName);
        }
        if (result == null && this.prefs != null) {
            result = this.prefs.getBooleanValue(prefName);
        }
        if (trace.getDebugCode("log")) {
            trace.out("log", "getBooleanPref(" + prefName + ", " + propName + ") => " + result);
        }
        return result;
    }

    protected boolean sendResponse(Socket sock, String response) {
        if (trace.getDebugCode("logservice")) {
            trace.out("logservice", "sendResponse(" + sock + "," + response + ")");
        }
        if (sock == null) {
            return false;
        }
        boolean result = false;
        try {
            PrintWriter pw = new PrintWriter(sock.getOutputStream());
            pw.write("HTTP/1.1 200 OK\r\n");
            pw.write("Date: " + respDateFmt.format(new Date()) + "\r\n");
            pw.write("Connection: close\r\n");
            pw.write("Server: CTATTutoringService\r\n");
            pw.write("Access-Control-Allow-Origin: *\r\n");
            pw.write("Content-Length: " + response.length() + "\r\n");
            pw.write("Content-Type: text/plain\r\n");
            pw.write("\r\n");
            pw.write(response);
            pw.flush();
            result = true;
        }
        catch (Exception e) {
            trace.errStack("Error writing HTTP response: " + e + "\n  Original response content:\n  " + response, e);
            result = false;
        }
        try {
            sock.close();
        }
        catch (Exception e) {
            trace.errStack("Error closing HTTP response socket: " + e + "\n  Original response content:\n  " + response, e);
        }
        if (trace.getDebugCode("logservice")) {
            trace.out("logservice", "sendResponse(): " + result);
        }
        return result;
    }

    @Override
    protected boolean canForward() {
        Boolean enableLogFwd = this.getBooleanPreference(ENABLE_LOG_FORWARDING, null);
        if (trace.getDebugCode("logservice")) {
            trace.out("logservice", "canForward() enable " + enableLogFwd);
        }
        if (enableLogFwd != null && !enableLogFwd.booleanValue()) {
            return false;
        }
        Boolean pref = this.getBooleanPreference("Use OLI Logging", "log_to_remote_server");
        if (trace.getDebugCode("logservice")) {
            trace.out("logservice", "canForward() tsMode " + this.inTutoringServiceMode + ", oli logging pref " + pref);
        }
        if (!this.inTutoringServiceMode && pref != null && !pref.booleanValue()) {
            return false;
        }
        this.setLogServerURL(this.getPreference("OLI Logging URL", "log_service_url"));
        if (trace.getDebugCode("logservice")) {
            trace.out("logservice", "canForward(" + this.logServerURL + ")");
        }
        if (this.logServerURL == null || this.logServerURL.length() < 1) {
            this.logInfo.incrementForwardLogErrors();
            return false;
        }
        return true;
    }

    public static void main(String[] args) throws IOException {
        InputStream in = args.length > 0 ? new FileInputStream(args[0]) : System.in;
        ByteArrayOutputStream stdin = new ByteArrayOutputStream();
        int c = -1;
        while (0 <= (c = in.read())) {
            stdin.write(c);
            c = -1;
        }
        boolean[] isHTTP = new boolean[1];
        String logMsg = LogServlet.extractLogRecord(stdin.toString(), isHTTP);
        System.out.println(logMsg);
    }

    public static String extractLogRecord(String msg, boolean[] isHTTP) {
        if (isHTTP != null) {
            isHTTP[0] = false;
        }
        if (msg == null) {
            return null;
        }
        int idx = 0;
        String start = msg.substring(idx).trim();
        if ("<quit/>".equals(start)) {
            return msg;
        }
        if (start.startsWith("<log_act") || start.startsWith("<log_ses")) {
            return msg;
        }
        for (int i = 0; i < 2; ++i) {
            if (trace.getDebugCode("logservice")) {
                trace.outNT("logservice", "HttpPostHeader msg[" + i + "] " + msg);
            }
            if (msg.startsWith("<?")) {
                idx = msg.indexOf("?>");
                if (idx < 0) {
                    return null;
                }
                idx += 2;
                break;
            }
            if (i >= 1) continue;
            Matcher m = HttpPostHeader.matcher(msg);
            boolean matched = m.find();
            if (isHTTP != null) {
                isHTTP[0] = matched;
            }
            if (trace.getDebugCode("logservice")) {
                trace.outNT("logservice", "HttpPostHeader matched " + matched + (matched ? " at [" + m.start() + "," + m.end() + "]" : ""));
            }
            if (!matched || 0 != m.start()) {
                return null;
            }
            msg = msg.substring(m.end());
        }
        start = msg.substring(idx).trim();
        if (trace.getDebugCode("logservice")) {
            trace.outNT("logservice", "stripped msg: " + start);
        }
        if (start.startsWith("<log_act") || start.startsWith("<log_ses")) {
            return msg;
        }
        return null;
    }

    @Override
    public void setLogInfo(LogInfo logInfo) {
        if (trace.getDebugCode("ls")) {
            trace.out("ls", "LogServlet setLogInfo: logInfo = " + logInfo);
        }
        this.logInfo = logInfo;
    }

    @Override
    public synchronized boolean isExiting() {
        return this.nowExiting;
    }

    @Override
    public synchronized boolean startExiting() {
        boolean result = this.nowExiting;
        this.nowExiting = true;
        if (trace.getDebugCode("ls")) {
            trace.out("ls", "LogServlet.startExiting() previous nowExiting " + result);
        }
        try {
            this.exit();
        }
        catch (Exception e) {
            trace.errStack("LogServlet.startExiting() error queuing quit msg " + e + ";\n  cause " + e.getCause(), e);
        }
        return result;
    }

    public static boolean handleLogRecord(String requestBody, CTATHTTPExchange exchange, LogServlet logServlet) throws Exception {
        String msg = LogServlet.extractLogRecord(requestBody == null ? exchange.getRequestBodyAsString() : requestBody, null);
        if (msg == null) {
            return false;
        }
        if (logServlet == null) {
            throw new IllegalStateException("<p>No LogServlet available for request <pre>" + msg + "</pre></p>");
        }
        String response = logServlet.logOrQueueAndReply(msg);
        exchange.writeBytesString(response, false);
        return true;
    }

    public static boolean handleLogRecord(String msg, LogServlet logServlet, Socket sock) {
        boolean[] isHTTP = new boolean[1];
        String msgSansHeader = LogServlet.extractLogRecord(msg, isHTTP);
        if (trace.getDebugCode("logservice")) {
            trace.outNT("logservice", "handleLogRecord() msgSansHeader = " + msgSansHeader + "\n\tmsg = " + msg + "\n\t\tsock =" + sock);
        }
        if (msgSansHeader == null) {
            return false;
        }
        if (!isHTTP[0] && System.getProperty("breakSocketLogging") != null) {
            return true;
        }
        if (logServlet == null) {
            throw new IllegalStateException("<p>No LogServlet available for request <pre>" + msg + "</pre></p>");
        }
        String response = logServlet.logOrQueueAndReply(msgSansHeader);
        if (!msg.equals(msgSansHeader)) {
            logServlet.sendResponse(sock, response);
        }
        return true;
    }

    @Override
    protected boolean shouldLog() {
        Boolean pref = null;
        return this.inTutoringServiceMode || (pref = this.getBooleanPreference("Use Disk Logging", "log_to_disk")) != null && pref != false;
    }
}

