/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.TutoringService;

import edu.cmu.pact.TutoringService.TransactionInfo;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import java.util.Date;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TransactionInfoTest
extends TestCase {
    private TransactionInfo txInfo = new TransactionInfo();
    private Problem[] problems = new Problem[]{new Problem("p1", 100, 200, 300), new Problem("p2", 500, 300), new Problem("p3", 100, 600, 300, 400, 200)};
    Session[] sessions = new Session[]{new Session("S1", this.problems), new Session("S2", this.problems), new Session("S3", this.problems), new Session("S4", this.problems)};

    public static Test suite() {
        return new TestSuite(TransactionInfoTest.class);
    }

    public void testProblemSessions() {
        int txCount = 0;
        long firstDuration = -1L;
        long maxDuration = -1L;
        long totalDuration = 0L;
        for (Problem p : this.problems) {
            txCount += p.times.length;
            for (int t : p.times) {
                if (firstDuration < 0L) {
                    firstDuration = t;
                }
                maxDuration = Math.max(maxDuration, (long)t);
                totalDuration += (long)t;
            }
        }
        totalDuration *= (long)this.sessions.length;
        Date earliestTxTime = new Date();
        for (Session sess : this.sessions) {
            sess.start();
        }
        for (Session sess : this.sessions) {
            try {
                sess.join(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        Date latestTxTime = new Date();
        Map<String, String> attrs = this.txInfo.toAttributes();
        for (String sessionId : attrs.keySet()) {
            System.out.printf("%-30s=\"%s\"\n", sessionId, attrs.get(sessionId));
        }
        TransactionInfoTest.assertTrue((String)"first tx start time", (earliestTxTime.getTime() <= this.txInfo.getFirst().getStartTime().getTime() && this.txInfo.getFirst().getStartTime().getTime() <= latestTxTime.getTime() ? 1 : 0) != 0);
        TransactionInfoTest.assertTrue((String)("first tx duration should be near " + firstDuration + ", was " + this.txInfo.getFirst().getDuration()), (firstDuration <= this.txInfo.getFirst().getDuration() && this.txInfo.getFirst().getDuration() < firstDuration + 100L ? 1 : 0) != 0);
        TransactionInfoTest.assertTrue((String)"longest tx start time", (earliestTxTime.getTime() <= this.txInfo.getLongest().getStartTime().getTime() && this.txInfo.getLongest().getStartTime().getTime() <= latestTxTime.getTime() ? 1 : 0) != 0);
        TransactionInfoTest.assertTrue((String)("longest tx duration should be near " + maxDuration + ", was " + this.txInfo.getLongest().getDuration()), (maxDuration <= this.txInfo.getLongest().getDuration() && this.txInfo.getLongest().getDuration() < maxDuration + 100L ? 1 : 0) != 0);
        TransactionInfoTest.assertTrue((String)("total duration should be near " + totalDuration + ", was " + this.txInfo.getTotalDuration()), (totalDuration <= this.txInfo.getTotalDuration() && this.txInfo.getTotalDuration() < totalDuration + 500L ? 1 : 0) != 0);
        TransactionInfoTest.assertEquals((String)"transactions started", (int)(this.sessions.length * txCount), (int)this.txInfo.getTransactionCount());
        TransactionInfoTest.assertEquals((String)"transactions completed", (int)(this.sessions.length * txCount), (int)this.txInfo.getTransactionCompletedCount());
        TransactionInfoTest.assertEquals((String)"problems started", (int)(this.sessions.length * this.problems.length), (int)this.txInfo.getProblemCount());
        TransactionInfoTest.assertEquals((String)"problems completed", (int)(this.sessions.length * this.problems.length), (int)this.txInfo.getProblemCompletedCount());
    }

    static {
        trace.addDebugCode("tx");
    }

    private class Session
    extends Thread {
        private String sessionId;
        private Problem[] problems;

        Session(String sessionId, Problem[] problems) {
            this.sessionId = sessionId;
            this.problems = problems;
        }

        @Override
        public void run() {
            for (Problem p : this.problems) {
                p.execute();
                if (trace.getDebugCode("tx")) {
                    trace.outNT("tx", "completed " + this.sessionId + ", " + p.problemName + ": " + TransactionInfoTest.this.txInfo.toAttributes());
                }
                Utils.sleep(100L);
            }
        }
    }

    private class Problem {
        private String problemName;
        private int[] times;

        Problem(String problemName, int ... times) {
            this.problemName = problemName;
            this.times = times;
        }

        public void execute() {
            TransactionInfoTest.this.txInfo.update(Boolean.FALSE);
            for (int i = 0; i < this.times.length; ++i) {
                TransactionInfo.Single txInfo0 = TransactionInfoTest.this.txInfo.create();
                Utils.sleep(this.times[i]);
                txInfo0.update(Boolean.TRUE);
                if (!trace.getDebugCode("tx")) continue;
                trace.outNT("tx", "problem " + this.problemName + "[" + i + "]: " + txInfo0.toAttributes());
            }
            TransactionInfoTest.this.txInfo.update(Boolean.TRUE);
        }
    }
}

