/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Utilities;

import edu.cmu.pact.Utilities.trace;
import java.util.Comparator;

public class VersionComparator
implements Comparator<String> {
    public static VersionComparator vc = new VersionComparator();

    @Override
    public int compare(String o1, String o2) {
        int i;
        if (o1 == null) {
            return o2 == null ? 0 : -1;
        }
        if (o2 == null) {
            return 1;
        }
        int result = 0;
        String[] a1 = o1.split("\\.");
        String[] a2 = o2.split("\\.");
        for (i = 0; i < Math.min(a1.length, a2.length); ++i) {
            try {
                Integer i1 = Integer.valueOf(a1[i]);
                Integer i2 = Integer.valueOf(a2[i]);
                result = i1.compareTo(i2);
                if (0 == result) continue;
                return result;
            }
            catch (NumberFormatException nfe) {
                trace.err("Version parse error at element " + i + " in \"" + o1 + "\" or \"" + o2 + "\": " + nfe);
                result = a1[i].compareTo(a2[i]);
                if (0 == result) continue;
                return result;
            }
        }
        if (i < a1.length) {
            return 1;
        }
        if (i < a2.length) {
            return -1;
        }
        return o1.compareTo(o2);
    }

    private VersionComparator() {
    }

    public static void main(String[] args) {
        if (args.length < 1 || args[0].toLowerCase().startsWith("-h")) {
            VersionComparator.usageExit(null);
        }
        if (args.length < 2) {
            VersionComparator.usageExit("At least 2 arguments are required.");
        }
        String v0 = null;
        int result = 0;
        for (int i = 0; i < args.length; ++i) {
            String vi = args[i];
            if (vi.equalsIgnoreCase("null")) {
                vi = null;
            }
            if (i == 0) {
                v0 = vi;
                continue;
            }
            int c = vc.compare(v0, vi);
            if (c != 0) {
                ++result;
            }
            System.out.printf("%12s %c %s\n", v0, Character.valueOf((char)(c == 0 ? 61 : (c < 0 ? 60 : 62))), vi);
        }
        System.exit(result);
    }

    private static void usageExit(String errMsg) {
        System.err.printf("%sUsage: java -cp ... %s v0 v1 ...\nwhere--\n  v0 is a string like 2.11.0 against which all others will be compared;\n  v1 ... are the other comparison strings.\nEnter null to compare a null value. Exit code is number of mismatches.\n", errMsg == null ? "" : errMsg + " ", VersionComparator.class.getName());
        System.exit(2);
    }
}

