/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.ctatview;

import edu.cmu.pact.BehaviorRecorder.Controller.CTAT_Launcher;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.view.CtatFrame;
import edu.cmu.pact.ctatview.CtatviewException;
import edu.cmu.pact.ctatview.DockManager;
import javax.swing.JOptionPane;

public class CtatFrameController {
    private DockManager dockManager;

    public CtatFrameController(CTAT_Launcher server) {
        this.dockManager = server.getDockManager();
        this.dockManager.ctatFrame = new CtatFrame(server);
    }

    public void dockWindowsNow(boolean showCtatWindow) {
        try {
            this.dockManager.dockWindowsNow(showCtatWindow);
        }
        catch (CtatviewException ce) {
            StringBuffer errMsg = new StringBuffer("Error trying to dock windows.");
            errMsg.append(" Additional information:\n").append(ce);
            Throwable cause = ce.getCause();
            if (cause != null) {
                errMsg.append("\n: Cause: ").append(cause);
            }
            trace.errStack("dockWindowsNow(): " + errMsg, ce);
            JOptionPane.showMessageDialog(this.dockManager.ctatFrame, errMsg, "Error docking windows", 0);
        }
    }

    public DockManager getDockManager() {
        return this.dockManager;
    }

    public CtatFrame getDockedFrame() {
        return this.dockManager.ctatFrame;
    }

    public void saveLayout(String mode) {
        this.dockManager.saveLayout(mode);
    }

    public void restoreDefaultView() {
        this.dockManager.restoreDefaultView();
    }
}

