/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.jess;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.ExactMatcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Matcher;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.jess.JessModelTracing;
import edu.cmu.pact.jess.MTRete;
import edu.cmu.pact.jess.RuleActivationNode;
import java.io.Serializable;
import jess.Context;
import jess.Funcall;
import jess.JessException;
import jess.Userfunction;
import jess.Value;
import jess.ValueVector;

public class LHSPredictObservableAction
implements Userfunction,
Serializable {
    private static final String LHS_PREDICT_OBSERVABLE_ACTION = "lhs-predict-oa";
    protected transient JessModelTracing jmt;
    protected transient Context context;

    public LHSPredictObservableAction() {
        this(null);
    }

    public LHSPredictObservableAction(JessModelTracing jmt) {
        this.jmt = jmt;
    }

    public String getName() {
        return LHS_PREDICT_OBSERVABLE_ACTION;
    }

    public Value call(ValueVector vv, Context context) throws JessException {
        return this.internalCall(vv, context, false);
    }

    protected Value internalCall(ValueVector vv, Context context, boolean fromBuggyRule) throws JessException {
        boolean isHint;
        if (trace.getDebugCode("eep")) {
            trace.out("eep", "lhspoa called");
        }
        this.context = context;
        if (!vv.get(0).stringValue(context).equals(this.getName())) {
            throw new JessException(this.getName(), "called but ValueVector head differs", vv.get(0).stringValue(context));
        }
        if (vv.size() < 3) {
            throw new JessException(this.getName(), "called but too few arguments", "args num:" + vv.size());
        }
        String sSelection = vv.get(1).resolveValue(context).stringValue(context);
        String sAction = vv.get(2).resolveValue(context).stringValue(context);
        String sInput = vv.get(3).resolveValue(context).stringValue(context);
        String predictedSelection = "NotSpecified";
        String predictedAction = "NotSpecified";
        String predictedInput = "NotSpecified";
        String predictedInputTestFunction = "NotSpecified";
        if (this.getJmt() == null) {
            return Funcall.TRUE;
        }
        if (vv.size() > 4) {
            predictedSelection = vv.get(4).resolveValue(context).stringValue(context);
            if (vv.size() > 5) {
                predictedAction = vv.get(5).resolveValue(context).stringValue(context);
                if (vv.size() > 6) {
                    predictedInput = vv.get(6).resolveValue(context).stringValue(context);
                }
            }
        }
        if (vv.size() > 7) {
            predictedInputTestFunction = vv.get(vv.size() - 1).stringValue(context);
        }
        if (trace.getDebugCode("mt")) {
            trace.out("mt", String.format("lhs-predict-oa(%s, %s, %s, %s, %s, %s, %s)", sSelection, sAction, sInput, predictedSelection, predictedAction, predictedInput, predictedInputTestFunction));
        }
        boolean bl = isHint = this.getJmt().isHintTrace() || "hint".equalsIgnoreCase(sSelection);
        if (isHint && fromBuggyRule) {
            if (trace.getDebugCode("mt")) {
                trace.out("mt", "BUGGYLHS HINT RETURNS: FALSE for [ " + sSelection + " , " + sAction + " , " + sInput + " ] isHint:" + this.getJmt().isHintTrace() + " sS==hint:" + sSelection.equalsIgnoreCase("hint"));
            }
            return Funcall.FALSE;
        }
        if (predictedSelection == "NotSpecified" && predictedAction == "NotSpecified" && predictedInput == "NotSpecified") {
            throw new JessException(this.getName(), "at least one selection, action or input argument must be specified", "NotSpecified");
        }
        if (isHint) {
            if (trace.getDebugCode("mt")) {
                trace.out("mt", "LHS HINT RETURNS: TRUE for [ " + sSelection + " , " + sAction + " , " + sInput + " ] isHint:" + this.getJmt().isHintTrace() + " sS==hint:" + sSelection.equalsIgnoreCase("hint"));
            }
            return Funcall.TRUE;
        }
        RuleActivationNode r = RuleActivationNode.create(null, 0);
        if (r.isSAIFound(sSelection, sAction, sInput, predictedSelection, predictedAction, predictedInput, predictedInputTestFunction, false, context) == 2) {
            if (trace.getDebugCode("mt")) {
                trace.out("mt", "LHS RETURNS: FALSE for [ " + sSelection + " , " + sAction + " , " + sInput + " ]");
            }
            return Funcall.FALSE;
        }
        if (trace.getDebugCode("mt")) {
            trace.out("mt", "LHS RETURNS:TRUE for [ " + sSelection + " , " + sAction + " , " + sInput + " ] isHint:" + this.getJmt().isHintTrace() + " sS==hint:" + sSelection.equalsIgnoreCase("hint"));
        }
        return Funcall.TRUE;
    }

    public Matcher getMatcher(ValueVector vv, Context context) throws JessException {
        Matcher m = null;
        Value cnv = vv.get(vv.size() - 1).resolveValue(context);
        String possibleClassName = cnv == null ? null : cnv.stringValue(context);
        int lastArgIndex = vv.size() - 2;
        m = this.jmt.getMatcher(possibleClassName);
        if (m == null && vv.size() == 4) {
            m = new ExactMatcher();
            lastArgIndex = vv.size() - 1;
        }
        if (m != null) {
            for (int i = 1; i <= lastArgIndex; ++i) {
                String param;
                Value rv = vv.get(i).resolveValue(context);
                String string = param = rv == null ? null : rv.stringValue(context);
                if ("NotSpecified".equals(param)) {
                    m.setParamNotSpecified(i - 1, "NotSpecified");
                    continue;
                }
                if ("DONT-CARE".equals(param)) {
                    m.setParamNotSpecified(i - 1, "DONT-CARE");
                    continue;
                }
                m.setParameterByIndex(param, i - 1);
            }
        }
        return m;
    }

    protected JessModelTracing getJmt() {
        if (this.jmt == null && this.context != null && this.context.getEngine() instanceof MTRete) {
            this.jmt = ((MTRete)this.context.getEngine()).getJmt();
        }
        return this.jmt;
    }

    protected void setJmt(JessModelTracing jmt) {
        this.jmt = jmt;
    }
}

