/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.jess;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jess.Context;
import jess.Deftemplate;
import jess.Fact;
import jess.FactIDValue;
import jess.JessException;
import jess.Test1;
import jess.Value;

class VariableBindingNode {
    static final String REF = "REF_";
    static final String LIT = "LIT_";
    private static final Pattern BLANK_VAR_PATTERN = Pattern.compile("\\?_\\w*_\\w*");
    private static final Pattern LIT_PATTERN = Pattern.compile("^LIT_[0-9][0-9]*_(.*)$");
    private static final Pattern REF_PATTERN = Pattern.compile("^REF_[0-9][0-9]*_(.*)$");
    public static final int SLOT = 0;
    public static final int MULTISLOT = 1;
    public static final int BOUND_NAME = 2;
    public static final int TEMPLATE = 3;
    public static final int MATCHES_SINGLE = 0;
    public static final int MATCHES_MULTI = 1;
    public static final int LITERAL = 2;
    public static final int FUNCALL = 3;
    public static final int BAD_VARIABLE = 4;
    private String variableName;
    private boolean isBlank = false;
    Value value;
    int srNo;
    int depth;
    int slotIndex;
    int typeOfVariable;
    int slotType;
    int subSlotIndex;
    int testType;
    Test1 test;
    private static final String[] typeOfVariableNames = new String[]{"MATCHES_SINGLE", "MATCHES_MULTI", "LITERAL", "FUNCALL", "BAD_VARIABLE"};

    public void setTest(Test1 test) {
        this.test = test;
    }

    public Test1 getTest() {
        return this.test;
    }

    public VariableBindingNode(VariableBindingNode vbn) {
        this.setVariableName(vbn.getVariableName());
        this.value = vbn.getVariableValue();
        this.slotIndex = vbn.getSlotIndex();
        this.subSlotIndex = vbn.getSubSlotIndexes();
        this.typeOfVariable = vbn.getVariableType();
        this.srNo = vbn.getSrNo();
        this.testType = vbn.getTestType();
        this.slotType = vbn.getSlotType();
    }

    public VariableBindingNode(String prefix, String varName, int depth, int srNo, int index, int subIndex, int slotType, int varType, int testType) {
        if (prefix != null) {
            this.setVariableName(prefix + Integer.toString(srNo) + "_" + varName);
        } else {
            this.setVariableName(varName);
        }
        this.depth = depth;
        this.slotIndex = index;
        this.subSlotIndex = subIndex;
        this.srNo = srNo;
        this.slotType = slotType;
        this.typeOfVariable = varType;
        this.testType = testType;
    }

    public VariableBindingNode(String name, int typeOfVariable, int slotType, int testType) {
        this(null, name, 0, 0, 0, 0, slotType, typeOfVariable, testType);
    }

    public VariableBindingNode(String varName, int depth, int srNo, int index, int subIndex, int slotType, int varType, int testType) {
        this(null, varName, depth, srNo, index, subIndex, slotType, varType, testType);
    }

    public void setVariableName(String name) {
        this.variableName = name;
        this.isBlank = VariableBindingNode.isBlank(name);
    }

    public static boolean isBlank(String s) {
        Matcher m = BLANK_VAR_PATTERN.matcher(s);
        return m.matches();
    }

    public boolean isBlank() {
        return this.isBlank;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public Value getVariableValue() {
        return this.value;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getSrNo() {
        return this.srNo;
    }

    public int getSubSlotIndexes() {
        return this.subSlotIndex;
    }

    public int getSlotIndex() {
        return this.slotIndex;
    }

    public int getSlotType() {
        return this.slotType;
    }

    public void setDepth(int d) {
        this.depth = d;
    }

    public void setValue(Value v) {
        this.value = new Value(v);
    }

    public void setSrNo(int s) {
        this.srNo = s;
    }

    public String toString() {
        return this.variableName;
    }

    public int getVariableType() {
        return this.typeOfVariable;
    }

    public void setSlotIndex(int index) {
        this.slotIndex = index;
    }

    public void setSubIndex(int index) {
        this.subSlotIndex = index;
    }

    public void setTestType(int t) {
        this.testType = t;
    }

    public int getTestType() {
        return this.testType;
    }

    public void setVariableType(int type) {
        this.typeOfVariable = type;
    }

    String getExtVariableName() {
        Matcher m = REF_PATTERN.matcher(this.variableName);
        if (m.matches()) {
            return m.group(1);
        }
        m = LIT_PATTERN.matcher(this.variableName);
        if (m.matches()) {
            return m.group(1);
        }
        return this.getVariableName();
    }

    boolean isVariableReference() {
        Matcher m = REF_PATTERN.matcher(this.variableName);
        boolean result = m.matches();
        return m.matches();
    }

    public String getTypeOfVariableAsString() {
        int i = this.typeOfVariable;
        if (0 <= i && i < typeOfVariableNames.length) {
            return typeOfVariableNames[i];
        }
        return "(unkn TYPE)";
    }

    public String getSlotTypeAsString() {
        switch (this.slotType) {
            case 0: {
                return "SLOT";
            }
            case 1: {
                return "MULTISLOT";
            }
            case 2: {
                return "BOUND_NAME";
            }
            case 3: {
                return "TEMPLATE";
            }
        }
        return "(unkn SLOT)";
    }

    public String dump() {
        String NS = "(null)";
        StringBuffer sb = new StringBuffer("[");
        sb.append("name ").append(this.variableName == null ? NS : this.variableName);
        sb.append(" ").append(this.getTypeOfVariableAsString());
        sb.append(" ").append(this.getSlotTypeAsString());
        sb.append(", value ").append(this.value == null ? NS : this.value.toString());
        sb.append(", srNo ").append(Integer.toString(this.srNo));
        sb.append(", depth ").append(Integer.toString(this.depth));
        sb.append(", slot ").append(Integer.toString(this.slotIndex));
        return sb.append("]").toString();
    }

    String formatValue(Context context) {
        String result = "(null)";
        Value val = this.getVariableValue();
        if (val == null) {
            return result;
        }
        try {
            int nameSlotIdx;
            Fact vbnFact = val.factValue(context);
            Deftemplate dt = vbnFact.getDeftemplate();
            int n = nameSlotIdx = dt == null ? -1 : dt.getSlotIndex("name");
            result = nameSlotIdx < 0 ? val.toString() : vbnFact.getSlotValue("name") + " " + new FactIDValue(vbnFact).toString();
        }
        catch (JessException e) {
            result = val.toString();
        }
        return result;
    }
}

