/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.jess;

import edu.cmu.pact.BehaviorRecorder.Dialogs.DialogUtilities;
import edu.cmu.pact.Utilities.CTAT_Controller;
import edu.cmu.pact.Utilities.MessageEvent;
import edu.cmu.pact.Utilities.MessageEventListener;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.view.AbstractCtatWindow;
import edu.cmu.pact.ctatview.JHorizontalTable;
import edu.cmu.pact.jess.MT;
import edu.cmu.pact.jess.MTRete;
import edu.cmu.pact.jess.Utils;
import edu.cmu.pact.jess.WMEEditorPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jess.Context;
import jess.Deftemplate;
import jess.Fact;
import jess.FactIDValue;
import jess.Funcall;
import jess.JessException;
import jess.PrettyPrinter;
import jess.RU;
import jess.Rete;
import jess.Value;
import jess.ValueVector;
import jess.Visitable;

public class WMEEditor
implements MessageEventListener,
PropertyChangeListener,
TreeSelectionListener,
ListSelectionListener {
    private static final String DISPLAY_FACT_NAMES = "Display Fact Names";
    private static final String DISPLAY_FACT_IDS = "Display Fact IDs";
    private static final String PROBLEM_FOLDER = "Problem Directory";
    private static final Pattern slotTypePattern = Pattern.compile("(\\p{Space}*\\(slot )(.*)(\\(type\\p{Space}+)([1-9][0-9]*)\\)(\\)+)\\p{Space}*$");
    private static final Pattern factDisplayPattern = Pattern.compile("<[fF][aA][cC][tT]-([0-9]+)>");
    private String problemName = "";
    JLabel type;
    JLabel slots;
    JLabel types;
    JLabel slotValues;
    JLabel value;
    JLabel description;
    JTree wmeTree;
    Deftemplate selectedTemplate;
    Fact selectedFact;
    JMenuItem addSlotMenu;
    JMenuItem deleteSlotMenu;
    JHorizontalTable slotTable;
    int selectedSlotNum;
    JLabel templateLabel;
    JLabel factLabel;
    JTextField templateField;
    SlotTableModel slotTableModel;
    JComboBox typeCbo;
    DefaultTreeModel wmeTreeModel;
    private MTRete r;
    private MTRete preRete;
    private MTRete postRete;
    JCheckBox reactive;
    private WMEEditorPanel editorPanel;
    private final boolean setSize;
    private final boolean isWhyNot;
    public static final int MTSTATE_NO_PROBLEM_YET = 0;
    public static final int MTSTATE_LOADING_PROBLEM = 1;
    public static final int MTSTATE_START_STATE = 2;
    public static final int MTSTATE_TRYING_MODEL_TRACE = 3;
    public static final int MTSTATE_MODEL_TRACING_BEGUN = 4;
    private static final String[] mtStateNames = new String[]{"No problem defined", "Loading problem definition", "In start state", "Trying first intermediate state", "Intermediate or done state"};
    private static final String[] mtStateSaveWarnings = new String[]{"", "Warning: The system is loading the problem definition and working memory\n may be changing. This save may not capture a consistent state.", "If saved under the same name as the problem graph, the current facts will\n replace the starting state for this problem.", "Warning: The rule engine is active and working memory may be changing.\n This save may not capture a consistent state.", "Warning: The rule engine has changed working memory from the starting state.\n Do not save this working memory under the same name as the problem graph's."};
    private static final String[] mtStateEditWarnings = new String[]{"Warning: your edits will be lost if you do not save them before loading\n a problem graph.", "Warning: The system is loading the problem definition and working memory\n may be changing.", "", "Warning: The rule engine is active and working memory may be changing.", ""};
    private int mtState = 0;
    private boolean dirtyTypes = false;
    private boolean dirtyInstances = false;
    static final String wmeTypeFileName = "wmeTypes.clp";
    static final String rulesFileName = "productionRules.pr";
    private MT mt;
    public static final String ADD_SLOT = "ADD_SLOT";
    public static final String DELETE_SLOT = "DELETE_SLOT";
    public static final String CANCEL_DELETE_TEMPLATE = "CANCEL_DELETE_TEMPLATE";
    public static final String RENAME_TEMPLATE = "RENAME_TEMPLATE";
    public static final String DELETE_TEMPLATE = "DELETE_TEMPLATE";
    public static final String EDIT_TEMPLATE = "EDIT_TEMPLATE";
    public static final String ADD_TEMPLATE = "ADD_TEMPLATE";
    public static final String DELETE_FACT = "DELETE_FACT";
    public static final String EDIT_FACT = "EDIT_FACT";
    public static final String ADD_FACT = "ADD_FACT";
    public static final String SAVE_TEMPLATES = "SAVE_TEMPLATES";
    public static final String SAVE_FACTS = "SAVE_FACTS";
    static final String INSPECT_FACT = "INSPECT_FACT";
    private CTAT_Controller controller;
    private AbstractCtatWindow parentFrame;
    public static final FileFilter templateFileFilter = new TemplateFileFilter();
    public static final FileFilter factFileFilter = new FactFileFilter();

    public WMEEditor(MTRete rete, MT mt, MTRete postRete, boolean doSetSize, boolean isWhyNot) {
        this.controller = mt.getController();
        this.parentFrame = this.controller.getActiveWindow();
        this.mt = mt;
        this.setSize = doSetSize;
        this.isWhyNot = isWhyNot;
        this.setRete(rete);
        this.setPreRete(rete);
        this.setPostRete(postRete);
        this.controller.getPreferencesModel().addPropertyChangeListener(this);
        this.wmeTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
        this.wmeTree = new JTree(this.wmeTreeModel);
        this.wmeTree.setName("WME Tree");
        this.wmeTree.addTreeSelectionListener(this);
        this.wmeTree.setDragEnabled(true);
        this.wmeTree.setRootVisible(false);
        this.wmeTree.setBackground(new Color(240, 240, 240));
        this.wmeTree.setShowsRootHandles(true);
        this.wmeTree.getSelectionModel().setSelectionMode(1);
        WMETreeCellRenderer renderer = new WMETreeCellRenderer();
        this.wmeTree.setCellRenderer(renderer);
        String[] columnNames = new String[]{"Slot", "Type", "Slot Value"};
        this.typeCbo = new JComboBox();
        this.typeCbo.setName("WME Slot Type");
        this.typeCbo.addItem("slot");
        this.typeCbo.addItem("multislot");
        this.slotTableModel = new SlotTableModel(columnNames, 5);
        this.slotTable = new JHorizontalTable(this.slotTableModel);
        this.slotTable.setName("WME Slot Table");
        this.slotTable.setTransferHandler(new FactTransferHandler());
        this.slotTable.addKeyListener(this.getPanel());
        this.slotTable.setSelectionMode(0);
        this.slotTable.setCellSelectionEnabled(true);
        this.slotTable.getSelectionModel().addListSelectionListener(this);
        for (int i = 0; i < 3; ++i) {
            TableColumn column = this.slotTable.getColumnModel().getColumn(i);
            if (i == 0) {
                column.setMinWidth(100);
            }
            if (i == 1) {
                column.setMinWidth(50);
            }
            if (i != 2) continue;
            column.setMinWidth(200);
        }
        TableColumn tc = this.slotTable.getColumnModel().getColumn(1);
        tc.setCellEditor(new DefaultCellEditor(this.typeCbo));
        this.slotTable.setPreferredScrollableViewportSize(new Dimension(500, 110));
    }

    private void displayCognitiveModelFolder() {
        this.getPanel().displayCognitiveModelFolder();
    }

    void checkDirtyInstances() {
        if (this.dirtyInstances) {
            int n = JOptionPane.showConfirmDialog(this.parentFrame, "You have modified working memory. Do you wish to save?\n", "Confirm", 0, 2);
            if (n == 0) {
                this.saveFacts();
            }
            this.dirtyInstances = false;
        }
    }

    public void checkDirtyTypes() {
        if (this.dirtyTypes) {
            int n = JOptionPane.showConfirmDialog(this.parentFrame, "You have modified the deftemplates.\nDo you want to save the changes and make the new wme types\na part of the start state?\nOtherwise all changes that youmade will be undone.", "Confirm", 0, 2);
            if (n == 0) {
                this.saveTemplates(true);
            }
            this.dirtyTypes = false;
        }
    }

    void setRete(MTRete rete) {
        this.r = rete;
    }

    public void setProblemName(String name) {
        this.problemName = name == null ? "" : name;
    }

    void removeTemplate(Deftemplate template) {
        StringWriter swt = new StringWriter();
        StringWriter swf = new StringWriter();
        this.saveTemplatesExcept(template, swt);
        this.saveFactsAsJessCodeExcept(template, this.r.listFacts(), swf);
        try {
            this.r.clear();
            this.r.parse(new BufferedReader(new StringReader(swt.toString())));
            this.r.parse(new BufferedReader(new StringReader(swf.toString())));
        }
        catch (JessException je) {
            trace.errStack("removeTemplate(" + template + ")", je);
        }
    }

    void setSelection(Fact fact, Deftemplate template) {
        if (fact == null && template == null) {
            this.wmeTree.setSelectionPath(null);
            this.getPanel().mouseReleased(null);
            return;
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.wmeTreeModel.getRoot();
        String factID = "";
        try {
            if (fact != null) {
                factID = new FactIDValue(fact).toString();
            }
        }
        catch (JessException je) {
            trace.errStack("setSelection(" + factID + ")", je);
            return;
        }
        String templateName = template.getBaseName();
        Enumeration<TreeNode> templates = root.children();
        while (templates.hasMoreElements()) {
            DefaultMutableTreeNode templateNode = (DefaultMutableTreeNode)templates.nextElement();
            if (!templateNode.toString().equals(templateName)) continue;
            TreePath selectionPath = new TreePath(this.wmeTreeModel.getPathToRoot(templateNode));
            if (fact != null) {
                Enumeration<TreeNode> facts = templateNode.children();
                while (facts.hasMoreElements()) {
                    DefaultMutableTreeNode factNode = (DefaultMutableTreeNode)facts.nextElement();
                    if (factNode.toString().indexOf(factID) == -1) continue;
                    selectionPath = new TreePath(this.wmeTreeModel.getPathToRoot(factNode));
                    break;
                }
            }
            this.wmeTree.setSelectionPath(selectionPath);
            this.wmeTree.scrollPathToVisible(selectionPath);
            break;
        }
        this.getPanel().mouseReleased(null);
    }

    private void setShowFactNames(boolean show) {
    }

    private void setShowFactIDs(boolean show) {
    }

    public String saveTemplates(boolean showLocation) {
        String path = this.mt.findCognitiveModelDirectory();
        File dir = new File(path);
        if (!dir.exists()) {
            dir = edu.cmu.pact.Utilities.Utils.getFileAsResource(path, this);
        }
        return this.saveTemplates(false, showLocation, dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String saveTemplates(boolean prompt, boolean showLocation, File dir) {
        int confirm;
        if (dir == null) {
            return null;
        }
        if (prompt && (confirm = JOptionPane.showConfirmDialog(this.parentFrame, "Would you like also to save your deftemplates to file wmeTypes.clp?", "Save Jess Deftemplates?", 0)) != 0) {
            return null;
        }
        File f = new File(dir, wmeTypeFileName);
        FileWriter out = null;
        try {
            out = this.openFile(f);
            if (out == null) {
                String string = null;
                return string;
            }
            boolean success = this.saveTemplates(out, this.r);
            if (success && showLocation) {
                JOptionPane.showMessageDialog(this.parentFrame, "Template definitions (deftemplates) saved to\n" + f, "Templates Saved.", 1);
            }
            String string = success ? f.toString() : null;
            return string;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.parentFrame, "Error writing file " + f + ":\n" + e, "Exception.", 0);
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            if (out != null) {
                try {
                    ((Writer)out).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private boolean saveTemplates(Writer w, Rete r) throws IOException {
        BufferedWriter out = null;
        try {
            out = w instanceof BufferedWriter ? (BufferedWriter)w : new BufferedWriter(w);
            Iterator it = r.listDeftemplates();
            while (it.hasNext()) {
                Deftemplate dt = (Deftemplate)it.next();
                if (dt.getBaseName().startsWith("_") || dt.getBaseName().equalsIgnoreCase("initial-fact")) continue;
                StringBuffer sb = new StringBuffer();
                String template = new PrettyPrinter((Visitable)dt).toString();
                StringTokenizer tkzr = new StringTokenizer(template, "\n");
                while (tkzr.hasMoreTokens()) {
                    String line = tkzr.nextToken();
                    Matcher m = slotTypePattern.matcher(line);
                    if (m.matches()) {
                        block19: {
                            sb.replace(0, sb.length(), m.group(1));
                            sb.append(m.group(2));
                            int typeNum = -1;
                            try {
                                typeNum = Integer.parseInt(m.group(4));
                                String type = RU.getTypeName((int)typeNum);
                                if (type == null) {
                                    if (trace.getDebugCode("mt")) {
                                        trace.out("mt", "bad slot type number " + typeNum);
                                    }
                                } else {
                                    sb.append(m.group(3));
                                    sb.append(RU.getTypeName((int)typeNum));
                                    sb.append(')');
                                }
                            }
                            catch (NumberFormatException nfe) {
                                if (!trace.getDebugCode("mt")) break block19;
                                trace.out("mt", "regex should prevent this " + typeNum);
                            }
                        }
                        sb.append(m.group(5));
                        line = sb.toString();
                    }
                    out.write(line);
                    out.newLine();
                }
                if (dt.getBackwardChaining()) {
                    out.write("(do-backward-chaining " + dt.getBaseName() + ")");
                    out.newLine();
                }
                out.flush();
            }
            out.newLine();
            out.write("; tell productionRules file that templates have been parsed");
            out.newLine();
            out.write("(provide wmeTypes)");
            out.newLine();
            this.dirtyTypes = false;
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveTemplatesExcept(Deftemplate deleted, Writer w) {
        BufferedWriter out = null;
        try {
            out = w instanceof BufferedWriter ? (BufferedWriter)w : new BufferedWriter(w);
            Iterator it = this.r.listDeftemplates();
            while (it.hasNext()) {
                Deftemplate dt = (Deftemplate)it.next();
                if (dt.getBaseName().equals(deleted.getBaseName()) || dt.getBaseName().startsWith("_") || dt.getBaseName().equalsIgnoreCase("initial-fact")) continue;
                StringBuffer sb = new StringBuffer();
                String template = new PrettyPrinter((Visitable)dt).toString();
                StringTokenizer tkzr = new StringTokenizer(template, "\n");
                while (tkzr.hasMoreTokens()) {
                    String line = tkzr.nextToken();
                    Matcher m = slotTypePattern.matcher(line);
                    if (m.matches()) {
                        block21: {
                            sb.replace(0, sb.length(), m.group(1));
                            sb.append(m.group(2));
                            int typeNum = -1;
                            try {
                                typeNum = Integer.parseInt(m.group(4));
                                String type = RU.getTypeName((int)typeNum);
                                if (type == null) {
                                    if (trace.getDebugCode("wme")) {
                                        trace.out("wme", "bad slot type number " + typeNum);
                                    }
                                } else {
                                    sb.append(m.group(3));
                                    sb.append(RU.getTypeName((int)typeNum));
                                    sb.append(')');
                                }
                            }
                            catch (NumberFormatException nfe) {
                                if (!trace.getDebugCode("wme")) break block21;
                                trace.out("wme", "regex should prevent this " + typeNum);
                            }
                        }
                        sb.append(m.group(5));
                        line = sb.toString();
                    }
                    out.write(line);
                    out.newLine();
                }
                if (dt.getBackwardChaining()) {
                    out.write("(do-backward-chaining " + dt.getBaseName() + ")");
                    out.newLine();
                }
                out.flush();
            }
            this.dirtyTypes = false;
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.parentFrame, "Error writing file.", "I/O Error.", 0);
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean saveTemplatesRename(Deftemplate changed, String newName, Writer w) {
        BufferedWriter out = null;
        try {
            out = w instanceof BufferedWriter ? (BufferedWriter)w : new BufferedWriter(w);
            Iterator it = this.r.listDeftemplates();
            while (it.hasNext()) {
                Deftemplate dt = (Deftemplate)it.next();
                if (dt.getBaseName().startsWith("_") || dt.getBaseName().equalsIgnoreCase("initial-fact")) continue;
                StringBuffer sb = new StringBuffer();
                String template = new PrettyPrinter((Visitable)dt).toString();
                StringTokenizer tkzr = new StringTokenizer(template, "\n");
                int lineNum = 1;
                while (tkzr.hasMoreTokens()) {
                    Matcher m;
                    String line = tkzr.nextToken();
                    if (dt == changed && lineNum == 1) {
                        line = line.substring(0, line.indexOf(changed.getBaseName())) + newName + line.substring(line.indexOf(changed.getBaseName()) + changed.getBaseName().length(), line.length() - 1);
                    }
                    if ((m = slotTypePattern.matcher(line)).matches()) {
                        block22: {
                            sb.replace(0, sb.length(), m.group(1));
                            sb.append(m.group(2));
                            int typeNum = -1;
                            try {
                                typeNum = Integer.parseInt(m.group(4));
                                String type = RU.getTypeName((int)typeNum);
                                if (type == null) {
                                    if (trace.getDebugCode("wme")) {
                                        trace.out("wme", "bad slot type number " + typeNum);
                                    }
                                } else {
                                    sb.append(m.group(3));
                                    sb.append(RU.getTypeName((int)typeNum));
                                    sb.append(')');
                                }
                            }
                            catch (NumberFormatException nfe) {
                                if (!trace.getDebugCode("wme")) break block22;
                                trace.out("wme", "regex should prevent this " + typeNum);
                            }
                        }
                        sb.append(m.group(5));
                        line = sb.toString();
                    }
                    out.write(line);
                    out.newLine();
                    ++lineNum;
                }
                if (dt.getBackwardChaining()) {
                    out.write("(do-backward-chaining " + dt.getBaseName() + ")");
                    out.newLine();
                }
                out.flush();
            }
            this.dirtyTypes = false;
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.parentFrame, "Error writing file.", "I/O Error.", 0);
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveTemplatesChangeSlot(Deftemplate changed, String oldSlotName, String newSlotName, String slotType, String dft, Writer w) {
        BufferedWriter out = null;
        try {
            out = w instanceof BufferedWriter ? (BufferedWriter)w : new BufferedWriter(w);
            Iterator it = this.r.listDeftemplates();
            while (it.hasNext()) {
                Deftemplate dt = (Deftemplate)it.next();
                if (dt.getBaseName().startsWith("_") || dt.getBaseName().equalsIgnoreCase("initial-fact")) continue;
                StringBuffer sb = new StringBuffer();
                String template = new PrettyPrinter((Visitable)dt).toString();
                StringTokenizer tkzr = new StringTokenizer(template, "\n");
                while (tkzr.hasMoreTokens()) {
                    String line = tkzr.nextToken();
                    boolean changedLine = dt.getBaseName().equals(changed.getBaseName()) && line.indexOf("slot " + oldSlotName) != -1;
                    Matcher m = slotTypePattern.matcher(line);
                    if (m.matches()) {
                        block26: {
                            sb.replace(0, sb.length(), m.group(1));
                            sb.append(m.group(2));
                            int typeNum = -1;
                            try {
                                typeNum = Integer.parseInt(m.group(4));
                                String type = RU.getTypeName((int)typeNum);
                                if (type == null) {
                                    if (trace.getDebugCode("wme")) {
                                        trace.out("wme", "bad slot type number " + typeNum);
                                    }
                                } else {
                                    sb.append(m.group(3));
                                    sb.append(RU.getTypeName((int)typeNum));
                                    sb.append(')');
                                }
                            }
                            catch (NumberFormatException nfe) {
                                if (!trace.getDebugCode("wme")) break block26;
                                trace.out("wme", "regex should prevent this " + typeNum);
                            }
                        }
                        sb.append(m.group(5));
                        line = sb.toString();
                    }
                    if (changedLine) {
                        String newLine = !slotType.equalsIgnoreCase("multislot") ? "(slot " + newSlotName : "(multislot " + newSlotName;
                        if (!slotType.equalsIgnoreCase("slot") && !slotType.equalsIgnoreCase("multislot")) {
                            newLine = newLine + " (type " + slotType + ")";
                        }
                        if (dft != null && dft.trim().length() > 0) {
                            newLine = !slotType.equalsIgnoreCase("multislot") ? (dft.indexOf(32) != -1 ? newLine + " (default " + dft.substring(0, dft.indexOf(32)) + ")" : newLine + " (default " + dft + ")") : newLine + " (default (create$ " + dft + "))";
                        } else if (line.indexOf("(default ") != -1) {
                            newLine = newLine + " " + line.substring(line.indexOf("(default "), line.indexOf(")", line.indexOf("(default ")));
                        }
                        line = newLine = newLine + (tkzr.hasMoreTokens() ? ")" : "))");
                    }
                    out.write(line);
                    out.newLine();
                }
                if (dt.getBackwardChaining()) {
                    out.write("(do-backward-chaining " + dt.getBaseName() + ")");
                    out.newLine();
                }
                out.flush();
            }
            this.dirtyTypes = false;
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.parentFrame, "Error writing file.", "I/O Error.", 0);
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean saveTemplatesAddSlot(Deftemplate changed, Writer w) {
        BufferedWriter out = null;
        try {
            out = w instanceof BufferedWriter ? (BufferedWriter)w : new BufferedWriter(w);
            Iterator it = this.r.listDeftemplates();
            while (it.hasNext()) {
                Deftemplate dt = (Deftemplate)it.next();
                if (dt.getBaseName().startsWith("_") || dt.getBaseName().equalsIgnoreCase("initial-fact")) continue;
                StringBuffer sb = new StringBuffer();
                String template = new PrettyPrinter((Visitable)dt).toString();
                boolean addToThis = dt.getBaseName().equalsIgnoreCase(changed.getBaseName());
                String newSlotName = "newslot";
                int i = -1;
                StringTokenizer tkzr = new StringTokenizer(template, "\n");
                while (tkzr.hasMoreTokens()) {
                    Matcher m;
                    String line = tkzr.nextToken();
                    if (addToThis && line.indexOf(newSlotName) != -1) {
                        if (i == -1) {
                            newSlotName = newSlotName + "1";
                            i = 1;
                        } else {
                            newSlotName = newSlotName.substring(0, newSlotName.length() - 1) + i;
                        }
                        if (++i > 10) {
                            i -= 10;
                        }
                    }
                    if ((m = slotTypePattern.matcher(line)).matches()) {
                        block26: {
                            sb.replace(0, sb.length(), m.group(1));
                            sb.append(m.group(2));
                            int typeNum = -1;
                            try {
                                typeNum = Integer.parseInt(m.group(4));
                                String type = RU.getTypeName((int)typeNum);
                                if (type == null) {
                                    if (trace.getDebugCode("wme")) {
                                        trace.out("wme", "bad slot type number " + typeNum);
                                    }
                                } else {
                                    sb.append(m.group(3));
                                    sb.append(RU.getTypeName((int)typeNum));
                                    sb.append(')');
                                }
                            }
                            catch (NumberFormatException nfe) {
                                if (!trace.getDebugCode("wme")) break block26;
                                trace.out("wme", "regex should prevent this " + typeNum);
                            }
                        }
                        sb.append(m.group(5));
                        line = sb.toString();
                    }
                    if (addToThis && !tkzr.hasMoreTokens()) {
                        out.write(line.substring(0, line.length() - 1));
                        out.newLine();
                        out.write("(slot " + newSlotName + "))");
                        out.newLine();
                        continue;
                    }
                    out.write(line);
                    out.newLine();
                }
                if (dt.getBackwardChaining()) {
                    out.write("(do-backward-chaining " + dt.getBaseName() + ")");
                    out.newLine();
                }
                out.flush();
            }
            this.dirtyTypes = false;
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.parentFrame, "Error writing file.", "I/O Error.", 0);
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean saveTemplatesDeleteSlot(Deftemplate changed, String slotName, Writer w) {
        BufferedWriter out = null;
        try {
            out = w instanceof BufferedWriter ? (BufferedWriter)w : new BufferedWriter(w);
            Iterator it = this.r.listDeftemplates();
            while (it.hasNext()) {
                Deftemplate dt = (Deftemplate)it.next();
                if (dt.getBaseName().startsWith("_") || dt.getBaseName().equalsIgnoreCase("initial-fact")) continue;
                StringBuffer sb = new StringBuffer();
                String template = new PrettyPrinter((Visitable)dt).toString();
                boolean deleteFromThis = dt.getBaseName().equalsIgnoreCase(changed.getBaseName());
                StringTokenizer tkzr = new StringTokenizer(template, "\n");
                while (tkzr.hasMoreTokens()) {
                    String line = tkzr.nextToken();
                    if (deleteFromThis && line.indexOf(slotName) != -1) {
                        if (tkzr.hasMoreTokens()) continue;
                        out.write(")");
                        out.newLine();
                        continue;
                    }
                    Matcher m = slotTypePattern.matcher(line);
                    if (m.matches()) {
                        block22: {
                            sb.replace(0, sb.length(), m.group(1));
                            sb.append(m.group(2));
                            int typeNum = -1;
                            try {
                                typeNum = Integer.parseInt(m.group(4));
                                String type = RU.getTypeName((int)typeNum);
                                if (type == null) {
                                    if (trace.getDebugCode("wme")) {
                                        trace.out("wme", "bad slot type number " + typeNum);
                                    }
                                } else {
                                    sb.append(m.group(3));
                                    sb.append(RU.getTypeName((int)typeNum));
                                    sb.append(')');
                                }
                            }
                            catch (NumberFormatException nfe) {
                                if (!trace.getDebugCode("wme")) break block22;
                                trace.out("wme", "regex should prevent this " + typeNum);
                            }
                        }
                        sb.append(m.group(5));
                        line = sb.toString();
                    }
                    out.write(line);
                    out.newLine();
                }
                if (dt.getBackwardChaining()) {
                    out.write("(do-backward-chaining " + dt.getBaseName() + ")");
                    out.newLine();
                }
                out.flush();
            }
            this.dirtyTypes = false;
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.parentFrame, "Error writing file.", "I/O Error.", 0);
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String saveFacts() {
        boolean saved;
        File f;
        int n;
        if (!mtStateSaveWarnings[this.mtState].equals("") && (n = JOptionPane.showConfirmDialog(this.parentFrame, mtStateSaveWarnings[this.mtState], "Confirm before saving.", 2, 2)) != 0) {
            return null;
        }
        String path = this.mt.findCognitiveModelDirectory();
        File selectedFile = f = new File(path);
        if (this.mtState == 2) {
            String filename = null;
            filename = this.mt != null ? this.mt.getProblemName() + ".wme" : (this.problemName != null && this.problemName.length() > 0 ? this.problemName + ".wme" : this.controller.getProblemName().replaceFirst(".brd", ".wme"));
            selectedFile = new File(path, filename);
        }
        if (trace.getDebugCode("wme")) {
            trace.out("wme", "saveFacts() mtState " + this.mtState + ", path" + path + ", file f " + f + ", selectedFile " + selectedFile);
        }
        if ((f = DialogUtilities.chooseFile(selectedFile.getParent(), selectedFile.getName(), factFileFilter, "Save Facts", "Save", this.controller)) == null) {
            return null;
        }
        if (trace.getDebugCode("wme")) {
            trace.out("wme", "saveFacts() chosen path " + f.getAbsoluteFile());
        }
        if (saved = this.saveFactsAsJessCode(this.r.listFacts(), f)) {
            this.dirtyInstances = false;
            return f.getPath();
        }
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new FileOutputStream(f));
            Iterator it = this.r.getWMEEditorFactsList().iterator();
            while (it.hasNext()) {
                out.writeObject(it.next());
                out.flush();
            }
            this.dirtyInstances = false;
            String string = f.getPath();
            return string;
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(this.parentFrame, "File not found.", "I/O Error.", 0);
            e.printStackTrace();
            String string = null;
            return string;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.parentFrame, "Error reading file.", "I/O Error.", 0);
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                    Object it = null;
                    f = null;
                    out = null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private boolean isEmptyTemplate(Object val) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)val;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.wmeTreeModel.getRoot();
        return root.isNodeChild(node);
    }

    @Override
    public void messageEventOccurred(MessageEvent me) {
        String msgType = me.getMessageType();
        String result = me.getResult();
        int oldState = this.mtState;
        if ("LISPCheck".equalsIgnoreCase(msgType)) {
            if (this.mtState != 4) {
                this.mtState = 3;
            }
        } else if ("Go_To_WM_State".equalsIgnoreCase(msgType)) {
            this.mtState = 4;
        } else if ("LISPCheckResult".equalsIgnoreCase(msgType)) {
            if ("SUCCESS".equalsIgnoreCase(result)) {
                this.mtState = 4;
            } else if (this.mtState == 3) {
                this.mtState = 2;
            }
        } else if ("ShowHintsMessage".equalsIgnoreCase(msgType)) {
            if (this.mtState == 3) {
                this.mtState = 2;
            }
        } else if ("StartProblem".equalsIgnoreCase(msgType)) {
            this.mtState = 1;
        } else if ("StartStateComplete".equalsIgnoreCase(msgType)) {
            if (this.mtState != 1) {
                trace.err("mtStateMachine error: StartStateComplete in state " + mtStateNames[this.mtState]);
            }
            this.mtState = 2;
        }
        this.getPanel().refresh();
        if (trace.getDebugCode("wme")) {
            trace.out("wme", "WMEEditor msg evt: msgType " + msgType + ", result " + result + "\n   oldState " + mtStateNames[oldState] + " -> " + mtStateNames[this.mtState]);
        }
    }

    private FileWriter openFile(File f) {
        FileWriter result = null;
        try {
            if (!f.exists()) {
                File parentFile = f.getParentFile();
                parentFile.mkdirs();
                f.createNewFile();
            }
            result = new FileWriter(f, false);
            return result;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.parentFrame, "Error opening file " + f.getName() + ":\n" + e, "I/O Error.", 0);
            e.printStackTrace();
            return null;
        }
    }

    public boolean saveFactsAsJessCode(Iterator factsIt, File file) {
        PrintWriter out = new PrintWriter(this.openFile(file));
        if (out == null) {
            return false;
        }
        boolean result = this.saveFactsAsJessCode(factsIt, out);
        out.close();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean saveFactsAsJessCode(Iterator factsIt, Writer w) {
        String extRefErrMsg = "One or more facts in the working memory contains a reference to an external object as a slot value.\n Hence the factscannot be stored in a text file.";
        try (PrintWriter out = null;){
            PrintWriter printWriter = out = w instanceof PrintWriter ? (PrintWriter)w : new PrintWriter(w);
            if (out == null) {
                boolean bl = false;
                return bl;
            }
            out.println(";; for Eclipse, etc., specify templates to read");
            out.println("(require* wmeTypes \"wmeTypes.clp\")");
            out.println("");
            Context context = this.r.getGlobalContext();
            class FactVar {
                Fact f;
                String v;

                FactVar(Fact f, int i) {
                    this.f = f;
                    this.v = "?var" + i;
                }
            }
            LinkedHashMap<Integer, FactVar> map = new LinkedHashMap<Integer, FactVar>();
            if (factsIt == null) {
                factsIt = this.r.listFacts();
            }
            int i = 1;
            while (factsIt.hasNext()) {
                Fact f = (Fact)factsIt.next();
                map.put(new Integer(f.getFactId()), new FactVar(f, i));
                ++i;
            }
            out.println(";;;; Fact assertions: slot assignments are below.");
            out.println("");
            for (FactVar fv : map.values()) {
                String nameAssgnmt = "";
                int n = fv.f.getDeftemplate().getSlotIndex("name");
                if (n >= 0) {
                    Value nameVal = fv.f.getSlotValue("name");
                    nameAssgnmt = " (name " + nameVal.resolveValue(context) + ")";
                }
                out.println("(bind " + fv.v + " (assert(" + fv.f.getName() + nameAssgnmt + ")))");
            }
            out.println();
            out.println(";;;; Slot assignments");
            out.println();
            for (FactVar fv : map.values()) {
                Deftemplate dt = fv.f.getDeftemplate();
                int nSlots = dt.getNSlots();
                if (nSlots < 1) continue;
                out.println("; " + fv.f.getName());
                out.println("(modify " + fv.v);
                for (int i2 = 0; i2 < nSlots; ++i2) {
                    String slotName = dt.getSlotName(i2);
                    Value val = fv.f.getSlotValue(slotName).resolveValue(context);
                    out.print("    (" + slotName);
                    switch (val.type()) {
                        case 16: {
                            Fact valFact = val.factValue(context);
                            FactVar valFV = (FactVar)map.get(new Integer(valFact.getFactId()));
                            out.print(" " + valFV.v);
                            break;
                        }
                        case 512: {
                            ValueVector vv = val.listValue(context);
                            for (int j = 0; j < vv.size(); ++j) {
                                Value listVal = vv.get(j).resolveValue(context);
                                if (listVal.type() == 16) {
                                    Fact valFact = listVal.factValue(context);
                                    FactVar valFV = (FactVar)map.get(new Integer(valFact.getFactId()));
                                    out.print(" " + valFV.v);
                                    continue;
                                }
                                if (listVal.type() == 2048) {
                                    JOptionPane.showMessageDialog(this.parentFrame, extRefErrMsg, "ERROR", 0);
                                    continue;
                                }
                                out.print(" " + listVal.toString());
                            }
                            break;
                        }
                        case 2048: {
                            JOptionPane.showMessageDialog(this.parentFrame, extRefErrMsg, "ERROR", 0);
                            boolean vv = false;
                            return vv;
                        }
                        default: {
                            String valString = val.toString();
                            if (valString.length() < 3 && this.isOperator(valString)) {
                                out.print(" \"" + val.toString() + "\"");
                                break;
                            }
                            out.print(" " + val.toString());
                        }
                    }
                    out.println(")");
                }
                out.println(")");
            }
            boolean bl = true;
            return bl;
        }
    }

    private boolean isOperator(String str) {
        boolean blnNumericAlpha = false;
        char[] chr = null;
        if (str != null) {
            chr = str.toCharArray();
        }
        for (int i = 0; i < chr.length; ++i) {
            if (!(chr[i] >= '0' && chr[i] <= '9' || chr[i] >= 'A' && chr[i] <= 'Z') && (chr[i] < 'a' || chr[i] > 'z')) continue;
            blnNumericAlpha = true;
            break;
        }
        return !blnNumericAlpha;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveFactsAsJessCodeExcept(Deftemplate deleted, Iterator factsIt, Writer w) {
        String extRefErrMsg = "One or more facts in the working memory contains a reference to an external object as a slot value.\n Hence the factscannot be stored in a text file.";
        try (PrintWriter out = null;){
            PrintWriter printWriter = out = w instanceof PrintWriter ? (PrintWriter)w : new PrintWriter(w);
            if (out == null) {
                boolean bl = false;
                return bl;
            }
            Context context = this.r.getGlobalContext();
            class FactVar {
                Fact f;
                String v;

                FactVar(Fact f, int i) {
                    this.f = f;
                    this.v = "?var" + i;
                }
            }
            LinkedHashMap<Integer, FactVar> map = new LinkedHashMap<Integer, FactVar>();
            if (factsIt == null) {
                factsIt = this.r.listFacts();
            }
            int i = 1;
            while (factsIt.hasNext()) {
                Fact f = (Fact)factsIt.next();
                if (!f.getDeftemplate().getBaseName().equals(deleted.getBaseName())) {
                    map.put(new Integer(f.getFactId()), new FactVar(f, i));
                }
                ++i;
            }
            out.println(";;;; Fact assertions: slot assignments are below.");
            out.println("");
            for (FactVar fv : map.values()) {
                String nameAssgnmt = "";
                int n = fv.f.getDeftemplate().getSlotIndex("name");
                if (n >= 0) {
                    Value nameVal = fv.f.getSlotValue("name");
                    nameAssgnmt = " (name " + nameVal.resolveValue(context) + ")";
                }
                out.println("(bind " + fv.v + " (assert(" + fv.f.getName() + nameAssgnmt + ")))");
            }
            out.println();
            out.println(";;;; Slot assignments");
            out.println();
            for (FactVar fv : map.values()) {
                Deftemplate dt = fv.f.getDeftemplate();
                int nSlots = dt.getNSlots();
                if (nSlots < 1) continue;
                out.println("; " + fv.f.getName());
                out.println("(modify " + fv.v);
                for (int i2 = 0; i2 < nSlots; ++i2) {
                    String slotName = dt.getSlotName(i2);
                    Value val = fv.f.getSlotValue(slotName).resolveValue(context);
                    out.print("    (" + slotName);
                    switch (val.type()) {
                        case 16: {
                            Fact valFact = val.factValue(context);
                            FactVar valFV = (FactVar)map.get(new Integer(valFact.getFactId()));
                            if (valFV == null) {
                                out.print(" nil");
                                break;
                            }
                            out.print(" " + valFV.v);
                            break;
                        }
                        case 512: {
                            ValueVector vv = val.listValue(context);
                            for (int j = 0; j < vv.size(); ++j) {
                                Value listVal = vv.get(j).resolveValue(context);
                                if (listVal.type() == 16) {
                                    Fact valFact = listVal.factValue(context);
                                    FactVar valFV = (FactVar)map.get(new Integer(valFact.getFactId()));
                                    if (valFV == null) continue;
                                    out.print(" " + valFV.v);
                                    continue;
                                }
                                if (listVal.type() == 2048) {
                                    JOptionPane.showMessageDialog(this.parentFrame, extRefErrMsg, "ERROR", 0);
                                    continue;
                                }
                                out.print(" " + listVal.toString());
                            }
                            break;
                        }
                        case 2048: {
                            JOptionPane.showMessageDialog(this.parentFrame, extRefErrMsg, "ERROR", 0);
                            boolean bl = false;
                            return bl;
                        }
                        default: {
                            out.print(" " + val.toString());
                        }
                    }
                    out.println(")");
                }
                out.println(")");
            }
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean saveFactsAsJessCodeRename(Deftemplate changed, String newName, Iterator factsIt, Writer w) {
        String extRefErrMsg = "One or more facts in the working memory contains a reference to an external object as a slot value.\n Hence the factscannot be stored in a text file.";
        try (PrintWriter out = null;){
            PrintWriter printWriter = out = w instanceof PrintWriter ? (PrintWriter)w : new PrintWriter(w);
            if (out == null) {
                boolean bl = false;
                return bl;
            }
            Context context = this.r.getGlobalContext();
            class FactVar {
                Fact f;
                String v;

                FactVar(Fact f, int i) {
                    this.f = f;
                    this.v = "?var" + i;
                }
            }
            LinkedHashMap<Integer, FactVar> map = new LinkedHashMap<Integer, FactVar>();
            if (factsIt == null) {
                factsIt = this.r.listFacts();
            }
            int i = 1;
            while (factsIt.hasNext()) {
                Fact f = (Fact)factsIt.next();
                map.put(new Integer(f.getFactId()), new FactVar(f, i));
                ++i;
            }
            out.println(";;;; Fact assertions: slot assignments are below.");
            out.println("");
            for (FactVar fv : map.values()) {
                String nameAssgnmt = "";
                int n = fv.f.getDeftemplate().getSlotIndex("name");
                if (n >= 0) {
                    Value nameVal = fv.f.getSlotValue("name");
                    nameAssgnmt = " (name " + nameVal.resolveValue(context) + ")";
                }
                if (fv.f.getDeftemplate() == changed) {
                    out.println("(bind " + fv.v + " (assert(" + fv.f.getName().substring(0, fv.f.getName().indexOf(fv.f.getDeftemplate().getBaseName())) + newName + nameAssgnmt + ")))");
                    continue;
                }
                out.println("(bind " + fv.v + " (assert(" + fv.f.getName() + nameAssgnmt + ")))");
            }
            out.println();
            out.println(";;;; Slot assignments");
            out.println();
            for (FactVar fv : map.values()) {
                Deftemplate dt = fv.f.getDeftemplate();
                int nSlots = dt.getNSlots();
                if (nSlots < 1) continue;
                out.println("; " + fv.f.getName());
                out.println("(modify " + fv.v);
                for (int i2 = 0; i2 < nSlots; ++i2) {
                    String slotName = dt.getSlotName(i2);
                    Value val = fv.f.getSlotValue(slotName).resolveValue(context);
                    out.print("    (" + slotName);
                    switch (val.type()) {
                        case 16: {
                            Fact valFact = val.factValue(context);
                            FactVar valFV = (FactVar)map.get(new Integer(valFact.getFactId()));
                            out.print(" " + valFV.v);
                            break;
                        }
                        case 512: {
                            ValueVector vv = val.listValue(context);
                            for (int j = 0; j < vv.size(); ++j) {
                                Value listVal = vv.get(j).resolveValue(context);
                                if (listVal.type() == 16) {
                                    Fact valFact = listVal.factValue(context);
                                    FactVar valFV = (FactVar)map.get(new Integer(valFact.getFactId()));
                                    out.print(" " + valFV.v);
                                    continue;
                                }
                                if (listVal.type() == 2048) {
                                    JOptionPane.showMessageDialog(this.parentFrame, extRefErrMsg, "ERROR", 0);
                                    continue;
                                }
                                out.print(" " + listVal.toString());
                            }
                            break;
                        }
                        case 2048: {
                            JOptionPane.showMessageDialog(this.parentFrame, extRefErrMsg, "ERROR", 0);
                            boolean bl = false;
                            return bl;
                        }
                        default: {
                            out.print(" " + val.toString());
                        }
                    }
                    out.println(")");
                }
                out.println(")");
            }
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveFactsAsJessCodeChangeSlot(Deftemplate changed, String oldSlotName, String newSlotName, String slotType, Iterator factsIt, Writer w) {
        String extRefErrMsg = "One or more facts in the working memory contains a reference to an external object as a slot value.\n Hence the factscannot be stored in a text file.";
        try (PrintWriter out = null;){
            PrintWriter printWriter = out = w instanceof PrintWriter ? (PrintWriter)w : new PrintWriter(w);
            if (out == null) {
                boolean bl = false;
                return bl;
            }
            Context context = this.r.getGlobalContext();
            class FactVar {
                Fact f;
                String v;

                FactVar(Fact f, int i) {
                    this.f = f;
                    this.v = "?var" + i;
                }
            }
            LinkedHashMap<Integer, FactVar> map = new LinkedHashMap<Integer, FactVar>();
            if (factsIt == null) {
                factsIt = this.r.listFacts();
            }
            int i = 1;
            while (factsIt.hasNext()) {
                Fact f = (Fact)factsIt.next();
                map.put(new Integer(f.getFactId()), new FactVar(f, i));
                ++i;
            }
            out.println(";;;; Fact assertions: slot assignments are below.");
            out.println("");
            for (FactVar fv : map.values()) {
                String nameAssgnmt = "";
                int n = fv.f.getDeftemplate().getSlotIndex("name");
                if (n >= 0) {
                    Value nameVal = fv.f.getSlotValue("name");
                    nameAssgnmt = " (name " + nameVal.resolveValue(context) + ")";
                }
                out.println("(bind " + fv.v + " (assert(" + fv.f.getName() + nameAssgnmt + ")))");
            }
            out.println();
            out.println(";;;; Slot assignments");
            out.println();
            for (FactVar fv : map.values()) {
                Deftemplate dt = fv.f.getDeftemplate();
                int nSlots = dt.getNSlots();
                if (nSlots < 1) continue;
                out.println("; " + fv.f.getName());
                out.println("(modify " + fv.v);
                for (int i2 = 0; i2 < nSlots; ++i2) {
                    String slotName = dt.getSlotName(i2);
                    Value val = fv.f.getSlotValue(slotName).resolveValue(context);
                    if (dt.getBaseName().equals(changed.getBaseName()) && slotName.equals(oldSlotName)) {
                        slotName = newSlotName;
                    }
                    out.print("    (" + slotName);
                    switch (val.type()) {
                        case 16: {
                            Fact valFact = val.factValue(context);
                            FactVar valFV = (FactVar)map.get(new Integer(valFact.getFactId()));
                            out.print(" " + valFV.v);
                            break;
                        }
                        case 512: {
                            ValueVector vv = val.listValue(context);
                            for (int j = 0; j < vv.size(); ++j) {
                                Value listVal = vv.get(j).resolveValue(context);
                                if (listVal.type() == 16) {
                                    Fact valFact = listVal.factValue(context);
                                    FactVar valFV = (FactVar)map.get(new Integer(valFact.getFactId()));
                                    out.print(" " + valFV.v);
                                    continue;
                                }
                                if (listVal.type() == 2048) {
                                    JOptionPane.showMessageDialog(this.parentFrame, extRefErrMsg, "ERROR", 0);
                                    continue;
                                }
                                out.print(" " + listVal.toString());
                            }
                            break;
                        }
                        case 2048: {
                            JOptionPane.showMessageDialog(this.parentFrame, extRefErrMsg, "ERROR", 0);
                            boolean bl = false;
                            return bl;
                        }
                        default: {
                            out.print(" " + val.toString());
                        }
                    }
                    out.println(")");
                }
                out.println(")");
            }
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean saveFactsAsJessCodeDeleteSlot(Deftemplate changed, String deletedSlotName, Iterator factsIt, Writer w) {
        String extRefErrMsg = "One or more facts in the working memory contains a reference to an external object as a slot value.\n Hence the factscannot be stored in a text file.";
        try (PrintWriter out = null;){
            PrintWriter printWriter = out = w instanceof PrintWriter ? (PrintWriter)w : new PrintWriter(w);
            if (out == null) {
                boolean bl = false;
                return bl;
            }
            Context context = this.r.getGlobalContext();
            class FactVar {
                Fact f;
                String v;

                FactVar(Fact f, int i) {
                    this.f = f;
                    this.v = "?var" + i;
                }
            }
            LinkedHashMap<Integer, FactVar> map = new LinkedHashMap<Integer, FactVar>();
            if (factsIt == null) {
                factsIt = this.r.listFacts();
            }
            int i = 1;
            while (factsIt.hasNext()) {
                Fact f = (Fact)factsIt.next();
                map.put(new Integer(f.getFactId()), new FactVar(f, i));
                ++i;
            }
            out.println(";;;; Fact assertions: slot assignments are below.");
            out.println("");
            for (FactVar fv : map.values()) {
                String nameAssgnmt = "";
                int n = fv.f.getDeftemplate().getSlotIndex("name");
                if (n >= 0) {
                    Value nameVal = fv.f.getSlotValue("name");
                    nameAssgnmt = " (name " + nameVal.resolveValue(context) + ")";
                }
                out.println("(bind " + fv.v + " (assert(" + fv.f.getName() + nameAssgnmt + ")))");
            }
            out.println();
            out.println(";;;; Slot assignments");
            out.println();
            for (FactVar fv : map.values()) {
                Deftemplate dt = fv.f.getDeftemplate();
                int nSlots = dt.getNSlots();
                if (nSlots < 1) continue;
                out.println("; " + fv.f.getName());
                out.println("(modify " + fv.v);
                for (int i2 = 0; i2 < nSlots; ++i2) {
                    String slotName = dt.getSlotName(i2);
                    Value val = fv.f.getSlotValue(slotName).resolveValue(context);
                    if (dt.getBaseName().equals(changed.getBaseName()) && slotName.equals(deletedSlotName)) continue;
                    out.print("    (" + slotName);
                    switch (val.type()) {
                        case 16: {
                            Fact valFact = val.factValue(context);
                            FactVar valFV = (FactVar)map.get(new Integer(valFact.getFactId()));
                            out.print(" " + valFV.v);
                            break;
                        }
                        case 512: {
                            ValueVector vv = val.listValue(context);
                            for (int j = 0; j < vv.size(); ++j) {
                                Value listVal = vv.get(j).resolveValue(context);
                                if (listVal.type() == 16) {
                                    Fact valFact = listVal.factValue(context);
                                    FactVar valFV = (FactVar)map.get(new Integer(valFact.getFactId()));
                                    out.print(" " + valFV.v);
                                    continue;
                                }
                                if (listVal.type() == 2048) {
                                    JOptionPane.showMessageDialog(this.parentFrame, extRefErrMsg, "ERROR", 0);
                                    continue;
                                }
                                out.print(" " + listVal.toString());
                            }
                            break;
                        }
                        case 2048: {
                            JOptionPane.showMessageDialog(this.parentFrame, extRefErrMsg, "ERROR", 0);
                            boolean bl = false;
                            return bl;
                        }
                        default: {
                            out.print(" " + val.toString());
                        }
                    }
                    out.println(")");
                }
                out.println(")");
            }
            boolean bl = true;
            return bl;
        }
    }

    public static void main(String[] args) {
        int i = 0;
        for (i = 0; i < args.length; ++i) {
            System.out.println(Utils.escapeString(args[i]));
        }
    }

    public static String unescapeString(String s) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        if (len < 2 || s.charAt(0) != '\"' || s.charAt(--len) != '\"') {
            return null;
        }
        StringBuffer result = new StringBuffer("");
        for (int i = 1; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                if (++i >= len) {
                    return null;
                }
                result.append(s.charAt(i));
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public Value makeValue(int slotType, int dataType, Object newValObj) {
        Value result = null;
        String newValStr = null;
        if (trace.getDebugCode("wme")) {
            trace.out("wme", "makeValue() newValObj class " + (newValObj == null ? "(null)" : newValObj.getClass().getName()));
        }
        if (newValObj instanceof Value) {
            return (Value)newValObj;
        }
        if (newValObj instanceof Fact) {
            try {
                return new FactIDValue((Fact)newValObj);
            }
            catch (JessException je) {
                trace.errStack("makeValue(Fact)", je);
            }
        }
        try {
            newValStr = newValObj == null ? null : (String)newValObj;
        }
        catch (ClassCastException cce) {
            JOptionPane.showMessageDialog(this.parentFrame, "Data type of new value is not String:\n update not supported", "ERROR", 0);
            return null;
        }
        try {
            if (slotType == 32768) {
                if (newValStr == null || newValStr.length() < 1) {
                    result = new Value(Funcall.NILLIST);
                } else {
                    StringTokenizer tkzr = new StringTokenizer(newValStr);
                    ValueVector vv = new ValueVector();
                    Value val = null;
                    while (tkzr.hasMoreTokens()) {
                        val = this.makeValue(16384, 1, tkzr.nextToken());
                        if (val == null) {
                            return null;
                        }
                        vv.add(val);
                    }
                    result = new Value(vv, 512);
                }
            } else if (newValStr == null || newValStr.length() < 1 || newValStr.equalsIgnoreCase("nil")) {
                result = new Value(Funcall.NIL);
            } else if (newValStr.charAt(0) == '\"' && newValStr.length() > 1) {
                String unescaped = WMEEditor.unescapeString(newValStr);
                if (unescaped == null) {
                    JOptionPane.showMessageDialog(this.parentFrame, "Malformed string " + newValStr + ".", "Input Error.", 0);
                } else {
                    result = new Value(unescaped, 2);
                }
            } else {
                Matcher m = factDisplayPattern.matcher(newValStr);
                if (m.matches()) {
                    int factId = Integer.parseInt(m.group(1));
                    Fact fact = this.r.findFactByID(factId);
                    if (fact == null) {
                        JOptionPane.showMessageDialog(this.parentFrame, "<Fact-" + factId + "> not found", "Input Error.", 0);
                    } else {
                        result = new FactIDValue(fact);
                    }
                } else {
                    result = new Value(newValStr, 1);
                }
            }
        }
        catch (NumberFormatException nfe) {
            System.err.println("shouldn't happen: fix the factDisplayPattern; newValStr \"" + newValStr + "\"");
            nfe.printStackTrace();
        }
        catch (JessException je) {
            String errMsg = "Jess error connverting input \"" + newValStr + "\" to value: " + (Object)((Object)je) + " Cause: " + je.getCause();
            JOptionPane.showMessageDialog(this.parentFrame, errMsg, "Jess Error.", 0);
            System.err.println("WMEEditor.makeValue() " + errMsg);
            je.printStackTrace();
        }
        return result;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (this.slotTable.getSelectedRow() != -1) {
            this.selectedSlotNum = this.slotTable.getSelectedRow();
            this.getPanel().constructSlotPopupMenu(true);
        } else {
            this.getPanel().constructSlotPopupMenu(false);
        }
        this.getPanel().repaint();
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        Object newValue = evt.getNewValue();
        if (name.equals(DISPLAY_FACT_IDS)) {
            this.setShowFactIDs((Boolean)newValue);
        }
        if (name.equals(DISPLAY_FACT_NAMES)) {
            this.setShowFactNames((Boolean)newValue);
        }
        if (name.equals(PROBLEM_FOLDER)) {
            this.displayCognitiveModelFolder();
            this.getPanel().refresh();
        }
        this.getPanel().validate();
        this.getPanel().repaint();
    }

    private String getSlotTypeString(Deftemplate dt, int slot) {
        try {
            if (dt.getSlotType(slot) == 32768) {
                return "multislot";
            }
            if (dt.getSlotDataType(slot) == 1) {
                return "atom";
            }
            if (dt.getSlotDataType(slot) == 2) {
                return "string";
            }
            if (dt.getSlotDataType(slot) == 4) {
                return "integer";
            }
            if (dt.getSlotDataType(slot) == 32) {
                return "float";
            }
            if (dt.getSlotDataType(slot) == 65536) {
                return "long";
            }
        }
        catch (JessException e) {
            trace.errStack("getSlotTypeString(" + dt + "," + slot + ")", e);
        }
        return "slot";
    }

    MTRete getPostRete() {
        return this.postRete;
    }

    private void setPostRete(MTRete postRete) {
        this.postRete = postRete;
    }

    MTRete getPreRete() {
        return this.preRete;
    }

    private void setPreRete(MTRete preRete) {
        this.preRete = preRete;
    }

    JTree getWMETree() {
        return this.wmeTree;
    }

    JHorizontalTable getSlotTable() {
        return this.slotTable;
    }

    public WMEEditorPanel getPanel() {
        if (trace.getDebugCode("wme")) {
            trace.out("wme", "WMEEditor.getPanel() inWhyNot " + this.isWhyNot + ", postRete " + this.postRete + ", editorPanel " + this.editorPanel);
        }
        if (!this.isWhyNot) {
            return this.controller.getServer().getCtatFrameController().getDockManager().getMainWMEEditorPanel();
        }
        if (this.editorPanel == null) {
            this.editorPanel = new WMEEditorPanel(this.controller.getServer(), this, this.setSize, this.isWhyNot);
        }
        return this.editorPanel;
    }

    Fact getSelectedFact() {
        return this.selectedFact;
    }

    void setSelectedFact(Fact fact) {
        this.selectedFact = fact;
    }

    Deftemplate getSelectedTemplate() {
        return this.selectedTemplate;
    }

    void setSelectedTemplate(Deftemplate template) {
        this.selectedTemplate = template;
    }

    int getSelectedSlotNumber() {
        return this.selectedSlotNum;
    }

    MTRete getRete() {
        return this.r;
    }

    SlotTableModel getNewTableModel(String[] columnNames, int numCols) {
        return new SlotTableModel(columnNames, numCols);
    }

    private class FactTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = 7434741040775489474L;

        private FactTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 2;
        }

        @Override
        public boolean importData(JComponent c, Transferable t) {
            if (this.canImport(c, t.getTransferDataFlavors())) {
                try {
                    String str = (String)t.getTransferData(DataFlavor.stringFlavor);
                    Iterator it = WMEEditor.this.r.listFacts();
                    String factID = str.substring(str.indexOf(60));
                    try {
                        while (it.hasNext()) {
                            Fact fact = (Fact)it.next();
                            Deftemplate dt = fact.getDeftemplate();
                            if (dt == null || !factID.equals(new FactIDValue(fact).toString())) continue;
                            JTable table = (JTable)c;
                            int index = table.getSelectedRow();
                            Value oldVal = (Value)table.getModel().getValueAt(index, 2);
                            if (oldVal.type() != 512) {
                                table.getModel().setValueAt(fact, index, 2);
                            } else {
                                String factList = oldVal.toString();
                                factList = factList + new FactIDValue(fact).toString();
                                StringTokenizer tkzr = new StringTokenizer(factList);
                                ValueVector vv = new ValueVector();
                                Value val = null;
                                while (tkzr.hasMoreTokens()) {
                                    val = WMEEditor.this.makeValue(16384, 16, tkzr.nextToken());
                                    if (val == null) {
                                        return false;
                                    }
                                    vv.add(val);
                                }
                                table.getModel().setValueAt(new Value(vv, 512), index, 2);
                            }
                            return true;
                        }
                    }
                    catch (JessException je) {
                        trace.errStack("importData()", je);
                        return false;
                    }
                    return false;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
        }

        @Override
        public boolean canImport(JComponent c, DataFlavor[] flavors) {
            for (int i = 0; i < flavors.length; ++i) {
                if (!DataFlavor.stringFlavor.equals(flavors[i])) continue;
                return true;
            }
            return false;
        }
    }

    public class RefreshAction
    extends AbstractAction {
        private static final long serialVersionUID = 6477130125081984667L;

        public RefreshAction() {
            this.putValue("Name", "Refresh");
            this.putValue("ShortDescription", "Refreshes window with current data");
            this.putValue("MnemonicKey", new Integer(82));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, 2));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            WMEEditor.this.getPanel().refresh();
        }
    }

    public class SaveTemplatesAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public SaveTemplatesAction() {
            this.putValue("Name", "Save Templates");
            this.putValue("ShortDescription", "Saves fact definitions (deftemplates)");
            this.putValue("MnemonicKey", new Integer(84));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, 2));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String filename = WMEEditor.this.saveTemplates(true);
            WMEEditor.this.mt.authorActionLog("WORKING_MEMORY_EDITOR", WMEEditor.SAVE_TEMPLATES, filename, "", "");
        }
    }

    public class SaveFactsAction
    extends AbstractAction {
        private static final long serialVersionUID = 927991208867294707L;

        public SaveFactsAction() {
            this.putValue("Name", "Save Facts");
            this.putValue("ShortDescription", "Saves fact instances");
            this.putValue("MnemonicKey", new Integer(83));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 2));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String filename = WMEEditor.this.saveFacts();
            WMEEditor.this.mt.authorActionLog("WORKING_MEMORY_EDITOR", WMEEditor.SAVE_FACTS, filename, "", "");
        }
    }

    static class FactFileFilter
    extends FileFilter {
        FactFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (trace.getDebugCode("wme")) {
                trace.out("wme", "WMEEditor.FactFileFilter.accept(" + f + ")");
            }
            if (f == null) {
                return false;
            }
            if (f.isDirectory()) {
                return true;
            }
            return f.toString().endsWith(".wme");
        }

        @Override
        public String getDescription() {
            return "Fact files (*.wme)";
        }
    }

    static class TemplateFileFilter
    extends FileFilter {
        TemplateFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f == null) {
                return false;
            }
            if (f.isDirectory()) {
                return true;
            }
            return f.toString().endsWith(".clp");
        }

        @Override
        public String getDescription() {
            return "Template files (*.clp)";
        }
    }

    private class WMETreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 983323185387528060L;
        protected Icon emptyTemplateIcon;

        private WMETreeCellRenderer() {
            this.emptyTemplateIcon = this.closedIcon;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (leaf && WMEEditor.this.isEmptyTemplate(value)) {
                this.setIcon(this.emptyTemplateIcon);
            }
            return this;
        }
    }

    class SlotTableModel
    extends DefaultTableModel
    implements TableModelListener {
        private static final long serialVersionUID = -6552842063544081938L;
        final int SLOTNAME_COL = 0;
        final int SLOTTYPE_COL = 1;
        final int SLOTVALUE_COL = 2;
        private Fact fact;
        private Fact originalFact;
        private Deftemplate dt;
        private ArrayList<Fact> factHistory;
        private int currentHistoryIndex;

        SlotTableModel(String[] columnNames, int rowCount) {
            super(columnNames, rowCount);
            this.SLOTNAME_COL = 0;
            this.SLOTTYPE_COL = 1;
            this.SLOTVALUE_COL = 2;
            this.fact = null;
            this.originalFact = null;
            this.dt = null;
            this.factHistory = new ArrayList();
            this.currentHistoryIndex = -1;
            this.addTableModelListener(this);
        }

        void clear() {
            this.setRowCount(0);
            this.originalFact = null;
            this.fact = null;
            this.dt = null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }

        @Override
        public void tableChanged(TableModelEvent evt) {
            block15: {
                if (evt.getType() != 0) {
                    return;
                }
                int row = evt.getFirstRow();
                int col = evt.getColumn();
                SlotTableModel stm = (SlotTableModel)evt.getSource();
                if (stm.dt == null) {
                    if (trace.getDebugCode("wme")) {
                        trace.out("wme", "event source state bad on tableChanged:, fact " + stm.fact + ", dt:\n " + stm.dt);
                    }
                    return;
                }
                try {
                    if (col == 2 && WMEEditor.this.selectedFact != null) {
                        String slotName;
                        int slotIdx;
                        if (stm.fact == null) {
                            stm.fact = new Fact(stm.dt);
                        }
                        if ((slotIdx = stm.dt.getSlotIndex(slotName = (String)stm.getValueAt(row, 0))) < 0) {
                            throw new ArrayIndexOutOfBoundsException("Unknown slot name " + slotName + " in deftemplate:\n" + stm.dt.toString());
                        }
                        int type = stm.dt.getSlotType(slotIdx);
                        int dataType = stm.dt.getSlotDataType(slotIdx);
                        Object newValObj = stm.getValueAt(row, col);
                        if (trace.getDebugCode("wme")) {
                            trace.out("wme", "tbl chg update dt " + stm.dt.getBaseName() + ", slot " + slotName + ": source " + stm + ", newValObj " + newValObj.toString() + ";");
                        }
                        WMEEditor.this.mt.getRete().getEventLogger().log(true, "WORKING_MEMORY_EDITOR", WMEEditor.EDIT_FACT, "Fact ID: " + WMEEditor.this.selectedFact.getFactId() + ", Fact name: " + WMEEditor.this.selectedFact.getSlotValue("name") + ", Slot name: " + WMEEditor.this.selectedFact.getDeftemplate().getSlotName(WMEEditor.this.selectedSlotNum), newValObj.toString(), "");
                        Value newVal = WMEEditor.this.makeValue(type, dataType, newValObj);
                        if (newVal == null) {
                            return;
                        }
                        stm.fact.setSlotValue(slotName, newVal);
                        this.modify();
                        break block15;
                    }
                    StringWriter swt = new StringWriter();
                    StringWriter swf = new StringWriter();
                    String dft = null;
                    if (WMEEditor.this.selectedFact == null && stm.getValueAt(row, 2) != null) {
                        dft = stm.getValueAt(row, 2).toString();
                    }
                    WMEEditor.this.saveTemplatesChangeSlot(WMEEditor.this.selectedTemplate, WMEEditor.this.selectedTemplate.getSlotName(row), stm.getValueAt(row, 0).toString(), stm.getValueAt(row, 1).toString(), dft, swt);
                    WMEEditor.this.saveFactsAsJessCodeChangeSlot(WMEEditor.this.selectedTemplate, WMEEditor.this.selectedTemplate.getSlotName(row), stm.getValueAt(row, 0).toString(), stm.getValueAt(row, 1).toString(), WMEEditor.this.r.listFacts(), swf);
                    try {
                        WMEEditor.this.r.clear();
                        WMEEditor.this.r.parse(new BufferedReader(new StringReader(swt.toString())));
                        WMEEditor.this.r.parse(new BufferedReader(new StringReader(swf.toString())));
                    }
                    catch (JessException je) {
                        if (trace.getDebugCode("wme")) {
                            trace.out("wme", je.toString());
                        }
                    }
                }
                catch (ArrayIndexOutOfBoundsException aie) {
                    aie.printStackTrace();
                }
                catch (JessException je) {
                    System.err.println("Error in slot table update, cause: " + je.getCause());
                    je.printStackTrace();
                }
            }
        }

        void goBackInHistory() {
            Fact factToLoad;
            if (this.currentHistoryIndex == 0 || this.factHistory.isEmpty()) {
                return;
            }
            --this.currentHistoryIndex;
            WMEEditor.this.selectedFact = factToLoad = this.factHistory.get(this.currentHistoryIndex);
            WMEEditor.this.setSelectedTemplate(factToLoad.getDeftemplate());
            WMEEditor.this.getPanel().refresh();
            WMEEditor.this.mt.getRete().getEventLogger().log(true, "WORKING_MEMORY_EDITOR", "BACK", factToLoad.toString(), "", "");
        }

        void goForwardInHistory() {
            Fact factToLoad;
            if (this.currentHistoryIndex >= this.factHistory.size() - 1 || this.factHistory.isEmpty()) {
                return;
            }
            ++this.currentHistoryIndex;
            WMEEditor.this.selectedFact = factToLoad = this.factHistory.get(this.currentHistoryIndex);
            WMEEditor.this.setSelectedTemplate(factToLoad.getDeftemplate());
            WMEEditor.this.getPanel().refresh();
            WMEEditor.this.mt.getRete().getEventLogger().log(true, "WORKING_MEMORY_EDITOR", "FORWARD", factToLoad.toString(), "", "");
        }

        public void enterFactIntoHistory(Fact fact) {
            int oldIndex = this.currentHistoryIndex;
            int nRemoved = 0;
            if (this.factHistory.isEmpty() || !this.factHistory.get(this.currentHistoryIndex).equals((Object)fact)) {
                while (this.factHistory.size() - 1 > this.currentHistoryIndex) {
                    this.factHistory.remove(this.factHistory.size() - 1);
                    ++nRemoved;
                }
                this.factHistory.add(fact);
                ++this.currentHistoryIndex;
            }
            if (trace.getDebugCode("wme")) {
                trace.outA("WMEEditor.SlotTableModel.enterFactIntoHistory(): index " + oldIndex + " => " + this.currentHistoryIndex + ", nRemoved " + nRemoved + " new fact-" + fact.getFactId() + " " + fact.toStringWithParens());
            }
        }

        void loadFact(Fact fact) {
            String errMsg;
            Object[] rowData = new Object[3];
            String slotName = null;
            int i = 0;
            this.clear();
            try {
                this.dt = fact.getDeftemplate();
                this.originalFact = fact;
                this.fact = new Fact(this.dt);
            }
            catch (JessException je) {
                errMsg = "Jess error creating fact; cause: " + je.getCause();
                System.err.println(errMsg);
                je.printStackTrace();
            }
            try {
                for (i = 0; i < this.dt.getNSlots(); ++i) {
                    slotName = this.dt.getSlotName(i);
                    rowData[0] = slotName;
                    Value val = fact.getSlotValue(slotName).resolveValue(null);
                    this.fact.setSlotValue(slotName, val);
                    rowData[1] = WMEEditor.this.getSlotTypeString(this.dt, i);
                    rowData[2] = val.type() == 2 && val.toString().length() > 1 && !val.toString().equals("nil") ? val.toString() : val;
                    this.addRow(rowData);
                }
            }
            catch (JessException je) {
                errMsg = "Jess error on slot " + i + "; cause: " + je.getCause();
                System.err.println(errMsg);
                je.printStackTrace();
            }
            this.enterFactIntoHistory(fact);
        }

        void loadTemplate(Deftemplate dt) {
            Object[] data = new Object[3];
            this.clear();
            this.dt = dt;
            this.fact = null;
            for (int i = 0; i < dt.getNSlots(); ++i) {
                try {
                    data[0] = dt.getSlotName(i);
                    data[1] = WMEEditor.this.getSlotTypeString(dt, i);
                    data[2] = dt.getSlotDefault(i);
                    if (dt.getSlotDataType(i) == 2 && data[2].toString().length() > 1 && !data[2].toString().equals("nil")) {
                        data[2] = data[2].toString();
                    }
                    if (data[2].equals("nil")) {
                        data[2] = "";
                    }
                    this.addRow(data);
                    continue;
                }
                catch (JessException je) {
                    System.err.println("Error on slot " + i + ": cause " + je.getCause());
                    je.printStackTrace();
                    break;
                }
            }
        }

        private Fact modify() throws JessException {
            Fact result = null;
            String slotName = null;
            int i = 0;
            Value newVal = null;
            try {
                for (i = 0; i < this.dt.getNSlots(); ++i) {
                    slotName = this.dt.getSlotName(i);
                    Value oldVal = this.originalFact.getSlotValue(slotName);
                    if (oldVal.equals(newVal = this.fact.getSlotValue(slotName))) continue;
                    if (trace.getDebugCode("mt")) {
                        trace.out("mt", "calling Rete.modify");
                    }
                    result = WMEEditor.this.r.modify(this.originalFact, slotName, newVal);
                }
            }
            catch (JessException je) {
                throw new JessException("WMEEditor.SlotTableModel.modify()", je.getMessage() + " slotName " + slotName + ", new value \"" + newVal + "\"", (Throwable)je);
            }
            WMEEditor.this.getPanel().refresh();
            return result;
        }
    }
}

