/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss;

import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.jess.RuleActivationNode;
import edu.cmu.pact.miss.Rule;
import edu.cmu.pact.miss.SimSt;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JOptionPane;

public class ActivationList
implements Comparator<RuleActivationNode>,
SortedSet<RuleActivationNode> {
    private TreeSet<RuleActivationNode> activationList;
    private List<RuleActivationNode> activationListUnsort;
    private SimSt simSt;
    boolean sort = true;

    public ActivationList(Vector list, SimSt ss) {
        this.simSt = ss;
        this.activationList = new TreeSet<RuleActivationNode>(this);
        this.activationListUnsort = new LinkedList<RuleActivationNode>();
        for (int i = 0; i < list.size(); ++i) {
            this.activationList.add((RuleActivationNode)list.get(i));
            this.activationListUnsort.add((RuleActivationNode)list.get(i));
        }
    }

    @Override
    public int compare(RuleActivationNode ran1, RuleActivationNode ran2) {
        if (this.sort) {
            String rule2Name;
            Rule rule2;
            double rule2Rating;
            String rule1Name = Rule.getRuleBaseName(ran1.getName()).replaceAll("MAIN::", "");
            Rule rule1 = this.simSt.getRule(rule1Name);
            double rule1Rating = rule1.getAcceptedRatio() + rule1.getSelectionAcceptRatio(ran1.getRuleFoas());
            if (rule1Rating < (rule2Rating = (rule2 = this.simSt.getRule(rule2Name = Rule.getRuleBaseName(ran2.getName()).replaceAll("MAIN::", ""))).getAcceptedRatio() + rule2.getSelectionAcceptRatio(ran2.getRuleFoas()))) {
                return 1;
            }
            if (rule1Rating > rule2Rating) {
                return -1;
            }
            if (rule1.getUses() < rule2.getUses()) {
                return 1;
            }
            if (rule1.getUses() > rule2.getUses()) {
                return -1;
            }
            int compare = rule1Name.compareTo(rule2Name);
            if (compare == 0 && !ran1.equals(ran2)) {
                return 1;
            }
            trace.out("ss", "Resort to alphabetic");
            return compare;
        }
        String rule1Name = Rule.getRuleBaseName(ran1.getName()).replaceAll("MAIN::", "");
        Rule rule1 = this.simSt.getRule(rule1Name);
        String rule2Name = Rule.getRuleBaseName(ran2.getName()).replaceAll("MAIN::", "");
        Rule rule2 = this.simSt.getRule(rule2Name);
        if (rule1.identity < rule2.identity) {
            return 1;
        }
        if (rule1.identity > rule2.identity) {
            return -1;
        }
        int compare = rule1Name.compareTo(rule2Name);
        if (compare == 0 && !ran1.equals(ran2)) {
            return 1;
        }
        return compare;
    }

    public void printList() {
        System.out.println("--------------------------------------------");
        System.out.println("Activation List");
        for (RuleActivationNode ran : this) {
            String ruleName = Rule.getRuleBaseName(ran.getName()).replaceAll("MAIN::", "");
            Rule rule = this.simSt.getRule(ruleName);
            if (rule == null) {
                JOptionPane.showMessageDialog(null, "Rule " + ruleName + " is null");
            }
            int recencyValue = Rule.count;
            double ruleRating = rule.getAcceptedRatio() + rule.getSelectionAcceptRatio(ran.getRuleFoas());
            System.out.println(ruleName + ": " + ruleRating + " (" + rule.getAcceptedRatio() + "+" + rule.getSelectionAcceptRatio(ran.getRuleFoas()) + ") " + rule.getAcceptedUses() + " [" + (recencyValue -= rule.identity + rule.getAcceptedUses()) + "]");
        }
        System.out.println("--------------------------------------------");
    }

    @Override
    public Comparator<RuleActivationNode> comparator() {
        return this;
    }

    @Override
    public RuleActivationNode first() {
        return this.activationList.first();
    }

    @Override
    public SortedSet<RuleActivationNode> headSet(RuleActivationNode toElement) {
        return this.activationList.headSet(toElement);
    }

    @Override
    public RuleActivationNode last() {
        return this.activationList.last();
    }

    @Override
    public SortedSet<RuleActivationNode> subSet(RuleActivationNode fromElement, RuleActivationNode toElement) {
        return this.activationList.subSet(fromElement, toElement);
    }

    @Override
    public SortedSet<RuleActivationNode> tailSet(RuleActivationNode fromElement) {
        return this.activationList.tailSet(fromElement);
    }

    @Override
    public boolean add(RuleActivationNode e) {
        return this.activationList.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends RuleActivationNode> c) {
        return this.activationList.addAll(c);
    }

    @Override
    public void clear() {
        this.activationList.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.activationList.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.activationList.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.activationList.isEmpty();
    }

    @Override
    public Iterator<RuleActivationNode> iterator() {
        return this.activationList.iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.activationList.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.activationList.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.activationList.retainAll(c);
    }

    @Override
    public int size() {
        return this.activationList.size();
    }

    @Override
    public Object[] toArray() {
        return this.activationList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.activationList.toArray(a);
    }
}

