/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.miss.AskHintClAlgebraTutor;
import edu.cmu.pact.miss.InquiryClAlgebraTutor;
import edu.cmu.pact.miss.InquiryClSolverTutor;
import edu.cmu.pact.miss.Sai;
import edu.cmu.pact.miss.SimSt;
import edu.cmu.pact.miss.userDef.algebra.EqFeaturePredicate;
import java.util.Vector;

public class AskHintClSolverTutor
extends AskHintClAlgebraTutor {
    public AskHintClSolverTutor(BR_Controller brController, ProblemNode currentNode) {
        super(brController, currentNode);
    }

    @Override
    public void getHint(BR_Controller brController, ProblemNode currentNode) {
        InquiryClSolverTutor iclSolverTutor = new InquiryClSolverTutor(SimSt.getClSolverTutorHost(), SimSt.getClSolverTutorPort());
        int numSteps = iclSolverTutor.goToState(brController, currentNode);
        String hintMessage = iclSolverTutor.askNextStep();
        String clAction = hintMessage.split(";")[1];
        String skillName = null;
        if ("done".equals(clAction)) {
            skillName = "-kill-interactive-learning-";
        } else {
            skillName = numSteps == 0 ? clAction : iclSolverTutor.getCurrentSkill() + "-typein";
            this.setSelection(this.findSelection(brController, currentNode, clAction));
            this.setInput(this.findInput(hintMessage, numSteps));
            this.setSai(new Sai(this.getSelection(), this.getAction(), this.getInput()));
        }
        this.setSkillName(skillName);
    }

    private String findInput(String hintMessage, int numSteps) {
        String input = null;
        String[] msg = hintMessage.split(";");
        if (numSteps == 0) {
            input = msg[1];
            if (EqFeaturePredicate.isOperandArithmeticSkill(msg[1])) {
                input = input + " " + msg[2];
            }
        } else {
            input = msg[2];
        }
        return input;
    }

    private String findSelection(BR_Controller brController, ProblemNode currentNode, String clAction) {
        int stepDepth;
        String selection = "commTable1_";
        ProblemNode startNode = brController.getProblemModel().getStartNode();
        Vector path = InquiryClAlgebraTutor.findPathDepthFirst(startNode, currentNode);
        int n = stepDepth = path == null ? 0 : path.size();
        if (stepDepth % 3 == 0) {
            selection = selection + "C3R" + (stepDepth / 3 + 1);
        } else {
            int column = "left".equals(clAction) ? 1 : 2;
            selection = selection + "C" + column + "R" + (stepDepth / 3 + 2);
        }
        return selection;
    }
}

