/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.DStoBRD;

import com.megginson.sax.DataWriter;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.XMLElements.ActionLabelElement;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.XMLElements.EdgeElement;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.XMLElements.MatcherElement;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.XMLElements.MessageElement;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.XMLElements.NodeElement;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.XMLElements.PropertiesElement;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.XMLElements.StartNodeMessagesElement;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.XMLElements.StateGraphElement;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.XMLElements.VectorProperty;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.xml.sax.SAXException;

public class SimStudentBRDWriter {
    private String workingDir;
    private int numStudents = 0;
    private int numBrdTransactions = 0;
    private int numBrdFiles = 0;
    private int numBrokenBrdk = 0;
    private int lastCorrectNodeIDSource = 1;
    private int lastCorrectNodeID = 1;

    private String getWorkingDir() {
        return this.workingDir;
    }

    protected void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    private void resetNumStudents() {
        this.numStudents = 0;
    }

    protected void incNumStudents() {
        ++this.numStudents;
    }

    private int getNumStudents() {
        return this.numStudents;
    }

    protected void resetNumBrdTransactions() {
        this.numBrdTransactions = 0;
    }

    protected void incNumBrdTransactions() {
        ++this.numBrdTransactions;
    }

    private int getNumBrdTransactions() {
        return this.numBrdTransactions;
    }

    protected void resetNumBrdFiles() {
        this.numBrdFiles = 0;
    }

    private void incNumBrdFiles() {
        ++this.numBrdFiles;
    }

    private int getNumBrdFiles() {
        return this.numBrdFiles;
    }

    private void resetNumBrokenBrd() {
        this.numBrokenBrdk = 0;
    }

    private void incNumBrokenBrd() {
        ++this.numBrokenBrdk;
    }

    private int getNumBrokenBrd() {
        return this.numBrokenBrdk;
    }

    public void setLastCorrectNodeIDSource(int value) {
        this.lastCorrectNodeIDSource = value;
    }

    public int getLastCorrectNodeIDSource() {
        return this.lastCorrectNodeIDSource;
    }

    public void setLastCorrectNodeID(int value) {
        this.lastCorrectNodeID = value;
    }

    public int getLastCorrectNodeID() {
        return this.lastCorrectNodeID;
    }

    private StateGraphElement writeRootElement() {
        StateGraphElement xmlstategraph = new StateGraphElement();
        xmlstategraph.addcaseInsensitive(true);
        xmlstategraph.addfirstCheckAllStates(true);
        xmlstategraph.addlockWidget(true);
        xmlstategraph.addversion("1.0");
        xmlstategraph.addunordered(true);
        return xmlstategraph;
    }

    protected NodeEdgePairs nodeList(String problemName, ArrayList actionList) {
        ArrayList<NodeElement> nodeElemList = new ArrayList<NodeElement>();
        ArrayList<EdgeElement> edgeElemList = new ArrayList<EdgeElement>();
        boolean id = true;
        int nodeID = 1;
        int edgeID = 1;
        int x = 200;
        int y = 30;
        boolean startNodeID = true;
        this.setLastCorrectNodeID(nodeID);
        this.setLastCorrectNodeIDSource(nodeID);
        NodeElement startState = new NodeElement();
        startState.addtext(this.parseProblemName(problemName));
        startState.addlocked(false);
        startState.adddoneState(false);
        startState.adddimension(x, y);
        startState.adduniqueID(nodeID);
        nodeElemList.add(startState);
        ++nodeID;
        for (int i = 0; i < actionList.size(); ++i) {
            StudentTransactionItems item = (StudentTransactionItems)actionList.get(i);
            if (this.transactionNotActualBrdEdge(item)) continue;
            if (!item.validBrdTransaction()) {
                return null;
            }
            ActionLabelElement actionLabel = new ActionLabelElement();
            MessageElement message = new MessageElement();
            message.addverb("NotePropertySet");
            PropertiesElement properties = new PropertiesElement();
            properties.addProperty("MessageType", "InterfaceAction");
            VectorProperty selectionProp = new VectorProperty("Selection");
            selectionProp.addValue(item.selection);
            properties.addProperty("Selection", selectionProp);
            VectorProperty actionProp = new VectorProperty("Action");
            actionProp.addValue(item.action);
            properties.addProperty("Action", actionProp);
            VectorProperty inputProp = new VectorProperty("Input");
            inputProp.addValue(item.input);
            properties.addProperty("Input", inputProp);
            message.addproperties(properties);
            MatcherElement matcher = new MatcherElement();
            matcher.addmatcherType("ExactMatcher");
            matcher.addmatcherParameter("selection", item.selection);
            matcher.addmatcherParameter("action", item.action);
            matcher.addmatcherParameter("input", item.input);
            actionLabel.addmessage(message);
            actionLabel.addMatcher(matcher);
            EdgeElement edge = new EdgeElement();
            edge.addactionLabel(actionLabel);
            edge.addrule(item.subskillName + " eq", -1);
            edge.addprecheckedStatus("No-Applicable");
            NodeElement node = new NodeElement();
            String stateText = "state" + new Integer(i + 1).toString();
            node.addtext(stateText);
            if (this.proceedToNextNode(item)) {
                actionLabel.addpreferPathMark(true);
                actionLabel.addstudentHintRequest("false");
                actionLabel.addstepSuccessfulCompletion("false");
                actionLabel.addstepStudentError("false");
                actionLabel.addbuggyMessage("");
                actionLabel.addsuccessMessage("");
                actionLabel.addhintMessage("");
                actionLabel.addactionType(this.decodeCorrectness(item.outcome));
                actionLabel.adduniqueID(edgeID);
                actionLabel.addoldActionType("Correct Action");
                actionLabel.addcheckedStatus("Never Checked");
                this.setLastCorrectNodeIDSource(this.getLastCorrectNodeID());
                edge.addsourceID(this.getLastCorrectNodeID());
                edge.adddestID(nodeID);
                this.setLastCorrectNodeID(nodeID);
                node.adduniqueID(nodeID);
                node.adddimension(x, y + 100 * ++nodeID);
            } else {
                actionLabel.addpreferPathMark(false);
                actionLabel.addstudentHintRequest("false");
                actionLabel.addstepSuccessfulCompletion("false");
                actionLabel.addstepStudentError("false");
                actionLabel.addbuggyMessage("");
                actionLabel.addsuccessMessage("");
                actionLabel.addhintMessage("");
                actionLabel.addactionType(this.decodeCorrectness(item.outcome));
                actionLabel.addoldActionType("Correct Action");
                actionLabel.addcheckedStatus("Never Checked");
                actionLabel.adduniqueID(edgeID);
                edge.addsourceID(this.getLastCorrectNodeID());
                edge.adddestID(nodeID);
                node.adduniqueID(nodeID);
                node.adddimension(x + 100, y + 100 * ++nodeID);
            }
            ++edgeID;
            edge.addtraversalCount(0);
            edgeElemList.add(edge);
            node.addlocked(false);
            node.adddoneState(false);
            nodeElemList.add(node);
        }
        return new NodeEdgePairs(nodeElemList, edgeElemList);
    }

    protected String decodeCorrectness(String outcome) {
        String returnString = "";
        if (outcome.equals("OK")) {
            returnString = "Correct Action";
        } else if (outcome.equalsIgnoreCase("BUG")) {
            returnString = "Buggy Action";
        } else {
            if (outcome.equalsIgnoreCase("ERROR")) {
                return "Error Action";
            }
            if (outcome.equalsIgnoreCase("UNTRACEABLE_ERROR")) {
                return "Untraceable Error";
            }
            if (outcome.equalsIgnoreCase("hint")) {
                returnString = "Hint Action";
            }
        }
        return returnString;
    }

    protected boolean transactionNotActualBrdEdge(Object item) {
        return false;
    }

    protected boolean proceedToNextNode(Object item) {
        return ((StudentTransactionItems)item).outcome.equalsIgnoreCase("OK");
    }

    protected String parseProblemName(String probName) {
        return probName.substring(5);
    }

    private StateGraphElement buildGraphfromFile(ArrayList actionList, String probName) {
        StateGraphElement xmlstategraph = this.writeRootElement();
        try {
            StartNodeMessagesElement startMessage = this.startNodeMessages("StartNodeMsgTemplate.txt", this.parseProblemName(probName));
            NodeEdgePairs nodeEdgePairs = this.nodeList(probName, actionList);
            if (nodeEdgePairs == null) {
                return null;
            }
            if (nodeEdgePairs.edgeList.size() == 0) {
                return null;
            }
            xmlstategraph.addStartNodeMessages(startMessage);
            for (int j = 0; j < nodeEdgePairs.nodeList.size(); ++j) {
                NodeElement node = (NodeElement)nodeEdgePairs.nodeList.get(j);
                xmlstategraph.addNode(node);
            }
            for (int k = 0; k < nodeEdgePairs.edgeList.size(); ++k) {
                EdgeElement edge = (EdgeElement)nodeEdgePairs.edgeList.get(k);
                xmlstategraph.addEdge(edge);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return xmlstategraph;
    }

    protected StartNodeMessagesElement startNodeMessages(String inputTemplate, String probName) throws IOException {
        StartNodeMessagesElement StartmessageList = new StartNodeMessagesElement();
        BufferedReader in = new BufferedReader(new FileReader(inputTemplate));
        in.readLine();
        String fileLine = in.readLine();
        while (fileLine != null) {
            if (fileLine.endsWith("<message>")) {
                MessageElement message = new MessageElement();
                fileLine = in.readLine();
                if (fileLine.endsWith("</verb>")) {
                    message.addverb(fileLine.substring(fileLine.indexOf(">") + 1, fileLine.lastIndexOf("<")));
                }
                if ((fileLine = in.readLine()).endsWith("<properties>")) {
                    fileLine = in.readLine();
                    PropertiesElement properties = new PropertiesElement();
                    while (!fileLine.endsWith("</properties>")) {
                        String propName;
                        int lastIndex;
                        int firstIndex = fileLine.indexOf(">");
                        if (firstIndex < (lastIndex = fileLine.lastIndexOf("<"))) {
                            int LHSIndex;
                            propName = fileLine.substring(fileLine.indexOf("<") + 1, firstIndex);
                            String value = fileLine.substring(firstIndex + 1, lastIndex);
                            if (value.equalsIgnoreCase("$(PROB_NAME)$")) {
                                value = probName;
                            } else if (value.equalsIgnoreCase("$(GIVEN_1)$")) {
                                LHSIndex = probName.indexOf("=");
                                value = probName.charAt(LHSIndex - 1) == ' ' ? probName.substring(0, LHSIndex - 1) : probName.substring(0, LHSIndex);
                            } else if (value.equalsIgnoreCase("$(GIVEN_2)$")) {
                                LHSIndex = probName.indexOf("=");
                                value = probName.charAt(LHSIndex + 1) == ' ' ? probName.substring(LHSIndex + 2) : probName.substring(LHSIndex + 1);
                            }
                            properties.addProperty(propName, value);
                        } else {
                            propName = fileLine.substring(fileLine.indexOf("<") + 1, firstIndex);
                            VectorProperty vectorProp = new VectorProperty(propName);
                            fileLine = in.readLine();
                            while (!fileLine.endsWith("</" + propName + ">")) {
                                int LHSIndex;
                                int end;
                                int begin = fileLine.indexOf(">");
                                String value = fileLine.substring(begin + 1, end = fileLine.lastIndexOf("<"));
                                if (value.equalsIgnoreCase("$(PROB_NAME)$")) {
                                    value = probName;
                                } else if (value.equalsIgnoreCase("$(GIVEN_1)$")) {
                                    LHSIndex = probName.indexOf("=");
                                    value = probName.charAt(LHSIndex - 1) == ' ' ? probName.substring(0, LHSIndex - 1) : probName.substring(0, LHSIndex);
                                } else if (value.equalsIgnoreCase("$(GIVEN_2)$")) {
                                    LHSIndex = probName.indexOf("=");
                                    value = probName.charAt(LHSIndex + 1) == ' ' ? probName.substring(LHSIndex + 2) : probName.substring(LHSIndex + 1);
                                }
                                vectorProp.addValue(value);
                                fileLine = in.readLine();
                            }
                            properties.addProperty(propName, vectorProp);
                        }
                        fileLine = in.readLine();
                    }
                    message.addproperties(properties);
                }
                StartmessageList.addmessage(message);
            }
            fileLine = in.readLine();
        }
        return StartmessageList;
    }

    protected Object createTransactionItem(String fileLine) {
        String[] tokens = fileLine.split("\t");
        int base = 1;
        String student = tokens[base + 0];
        String problem = tokens[base + 1];
        String selection = tokens[base + 2];
        String action = tokens[base + 3];
        String input = tokens[base + 4];
        String skill = tokens[base + 5];
        String outcome = tokens[base + 6];
        StudentTransactionItems item = new StudentTransactionItems(student, problem, selection, action, input, skill, outcome);
        return item;
    }

    protected void printBRD(String fileName) throws IOException, SAXException {
        ArrayList<Object> transactionList = new ArrayList<Object>();
        BufferedReader in = new BufferedReader(new FileReader(fileName));
        String fileLine = null;
        String previousProblemName = null;
        String lastStudent = null;
        in.readLine();
        while ((fileLine = in.readLine()) != null) {
            this.incNumBrdTransactions();
            Object item = this.createTransactionItem(fileLine);
            if (lastStudent == null) {
                lastStudent = ((StudentTransactionItems)item).getStudentID();
                this.incNumStudents();
            }
            if (!((StudentTransactionItems)item).getStudentID().equals(lastStudent)) {
                lastStudent = ((StudentTransactionItems)item).getStudentID();
                this.incNumStudents();
            }
            if (previousProblemName == null) {
                previousProblemName = ((StudentTransactionItems)item).getProblemName();
            }
            if (this.newProblemTransaction(item, transactionList)) {
                this.generateBRD(transactionList, previousProblemName);
                transactionList.clear();
                previousProblemName = ((StudentTransactionItems)item).getProblemName();
            }
            if (!this.transactionImportant(item)) continue;
            transactionList.add(item);
        }
        this.generateBRD(transactionList, previousProblemName);
    }

    protected boolean transactionImportant(Object item) {
        return true;
    }

    protected boolean newProblemTransaction(Object inputItem, ArrayList transactionList) {
        boolean returnValue = false;
        if (!transactionList.isEmpty()) {
            String previousProblemName = ((StudentTransactionItems)transactionList.get(transactionList.size() - 1)).getProblemName();
            returnValue = !((StudentTransactionItems)inputItem).getProblemName().equals(previousProblemName);
        }
        return returnValue;
    }

    protected void generateBRD(ArrayList transactionList, String previousProblemName) throws FileNotFoundException, SAXException {
        StateGraphElement xmlstategraph = this.buildGraphfromFile(transactionList, previousProblemName);
        String studentName = ((StudentTransactionItems)transactionList.get((int)0)).studentID;
        if (xmlstategraph != null) {
            String brdFileName = this.brdFileName(previousProblemName);
            this.writeBrdToFile(xmlstategraph, brdFileName, studentName);
        } else {
            this.incNumBrokenBrd();
        }
    }

    private void writeBrdToFile(StateGraphElement xmlstategraph, String outputFile, String studentName) throws FileNotFoundException, SAXException {
        String filePathName = this.getWorkingDir() + "/" + studentName + "/" + this.getBrdNo() + "_" + outputFile;
        String parentDir = new File(filePathName).getParent();
        new File(parentDir).mkdirs();
        PrintWriter pw = new PrintWriter(new FileOutputStream(filePathName));
        DataWriter w = new DataWriter((Writer)pw);
        w.setIndentStep(4);
        w.startDocument();
        xmlstategraph.printXML(w);
        w.endDocument();
        pw.close();
        this.incNumBrdFiles();
    }

    private String getBrdNo() {
        String brdNo = "000000" + this.getNumBrdFiles();
        return brdNo.substring(brdNo.length() - 6);
    }

    private String brdFileName(String problemName) {
        String outputFile = problemName.replaceAll(" ", "") + ".brd";
        if (outputFile.indexOf(45) == 0) {
            outputFile = 'm' + outputFile.substring(1);
        }
        outputFile = outputFile.replaceAll("=", "_");
        outputFile = outputFile.replaceAll("/", "I");
        outputFile = outputFile.replaceAll("[()]", "C");
        outputFile = outputFile.substring(0, 4) + "_" + outputFile.substring(4);
        char[] outputChar = outputFile.toCharArray();
        for (int i = 0; i < outputChar.length; ++i) {
            if (outputChar[i] != '*') continue;
            outputChar[i] = 84;
        }
        return new String(outputChar);
    }

    public void testFunc(String fileName, String workingDir) throws IOException {
        this.setWorkingDir(workingDir);
        try {
            this.resetNumBrdTransactions();
            this.resetNumBrdFiles();
            this.resetNumBrokenBrd();
            this.resetNumStudents();
            this.printBRD(fileName);
            System.out.println(this.getNumBrdTransactions() + " BRD transactions read.");
            System.out.println(this.getNumBrdFiles() + " BRD files generated for " + this.getNumStudents() + " students.");
            System.out.println(this.getNumBrokenBrd() + " potential broken BRD files.");
        }
        catch (SAXException e) {
            String message = this.getClass().getName() + " : testFunc : " + e.getMessage();
            throw new IOException(message);
        }
    }

    public static void main(String[] args) {
        SimStudentBRDWriter ssBRDTest = new SimStudentBRDWriter();
        if (args.length != 2) {
            System.out.println("Usage: SimStBRDWriter <input_file> <output_dir>");
            System.out.println("Specify both the input file to read and a directory where the files would be saved.");
            System.exit(-1);
        }
        try {
            ssBRDTest.testFunc(args[0], args[1]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class NodeEdgePairs {
        ArrayList nodeList;
        ArrayList edgeList;

        public NodeEdgePairs(ArrayList nodeList, ArrayList edgeList) {
            this.nodeList = nodeList;
            this.edgeList = edgeList;
        }
    }

    public static class StudentTransactionItems {
        protected String studentID;
        protected String probName;
        protected String selection;
        protected String action;
        protected String input;
        protected String subskillName;
        protected String outcome;

        protected String getStudentID() {
            return this.studentID;
        }

        protected String getProblemName() {
            return this.probName;
        }

        public StudentTransactionItems(String studentID, String probName, String selection, String action, String input, String subskillName, String outcome) {
            this.studentID = studentID;
            this.probName = probName;
            this.selection = selection;
            this.action = action;
            this.input = input;
            this.subskillName = subskillName;
            this.outcome = outcome;
        }

        public boolean validBrdTransaction() {
            return this.subskillName.equalsIgnoreCase("hint") || this.selection.matches("commTable1_C.R.") && this.input != null && this.subskillName != null;
        }
    }
}

