/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.userDef.algebra.expression;

import edu.cmu.pact.miss.userDef.algebra.expression.AlgExp;
import edu.cmu.pact.miss.userDef.algebra.expression.ComplexFraction;
import edu.cmu.pact.miss.userDef.algebra.expression.ComplexTerm;
import edu.cmu.pact.miss.userDef.algebra.expression.Constant;
import edu.cmu.pact.miss.userDef.algebra.expression.DoubleConst;
import edu.cmu.pact.miss.userDef.algebra.expression.IntConst;
import edu.cmu.pact.miss.userDef.algebra.expression.Polynomial;
import edu.cmu.pact.miss.userDef.algebra.expression.SimpleTerm;
import edu.cmu.pact.miss.userDef.algebra.expression.Variable;
import mylib.MathLib;

public class ConstantFraction
extends Constant {
    protected Constant Numerator;
    protected Constant Denominator;

    public ConstantFraction(Constant n, Constant d) {
        this.Numerator = n;
        this.Denominator = d;
        this.isNegative = this.Numerator.isNegative() ^ this.Denominator.isNegative();
        this.isFraction = true;
    }

    ConstantFraction(AlgExp n, AlgExp d) {
        this((Constant)n, (Constant)d);
    }

    @Override
    public double getVal() {
        return this.Numerator.getVal() / this.Denominator.getVal();
    }

    public Constant getNumerator() {
        return this.Numerator;
    }

    public Constant getDenominator() {
        return this.Denominator;
    }

    public String toString() {
        if (this.Denominator.isNegative() && !this.Numerator.isNegative()) {
            return this.Numerator.negate() + "/" + this.Denominator.negate();
        }
        return this.Numerator + "/" + this.Denominator;
    }

    @Override
    public AlgExp add(ConstantFraction c) {
        Constant d1 = this.Denominator;
        Constant d2 = c.getDenominator();
        if (d1 instanceof IntConst && d2 instanceof IntConst) {
            int d1value = (int)d1.getVal();
            int d2value = (int)d2.getVal();
            int commonDenominator = MathLib.lcm((int)d1value, (int)d2value);
            int multiplier1 = commonDenominator / d1value;
            int multiplier2 = commonDenominator / d2value;
            int n1value = (int)this.Numerator.getVal();
            int n2value = (int)c.getNumerator().getVal();
            int newNValue = n1value * multiplier1 + n2value * multiplier2;
            return new ConstantFraction(new IntConst(newNValue), new IntConst(commonDenominator)).reduce();
        }
        return new Polynomial(this, c);
    }

    @Override
    public AlgExp mul(ConstantFraction c) {
        return new ConstantFraction(this.Numerator.mul(c.getNumerator()), this.Denominator.mul(c.getDenominator())).reduce();
    }

    @Override
    public AlgExp invert() {
        if (this.Numerator.equals(AlgExp.ONE)) {
            return this.Denominator;
        }
        return new ConstantFraction(this.Denominator, this.Numerator);
    }

    @Override
    public boolean equals(ConstantFraction f) {
        AlgExp thisSimple = this.reduce();
        AlgExp fSimple = f.reduce();
        if (thisSimple.isFraction() && fSimple.isFraction()) {
            ConstantFraction f1 = (ConstantFraction)thisSimple;
            ConstantFraction f2 = (ConstantFraction)fSimple;
            return f1.getNumerator().equals(f2.getNumerator()) && f1.getDenominator().equals(f2.getDenominator());
        }
        return thisSimple.equals(fSimple);
    }

    @Override
    public boolean equals(SimpleTerm t) {
        return t.equals(this);
    }

    @Override
    public boolean equals(Polynomial e) {
        return e.equals(this);
    }

    @Override
    public boolean equals(ComplexTerm ct) {
        return ct.equals(this);
    }

    @Override
    public boolean equals(ComplexFraction cf) {
        return cf.equals(this);
    }

    @Override
    public boolean equals(IntConst c) {
        AlgExp reduced = this.reduce();
        if (!reduced.isFraction()) {
            return reduced.equals(c);
        }
        return false;
    }

    @Override
    public boolean equals(DoubleConst c) {
        AlgExp reduced = this.reduce();
        if (!reduced.isFraction()) {
            return reduced.equals(c);
        }
        return DoubleConst.doubleEq(this.getVal(), c.getVal());
    }

    @Override
    public boolean equals(Variable v) {
        return false;
    }

    @Override
    public AlgExp div(Variable v) {
        return this.mul(v.invert());
    }

    @Override
    public AlgExp div(ConstantFraction f) {
        return this.mul(f.invert());
    }

    @Override
    public AlgExp div(SimpleTerm t) {
        return this.mul(t.invert());
    }

    @Override
    public AlgExp div(Polynomial e) {
        return this.mul(e.invert());
    }

    @Override
    public AlgExp div(ComplexTerm ct) {
        return this.mul(ct.invert());
    }

    @Override
    public AlgExp div(ComplexFraction cf) {
        return this.mul(cf.invert());
    }

    @Override
    public AlgExp add(Variable v) {
        return v.add(this);
    }

    @Override
    public AlgExp add(SimpleTerm t) {
        return t.add(this);
    }

    @Override
    public AlgExp add(Polynomial e) {
        return e.add(this);
    }

    @Override
    public AlgExp add(ComplexTerm ct) {
        return ct.add(this);
    }

    @Override
    public AlgExp add(ComplexFraction cf) {
        return cf.add(this);
    }

    @Override
    public AlgExp mul(Variable v) {
        return v.mul(this);
    }

    @Override
    public AlgExp mul(SimpleTerm t) {
        return t.mul(this);
    }

    @Override
    public AlgExp mul(Polynomial e) {
        return e.mul(this);
    }

    @Override
    public AlgExp mul(ComplexTerm ct) {
        return ct.mul(this);
    }

    @Override
    public AlgExp mul(ComplexFraction cf) {
        return cf.mul(this);
    }

    @Override
    public AlgExp mul(IntConst c) {
        int d2Val;
        int d1Val = (int)this.Denominator.getVal();
        if (d1Val % (d2Val = (int)c.getVal()) == 0) {
            int div = d1Val / d2Val;
            if (div == 1) {
                return this.Numerator;
            }
            return new ConstantFraction(this.Numerator, new IntConst(div));
        }
        if (d2Val % d1Val == 0) {
            int div = d2Val / d1Val;
            return this.Numerator.mul(new IntConst(div));
        }
        return new ConstantFraction(this.Numerator.mul(c), (AlgExp)this.Denominator);
    }

    @Override
    public AlgExp mul(DoubleConst c) {
        return new ConstantFraction(this.Numerator.mul(c), (AlgExp)this.Denominator);
    }

    @Override
    public AlgExp div(IntConst c) {
        return this.mul(c.invert());
    }

    @Override
    public AlgExp div(DoubleConst c) {
        return this.mul(c.invert());
    }

    @Override
    public AlgExp add(IntConst c) {
        return new Polynomial(this, c);
    }

    @Override
    public AlgExp add(DoubleConst c) {
        return new Polynomial(this, c);
    }

    @Override
    public AlgExp eval() {
        int d;
        if (!this.Numerator.isInt() || !this.Denominator.isInt()) {
            return this;
        }
        int n = (int)this.Numerator.getVal();
        if (n % (d = (int)this.Denominator.getVal()) == 0) {
            return new IntConst(n / d);
        }
        return this.reduce();
    }

    public AlgExp reduce() {
        AlgExp reduce = null;
        if (this.Denominator.equals(AlgExp.ONE)) {
            reduce = this.Numerator;
        } else if (this.Numerator.isInt() && this.Denominator.isInt()) {
            int dValue;
            int nValue = (int)((IntConst)this.Numerator).getVal();
            int gcd = MathLib.gcd((int)nValue, (int)(dValue = (int)((IntConst)this.Denominator).getVal()));
            if (gcd == 1) {
                reduce = this;
            } else {
                int newNValue = nValue / gcd;
                int newDValue = dValue / gcd;
                reduce = newDValue == 1 ? new IntConst(newNValue) : new ConstantFraction(new IntConst(newNValue), new IntConst(newDValue));
            }
        } else {
            reduce = this.Numerator.isFraction() || this.Denominator.isFraction() ? this.Numerator.div(this.Denominator) : this;
        }
        return reduce;
    }

    @Override
    public AlgExp divDecimal(IntConst c) {
        new Exception().printStackTrace();
        return null;
    }
}

