/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.userDef.algebra.weak;

import edu.cmu.pact.miss.userDef.algebra.EqFeaturePredicate;
import edu.cmu.pact.miss.userDef.algebra.expression.AlgExp;
import edu.cmu.pact.miss.userDef.algebra.expression.ExpParseException;
import java.util.LinkedList;
import java.util.Vector;

public class GetNumbersAndSigns
extends EqFeaturePredicate {
    public GetNumbersAndSigns() {
        this.setArity(1);
        this.setName("get-number-and-signs");
        this.setReturnValueType(2);
        this.setArgValueType(new int[]{1});
    }

    @Override
    public String apply(Vector args) {
        String expString = (String)args.get(0);
        if (expString == null) {
            return null;
        }
        if (!GetNumbersAndSigns.isArithmeticExpression(expString)) {
            return null;
        }
        try {
            AlgExp exp = AlgExp.parseExp(expString);
            LinkedList<String> numbers = new LinkedList<String>();
            int count = 0;
            for (int x = 0; x < expString.length(); ++x) {
                String number = "";
                while (x < expString.length() - 1 && !this.isValidChar(Character.valueOf(expString.charAt(x)))) {
                    ++x;
                }
                if (this.isValidChar(Character.valueOf(expString.charAt(x)))) {
                    number = number + expString.charAt(x);
                }
                while (x < expString.length() - 1 && Character.isDigit(expString.charAt(x + 1))) {
                    number = number + expString.charAt(++x);
                }
                if (number.equals("") || number.equals("-")) continue;
                numbers.add(number);
                ++count;
            }
            if (numbers.size() > 0) {
                return this.makeList(numbers.toArray(new String[count]));
            }
            return null;
        }
        catch (ExpParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean isValidChar(Character c) {
        if (Character.isDigit(c.charValue())) {
            return true;
        }
        return c.charValue() == '-';
    }
}

