/*
 * Decompiled with CFR 0.152.
 */
package pact.CommWidgets;

import java.awt.Canvas;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.Serializable;
import pact.CommWidgets.HourHand;
import pact.CommWidgets.MinuteHand;

class Clock
extends Canvas
implements Serializable {
    protected double locX = 0.0;
    protected double locY = 0.0;
    protected int radius = 75;
    protected int clockFontSize = 14;
    protected MinuteHand minuteHand = new MinuteHand((int)(this.locX + (double)this.radius), (int)(this.locY + (double)this.radius), (int)((double)this.radius * 0.75), 3, (int)((double)this.radius * 0.1), 9);
    protected HourHand hourHand;
    protected String AMPM = "AM";

    public Clock() {
        this.minuteHand.setMinutes(0);
        this.hourHand = new HourHand((int)(this.locX + (double)this.radius), (int)(this.locY + (double)this.radius), (int)((double)this.radius * 0.4), 3, (int)((double)this.radius * 0.1), 9, this.minuteHand);
        this.hourHand.setHour(12);
        this.setSize(this.radius * 2, this.radius * 2);
    }

    @Override
    public void paint(Graphics g) {
        this.drawClockFace(g);
        this.minuteHand.draw(g);
        this.hourHand.draw(g);
    }

    public void drawClockFace(Graphics g) {
        g.setFont(new Font(null, 0, this.clockFontSize));
        FontMetrics f = g.getFontMetrics();
        int a = (int)(Math.cos(Math.toRadians(30.0)) * (double)this.radius);
        int b = (int)(Math.cos(Math.toRadians(60.0)) * (double)this.radius);
        g.drawOval((int)this.locX, (int)this.locY, this.radius * 2, this.radius * 2);
        g.drawString("12", (int)(this.locX + (double)this.radius - (double)f.stringWidth("12") / 2.0), (int)(this.locY + (double)f.getFont().getSize() - 1.0));
        g.drawString("6", (int)(this.locX + (double)this.radius - (double)f.stringWidth("6") / 2.0), (int)(this.locY + (double)(this.radius * 2)));
        g.drawString("9", (int)this.locX, (int)(this.locY + (double)this.radius + (double)f.getFont().getSize() / 2.0 - 1.0));
        g.drawString("3", (int)(this.locX + (double)(this.radius * 2) - (double)f.stringWidth("3")), (int)(this.locY + (double)this.radius + (double)f.getFont().getSize() / 2.0 - 1.0));
        g.drawString("2", (int)(this.locX + (double)a + (double)this.radius - (double)f.stringWidth("2") + 2.0), (int)(this.locY + (double)this.radius - (double)b + (double)f.getFont().getSize()));
        g.drawString("1", (int)(this.locX + (double)b + (double)this.radius - (double)f.stringWidth("1") + 2.0), (int)(this.locY + (double)this.radius - (double)a + (double)f.getFont().getSize()));
        g.drawString("4", (int)(this.locX + (double)a + (double)this.radius - (double)f.stringWidth("4") + 1.0), (int)(this.locY + (double)this.radius + (double)b));
        g.drawString("5", (int)(this.locX + (double)b + (double)this.radius - (double)f.stringWidth("5") + 1.0), (int)(this.locY + (double)this.radius + (double)a));
        g.drawString("8", (int)(this.locX - (double)a + (double)this.radius - 1.0), (int)(this.locY + (double)this.radius + (double)b));
        g.drawString("7", (int)(this.locX - (double)b + (double)this.radius - 1.0), (int)(this.locY + (double)this.radius + (double)a));
        g.drawString("10", (int)(this.locX - (double)a + (double)this.radius - 2.0), (int)(this.locY + (double)this.radius - (double)b + (double)f.getFont().getSize()));
        g.drawString("11", (int)(this.locX - (double)b + (double)this.radius - 2.0), (int)(this.locY + (double)this.radius - (double)a + (double)f.getFont().getSize()));
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int r) {
        this.radius = r;
    }

    public void setHour(int h) {
        this.hourHand.setHour(h);
        this.repaint();
    }

    public int getHour() {
        return this.hourHand.getHour();
    }

    public void setMinutes(int m) {
        this.minuteHand.setMinutes(m);
        this.hourHand.update();
        this.repaint();
    }

    public int getMinutes() {
        return this.minuteHand.getMinutes();
    }

    public String getAMPM() {
        return this.AMPM;
    }

    public void setAMPM(String s) {
        this.AMPM = s;
        this.repaint();
    }
}

